// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.quicksight.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * A description of the import source that you provide at the start of an import job. This value is set to either `Body` or `S3Uri`, depending on how the `StartAssetBundleImportJobRequest` is configured.
 */
public class AssetBundleImportSourceDescription private constructor(builder: Builder) {
    /**
     * An HTTPS download URL for the provided asset bundle that you optionally provided at the start of the import job. This URL is valid for five minutes after issuance. Call `DescribeAssetBundleExportJob` again for a fresh URL if needed. The downloaded asset bundle is a `.qs` zip file.
     */
    public val body: kotlin.String? = builder.body
    /**
     * The Amazon S3 URI that you provided at the start of the import job.
     */
    public val s3Uri: kotlin.String? = builder.s3Uri

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.quicksight.model.AssetBundleImportSourceDescription = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AssetBundleImportSourceDescription(")
        append("body=*** Sensitive Data Redacted ***,")
        append("s3Uri=$s3Uri")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = body?.hashCode() ?: 0
        result = 31 * result + (s3Uri?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AssetBundleImportSourceDescription

        if (body != other.body) return false
        if (s3Uri != other.s3Uri) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.quicksight.model.AssetBundleImportSourceDescription = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * An HTTPS download URL for the provided asset bundle that you optionally provided at the start of the import job. This URL is valid for five minutes after issuance. Call `DescribeAssetBundleExportJob` again for a fresh URL if needed. The downloaded asset bundle is a `.qs` zip file.
         */
        public var body: kotlin.String? = null
        /**
         * The Amazon S3 URI that you provided at the start of the import job.
         */
        public var s3Uri: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.quicksight.model.AssetBundleImportSourceDescription) : this() {
            this.body = x.body
            this.s3Uri = x.s3Uri
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.quicksight.model.AssetBundleImportSourceDescription = AssetBundleImportSourceDescription(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
