// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.quicksight.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The override parameters for a single VPC connection that is imported.
 */
public class AssetBundleImportJobVpcConnectionOverrideParameters private constructor(builder: Builder) {
    /**
     * An optional override of DNS resolvers to be used by the VPC connection.
     */
    public val dnsResolvers: List<String>? = builder.dnsResolvers
    /**
     * A new name for the VPC connection.
     */
    public val name: kotlin.String? = builder.name
    /**
     * An optional override of the role ARN to be used by the VPC connection.
     */
    public val roleArn: kotlin.String? = builder.roleArn
    /**
     * A new security group ID for the VPC connection you are importing. This field is required if you are importing the VPC connection from another Amazon Web Services account or Region.
     */
    public val securityGroupIds: List<String>? = builder.securityGroupIds
    /**
     * A list of new subnet IDs for the VPC connection you are importing. This field is required if you are importing the VPC connection from another Amazon Web Services account or Region.
     */
    public val subnetIds: List<String>? = builder.subnetIds
    /**
     * The ID of the VPC Connection to apply overrides to.
     */
    public val vpcConnectionId: kotlin.String = requireNotNull(builder.vpcConnectionId) { "A non-null value must be provided for vpcConnectionId" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.quicksight.model.AssetBundleImportJobVpcConnectionOverrideParameters = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AssetBundleImportJobVpcConnectionOverrideParameters(")
        append("dnsResolvers=$dnsResolvers,")
        append("name=$name,")
        append("roleArn=$roleArn,")
        append("securityGroupIds=$securityGroupIds,")
        append("subnetIds=$subnetIds,")
        append("vpcConnectionId=$vpcConnectionId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = dnsResolvers?.hashCode() ?: 0
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        result = 31 * result + (securityGroupIds?.hashCode() ?: 0)
        result = 31 * result + (subnetIds?.hashCode() ?: 0)
        result = 31 * result + (vpcConnectionId.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AssetBundleImportJobVpcConnectionOverrideParameters

        if (dnsResolvers != other.dnsResolvers) return false
        if (name != other.name) return false
        if (roleArn != other.roleArn) return false
        if (securityGroupIds != other.securityGroupIds) return false
        if (subnetIds != other.subnetIds) return false
        if (vpcConnectionId != other.vpcConnectionId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.quicksight.model.AssetBundleImportJobVpcConnectionOverrideParameters = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * An optional override of DNS resolvers to be used by the VPC connection.
         */
        public var dnsResolvers: List<String>? = null
        /**
         * A new name for the VPC connection.
         */
        public var name: kotlin.String? = null
        /**
         * An optional override of the role ARN to be used by the VPC connection.
         */
        public var roleArn: kotlin.String? = null
        /**
         * A new security group ID for the VPC connection you are importing. This field is required if you are importing the VPC connection from another Amazon Web Services account or Region.
         */
        public var securityGroupIds: List<String>? = null
        /**
         * A list of new subnet IDs for the VPC connection you are importing. This field is required if you are importing the VPC connection from another Amazon Web Services account or Region.
         */
        public var subnetIds: List<String>? = null
        /**
         * The ID of the VPC Connection to apply overrides to.
         */
        public var vpcConnectionId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.quicksight.model.AssetBundleImportJobVpcConnectionOverrideParameters) : this() {
            this.dnsResolvers = x.dnsResolvers
            this.name = x.name
            this.roleArn = x.roleArn
            this.securityGroupIds = x.securityGroupIds
            this.subnetIds = x.subnetIds
            this.vpcConnectionId = x.vpcConnectionId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.quicksight.model.AssetBundleImportJobVpcConnectionOverrideParameters = AssetBundleImportJobVpcConnectionOverrideParameters(this)

        internal fun correctErrors(): Builder {
            if (vpcConnectionId == null) vpcConnectionId = ""
            return this
        }
    }
}
