// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.quicksight.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * A list of overrides for a specific `RefreshsSchedule` resource that is present in the asset bundle that is imported.
 */
public class AssetBundleImportJobRefreshScheduleOverrideParameters private constructor(builder: Builder) {
    /**
     * A partial identifier for the specific `RefreshSchedule` resource that is being overridden. This structure is used together with the `ScheduleID` structure.
     */
    public val dataSetId: kotlin.String = requireNotNull(builder.dataSetId) { "A non-null value must be provided for dataSetId" }
    /**
     * A partial identifier for the specific `RefreshSchedule` resource being overridden. This structure is used together with the `DataSetId` structure.
     */
    public val scheduleId: kotlin.String = requireNotNull(builder.scheduleId) { "A non-null value must be provided for scheduleId" }
    /**
     * An override for the `StartAfterDateTime` of a `RefreshSchedule`. Make sure that the `StartAfterDateTime` is set to a time that takes place in the future.
     */
    public val startAfterDateTime: aws.smithy.kotlin.runtime.time.Instant? = builder.startAfterDateTime

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.quicksight.model.AssetBundleImportJobRefreshScheduleOverrideParameters = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AssetBundleImportJobRefreshScheduleOverrideParameters(")
        append("dataSetId=$dataSetId,")
        append("scheduleId=$scheduleId,")
        append("startAfterDateTime=$startAfterDateTime")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = dataSetId.hashCode()
        result = 31 * result + (scheduleId.hashCode())
        result = 31 * result + (startAfterDateTime?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AssetBundleImportJobRefreshScheduleOverrideParameters

        if (dataSetId != other.dataSetId) return false
        if (scheduleId != other.scheduleId) return false
        if (startAfterDateTime != other.startAfterDateTime) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.quicksight.model.AssetBundleImportJobRefreshScheduleOverrideParameters = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A partial identifier for the specific `RefreshSchedule` resource that is being overridden. This structure is used together with the `ScheduleID` structure.
         */
        public var dataSetId: kotlin.String? = null
        /**
         * A partial identifier for the specific `RefreshSchedule` resource being overridden. This structure is used together with the `DataSetId` structure.
         */
        public var scheduleId: kotlin.String? = null
        /**
         * An override for the `StartAfterDateTime` of a `RefreshSchedule`. Make sure that the `StartAfterDateTime` is set to a time that takes place in the future.
         */
        public var startAfterDateTime: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.quicksight.model.AssetBundleImportJobRefreshScheduleOverrideParameters) : this() {
            this.dataSetId = x.dataSetId
            this.scheduleId = x.scheduleId
            this.startAfterDateTime = x.startAfterDateTime
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.quicksight.model.AssetBundleImportJobRefreshScheduleOverrideParameters = AssetBundleImportJobRefreshScheduleOverrideParameters(this)

        internal fun correctErrors(): Builder {
            if (dataSetId == null) dataSetId = ""
            if (scheduleId == null) scheduleId = ""
            return this
        }
    }
}
