// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.quicksight.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The override parameters for a single data source that is being imported.
 */
public class AssetBundleImportJobDataSourceOverrideParameters private constructor(builder: Builder) {
    /**
     * An optional structure that provides the credentials to be used to create the imported data source.
     */
    public val credentials: aws.sdk.kotlin.services.quicksight.model.AssetBundleImportJobDataSourceCredentials? = builder.credentials
    /**
     * The ID of the data source to apply overrides to.
     */
    public val dataSourceId: kotlin.String = requireNotNull(builder.dataSourceId) { "A non-null value must be provided for dataSourceId" }
    /**
     * The parameters that Amazon QuickSight uses to connect to your underlying data source. This is a variant type structure. For this structure to be valid, only one of the attributes can be non-null.
     */
    public val dataSourceParameters: aws.sdk.kotlin.services.quicksight.model.DataSourceParameters? = builder.dataSourceParameters
    /**
     * A new name for the data source.
     */
    public val name: kotlin.String? = builder.name
    /**
     * Secure Socket Layer (SSL) properties that apply when Amazon QuickSight connects to your underlying data source.
     */
    public val sslProperties: aws.sdk.kotlin.services.quicksight.model.SslProperties? = builder.sslProperties
    /**
     * VPC connection properties.
     */
    public val vpcConnectionProperties: aws.sdk.kotlin.services.quicksight.model.VpcConnectionProperties? = builder.vpcConnectionProperties

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.quicksight.model.AssetBundleImportJobDataSourceOverrideParameters = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AssetBundleImportJobDataSourceOverrideParameters(")
        append("credentials=$credentials,")
        append("dataSourceId=$dataSourceId,")
        append("dataSourceParameters=$dataSourceParameters,")
        append("name=$name,")
        append("sslProperties=$sslProperties,")
        append("vpcConnectionProperties=$vpcConnectionProperties")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = credentials?.hashCode() ?: 0
        result = 31 * result + (dataSourceId.hashCode())
        result = 31 * result + (dataSourceParameters?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (sslProperties?.hashCode() ?: 0)
        result = 31 * result + (vpcConnectionProperties?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AssetBundleImportJobDataSourceOverrideParameters

        if (credentials != other.credentials) return false
        if (dataSourceId != other.dataSourceId) return false
        if (dataSourceParameters != other.dataSourceParameters) return false
        if (name != other.name) return false
        if (sslProperties != other.sslProperties) return false
        if (vpcConnectionProperties != other.vpcConnectionProperties) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.quicksight.model.AssetBundleImportJobDataSourceOverrideParameters = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * An optional structure that provides the credentials to be used to create the imported data source.
         */
        public var credentials: aws.sdk.kotlin.services.quicksight.model.AssetBundleImportJobDataSourceCredentials? = null
        /**
         * The ID of the data source to apply overrides to.
         */
        public var dataSourceId: kotlin.String? = null
        /**
         * The parameters that Amazon QuickSight uses to connect to your underlying data source. This is a variant type structure. For this structure to be valid, only one of the attributes can be non-null.
         */
        public var dataSourceParameters: aws.sdk.kotlin.services.quicksight.model.DataSourceParameters? = null
        /**
         * A new name for the data source.
         */
        public var name: kotlin.String? = null
        /**
         * Secure Socket Layer (SSL) properties that apply when Amazon QuickSight connects to your underlying data source.
         */
        public var sslProperties: aws.sdk.kotlin.services.quicksight.model.SslProperties? = null
        /**
         * VPC connection properties.
         */
        public var vpcConnectionProperties: aws.sdk.kotlin.services.quicksight.model.VpcConnectionProperties? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.quicksight.model.AssetBundleImportJobDataSourceOverrideParameters) : this() {
            this.credentials = x.credentials
            this.dataSourceId = x.dataSourceId
            this.dataSourceParameters = x.dataSourceParameters
            this.name = x.name
            this.sslProperties = x.sslProperties
            this.vpcConnectionProperties = x.vpcConnectionProperties
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.quicksight.model.AssetBundleImportJobDataSourceOverrideParameters = AssetBundleImportJobDataSourceOverrideParameters(this)

        /**
         * construct an [aws.sdk.kotlin.services.quicksight.model.AssetBundleImportJobDataSourceCredentials] inside the given [block]
         */
        public fun credentials(block: aws.sdk.kotlin.services.quicksight.model.AssetBundleImportJobDataSourceCredentials.Builder.() -> kotlin.Unit) {
            this.credentials = aws.sdk.kotlin.services.quicksight.model.AssetBundleImportJobDataSourceCredentials.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.quicksight.model.SslProperties] inside the given [block]
         */
        public fun sslProperties(block: aws.sdk.kotlin.services.quicksight.model.SslProperties.Builder.() -> kotlin.Unit) {
            this.sslProperties = aws.sdk.kotlin.services.quicksight.model.SslProperties.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.quicksight.model.VpcConnectionProperties] inside the given [block]
         */
        public fun vpcConnectionProperties(block: aws.sdk.kotlin.services.quicksight.model.VpcConnectionProperties.Builder.() -> kotlin.Unit) {
            this.vpcConnectionProperties = aws.sdk.kotlin.services.quicksight.model.VpcConnectionProperties.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (dataSourceId == null) dataSourceId = ""
            return this
        }
    }
}
