// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.quicksight.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Information about the dashboard that you want to embed.
 */
public class AnonymousUserDashboardEmbeddingConfiguration private constructor(builder: Builder) {
    /**
     * A list of all disabled features of a specified anonymous dashboard.
     */
    public val disabledFeatures: List<AnonymousUserDashboardEmbeddingConfigurationDisabledFeature>? = builder.disabledFeatures
    /**
     * A list of all enabled features of a specified anonymous dashboard.
     */
    public val enabledFeatures: List<AnonymousUserDashboardEmbeddingConfigurationEnabledFeature>? = builder.enabledFeatures
    /**
     * The feature configuration for an embedded dashboard.
     */
    public val featureConfigurations: aws.sdk.kotlin.services.quicksight.model.AnonymousUserDashboardFeatureConfigurations? = builder.featureConfigurations
    /**
     * The dashboard ID for the dashboard that you want the user to see first. This ID is included in the output URL. When the URL in response is accessed, Amazon QuickSight renders this dashboard.
     *
     * The Amazon Resource Name (ARN) of this dashboard must be included in the `AuthorizedResourceArns` parameter. Otherwise, the request will fail with `InvalidParameterValueException`.
     */
    public val initialDashboardId: kotlin.String = requireNotNull(builder.initialDashboardId) { "A non-null value must be provided for initialDashboardId" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.quicksight.model.AnonymousUserDashboardEmbeddingConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AnonymousUserDashboardEmbeddingConfiguration(")
        append("disabledFeatures=$disabledFeatures,")
        append("enabledFeatures=$enabledFeatures,")
        append("featureConfigurations=$featureConfigurations,")
        append("initialDashboardId=$initialDashboardId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = disabledFeatures?.hashCode() ?: 0
        result = 31 * result + (enabledFeatures?.hashCode() ?: 0)
        result = 31 * result + (featureConfigurations?.hashCode() ?: 0)
        result = 31 * result + (initialDashboardId.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AnonymousUserDashboardEmbeddingConfiguration

        if (disabledFeatures != other.disabledFeatures) return false
        if (enabledFeatures != other.enabledFeatures) return false
        if (featureConfigurations != other.featureConfigurations) return false
        if (initialDashboardId != other.initialDashboardId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.quicksight.model.AnonymousUserDashboardEmbeddingConfiguration = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * A list of all disabled features of a specified anonymous dashboard.
         */
        public var disabledFeatures: List<AnonymousUserDashboardEmbeddingConfigurationDisabledFeature>? = null
        /**
         * A list of all enabled features of a specified anonymous dashboard.
         */
        public var enabledFeatures: List<AnonymousUserDashboardEmbeddingConfigurationEnabledFeature>? = null
        /**
         * The feature configuration for an embedded dashboard.
         */
        public var featureConfigurations: aws.sdk.kotlin.services.quicksight.model.AnonymousUserDashboardFeatureConfigurations? = null
        /**
         * The dashboard ID for the dashboard that you want the user to see first. This ID is included in the output URL. When the URL in response is accessed, Amazon QuickSight renders this dashboard.
         *
         * The Amazon Resource Name (ARN) of this dashboard must be included in the `AuthorizedResourceArns` parameter. Otherwise, the request will fail with `InvalidParameterValueException`.
         */
        public var initialDashboardId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.quicksight.model.AnonymousUserDashboardEmbeddingConfiguration) : this() {
            this.disabledFeatures = x.disabledFeatures
            this.enabledFeatures = x.enabledFeatures
            this.featureConfigurations = x.featureConfigurations
            this.initialDashboardId = x.initialDashboardId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.quicksight.model.AnonymousUserDashboardEmbeddingConfiguration = AnonymousUserDashboardEmbeddingConfiguration(this)

        /**
         * construct an [aws.sdk.kotlin.services.quicksight.model.AnonymousUserDashboardFeatureConfigurations] inside the given [block]
         */
        public fun featureConfigurations(block: aws.sdk.kotlin.services.quicksight.model.AnonymousUserDashboardFeatureConfigurations.Builder.() -> kotlin.Unit) {
            this.featureConfigurations = aws.sdk.kotlin.services.quicksight.model.AnonymousUserDashboardFeatureConfigurations.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (initialDashboardId == null) initialDashboardId = ""
            return this
        }
    }
}
