// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.quicksight.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The definition of an analysis.
 */
public class AnalysisDefinition private constructor(builder: Builder) {
    /**
     * The configuration for default analysis settings.
     */
    public val analysisDefaults: aws.sdk.kotlin.services.quicksight.model.AnalysisDefaults? = builder.analysisDefaults
    /**
     * An array of calculated field definitions for the analysis.
     */
    public val calculatedFields: List<CalculatedField>? = builder.calculatedFields
    /**
     * An array of analysis-level column configurations. Column configurations can be used to set default formatting for a column to be used throughout an analysis.
     */
    public val columnConfigurations: List<ColumnConfiguration>? = builder.columnConfigurations
    /**
     * An array of dataset identifier declarations. This mapping allows the usage of dataset identifiers instead of dataset ARNs throughout analysis sub-structures.
     */
    public val dataSetIdentifierDeclarations: List<DataSetIdentifierDeclaration> = requireNotNull(builder.dataSetIdentifierDeclarations) { "A non-null value must be provided for dataSetIdentifierDeclarations" }
    /**
     * Filter definitions for an analysis.
     *
     * For more information, see [Filtering Data in Amazon QuickSight](https://docs.aws.amazon.com/quicksight/latest/user/adding-a-filter.html) in the *Amazon QuickSight User Guide*.
     */
    public val filterGroups: List<FilterGroup>? = builder.filterGroups
    /**
     * An array of option definitions for an analysis.
     */
    public val options: aws.sdk.kotlin.services.quicksight.model.AssetOptions? = builder.options
    /**
     * An array of parameter declarations for an analysis.
     *
     * Parameters are named variables that can transfer a value for use by an action or an object.
     *
     * For more information, see [Parameters in Amazon QuickSight](https://docs.aws.amazon.com/quicksight/latest/user/parameters-in-quicksight.html) in the *Amazon QuickSight User Guide*.
     */
    public val parameterDeclarations: List<ParameterDeclaration>? = builder.parameterDeclarations
    /**
     * A structure that describes the query execution options.
     */
    public val queryExecutionOptions: aws.sdk.kotlin.services.quicksight.model.QueryExecutionOptions? = builder.queryExecutionOptions
    /**
     * An array of sheet definitions for an analysis. Each `SheetDefinition` provides detailed information about a sheet within this analysis.
     */
    public val sheets: List<SheetDefinition>? = builder.sheets
    /**
     * The static files for the definition.
     */
    public val staticFiles: List<StaticFile>? = builder.staticFiles

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.quicksight.model.AnalysisDefinition = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AnalysisDefinition(")
        append("analysisDefaults=$analysisDefaults,")
        append("calculatedFields=$calculatedFields,")
        append("columnConfigurations=$columnConfigurations,")
        append("dataSetIdentifierDeclarations=$dataSetIdentifierDeclarations,")
        append("filterGroups=$filterGroups,")
        append("options=$options,")
        append("parameterDeclarations=$parameterDeclarations,")
        append("queryExecutionOptions=$queryExecutionOptions,")
        append("sheets=$sheets,")
        append("staticFiles=$staticFiles")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = analysisDefaults?.hashCode() ?: 0
        result = 31 * result + (calculatedFields?.hashCode() ?: 0)
        result = 31 * result + (columnConfigurations?.hashCode() ?: 0)
        result = 31 * result + (dataSetIdentifierDeclarations.hashCode())
        result = 31 * result + (filterGroups?.hashCode() ?: 0)
        result = 31 * result + (options?.hashCode() ?: 0)
        result = 31 * result + (parameterDeclarations?.hashCode() ?: 0)
        result = 31 * result + (queryExecutionOptions?.hashCode() ?: 0)
        result = 31 * result + (sheets?.hashCode() ?: 0)
        result = 31 * result + (staticFiles?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AnalysisDefinition

        if (analysisDefaults != other.analysisDefaults) return false
        if (calculatedFields != other.calculatedFields) return false
        if (columnConfigurations != other.columnConfigurations) return false
        if (dataSetIdentifierDeclarations != other.dataSetIdentifierDeclarations) return false
        if (filterGroups != other.filterGroups) return false
        if (options != other.options) return false
        if (parameterDeclarations != other.parameterDeclarations) return false
        if (queryExecutionOptions != other.queryExecutionOptions) return false
        if (sheets != other.sheets) return false
        if (staticFiles != other.staticFiles) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.quicksight.model.AnalysisDefinition = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The configuration for default analysis settings.
         */
        public var analysisDefaults: aws.sdk.kotlin.services.quicksight.model.AnalysisDefaults? = null
        /**
         * An array of calculated field definitions for the analysis.
         */
        public var calculatedFields: List<CalculatedField>? = null
        /**
         * An array of analysis-level column configurations. Column configurations can be used to set default formatting for a column to be used throughout an analysis.
         */
        public var columnConfigurations: List<ColumnConfiguration>? = null
        /**
         * An array of dataset identifier declarations. This mapping allows the usage of dataset identifiers instead of dataset ARNs throughout analysis sub-structures.
         */
        public var dataSetIdentifierDeclarations: List<DataSetIdentifierDeclaration>? = null
        /**
         * Filter definitions for an analysis.
         *
         * For more information, see [Filtering Data in Amazon QuickSight](https://docs.aws.amazon.com/quicksight/latest/user/adding-a-filter.html) in the *Amazon QuickSight User Guide*.
         */
        public var filterGroups: List<FilterGroup>? = null
        /**
         * An array of option definitions for an analysis.
         */
        public var options: aws.sdk.kotlin.services.quicksight.model.AssetOptions? = null
        /**
         * An array of parameter declarations for an analysis.
         *
         * Parameters are named variables that can transfer a value for use by an action or an object.
         *
         * For more information, see [Parameters in Amazon QuickSight](https://docs.aws.amazon.com/quicksight/latest/user/parameters-in-quicksight.html) in the *Amazon QuickSight User Guide*.
         */
        public var parameterDeclarations: List<ParameterDeclaration>? = null
        /**
         * A structure that describes the query execution options.
         */
        public var queryExecutionOptions: aws.sdk.kotlin.services.quicksight.model.QueryExecutionOptions? = null
        /**
         * An array of sheet definitions for an analysis. Each `SheetDefinition` provides detailed information about a sheet within this analysis.
         */
        public var sheets: List<SheetDefinition>? = null
        /**
         * The static files for the definition.
         */
        public var staticFiles: List<StaticFile>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.quicksight.model.AnalysisDefinition) : this() {
            this.analysisDefaults = x.analysisDefaults
            this.calculatedFields = x.calculatedFields
            this.columnConfigurations = x.columnConfigurations
            this.dataSetIdentifierDeclarations = x.dataSetIdentifierDeclarations
            this.filterGroups = x.filterGroups
            this.options = x.options
            this.parameterDeclarations = x.parameterDeclarations
            this.queryExecutionOptions = x.queryExecutionOptions
            this.sheets = x.sheets
            this.staticFiles = x.staticFiles
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.quicksight.model.AnalysisDefinition = AnalysisDefinition(this)

        /**
         * construct an [aws.sdk.kotlin.services.quicksight.model.AnalysisDefaults] inside the given [block]
         */
        public fun analysisDefaults(block: aws.sdk.kotlin.services.quicksight.model.AnalysisDefaults.Builder.() -> kotlin.Unit) {
            this.analysisDefaults = aws.sdk.kotlin.services.quicksight.model.AnalysisDefaults.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.quicksight.model.AssetOptions] inside the given [block]
         */
        public fun options(block: aws.sdk.kotlin.services.quicksight.model.AssetOptions.Builder.() -> kotlin.Unit) {
            this.options = aws.sdk.kotlin.services.quicksight.model.AssetOptions.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.quicksight.model.QueryExecutionOptions] inside the given [block]
         */
        public fun queryExecutionOptions(block: aws.sdk.kotlin.services.quicksight.model.QueryExecutionOptions.Builder.() -> kotlin.Unit) {
            this.queryExecutionOptions = aws.sdk.kotlin.services.quicksight.model.QueryExecutionOptions.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (dataSetIdentifierDeclarations == null) dataSetIdentifierDeclarations = emptyList()
            return this
        }
    }
}
