// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.quicksight.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The Amazon QuickSight settings associated with your Amazon Web Services account.
 */
public class AccountSettings private constructor(builder: Builder) {
    /**
     * The "account name" you provided for the Amazon QuickSight subscription in your Amazon Web Services account. You create this name when you sign up for Amazon QuickSight. It is unique in all of Amazon Web Services and it appears only when users sign in.
     */
    public val accountName: kotlin.String? = builder.accountName
    /**
     * The default Amazon QuickSight namespace for your Amazon Web Services account.
     */
    public val defaultNamespace: kotlin.String? = builder.defaultNamespace
    /**
     * The edition of Amazon QuickSight that you're currently subscribed to: Enterprise edition or Standard edition.
     */
    public val edition: aws.sdk.kotlin.services.quicksight.model.Edition? = builder.edition
    /**
     * The main notification email for your Amazon QuickSight subscription.
     */
    public val notificationEmail: kotlin.String? = builder.notificationEmail
    /**
     * A Boolean value that indicates whether public sharing is turned on for an Amazon QuickSight account. For more information about turning on public sharing, see [UpdatePublicSharingSettings](https://docs.aws.amazon.com/quicksight/latest/APIReference/API_UpdatePublicSharingSettings.html).
     */
    public val publicSharingEnabled: kotlin.Boolean = builder.publicSharingEnabled
    /**
     * A boolean value that determines whether or not an Amazon QuickSight account can be deleted. A `True` value doesn't allow the account to be deleted and results in an error message if a user tries to make a `DeleteAccountSubsctiption` request. A `False` value will allow the ccount to be deleted.
     */
    public val terminationProtectionEnabled: kotlin.Boolean = builder.terminationProtectionEnabled

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.quicksight.model.AccountSettings = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AccountSettings(")
        append("accountName=$accountName,")
        append("defaultNamespace=$defaultNamespace,")
        append("edition=$edition,")
        append("notificationEmail=$notificationEmail,")
        append("publicSharingEnabled=$publicSharingEnabled,")
        append("terminationProtectionEnabled=$terminationProtectionEnabled")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = accountName?.hashCode() ?: 0
        result = 31 * result + (defaultNamespace?.hashCode() ?: 0)
        result = 31 * result + (edition?.hashCode() ?: 0)
        result = 31 * result + (notificationEmail?.hashCode() ?: 0)
        result = 31 * result + (publicSharingEnabled.hashCode())
        result = 31 * result + (terminationProtectionEnabled.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AccountSettings

        if (accountName != other.accountName) return false
        if (defaultNamespace != other.defaultNamespace) return false
        if (edition != other.edition) return false
        if (notificationEmail != other.notificationEmail) return false
        if (publicSharingEnabled != other.publicSharingEnabled) return false
        if (terminationProtectionEnabled != other.terminationProtectionEnabled) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.quicksight.model.AccountSettings = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The "account name" you provided for the Amazon QuickSight subscription in your Amazon Web Services account. You create this name when you sign up for Amazon QuickSight. It is unique in all of Amazon Web Services and it appears only when users sign in.
         */
        public var accountName: kotlin.String? = null
        /**
         * The default Amazon QuickSight namespace for your Amazon Web Services account.
         */
        public var defaultNamespace: kotlin.String? = null
        /**
         * The edition of Amazon QuickSight that you're currently subscribed to: Enterprise edition or Standard edition.
         */
        public var edition: aws.sdk.kotlin.services.quicksight.model.Edition? = null
        /**
         * The main notification email for your Amazon QuickSight subscription.
         */
        public var notificationEmail: kotlin.String? = null
        /**
         * A Boolean value that indicates whether public sharing is turned on for an Amazon QuickSight account. For more information about turning on public sharing, see [UpdatePublicSharingSettings](https://docs.aws.amazon.com/quicksight/latest/APIReference/API_UpdatePublicSharingSettings.html).
         */
        public var publicSharingEnabled: kotlin.Boolean = false
        /**
         * A boolean value that determines whether or not an Amazon QuickSight account can be deleted. A `True` value doesn't allow the account to be deleted and results in an error message if a user tries to make a `DeleteAccountSubsctiption` request. A `False` value will allow the ccount to be deleted.
         */
        public var terminationProtectionEnabled: kotlin.Boolean = false

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.quicksight.model.AccountSettings) : this() {
            this.accountName = x.accountName
            this.defaultNamespace = x.defaultNamespace
            this.edition = x.edition
            this.notificationEmail = x.notificationEmail
            this.publicSharingEnabled = x.publicSharingEnabled
            this.terminationProtectionEnabled = x.terminationProtectionEnabled
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.quicksight.model.AccountSettings = AccountSettings(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
