// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.quicksight

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.manage
import aws.sdk.kotlin.runtime.config.AbstractAwsSdkClientFactory
import aws.sdk.kotlin.runtime.config.AwsSdkClientConfig
import aws.sdk.kotlin.runtime.config.endpoints.resolveEndpointUrl
import aws.sdk.kotlin.runtime.config.profile.AwsProfile
import aws.sdk.kotlin.runtime.config.profile.AwsSharedConfig
import aws.sdk.kotlin.runtime.http.retries.AwsRetryPolicy
import aws.sdk.kotlin.runtime.region.DefaultRegionProviderChain
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.quicksight.auth.DefaultQuickSightAuthSchemeProvider
import aws.sdk.kotlin.services.quicksight.auth.QuickSightAuthSchemeProvider
import aws.sdk.kotlin.services.quicksight.endpoints.DefaultQuickSightEndpointProvider
import aws.sdk.kotlin.services.quicksight.endpoints.QuickSightEndpointParameters
import aws.sdk.kotlin.services.quicksight.endpoints.QuickSightEndpointProvider
import aws.sdk.kotlin.services.quicksight.model.BatchCreateTopicReviewedAnswerRequest
import aws.sdk.kotlin.services.quicksight.model.BatchCreateTopicReviewedAnswerResponse
import aws.sdk.kotlin.services.quicksight.model.BatchDeleteTopicReviewedAnswerRequest
import aws.sdk.kotlin.services.quicksight.model.BatchDeleteTopicReviewedAnswerResponse
import aws.sdk.kotlin.services.quicksight.model.CancelIngestionRequest
import aws.sdk.kotlin.services.quicksight.model.CancelIngestionResponse
import aws.sdk.kotlin.services.quicksight.model.CreateAccountCustomizationRequest
import aws.sdk.kotlin.services.quicksight.model.CreateAccountCustomizationResponse
import aws.sdk.kotlin.services.quicksight.model.CreateAccountSubscriptionRequest
import aws.sdk.kotlin.services.quicksight.model.CreateAccountSubscriptionResponse
import aws.sdk.kotlin.services.quicksight.model.CreateAnalysisRequest
import aws.sdk.kotlin.services.quicksight.model.CreateAnalysisResponse
import aws.sdk.kotlin.services.quicksight.model.CreateBrandRequest
import aws.sdk.kotlin.services.quicksight.model.CreateBrandResponse
import aws.sdk.kotlin.services.quicksight.model.CreateCustomPermissionsRequest
import aws.sdk.kotlin.services.quicksight.model.CreateCustomPermissionsResponse
import aws.sdk.kotlin.services.quicksight.model.CreateDashboardRequest
import aws.sdk.kotlin.services.quicksight.model.CreateDashboardResponse
import aws.sdk.kotlin.services.quicksight.model.CreateDataSetRequest
import aws.sdk.kotlin.services.quicksight.model.CreateDataSetResponse
import aws.sdk.kotlin.services.quicksight.model.CreateDataSourceRequest
import aws.sdk.kotlin.services.quicksight.model.CreateDataSourceResponse
import aws.sdk.kotlin.services.quicksight.model.CreateFolderMembershipRequest
import aws.sdk.kotlin.services.quicksight.model.CreateFolderMembershipResponse
import aws.sdk.kotlin.services.quicksight.model.CreateFolderRequest
import aws.sdk.kotlin.services.quicksight.model.CreateFolderResponse
import aws.sdk.kotlin.services.quicksight.model.CreateGroupMembershipRequest
import aws.sdk.kotlin.services.quicksight.model.CreateGroupMembershipResponse
import aws.sdk.kotlin.services.quicksight.model.CreateGroupRequest
import aws.sdk.kotlin.services.quicksight.model.CreateGroupResponse
import aws.sdk.kotlin.services.quicksight.model.CreateIamPolicyAssignmentRequest
import aws.sdk.kotlin.services.quicksight.model.CreateIamPolicyAssignmentResponse
import aws.sdk.kotlin.services.quicksight.model.CreateIngestionRequest
import aws.sdk.kotlin.services.quicksight.model.CreateIngestionResponse
import aws.sdk.kotlin.services.quicksight.model.CreateNamespaceRequest
import aws.sdk.kotlin.services.quicksight.model.CreateNamespaceResponse
import aws.sdk.kotlin.services.quicksight.model.CreateRefreshScheduleRequest
import aws.sdk.kotlin.services.quicksight.model.CreateRefreshScheduleResponse
import aws.sdk.kotlin.services.quicksight.model.CreateRoleMembershipRequest
import aws.sdk.kotlin.services.quicksight.model.CreateRoleMembershipResponse
import aws.sdk.kotlin.services.quicksight.model.CreateTemplateAliasRequest
import aws.sdk.kotlin.services.quicksight.model.CreateTemplateAliasResponse
import aws.sdk.kotlin.services.quicksight.model.CreateTemplateRequest
import aws.sdk.kotlin.services.quicksight.model.CreateTemplateResponse
import aws.sdk.kotlin.services.quicksight.model.CreateThemeAliasRequest
import aws.sdk.kotlin.services.quicksight.model.CreateThemeAliasResponse
import aws.sdk.kotlin.services.quicksight.model.CreateThemeRequest
import aws.sdk.kotlin.services.quicksight.model.CreateThemeResponse
import aws.sdk.kotlin.services.quicksight.model.CreateTopicRefreshScheduleRequest
import aws.sdk.kotlin.services.quicksight.model.CreateTopicRefreshScheduleResponse
import aws.sdk.kotlin.services.quicksight.model.CreateTopicRequest
import aws.sdk.kotlin.services.quicksight.model.CreateTopicResponse
import aws.sdk.kotlin.services.quicksight.model.CreateVpcConnectionRequest
import aws.sdk.kotlin.services.quicksight.model.CreateVpcConnectionResponse
import aws.sdk.kotlin.services.quicksight.model.DeleteAccountCustomizationRequest
import aws.sdk.kotlin.services.quicksight.model.DeleteAccountCustomizationResponse
import aws.sdk.kotlin.services.quicksight.model.DeleteAccountSubscriptionRequest
import aws.sdk.kotlin.services.quicksight.model.DeleteAccountSubscriptionResponse
import aws.sdk.kotlin.services.quicksight.model.DeleteAnalysisRequest
import aws.sdk.kotlin.services.quicksight.model.DeleteAnalysisResponse
import aws.sdk.kotlin.services.quicksight.model.DeleteBrandAssignmentRequest
import aws.sdk.kotlin.services.quicksight.model.DeleteBrandAssignmentResponse
import aws.sdk.kotlin.services.quicksight.model.DeleteBrandRequest
import aws.sdk.kotlin.services.quicksight.model.DeleteBrandResponse
import aws.sdk.kotlin.services.quicksight.model.DeleteCustomPermissionsRequest
import aws.sdk.kotlin.services.quicksight.model.DeleteCustomPermissionsResponse
import aws.sdk.kotlin.services.quicksight.model.DeleteDashboardRequest
import aws.sdk.kotlin.services.quicksight.model.DeleteDashboardResponse
import aws.sdk.kotlin.services.quicksight.model.DeleteDataSetRefreshPropertiesRequest
import aws.sdk.kotlin.services.quicksight.model.DeleteDataSetRefreshPropertiesResponse
import aws.sdk.kotlin.services.quicksight.model.DeleteDataSetRequest
import aws.sdk.kotlin.services.quicksight.model.DeleteDataSetResponse
import aws.sdk.kotlin.services.quicksight.model.DeleteDataSourceRequest
import aws.sdk.kotlin.services.quicksight.model.DeleteDataSourceResponse
import aws.sdk.kotlin.services.quicksight.model.DeleteDefaultQBusinessApplicationRequest
import aws.sdk.kotlin.services.quicksight.model.DeleteDefaultQBusinessApplicationResponse
import aws.sdk.kotlin.services.quicksight.model.DeleteFolderMembershipRequest
import aws.sdk.kotlin.services.quicksight.model.DeleteFolderMembershipResponse
import aws.sdk.kotlin.services.quicksight.model.DeleteFolderRequest
import aws.sdk.kotlin.services.quicksight.model.DeleteFolderResponse
import aws.sdk.kotlin.services.quicksight.model.DeleteGroupMembershipRequest
import aws.sdk.kotlin.services.quicksight.model.DeleteGroupMembershipResponse
import aws.sdk.kotlin.services.quicksight.model.DeleteGroupRequest
import aws.sdk.kotlin.services.quicksight.model.DeleteGroupResponse
import aws.sdk.kotlin.services.quicksight.model.DeleteIamPolicyAssignmentRequest
import aws.sdk.kotlin.services.quicksight.model.DeleteIamPolicyAssignmentResponse
import aws.sdk.kotlin.services.quicksight.model.DeleteIdentityPropagationConfigRequest
import aws.sdk.kotlin.services.quicksight.model.DeleteIdentityPropagationConfigResponse
import aws.sdk.kotlin.services.quicksight.model.DeleteNamespaceRequest
import aws.sdk.kotlin.services.quicksight.model.DeleteNamespaceResponse
import aws.sdk.kotlin.services.quicksight.model.DeleteRefreshScheduleRequest
import aws.sdk.kotlin.services.quicksight.model.DeleteRefreshScheduleResponse
import aws.sdk.kotlin.services.quicksight.model.DeleteRoleCustomPermissionRequest
import aws.sdk.kotlin.services.quicksight.model.DeleteRoleCustomPermissionResponse
import aws.sdk.kotlin.services.quicksight.model.DeleteRoleMembershipRequest
import aws.sdk.kotlin.services.quicksight.model.DeleteRoleMembershipResponse
import aws.sdk.kotlin.services.quicksight.model.DeleteTemplateAliasRequest
import aws.sdk.kotlin.services.quicksight.model.DeleteTemplateAliasResponse
import aws.sdk.kotlin.services.quicksight.model.DeleteTemplateRequest
import aws.sdk.kotlin.services.quicksight.model.DeleteTemplateResponse
import aws.sdk.kotlin.services.quicksight.model.DeleteThemeAliasRequest
import aws.sdk.kotlin.services.quicksight.model.DeleteThemeAliasResponse
import aws.sdk.kotlin.services.quicksight.model.DeleteThemeRequest
import aws.sdk.kotlin.services.quicksight.model.DeleteThemeResponse
import aws.sdk.kotlin.services.quicksight.model.DeleteTopicRefreshScheduleRequest
import aws.sdk.kotlin.services.quicksight.model.DeleteTopicRefreshScheduleResponse
import aws.sdk.kotlin.services.quicksight.model.DeleteTopicRequest
import aws.sdk.kotlin.services.quicksight.model.DeleteTopicResponse
import aws.sdk.kotlin.services.quicksight.model.DeleteUserByPrincipalIdRequest
import aws.sdk.kotlin.services.quicksight.model.DeleteUserByPrincipalIdResponse
import aws.sdk.kotlin.services.quicksight.model.DeleteUserCustomPermissionRequest
import aws.sdk.kotlin.services.quicksight.model.DeleteUserCustomPermissionResponse
import aws.sdk.kotlin.services.quicksight.model.DeleteUserRequest
import aws.sdk.kotlin.services.quicksight.model.DeleteUserResponse
import aws.sdk.kotlin.services.quicksight.model.DeleteVpcConnectionRequest
import aws.sdk.kotlin.services.quicksight.model.DeleteVpcConnectionResponse
import aws.sdk.kotlin.services.quicksight.model.DescribeAccountCustomizationRequest
import aws.sdk.kotlin.services.quicksight.model.DescribeAccountCustomizationResponse
import aws.sdk.kotlin.services.quicksight.model.DescribeAccountSettingsRequest
import aws.sdk.kotlin.services.quicksight.model.DescribeAccountSettingsResponse
import aws.sdk.kotlin.services.quicksight.model.DescribeAccountSubscriptionRequest
import aws.sdk.kotlin.services.quicksight.model.DescribeAccountSubscriptionResponse
import aws.sdk.kotlin.services.quicksight.model.DescribeAnalysisDefinitionRequest
import aws.sdk.kotlin.services.quicksight.model.DescribeAnalysisDefinitionResponse
import aws.sdk.kotlin.services.quicksight.model.DescribeAnalysisPermissionsRequest
import aws.sdk.kotlin.services.quicksight.model.DescribeAnalysisPermissionsResponse
import aws.sdk.kotlin.services.quicksight.model.DescribeAnalysisRequest
import aws.sdk.kotlin.services.quicksight.model.DescribeAnalysisResponse
import aws.sdk.kotlin.services.quicksight.model.DescribeAssetBundleExportJobRequest
import aws.sdk.kotlin.services.quicksight.model.DescribeAssetBundleExportJobResponse
import aws.sdk.kotlin.services.quicksight.model.DescribeAssetBundleImportJobRequest
import aws.sdk.kotlin.services.quicksight.model.DescribeAssetBundleImportJobResponse
import aws.sdk.kotlin.services.quicksight.model.DescribeBrandAssignmentRequest
import aws.sdk.kotlin.services.quicksight.model.DescribeBrandAssignmentResponse
import aws.sdk.kotlin.services.quicksight.model.DescribeBrandPublishedVersionRequest
import aws.sdk.kotlin.services.quicksight.model.DescribeBrandPublishedVersionResponse
import aws.sdk.kotlin.services.quicksight.model.DescribeBrandRequest
import aws.sdk.kotlin.services.quicksight.model.DescribeBrandResponse
import aws.sdk.kotlin.services.quicksight.model.DescribeCustomPermissionsRequest
import aws.sdk.kotlin.services.quicksight.model.DescribeCustomPermissionsResponse
import aws.sdk.kotlin.services.quicksight.model.DescribeDashboardDefinitionRequest
import aws.sdk.kotlin.services.quicksight.model.DescribeDashboardDefinitionResponse
import aws.sdk.kotlin.services.quicksight.model.DescribeDashboardPermissionsRequest
import aws.sdk.kotlin.services.quicksight.model.DescribeDashboardPermissionsResponse
import aws.sdk.kotlin.services.quicksight.model.DescribeDashboardRequest
import aws.sdk.kotlin.services.quicksight.model.DescribeDashboardResponse
import aws.sdk.kotlin.services.quicksight.model.DescribeDashboardSnapshotJobRequest
import aws.sdk.kotlin.services.quicksight.model.DescribeDashboardSnapshotJobResponse
import aws.sdk.kotlin.services.quicksight.model.DescribeDashboardSnapshotJobResultRequest
import aws.sdk.kotlin.services.quicksight.model.DescribeDashboardSnapshotJobResultResponse
import aws.sdk.kotlin.services.quicksight.model.DescribeDashboardsQaConfigurationRequest
import aws.sdk.kotlin.services.quicksight.model.DescribeDashboardsQaConfigurationResponse
import aws.sdk.kotlin.services.quicksight.model.DescribeDataSetPermissionsRequest
import aws.sdk.kotlin.services.quicksight.model.DescribeDataSetPermissionsResponse
import aws.sdk.kotlin.services.quicksight.model.DescribeDataSetRefreshPropertiesRequest
import aws.sdk.kotlin.services.quicksight.model.DescribeDataSetRefreshPropertiesResponse
import aws.sdk.kotlin.services.quicksight.model.DescribeDataSetRequest
import aws.sdk.kotlin.services.quicksight.model.DescribeDataSetResponse
import aws.sdk.kotlin.services.quicksight.model.DescribeDataSourcePermissionsRequest
import aws.sdk.kotlin.services.quicksight.model.DescribeDataSourcePermissionsResponse
import aws.sdk.kotlin.services.quicksight.model.DescribeDataSourceRequest
import aws.sdk.kotlin.services.quicksight.model.DescribeDataSourceResponse
import aws.sdk.kotlin.services.quicksight.model.DescribeDefaultQBusinessApplicationRequest
import aws.sdk.kotlin.services.quicksight.model.DescribeDefaultQBusinessApplicationResponse
import aws.sdk.kotlin.services.quicksight.model.DescribeFolderPermissionsRequest
import aws.sdk.kotlin.services.quicksight.model.DescribeFolderPermissionsResponse
import aws.sdk.kotlin.services.quicksight.model.DescribeFolderRequest
import aws.sdk.kotlin.services.quicksight.model.DescribeFolderResolvedPermissionsRequest
import aws.sdk.kotlin.services.quicksight.model.DescribeFolderResolvedPermissionsResponse
import aws.sdk.kotlin.services.quicksight.model.DescribeFolderResponse
import aws.sdk.kotlin.services.quicksight.model.DescribeGroupMembershipRequest
import aws.sdk.kotlin.services.quicksight.model.DescribeGroupMembershipResponse
import aws.sdk.kotlin.services.quicksight.model.DescribeGroupRequest
import aws.sdk.kotlin.services.quicksight.model.DescribeGroupResponse
import aws.sdk.kotlin.services.quicksight.model.DescribeIamPolicyAssignmentRequest
import aws.sdk.kotlin.services.quicksight.model.DescribeIamPolicyAssignmentResponse
import aws.sdk.kotlin.services.quicksight.model.DescribeIngestionRequest
import aws.sdk.kotlin.services.quicksight.model.DescribeIngestionResponse
import aws.sdk.kotlin.services.quicksight.model.DescribeIpRestrictionRequest
import aws.sdk.kotlin.services.quicksight.model.DescribeIpRestrictionResponse
import aws.sdk.kotlin.services.quicksight.model.DescribeKeyRegistrationRequest
import aws.sdk.kotlin.services.quicksight.model.DescribeKeyRegistrationResponse
import aws.sdk.kotlin.services.quicksight.model.DescribeNamespaceRequest
import aws.sdk.kotlin.services.quicksight.model.DescribeNamespaceResponse
import aws.sdk.kotlin.services.quicksight.model.DescribeQPersonalizationConfigurationRequest
import aws.sdk.kotlin.services.quicksight.model.DescribeQPersonalizationConfigurationResponse
import aws.sdk.kotlin.services.quicksight.model.DescribeQuickSightQSearchConfigurationRequest
import aws.sdk.kotlin.services.quicksight.model.DescribeQuickSightQSearchConfigurationResponse
import aws.sdk.kotlin.services.quicksight.model.DescribeRefreshScheduleRequest
import aws.sdk.kotlin.services.quicksight.model.DescribeRefreshScheduleResponse
import aws.sdk.kotlin.services.quicksight.model.DescribeRoleCustomPermissionRequest
import aws.sdk.kotlin.services.quicksight.model.DescribeRoleCustomPermissionResponse
import aws.sdk.kotlin.services.quicksight.model.DescribeTemplateAliasRequest
import aws.sdk.kotlin.services.quicksight.model.DescribeTemplateAliasResponse
import aws.sdk.kotlin.services.quicksight.model.DescribeTemplateDefinitionRequest
import aws.sdk.kotlin.services.quicksight.model.DescribeTemplateDefinitionResponse
import aws.sdk.kotlin.services.quicksight.model.DescribeTemplatePermissionsRequest
import aws.sdk.kotlin.services.quicksight.model.DescribeTemplatePermissionsResponse
import aws.sdk.kotlin.services.quicksight.model.DescribeTemplateRequest
import aws.sdk.kotlin.services.quicksight.model.DescribeTemplateResponse
import aws.sdk.kotlin.services.quicksight.model.DescribeThemeAliasRequest
import aws.sdk.kotlin.services.quicksight.model.DescribeThemeAliasResponse
import aws.sdk.kotlin.services.quicksight.model.DescribeThemePermissionsRequest
import aws.sdk.kotlin.services.quicksight.model.DescribeThemePermissionsResponse
import aws.sdk.kotlin.services.quicksight.model.DescribeThemeRequest
import aws.sdk.kotlin.services.quicksight.model.DescribeThemeResponse
import aws.sdk.kotlin.services.quicksight.model.DescribeTopicPermissionsRequest
import aws.sdk.kotlin.services.quicksight.model.DescribeTopicPermissionsResponse
import aws.sdk.kotlin.services.quicksight.model.DescribeTopicRefreshRequest
import aws.sdk.kotlin.services.quicksight.model.DescribeTopicRefreshResponse
import aws.sdk.kotlin.services.quicksight.model.DescribeTopicRefreshScheduleRequest
import aws.sdk.kotlin.services.quicksight.model.DescribeTopicRefreshScheduleResponse
import aws.sdk.kotlin.services.quicksight.model.DescribeTopicRequest
import aws.sdk.kotlin.services.quicksight.model.DescribeTopicResponse
import aws.sdk.kotlin.services.quicksight.model.DescribeUserRequest
import aws.sdk.kotlin.services.quicksight.model.DescribeUserResponse
import aws.sdk.kotlin.services.quicksight.model.DescribeVpcConnectionRequest
import aws.sdk.kotlin.services.quicksight.model.DescribeVpcConnectionResponse
import aws.sdk.kotlin.services.quicksight.model.GenerateEmbedUrlForAnonymousUserRequest
import aws.sdk.kotlin.services.quicksight.model.GenerateEmbedUrlForAnonymousUserResponse
import aws.sdk.kotlin.services.quicksight.model.GenerateEmbedUrlForRegisteredUserRequest
import aws.sdk.kotlin.services.quicksight.model.GenerateEmbedUrlForRegisteredUserResponse
import aws.sdk.kotlin.services.quicksight.model.GenerateEmbedUrlForRegisteredUserWithIdentityRequest
import aws.sdk.kotlin.services.quicksight.model.GenerateEmbedUrlForRegisteredUserWithIdentityResponse
import aws.sdk.kotlin.services.quicksight.model.GetDashboardEmbedUrlRequest
import aws.sdk.kotlin.services.quicksight.model.GetDashboardEmbedUrlResponse
import aws.sdk.kotlin.services.quicksight.model.GetSessionEmbedUrlRequest
import aws.sdk.kotlin.services.quicksight.model.GetSessionEmbedUrlResponse
import aws.sdk.kotlin.services.quicksight.model.ListAnalysesRequest
import aws.sdk.kotlin.services.quicksight.model.ListAnalysesResponse
import aws.sdk.kotlin.services.quicksight.model.ListAssetBundleExportJobsRequest
import aws.sdk.kotlin.services.quicksight.model.ListAssetBundleExportJobsResponse
import aws.sdk.kotlin.services.quicksight.model.ListAssetBundleImportJobsRequest
import aws.sdk.kotlin.services.quicksight.model.ListAssetBundleImportJobsResponse
import aws.sdk.kotlin.services.quicksight.model.ListBrandsRequest
import aws.sdk.kotlin.services.quicksight.model.ListBrandsResponse
import aws.sdk.kotlin.services.quicksight.model.ListCustomPermissionsRequest
import aws.sdk.kotlin.services.quicksight.model.ListCustomPermissionsResponse
import aws.sdk.kotlin.services.quicksight.model.ListDashboardVersionsRequest
import aws.sdk.kotlin.services.quicksight.model.ListDashboardVersionsResponse
import aws.sdk.kotlin.services.quicksight.model.ListDashboardsRequest
import aws.sdk.kotlin.services.quicksight.model.ListDashboardsResponse
import aws.sdk.kotlin.services.quicksight.model.ListDataSetsRequest
import aws.sdk.kotlin.services.quicksight.model.ListDataSetsResponse
import aws.sdk.kotlin.services.quicksight.model.ListDataSourcesRequest
import aws.sdk.kotlin.services.quicksight.model.ListDataSourcesResponse
import aws.sdk.kotlin.services.quicksight.model.ListFolderMembersRequest
import aws.sdk.kotlin.services.quicksight.model.ListFolderMembersResponse
import aws.sdk.kotlin.services.quicksight.model.ListFoldersForResourceRequest
import aws.sdk.kotlin.services.quicksight.model.ListFoldersForResourceResponse
import aws.sdk.kotlin.services.quicksight.model.ListFoldersRequest
import aws.sdk.kotlin.services.quicksight.model.ListFoldersResponse
import aws.sdk.kotlin.services.quicksight.model.ListGroupMembershipsRequest
import aws.sdk.kotlin.services.quicksight.model.ListGroupMembershipsResponse
import aws.sdk.kotlin.services.quicksight.model.ListGroupsRequest
import aws.sdk.kotlin.services.quicksight.model.ListGroupsResponse
import aws.sdk.kotlin.services.quicksight.model.ListIamPolicyAssignmentsForUserRequest
import aws.sdk.kotlin.services.quicksight.model.ListIamPolicyAssignmentsForUserResponse
import aws.sdk.kotlin.services.quicksight.model.ListIamPolicyAssignmentsRequest
import aws.sdk.kotlin.services.quicksight.model.ListIamPolicyAssignmentsResponse
import aws.sdk.kotlin.services.quicksight.model.ListIdentityPropagationConfigsRequest
import aws.sdk.kotlin.services.quicksight.model.ListIdentityPropagationConfigsResponse
import aws.sdk.kotlin.services.quicksight.model.ListIngestionsRequest
import aws.sdk.kotlin.services.quicksight.model.ListIngestionsResponse
import aws.sdk.kotlin.services.quicksight.model.ListNamespacesRequest
import aws.sdk.kotlin.services.quicksight.model.ListNamespacesResponse
import aws.sdk.kotlin.services.quicksight.model.ListRefreshSchedulesRequest
import aws.sdk.kotlin.services.quicksight.model.ListRefreshSchedulesResponse
import aws.sdk.kotlin.services.quicksight.model.ListRoleMembershipsRequest
import aws.sdk.kotlin.services.quicksight.model.ListRoleMembershipsResponse
import aws.sdk.kotlin.services.quicksight.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.quicksight.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.quicksight.model.ListTemplateAliasesRequest
import aws.sdk.kotlin.services.quicksight.model.ListTemplateAliasesResponse
import aws.sdk.kotlin.services.quicksight.model.ListTemplateVersionsRequest
import aws.sdk.kotlin.services.quicksight.model.ListTemplateVersionsResponse
import aws.sdk.kotlin.services.quicksight.model.ListTemplatesRequest
import aws.sdk.kotlin.services.quicksight.model.ListTemplatesResponse
import aws.sdk.kotlin.services.quicksight.model.ListThemeAliasesRequest
import aws.sdk.kotlin.services.quicksight.model.ListThemeAliasesResponse
import aws.sdk.kotlin.services.quicksight.model.ListThemeVersionsRequest
import aws.sdk.kotlin.services.quicksight.model.ListThemeVersionsResponse
import aws.sdk.kotlin.services.quicksight.model.ListThemesRequest
import aws.sdk.kotlin.services.quicksight.model.ListThemesResponse
import aws.sdk.kotlin.services.quicksight.model.ListTopicRefreshSchedulesRequest
import aws.sdk.kotlin.services.quicksight.model.ListTopicRefreshSchedulesResponse
import aws.sdk.kotlin.services.quicksight.model.ListTopicReviewedAnswersRequest
import aws.sdk.kotlin.services.quicksight.model.ListTopicReviewedAnswersResponse
import aws.sdk.kotlin.services.quicksight.model.ListTopicsRequest
import aws.sdk.kotlin.services.quicksight.model.ListTopicsResponse
import aws.sdk.kotlin.services.quicksight.model.ListUserGroupsRequest
import aws.sdk.kotlin.services.quicksight.model.ListUserGroupsResponse
import aws.sdk.kotlin.services.quicksight.model.ListUsersRequest
import aws.sdk.kotlin.services.quicksight.model.ListUsersResponse
import aws.sdk.kotlin.services.quicksight.model.ListVpcConnectionsRequest
import aws.sdk.kotlin.services.quicksight.model.ListVpcConnectionsResponse
import aws.sdk.kotlin.services.quicksight.model.PredictQaResultsRequest
import aws.sdk.kotlin.services.quicksight.model.PredictQaResultsResponse
import aws.sdk.kotlin.services.quicksight.model.PutDataSetRefreshPropertiesRequest
import aws.sdk.kotlin.services.quicksight.model.PutDataSetRefreshPropertiesResponse
import aws.sdk.kotlin.services.quicksight.model.RegisterUserRequest
import aws.sdk.kotlin.services.quicksight.model.RegisterUserResponse
import aws.sdk.kotlin.services.quicksight.model.RestoreAnalysisRequest
import aws.sdk.kotlin.services.quicksight.model.RestoreAnalysisResponse
import aws.sdk.kotlin.services.quicksight.model.SearchAnalysesRequest
import aws.sdk.kotlin.services.quicksight.model.SearchAnalysesResponse
import aws.sdk.kotlin.services.quicksight.model.SearchDashboardsRequest
import aws.sdk.kotlin.services.quicksight.model.SearchDashboardsResponse
import aws.sdk.kotlin.services.quicksight.model.SearchDataSetsRequest
import aws.sdk.kotlin.services.quicksight.model.SearchDataSetsResponse
import aws.sdk.kotlin.services.quicksight.model.SearchDataSourcesRequest
import aws.sdk.kotlin.services.quicksight.model.SearchDataSourcesResponse
import aws.sdk.kotlin.services.quicksight.model.SearchFoldersRequest
import aws.sdk.kotlin.services.quicksight.model.SearchFoldersResponse
import aws.sdk.kotlin.services.quicksight.model.SearchGroupsRequest
import aws.sdk.kotlin.services.quicksight.model.SearchGroupsResponse
import aws.sdk.kotlin.services.quicksight.model.SearchTopicsRequest
import aws.sdk.kotlin.services.quicksight.model.SearchTopicsResponse
import aws.sdk.kotlin.services.quicksight.model.StartAssetBundleExportJobRequest
import aws.sdk.kotlin.services.quicksight.model.StartAssetBundleExportJobResponse
import aws.sdk.kotlin.services.quicksight.model.StartAssetBundleImportJobRequest
import aws.sdk.kotlin.services.quicksight.model.StartAssetBundleImportJobResponse
import aws.sdk.kotlin.services.quicksight.model.StartDashboardSnapshotJobRequest
import aws.sdk.kotlin.services.quicksight.model.StartDashboardSnapshotJobResponse
import aws.sdk.kotlin.services.quicksight.model.StartDashboardSnapshotJobScheduleRequest
import aws.sdk.kotlin.services.quicksight.model.StartDashboardSnapshotJobScheduleResponse
import aws.sdk.kotlin.services.quicksight.model.TagResourceRequest
import aws.sdk.kotlin.services.quicksight.model.TagResourceResponse
import aws.sdk.kotlin.services.quicksight.model.UntagResourceRequest
import aws.sdk.kotlin.services.quicksight.model.UntagResourceResponse
import aws.sdk.kotlin.services.quicksight.model.UpdateAccountCustomizationRequest
import aws.sdk.kotlin.services.quicksight.model.UpdateAccountCustomizationResponse
import aws.sdk.kotlin.services.quicksight.model.UpdateAccountSettingsRequest
import aws.sdk.kotlin.services.quicksight.model.UpdateAccountSettingsResponse
import aws.sdk.kotlin.services.quicksight.model.UpdateAnalysisPermissionsRequest
import aws.sdk.kotlin.services.quicksight.model.UpdateAnalysisPermissionsResponse
import aws.sdk.kotlin.services.quicksight.model.UpdateAnalysisRequest
import aws.sdk.kotlin.services.quicksight.model.UpdateAnalysisResponse
import aws.sdk.kotlin.services.quicksight.model.UpdateApplicationWithTokenExchangeGrantRequest
import aws.sdk.kotlin.services.quicksight.model.UpdateApplicationWithTokenExchangeGrantResponse
import aws.sdk.kotlin.services.quicksight.model.UpdateBrandAssignmentRequest
import aws.sdk.kotlin.services.quicksight.model.UpdateBrandAssignmentResponse
import aws.sdk.kotlin.services.quicksight.model.UpdateBrandPublishedVersionRequest
import aws.sdk.kotlin.services.quicksight.model.UpdateBrandPublishedVersionResponse
import aws.sdk.kotlin.services.quicksight.model.UpdateBrandRequest
import aws.sdk.kotlin.services.quicksight.model.UpdateBrandResponse
import aws.sdk.kotlin.services.quicksight.model.UpdateCustomPermissionsRequest
import aws.sdk.kotlin.services.quicksight.model.UpdateCustomPermissionsResponse
import aws.sdk.kotlin.services.quicksight.model.UpdateDashboardLinksRequest
import aws.sdk.kotlin.services.quicksight.model.UpdateDashboardLinksResponse
import aws.sdk.kotlin.services.quicksight.model.UpdateDashboardPermissionsRequest
import aws.sdk.kotlin.services.quicksight.model.UpdateDashboardPermissionsResponse
import aws.sdk.kotlin.services.quicksight.model.UpdateDashboardPublishedVersionRequest
import aws.sdk.kotlin.services.quicksight.model.UpdateDashboardPublishedVersionResponse
import aws.sdk.kotlin.services.quicksight.model.UpdateDashboardRequest
import aws.sdk.kotlin.services.quicksight.model.UpdateDashboardResponse
import aws.sdk.kotlin.services.quicksight.model.UpdateDashboardsQaConfigurationRequest
import aws.sdk.kotlin.services.quicksight.model.UpdateDashboardsQaConfigurationResponse
import aws.sdk.kotlin.services.quicksight.model.UpdateDataSetPermissionsRequest
import aws.sdk.kotlin.services.quicksight.model.UpdateDataSetPermissionsResponse
import aws.sdk.kotlin.services.quicksight.model.UpdateDataSetRequest
import aws.sdk.kotlin.services.quicksight.model.UpdateDataSetResponse
import aws.sdk.kotlin.services.quicksight.model.UpdateDataSourcePermissionsRequest
import aws.sdk.kotlin.services.quicksight.model.UpdateDataSourcePermissionsResponse
import aws.sdk.kotlin.services.quicksight.model.UpdateDataSourceRequest
import aws.sdk.kotlin.services.quicksight.model.UpdateDataSourceResponse
import aws.sdk.kotlin.services.quicksight.model.UpdateDefaultQBusinessApplicationRequest
import aws.sdk.kotlin.services.quicksight.model.UpdateDefaultQBusinessApplicationResponse
import aws.sdk.kotlin.services.quicksight.model.UpdateFolderPermissionsRequest
import aws.sdk.kotlin.services.quicksight.model.UpdateFolderPermissionsResponse
import aws.sdk.kotlin.services.quicksight.model.UpdateFolderRequest
import aws.sdk.kotlin.services.quicksight.model.UpdateFolderResponse
import aws.sdk.kotlin.services.quicksight.model.UpdateGroupRequest
import aws.sdk.kotlin.services.quicksight.model.UpdateGroupResponse
import aws.sdk.kotlin.services.quicksight.model.UpdateIamPolicyAssignmentRequest
import aws.sdk.kotlin.services.quicksight.model.UpdateIamPolicyAssignmentResponse
import aws.sdk.kotlin.services.quicksight.model.UpdateIdentityPropagationConfigRequest
import aws.sdk.kotlin.services.quicksight.model.UpdateIdentityPropagationConfigResponse
import aws.sdk.kotlin.services.quicksight.model.UpdateIpRestrictionRequest
import aws.sdk.kotlin.services.quicksight.model.UpdateIpRestrictionResponse
import aws.sdk.kotlin.services.quicksight.model.UpdateKeyRegistrationRequest
import aws.sdk.kotlin.services.quicksight.model.UpdateKeyRegistrationResponse
import aws.sdk.kotlin.services.quicksight.model.UpdatePublicSharingSettingsRequest
import aws.sdk.kotlin.services.quicksight.model.UpdatePublicSharingSettingsResponse
import aws.sdk.kotlin.services.quicksight.model.UpdateQPersonalizationConfigurationRequest
import aws.sdk.kotlin.services.quicksight.model.UpdateQPersonalizationConfigurationResponse
import aws.sdk.kotlin.services.quicksight.model.UpdateQuickSightQSearchConfigurationRequest
import aws.sdk.kotlin.services.quicksight.model.UpdateQuickSightQSearchConfigurationResponse
import aws.sdk.kotlin.services.quicksight.model.UpdateRefreshScheduleRequest
import aws.sdk.kotlin.services.quicksight.model.UpdateRefreshScheduleResponse
import aws.sdk.kotlin.services.quicksight.model.UpdateRoleCustomPermissionRequest
import aws.sdk.kotlin.services.quicksight.model.UpdateRoleCustomPermissionResponse
import aws.sdk.kotlin.services.quicksight.model.UpdateSpiceCapacityConfigurationRequest
import aws.sdk.kotlin.services.quicksight.model.UpdateSpiceCapacityConfigurationResponse
import aws.sdk.kotlin.services.quicksight.model.UpdateTemplateAliasRequest
import aws.sdk.kotlin.services.quicksight.model.UpdateTemplateAliasResponse
import aws.sdk.kotlin.services.quicksight.model.UpdateTemplatePermissionsRequest
import aws.sdk.kotlin.services.quicksight.model.UpdateTemplatePermissionsResponse
import aws.sdk.kotlin.services.quicksight.model.UpdateTemplateRequest
import aws.sdk.kotlin.services.quicksight.model.UpdateTemplateResponse
import aws.sdk.kotlin.services.quicksight.model.UpdateThemeAliasRequest
import aws.sdk.kotlin.services.quicksight.model.UpdateThemeAliasResponse
import aws.sdk.kotlin.services.quicksight.model.UpdateThemePermissionsRequest
import aws.sdk.kotlin.services.quicksight.model.UpdateThemePermissionsResponse
import aws.sdk.kotlin.services.quicksight.model.UpdateThemeRequest
import aws.sdk.kotlin.services.quicksight.model.UpdateThemeResponse
import aws.sdk.kotlin.services.quicksight.model.UpdateTopicPermissionsRequest
import aws.sdk.kotlin.services.quicksight.model.UpdateTopicPermissionsResponse
import aws.sdk.kotlin.services.quicksight.model.UpdateTopicRefreshScheduleRequest
import aws.sdk.kotlin.services.quicksight.model.UpdateTopicRefreshScheduleResponse
import aws.sdk.kotlin.services.quicksight.model.UpdateTopicRequest
import aws.sdk.kotlin.services.quicksight.model.UpdateTopicResponse
import aws.sdk.kotlin.services.quicksight.model.UpdateUserCustomPermissionRequest
import aws.sdk.kotlin.services.quicksight.model.UpdateUserCustomPermissionResponse
import aws.sdk.kotlin.services.quicksight.model.UpdateUserRequest
import aws.sdk.kotlin.services.quicksight.model.UpdateUserResponse
import aws.sdk.kotlin.services.quicksight.model.UpdateVpcConnectionRequest
import aws.sdk.kotlin.services.quicksight.model.UpdateVpcConnectionResponse
import aws.smithy.kotlin.runtime.auth.AuthSchemeId
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProviderConfig
import aws.smithy.kotlin.runtime.awsprotocol.ClockSkewInterceptor
import aws.smithy.kotlin.runtime.client.AbstractSdkClientBuilder
import aws.smithy.kotlin.runtime.client.AbstractSdkClientFactory
import aws.smithy.kotlin.runtime.client.LogMode
import aws.smithy.kotlin.runtime.client.RetryClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfigImpl
import aws.smithy.kotlin.runtime.client.SdkClient
import aws.smithy.kotlin.runtime.client.SdkClientConfig
import aws.smithy.kotlin.runtime.client.region.RegionProvider
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.HttpAuthConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpEngineConfig
import aws.smithy.kotlin.runtime.http.config.TimeoutConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.engine.HttpEngineConfigImpl
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.net.url.Url
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.policy.RetryPolicy
import aws.smithy.kotlin.runtime.telemetry.Global
import aws.smithy.kotlin.runtime.telemetry.TelemetryConfig
import aws.smithy.kotlin.runtime.telemetry.TelemetryProvider
import aws.smithy.kotlin.runtime.util.LazyAsyncValue
import kotlin.collections.List
import kotlin.jvm.JvmStatic
import kotlin.time.Duration
import kotlinx.coroutines.runBlocking


public const val ServiceId: String = "QuickSight"
public const val SdkVersion: String = "1.5.27"
public const val ServiceApiVersion: String = "2018-04-01"

/**
 * # Amazon QuickSight API Reference
 * Amazon QuickSight is a fully managed, serverless business intelligence service for the Amazon Web Services Cloud that makes it easy to extend data and insights to every user in your organization. This API reference contains documentation for a programming interface that you can use to manage Amazon QuickSight.
 */
public interface QuickSightClient : SdkClient {
    /**
     * QuickSightClient's configuration
     */
    public override val config: Config

    public companion object : AbstractAwsSdkClientFactory<Config, Config.Builder, QuickSightClient, Builder>()
     {
        @JvmStatic
        override fun builder(): Builder = Builder()

        override fun finalizeConfig(builder: Builder) {
            super.finalizeConfig(builder)
            builder.config.interceptors.add(0, ClockSkewInterceptor())
        }

        override suspend fun finalizeEnvironmentalConfig(builder: Builder, sharedConfig: LazyAsyncValue<AwsSharedConfig>, activeProfile: LazyAsyncValue<AwsProfile>) {
            super.finalizeEnvironmentalConfig(builder, sharedConfig, activeProfile)
            builder.config.endpointUrl = builder.config.endpointUrl ?: resolveEndpointUrl(
                sharedConfig,
                "QuickSight",
                "QUICKSIGHT",
                "quicksight",
            )
        }
    }

    public class Builder internal constructor(): AbstractSdkClientBuilder<Config, Config.Builder, QuickSightClient>() {
        override val config: Config.Builder = Config.Builder()
        override fun newClient(config: Config): QuickSightClient = DefaultQuickSightClient(config)
    }

    public class Config private constructor(builder: Builder) : AwsSdkClientConfig, CredentialsProviderConfig, HttpAuthConfig, HttpClientConfig, HttpEngineConfig by builder.buildHttpEngineConfig(), RetryClientConfig, RetryStrategyClientConfig by builder.buildRetryStrategyClientConfig(), SdkClientConfig, TelemetryConfig, TimeoutConfig {
        override val clientName: String = builder.clientName
        override val region: String? = builder.region ?: runBlocking { builder.regionProvider?.getRegion() ?: resolveRegion() }
        override val regionProvider: RegionProvider = builder.regionProvider ?: DefaultRegionProviderChain()
        override val attemptTimeout: Duration? = builder.attemptTimeout
        override val authSchemePreference: kotlin.collections.List<aws.smithy.kotlin.runtime.auth.AuthSchemeId>? = builder.authSchemePreference
        override val authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = builder.authSchemes
        override val callTimeout: Duration? = builder.callTimeout
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider(httpClient = httpClient, region = region).manage()
        public val endpointProvider: QuickSightEndpointProvider = builder.endpointProvider ?: DefaultQuickSightEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        override val logMode: LogMode = builder.logMode ?: LogMode.Default
        override val retryPolicy: RetryPolicy<Any?> = builder.retryPolicy ?: AwsRetryPolicy.Default
        override val telemetryProvider: TelemetryProvider = builder.telemetryProvider ?: TelemetryProvider.Global
        override val useDualStack: Boolean = builder.useDualStack ?: false
        override val useFips: Boolean = builder.useFips ?: false
        override val applicationId: String? = builder.applicationId
        public val authSchemeProvider: QuickSightAuthSchemeProvider = builder.authSchemeProvider ?: DefaultQuickSightAuthSchemeProvider(authSchemePreference = authSchemePreference)
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public fun toBuilder(): Builder = Builder().apply {
            clientName = this@Config.clientName
            region = this@Config.region
            regionProvider = this@Config.regionProvider
            attemptTimeout = this@Config.attemptTimeout
            authSchemePreference = this@Config.authSchemePreference
            authSchemes = this@Config.authSchemes
            callTimeout = this@Config.callTimeout
            credentialsProvider = this@Config.credentialsProvider
            endpointProvider = this@Config.endpointProvider
            endpointUrl = this@Config.endpointUrl
            httpClient = this@Config.httpClient
            interceptors = this@Config.interceptors.toMutableList()
            logMode = this@Config.logMode
            retryPolicy = this@Config.retryPolicy
            retryStrategy = this@Config.retryStrategy
            telemetryProvider = this@Config.telemetryProvider
            useDualStack = this@Config.useDualStack
            useFips = this@Config.useFips
            applicationId = this@Config.applicationId
            authSchemeProvider = this@Config.authSchemeProvider
        }

        public class Builder : AwsSdkClientConfig.Builder, CredentialsProviderConfig.Builder, HttpAuthConfig.Builder, HttpClientConfig.Builder, HttpEngineConfig.Builder by HttpEngineConfigImpl.BuilderImpl(), RetryClientConfig.Builder, RetryStrategyClientConfig.Builder by RetryStrategyClientConfigImpl.BuilderImpl(), SdkClientConfig.Builder<Config>, TelemetryConfig.Builder, TimeoutConfig.Builder {
            /**
             * A reader-friendly name for the client.
             */
            override var clientName: String = "QuickSight"

            /**
             * The AWS region (e.g. `us-west-2`) to make requests to. See about AWS
             * [global infrastructure](https://aws.amazon.com/about-aws/global-infrastructure/regions_az/) for more information.
             * When specified, this static region configuration takes precedence over other region resolution methods.
             *
             * The region resolution order is:
             * 1. Static region (if specified)
             * 2. Custom region provider (if configured)
             * 3. Default region provider chain
             */
            override var region: String? = null

            /**
             * An optional region provider that determines the AWS region for client operations. When specified, this provider
             * takes precedence over the default region provider chain, unless a static region is explicitly configured.
             *
             * The region resolution order is:
             * 1. Static region (if specified)
             * 2. Custom region provider (if configured)
             * 3. Default region provider chain
             */
            override var regionProvider: RegionProvider? = null

            /**
             * The maximum amount of time to wait for any single attempt of a request within the retry loop. By default,
             * the value is `null` indicating no timeout is enforced. Attempt timeouts may be retried if allowed by the
             * current retry policy and retry capacity.
             */
            override var attemptTimeout: Duration? = null

            /**
             * The ordered preference of [AuthScheme] that this client will use.
             */
            override var authSchemePreference: kotlin.collections.List<aws.smithy.kotlin.runtime.auth.AuthSchemeId>? = null

            /**
             * Register new or override default [AuthScheme]s configured for this client. By default, the set
             * of auth schemes configured comes from the service model. An auth scheme configured explicitly takes
             * precedence over the defaults and can be used to customize identity resolution and signing for specific
             * authentication schemes.
             */
            override var authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = emptyList()

            /**
             * The maximum amount of time to wait for completion of a call, including any retries after the first attempt.
             * By default, the value is `null` indicating no timeout is enforced. Call timeouts are not retried.
             */
            override var callTimeout: Duration? = null

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            override var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint provider used to determine where to make service requests. **This is an advanced config
             * option.**
             *
             * Endpoint resolution occurs as part of the workflow for every request made via the service client.
             *
             * The inputs to endpoint resolution are defined on a per-service basis (see [EndpointParameters]).
             */
            public var endpointProvider: QuickSightEndpointProvider? = null

            /**
             * A custom endpoint to route requests to. The endpoint set here is passed to the configured
             * [endpointProvider], which may inspect and modify it as needed.
             *
             * Setting a custom endpointUrl should generally be preferred to overriding the [endpointProvider] and is
             * the recommended way to route requests to development or preview instances of a service.
             *
             * **This is an advanced config option.**
             */
            public var endpointUrl: Url? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            override var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            override var logMode: LogMode? = null

            /**
             * The policy to use for evaluating operation results and determining whether/how to retry.
             */
            override var retryPolicy: RetryPolicy<Any?>? = null

            /**
             * The telemetry provider used to instrument the SDK operations with. By default, the global telemetry
             * provider will be used.
             */
            override var telemetryProvider: TelemetryProvider? = null

            /**
             *            Flag to toggle whether to use dual-stack endpoints when making requests.
             *            See [https://docs.aws.amazon.com/sdkref/latest/guide/feature-endpoints.html] for more information.
             * `          Disabled by default.
             */
            override var useDualStack: Boolean? = null

            /**
             *            Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             * `          Disabled by default.
             */
            override var useFips: Boolean? = null

            /**
             * An optional application specific identifier.
             * When set it will be appended to the User-Agent header of every request in the form of: `app/{applicationId}`.
             * When not explicitly set, the value will be loaded from the following locations:
             *
             * - JVM System Property: `aws.userAgentAppId`
             * - Environment variable: `AWS_SDK_UA_APP_ID`
             * - Shared configuration profile attribute: `sdk_ua_app_id`
             *
             * See [shared configuration settings](https://docs.aws.amazon.com/sdkref/latest/guide/settings-reference.html)
             * reference for more information on environment variables and shared config settings.
             */
            override var applicationId: String? = null

            /**
             * Configure the provider used to resolve the authentication scheme to use for a particular operation.
             */
            public var authSchemeProvider: QuickSightAuthSchemeProvider? = null

            override fun build(): Config = Config(this)
        }
    }

    /**
     * Creates new reviewed answers for a Q Topic.
     */
    public suspend fun batchCreateTopicReviewedAnswer(input: BatchCreateTopicReviewedAnswerRequest): BatchCreateTopicReviewedAnswerResponse

    /**
     * Deletes reviewed answers for Q Topic.
     */
    public suspend fun batchDeleteTopicReviewedAnswer(input: BatchDeleteTopicReviewedAnswerRequest): BatchDeleteTopicReviewedAnswerResponse

    /**
     * Cancels an ongoing ingestion of data into SPICE.
     */
    public suspend fun cancelIngestion(input: CancelIngestionRequest): CancelIngestionResponse

    /**
     * Creates Amazon QuickSight customizations for the current Amazon Web Services Region. Currently, you can add a custom default theme by using the `CreateAccountCustomization` or `UpdateAccountCustomization` API operation. To further customize Amazon QuickSight by removing Amazon QuickSight sample assets and videos for all new users, see [Customizing Amazon QuickSight](https://docs.aws.amazon.com/quicksight/latest/user/customizing-quicksight.html) in the *Amazon QuickSight User Guide.*
     *
     * You can create customizations for your Amazon Web Services account or, if you specify a namespace, for a QuickSight namespace instead. Customizations that apply to a namespace always override customizations that apply to an Amazon Web Services account. To find out which customizations apply, use the `DescribeAccountCustomization` API operation.
     *
     * Before you use the `CreateAccountCustomization` API operation to add a theme as the namespace default, make sure that you first share the theme with the namespace. If you don't share it with the namespace, the theme isn't visible to your users even if you make it the default theme. To check if the theme is shared, view the current permissions by using the ` <a href="https://docs.aws.amazon.com/quicksight/latest/APIReference/API_DescribeThemePermissions.html">DescribeThemePermissions</a> ` API operation. To share the theme, grant permissions by using the ` <a href="https://docs.aws.amazon.com/quicksight/latest/APIReference/API_UpdateThemePermissions.html">UpdateThemePermissions</a> ` API operation.
     */
    public suspend fun createAccountCustomization(input: CreateAccountCustomizationRequest): CreateAccountCustomizationResponse

    /**
     * Creates an Amazon QuickSight account, or subscribes to Amazon QuickSight Q.
     *
     * The Amazon Web Services Region for the account is derived from what is configured in the CLI or SDK.
     *
     * Before you use this operation, make sure that you can connect to an existing Amazon Web Services account. If you don't have an Amazon Web Services account, see [Sign up for Amazon Web Services](https://docs.aws.amazon.com/quicksight/latest/user/setting-up-aws-sign-up.html) in the *Amazon QuickSight User Guide*. The person who signs up for Amazon QuickSight needs to have the correct Identity and Access Management (IAM) permissions. For more information, see [IAM Policy Examples for Amazon QuickSight](https://docs.aws.amazon.com/quicksight/latest/user/iam-policy-examples.html) in the *Amazon QuickSight User Guide*.
     *
     * If your IAM policy includes both the `Subscribe` and `CreateAccountSubscription` actions, make sure that both actions are set to `Allow`. If either action is set to `Deny`, the `Deny` action prevails and your API call fails.
     *
     * You can't pass an existing IAM role to access other Amazon Web Services services using this API operation. To pass your existing IAM role to Amazon QuickSight, see [Passing IAM roles to Amazon QuickSight](https://docs.aws.amazon.com/quicksight/latest/user/security_iam_service-with-iam.html#security-create-iam-role) in the *Amazon QuickSight User Guide*.
     *
     * You can't set default resource access on the new account from the Amazon QuickSight API. Instead, add default resource access from the Amazon QuickSight console. For more information about setting default resource access to Amazon Web Services services, see [Setting default resource access to Amazon Web Services services](https://docs.aws.amazon.com/quicksight/latest/user/scoping-policies-defaults.html) in the *Amazon QuickSight User Guide*.
     */
    public suspend fun createAccountSubscription(input: CreateAccountSubscriptionRequest): CreateAccountSubscriptionResponse

    /**
     * Creates an analysis in Amazon QuickSight. Analyses can be created either from a template or from an `AnalysisDefinition`.
     */
    public suspend fun createAnalysis(input: CreateAnalysisRequest): CreateAnalysisResponse

    /**
     * Creates an Amazon QuickSight brand.
     */
    public suspend fun createBrand(input: CreateBrandRequest): CreateBrandResponse

    /**
     * Creates a custom permissions profile.
     */
    public suspend fun createCustomPermissions(input: CreateCustomPermissionsRequest): CreateCustomPermissionsResponse

    /**
     * Creates a dashboard from either a template or directly with a `DashboardDefinition`. To first create a template, see the ` <a href="https://docs.aws.amazon.com/quicksight/latest/APIReference/API_CreateTemplate.html">CreateTemplate</a> ` API operation.
     *
     * A dashboard is an entity in Amazon QuickSight that identifies Amazon QuickSight reports, created from analyses. You can share Amazon QuickSight dashboards. With the right permissions, you can create scheduled email reports from them. If you have the correct permissions, you can create a dashboard from a template that exists in a different Amazon Web Services account.
     */
    public suspend fun createDashboard(input: CreateDashboardRequest): CreateDashboardResponse

    /**
     * Creates a dataset. This operation doesn't support datasets that include uploaded files as a source.
     */
    public suspend fun createDataSet(input: CreateDataSetRequest): CreateDataSetResponse

    /**
     * Creates a data source.
     */
    public suspend fun createDataSource(input: CreateDataSourceRequest): CreateDataSourceResponse

    /**
     * Creates an empty shared folder.
     */
    public suspend fun createFolder(input: CreateFolderRequest): CreateFolderResponse

    /**
     * Adds an asset, such as a dashboard, analysis, or dataset into a folder.
     */
    public suspend fun createFolderMembership(input: CreateFolderMembershipRequest): CreateFolderMembershipResponse

    /**
     * Use the `CreateGroup` operation to create a group in Amazon QuickSight. You can create up to 10,000 groups in a namespace. If you want to create more than 10,000 groups in a namespace, contact Amazon Web Services Support.
     *
     * The permissions resource is `arn:aws:quicksight:<your-region>:<i><relevant-aws-account-id></i>:group/default/<i><group-name></i> `.
     *
     * The response is a group object.
     */
    public suspend fun createGroup(input: CreateGroupRequest): CreateGroupResponse

    /**
     * Adds an Amazon QuickSight user to an Amazon QuickSight group.
     */
    public suspend fun createGroupMembership(input: CreateGroupMembershipRequest): CreateGroupMembershipResponse

    /**
     * Creates an assignment with one specified IAM policy, identified by its Amazon Resource Name (ARN). This policy assignment is attached to the specified groups or users of Amazon QuickSight. Assignment names are unique per Amazon Web Services account. To avoid overwriting rules in other namespaces, use assignment names that are unique.
     */
    public suspend fun createIamPolicyAssignment(input: CreateIamPolicyAssignmentRequest): CreateIamPolicyAssignmentResponse

    /**
     * Creates and starts a new SPICE ingestion for a dataset. You can manually refresh datasets in an Enterprise edition account 32 times in a 24-hour period. You can manually refresh datasets in a Standard edition account 8 times in a 24-hour period. Each 24-hour period is measured starting 24 hours before the current date and time.
     *
     * Any ingestions operating on tagged datasets inherit the same tags automatically for use in access control. For an example, see [How do I create an IAM policy to control access to Amazon EC2 resources using tags?](http://aws.amazon.com/premiumsupport/knowledge-center/iam-ec2-resource-tags/) in the Amazon Web Services Knowledge Center. Tags are visible on the tagged dataset, but not on the ingestion resource.
     */
    public suspend fun createIngestion(input: CreateIngestionRequest): CreateIngestionResponse

    /**
     * (Enterprise edition only) Creates a new namespace for you to use with Amazon QuickSight.
     *
     * A namespace allows you to isolate the Amazon QuickSight users and groups that are registered for that namespace. Users that access the namespace can share assets only with other users or groups in the same namespace. They can't see users and groups in other namespaces. You can create a namespace after your Amazon Web Services account is subscribed to Amazon QuickSight. The namespace must be unique within the Amazon Web Services account. By default, there is a limit of 100 namespaces per Amazon Web Services account. To increase your limit, create a ticket with Amazon Web ServicesSupport.
     */
    public suspend fun createNamespace(input: CreateNamespaceRequest): CreateNamespaceResponse

    /**
     * Creates a refresh schedule for a dataset. You can create up to 5 different schedules for a single dataset.
     */
    public suspend fun createRefreshSchedule(input: CreateRefreshScheduleRequest): CreateRefreshScheduleResponse

    /**
     * Use `CreateRoleMembership` to add an existing Amazon QuickSight group to an existing role.
     */
    public suspend fun createRoleMembership(input: CreateRoleMembershipRequest): CreateRoleMembershipResponse

    /**
     * Creates a template either from a `TemplateDefinition` or from an existing Amazon QuickSight analysis or template. You can use the resulting template to create additional dashboards, templates, or analyses.
     *
     * A *template* is an entity in Amazon QuickSight that encapsulates the metadata required to create an analysis and that you can use to create s dashboard. A template adds a layer of abstraction by using placeholders to replace the dataset associated with the analysis. You can use templates to create dashboards by replacing dataset placeholders with datasets that follow the same schema that was used to create the source analysis and template.
     */
    public suspend fun createTemplate(input: CreateTemplateRequest): CreateTemplateResponse

    /**
     * Creates a template alias for a template.
     */
    public suspend fun createTemplateAlias(input: CreateTemplateAliasRequest): CreateTemplateAliasResponse

    /**
     * Creates a theme.
     *
     * A *theme* is set of configuration options for color and layout. Themes apply to analyses and dashboards. For more information, see [Using Themes in Amazon QuickSight](https://docs.aws.amazon.com/quicksight/latest/user/themes-in-quicksight.html) in the *Amazon QuickSight User Guide*.
     */
    public suspend fun createTheme(input: CreateThemeRequest): CreateThemeResponse

    /**
     * Creates a theme alias for a theme.
     */
    public suspend fun createThemeAlias(input: CreateThemeAliasRequest): CreateThemeAliasResponse

    /**
     * Creates a new Q topic.
     */
    public suspend fun createTopic(input: CreateTopicRequest): CreateTopicResponse

    /**
     * Creates a topic refresh schedule.
     */
    public suspend fun createTopicRefreshSchedule(input: CreateTopicRefreshScheduleRequest): CreateTopicRefreshScheduleResponse

    /**
     * Creates a new VPC connection.
     */
    public suspend fun createVpcConnection(input: CreateVpcConnectionRequest): CreateVpcConnectionResponse

    /**
     * Deletes all Amazon QuickSight customizations in this Amazon Web Services Region for the specified Amazon Web Services account and Amazon QuickSight namespace.
     */
    public suspend fun deleteAccountCustomization(input: DeleteAccountCustomizationRequest): DeleteAccountCustomizationResponse

    /**
     * Use the `DeleteAccountSubscription` operation to delete an Amazon QuickSight account. This operation will result in an error message if you have configured your account termination protection settings to `True`. To change this setting and delete your account, call the `UpdateAccountSettings` API and set the value of the `TerminationProtectionEnabled` parameter to `False`, then make another call to the `DeleteAccountSubscription` API.
     */
    public suspend fun deleteAccountSubscription(input: DeleteAccountSubscriptionRequest): DeleteAccountSubscriptionResponse

    /**
     * Deletes an analysis from Amazon QuickSight. You can optionally include a recovery window during which you can restore the analysis. If you don't specify a recovery window value, the operation defaults to 30 days. Amazon QuickSight attaches a `DeletionTime` stamp to the response that specifies the end of the recovery window. At the end of the recovery window, Amazon QuickSight deletes the analysis permanently.
     *
     * At any time before recovery window ends, you can use the `RestoreAnalysis` API operation to remove the `DeletionTime` stamp and cancel the deletion of the analysis. The analysis remains visible in the API until it's deleted, so you can describe it but you can't make a template from it.
     *
     * An analysis that's scheduled for deletion isn't accessible in the Amazon QuickSight console. To access it in the console, restore it. Deleting an analysis doesn't delete the dashboards that you publish from it.
     */
    public suspend fun deleteAnalysis(input: DeleteAnalysisRequest): DeleteAnalysisResponse

    /**
     * Deletes an Amazon QuickSight brand.
     */
    public suspend fun deleteBrand(input: DeleteBrandRequest): DeleteBrandResponse

    /**
     * Deletes a brand assignment.
     */
    public suspend fun deleteBrandAssignment(input: DeleteBrandAssignmentRequest): DeleteBrandAssignmentResponse

    /**
     * Deletes a custom permissions profile.
     */
    public suspend fun deleteCustomPermissions(input: DeleteCustomPermissionsRequest): DeleteCustomPermissionsResponse

    /**
     * Deletes a dashboard.
     */
    public suspend fun deleteDashboard(input: DeleteDashboardRequest): DeleteDashboardResponse

    /**
     * Deletes a dataset.
     */
    public suspend fun deleteDataSet(input: DeleteDataSetRequest): DeleteDataSetResponse

    /**
     * Deletes the dataset refresh properties of the dataset.
     */
    public suspend fun deleteDataSetRefreshProperties(input: DeleteDataSetRefreshPropertiesRequest): DeleteDataSetRefreshPropertiesResponse

    /**
     * Deletes the data source permanently. This operation breaks all the datasets that reference the deleted data source.
     */
    public suspend fun deleteDataSource(input: DeleteDataSourceRequest): DeleteDataSourceResponse

    /**
     * Deletes a linked Amazon Q Business application from an Amazon QuickSight account
     */
    public suspend fun deleteDefaultQBusinessApplication(input: DeleteDefaultQBusinessApplicationRequest): DeleteDefaultQBusinessApplicationResponse

    /**
     * Deletes an empty folder.
     */
    public suspend fun deleteFolder(input: DeleteFolderRequest): DeleteFolderResponse

    /**
     * Removes an asset, such as a dashboard, analysis, or dataset, from a folder.
     */
    public suspend fun deleteFolderMembership(input: DeleteFolderMembershipRequest): DeleteFolderMembershipResponse

    /**
     * Removes a user group from Amazon QuickSight.
     */
    public suspend fun deleteGroup(input: DeleteGroupRequest): DeleteGroupResponse

    /**
     * Removes a user from a group so that the user is no longer a member of the group.
     */
    public suspend fun deleteGroupMembership(input: DeleteGroupMembershipRequest): DeleteGroupMembershipResponse

    /**
     * Deletes an existing IAM policy assignment.
     */
    public suspend fun deleteIamPolicyAssignment(input: DeleteIamPolicyAssignmentRequest): DeleteIamPolicyAssignmentResponse

    /**
     * Deletes all access scopes and authorized targets that are associated with a service from the Amazon QuickSight IAM Identity Center application.
     *
     * This operation is only supported for Amazon QuickSight accounts that use IAM Identity Center.
     */
    public suspend fun deleteIdentityPropagationConfig(input: DeleteIdentityPropagationConfigRequest): DeleteIdentityPropagationConfigResponse

    /**
     * Deletes a namespace and the users and groups that are associated with the namespace. This is an asynchronous process. Assets including dashboards, analyses, datasets and data sources are not deleted. To delete these assets, you use the API operations for the relevant asset.
     */
    public suspend fun deleteNamespace(input: DeleteNamespaceRequest): DeleteNamespaceResponse

    /**
     * Deletes a refresh schedule from a dataset.
     */
    public suspend fun deleteRefreshSchedule(input: DeleteRefreshScheduleRequest): DeleteRefreshScheduleResponse

    /**
     * Removes custom permissions from the role.
     */
    public suspend fun deleteRoleCustomPermission(input: DeleteRoleCustomPermissionRequest): DeleteRoleCustomPermissionResponse

    /**
     * Removes a group from a role.
     */
    public suspend fun deleteRoleMembership(input: DeleteRoleMembershipRequest): DeleteRoleMembershipResponse

    /**
     * Deletes a template.
     */
    public suspend fun deleteTemplate(input: DeleteTemplateRequest): DeleteTemplateResponse

    /**
     * Deletes the item that the specified template alias points to. If you provide a specific alias, you delete the version of the template that the alias points to.
     */
    public suspend fun deleteTemplateAlias(input: DeleteTemplateAliasRequest): DeleteTemplateAliasResponse

    /**
     * Deletes a theme.
     */
    public suspend fun deleteTheme(input: DeleteThemeRequest): DeleteThemeResponse

    /**
     * Deletes the version of the theme that the specified theme alias points to. If you provide a specific alias, you delete the version of the theme that the alias points to.
     */
    public suspend fun deleteThemeAlias(input: DeleteThemeAliasRequest): DeleteThemeAliasResponse

    /**
     * Deletes a topic.
     */
    public suspend fun deleteTopic(input: DeleteTopicRequest): DeleteTopicResponse

    /**
     * Deletes a topic refresh schedule.
     */
    public suspend fun deleteTopicRefreshSchedule(input: DeleteTopicRefreshScheduleRequest): DeleteTopicRefreshScheduleResponse

    /**
     * Deletes the Amazon QuickSight user that is associated with the identity of the IAM user or role that's making the call. The IAM user isn't deleted as a result of this call.
     */
    public suspend fun deleteUser(input: DeleteUserRequest): DeleteUserResponse

    /**
     * Deletes a user identified by its principal ID.
     */
    public suspend fun deleteUserByPrincipalId(input: DeleteUserByPrincipalIdRequest): DeleteUserByPrincipalIdResponse

    /**
     * Deletes a custom permissions profile from a user.
     */
    public suspend fun deleteUserCustomPermission(input: DeleteUserCustomPermissionRequest): DeleteUserCustomPermissionResponse

    /**
     * Deletes a VPC connection.
     */
    public suspend fun deleteVpcConnection(input: DeleteVpcConnectionRequest): DeleteVpcConnectionResponse

    /**
     * Describes the customizations associated with the provided Amazon Web Services account and Amazon Amazon QuickSight namespace in an Amazon Web Services Region. The Amazon QuickSight console evaluates which customizations to apply by running this API operation with the `Resolved` flag included.
     *
     * To determine what customizations display when you run this command, it can help to visualize the relationship of the entities involved.
     * + `Amazon Web Services account` - The Amazon Web Services account exists at the top of the hierarchy. It has the potential to use all of the Amazon Web Services Regions and Amazon Web Services Services. When you subscribe to Amazon QuickSight, you choose one Amazon Web Services Region to use as your home Region. That's where your free SPICE capacity is located. You can use Amazon QuickSight in any supported Amazon Web Services Region.
     * + `Amazon Web Services Region` - In each Amazon Web Services Region where you sign in to Amazon QuickSight at least once, Amazon QuickSight acts as a separate instance of the same service. If you have a user directory, it resides in us-east-1, which is the US East (N. Virginia). Generally speaking, these users have access to Amazon QuickSight in any Amazon Web Services Region, unless they are constrained to a namespace. To run the command in a different Amazon Web Services Region, you change your Region settings. If you're using the CLI, you can use one of the following options:
     *    + Use [command line options](https://docs.aws.amazon.com/cli/latest/userguide/cli-configure-options.html).
     *    + Use [named profiles](https://docs.aws.amazon.com/cli/latest/userguide/cli-configure-profiles.html).
     *    + Run `aws configure` to change your default Amazon Web Services Region. Use Enter to key the same settings for your keys. For more information, see [Configuring the CLI](https://docs.aws.amazon.com/cli/latest/userguide/cli-chap-configure.html).
     * + `Namespace` - A QuickSight namespace is a partition that contains users and assets (data sources, datasets, dashboards, and so on). To access assets that are in a specific namespace, users and groups must also be part of the same namespace. People who share a namespace are completely isolated from users and assets in other namespaces, even if they are in the same Amazon Web Services account and Amazon Web Services Region.
     * + `Applied customizations` - Within an Amazon Web Services Region, a set of Amazon QuickSight customizations can apply to an Amazon Web Services account or to a namespace. Settings that you apply to a namespace override settings that you apply to an Amazon Web Services account. All settings are isolated to a single Amazon Web Services Region. To apply them in other Amazon Web Services Regions, run the `CreateAccountCustomization` command in each Amazon Web Services Region where you want to apply the same customizations.
     */
    public suspend fun describeAccountCustomization(input: DescribeAccountCustomizationRequest): DescribeAccountCustomizationResponse

    /**
     * Describes the settings that were used when your Amazon QuickSight subscription was first created in this Amazon Web Services account.
     */
    public suspend fun describeAccountSettings(input: DescribeAccountSettingsRequest): DescribeAccountSettingsResponse

    /**
     * Use the DescribeAccountSubscription operation to receive a description of an Amazon QuickSight account's subscription. A successful API call returns an `AccountInfo` object that includes an account's name, subscription status, authentication type, edition, and notification email address.
     */
    public suspend fun describeAccountSubscription(input: DescribeAccountSubscriptionRequest): DescribeAccountSubscriptionResponse

    /**
     * Provides a summary of the metadata for an analysis.
     */
    public suspend fun describeAnalysis(input: DescribeAnalysisRequest): DescribeAnalysisResponse

    /**
     * Provides a detailed description of the definition of an analysis.
     *
     * If you do not need to know details about the content of an Analysis, for instance if you are trying to check the status of a recently created or updated Analysis, use the `DescribeAnalysis`[](https://docs.aws.amazon.com/quicksight/latest/APIReference/API_DescribeAnalysis.html) instead.
     */
    public suspend fun describeAnalysisDefinition(input: DescribeAnalysisDefinitionRequest): DescribeAnalysisDefinitionResponse

    /**
     * Provides the read and write permissions for an analysis.
     */
    public suspend fun describeAnalysisPermissions(input: DescribeAnalysisPermissionsRequest): DescribeAnalysisPermissionsResponse

    /**
     * Describes an existing export job.
     *
     * Poll job descriptions after a job starts to know the status of the job. When a job succeeds, a URL is provided to download the exported assets' data from. Download URLs are valid for five minutes after they are generated. You can call the `DescribeAssetBundleExportJob` API for a new download URL as needed.
     *
     * Job descriptions are available for 14 days after the job starts.
     */
    public suspend fun describeAssetBundleExportJob(input: DescribeAssetBundleExportJobRequest): DescribeAssetBundleExportJobResponse

    /**
     * Describes an existing import job.
     *
     * Poll job descriptions after starting a job to know when it has succeeded or failed. Job descriptions are available for 14 days after job starts.
     */
    public suspend fun describeAssetBundleImportJob(input: DescribeAssetBundleImportJobRequest): DescribeAssetBundleImportJobResponse

    /**
     * Describes a brand.
     */
    public suspend fun describeBrand(input: DescribeBrandRequest): DescribeBrandResponse

    /**
     * Describes a brand assignment.
     */
    public suspend fun describeBrandAssignment(input: DescribeBrandAssignmentRequest): DescribeBrandAssignmentResponse

    /**
     * Describes the published version of the brand.
     */
    public suspend fun describeBrandPublishedVersion(input: DescribeBrandPublishedVersionRequest): DescribeBrandPublishedVersionResponse

    /**
     * Describes a custom permissions profile.
     */
    public suspend fun describeCustomPermissions(input: DescribeCustomPermissionsRequest): DescribeCustomPermissionsResponse

    /**
     * Provides a summary for a dashboard.
     */
    public suspend fun describeDashboard(input: DescribeDashboardRequest): DescribeDashboardResponse

    /**
     * Provides a detailed description of the definition of a dashboard.
     *
     * If you do not need to know details about the content of a dashboard, for instance if you are trying to check the status of a recently created or updated dashboard, use the `DescribeDashboard`[](https://docs.aws.amazon.com/quicksight/latest/APIReference/API_DescribeDashboard.html) instead.
     */
    public suspend fun describeDashboardDefinition(input: DescribeDashboardDefinitionRequest): DescribeDashboardDefinitionResponse

    /**
     * Describes read and write permissions for a dashboard.
     */
    public suspend fun describeDashboardPermissions(input: DescribeDashboardPermissionsRequest): DescribeDashboardPermissionsResponse

    /**
     * Describes an existing snapshot job.
     *
     * Poll job descriptions after a job starts to know the status of the job. For information on available status codes, see `JobStatus`.
     */
    public suspend fun describeDashboardSnapshotJob(input: DescribeDashboardSnapshotJobRequest): DescribeDashboardSnapshotJobResponse

    /**
     * Describes the result of an existing snapshot job that has finished running.
     *
     * A finished snapshot job will return a `COMPLETED` or `FAILED` status when you poll the job with a `DescribeDashboardSnapshotJob` API call.
     *
     * If the job has not finished running, this operation returns a message that says `Dashboard Snapshot Job with id <SnapshotjobId> has not reached a terminal state.`.
     */
    public suspend fun describeDashboardSnapshotJobResult(input: DescribeDashboardSnapshotJobResultRequest): DescribeDashboardSnapshotJobResultResponse

    /**
     * Describes an existing dashboard QA configuration.
     */
    public suspend fun describeDashboardsQaConfiguration(input: DescribeDashboardsQaConfigurationRequest): DescribeDashboardsQaConfigurationResponse

    /**
     * Describes a dataset. This operation doesn't support datasets that include uploaded files as a source.
     */
    public suspend fun describeDataSet(input: DescribeDataSetRequest): DescribeDataSetResponse

    /**
     * Describes the permissions on a dataset.
     *
     * The permissions resource is `arn:aws:quicksight:region:aws-account-id:dataset/data-set-id`.
     */
    public suspend fun describeDataSetPermissions(input: DescribeDataSetPermissionsRequest): DescribeDataSetPermissionsResponse

    /**
     * Describes the refresh properties of a dataset.
     */
    public suspend fun describeDataSetRefreshProperties(input: DescribeDataSetRefreshPropertiesRequest): DescribeDataSetRefreshPropertiesResponse

    /**
     * Describes a data source.
     */
    public suspend fun describeDataSource(input: DescribeDataSourceRequest): DescribeDataSourceResponse

    /**
     * Describes the resource permissions for a data source.
     */
    public suspend fun describeDataSourcePermissions(input: DescribeDataSourcePermissionsRequest): DescribeDataSourcePermissionsResponse

    /**
     * Describes a Amazon Q Business application that is linked to an Amazon QuickSight account.
     */
    public suspend fun describeDefaultQBusinessApplication(input: DescribeDefaultQBusinessApplicationRequest): DescribeDefaultQBusinessApplicationResponse

    /**
     * Describes a folder.
     */
    public suspend fun describeFolder(input: DescribeFolderRequest): DescribeFolderResponse

    /**
     * Describes permissions for a folder.
     */
    public suspend fun describeFolderPermissions(input: DescribeFolderPermissionsRequest): DescribeFolderPermissionsResponse

    /**
     * Describes the folder resolved permissions. Permissions consists of both folder direct permissions and the inherited permissions from the ancestor folders.
     */
    public suspend fun describeFolderResolvedPermissions(input: DescribeFolderResolvedPermissionsRequest): DescribeFolderResolvedPermissionsResponse

    /**
     * Returns an Amazon QuickSight group's description and Amazon Resource Name (ARN).
     */
    public suspend fun describeGroup(input: DescribeGroupRequest): DescribeGroupResponse

    /**
     * Use the `DescribeGroupMembership` operation to determine if a user is a member of the specified group. If the user exists and is a member of the specified group, an associated `GroupMember` object is returned.
     */
    public suspend fun describeGroupMembership(input: DescribeGroupMembershipRequest): DescribeGroupMembershipResponse

    /**
     * Describes an existing IAM policy assignment, as specified by the assignment name.
     */
    public suspend fun describeIamPolicyAssignment(input: DescribeIamPolicyAssignmentRequest): DescribeIamPolicyAssignmentResponse

    /**
     * Describes a SPICE ingestion.
     */
    public suspend fun describeIngestion(input: DescribeIngestionRequest): DescribeIngestionResponse

    /**
     * Provides a summary and status of IP rules.
     */
    public suspend fun describeIpRestriction(input: DescribeIpRestrictionRequest): DescribeIpRestrictionResponse

    /**
     * Describes all customer managed key registrations in a Amazon QuickSight account.
     */
    public suspend fun describeKeyRegistration(input: DescribeKeyRegistrationRequest): DescribeKeyRegistrationResponse

    /**
     * Describes the current namespace.
     */
    public suspend fun describeNamespace(input: DescribeNamespaceRequest): DescribeNamespaceResponse

    /**
     * Describes a personalization configuration.
     */
    public suspend fun describeQPersonalizationConfiguration(input: DescribeQPersonalizationConfigurationRequest): DescribeQPersonalizationConfigurationResponse

    /**
     * Describes the state of a Amazon QuickSight Q Search configuration.
     */
    public suspend fun describeQuickSightQSearchConfiguration(input: DescribeQuickSightQSearchConfigurationRequest): DescribeQuickSightQSearchConfigurationResponse

    /**
     * Provides a summary of a refresh schedule.
     */
    public suspend fun describeRefreshSchedule(input: DescribeRefreshScheduleRequest): DescribeRefreshScheduleResponse

    /**
     * Describes all custom permissions that are mapped to a role.
     */
    public suspend fun describeRoleCustomPermission(input: DescribeRoleCustomPermissionRequest): DescribeRoleCustomPermissionResponse

    /**
     * Describes a template's metadata.
     */
    public suspend fun describeTemplate(input: DescribeTemplateRequest): DescribeTemplateResponse

    /**
     * Describes the template alias for a template.
     */
    public suspend fun describeTemplateAlias(input: DescribeTemplateAliasRequest): DescribeTemplateAliasResponse

    /**
     * Provides a detailed description of the definition of a template.
     *
     * If you do not need to know details about the content of a template, for instance if you are trying to check the status of a recently created or updated template, use the `DescribeTemplate`[](https://docs.aws.amazon.com/quicksight/latest/APIReference/API_DescribeTemplate.html) instead.
     */
    public suspend fun describeTemplateDefinition(input: DescribeTemplateDefinitionRequest): DescribeTemplateDefinitionResponse

    /**
     * Describes read and write permissions on a template.
     */
    public suspend fun describeTemplatePermissions(input: DescribeTemplatePermissionsRequest): DescribeTemplatePermissionsResponse

    /**
     * Describes a theme.
     */
    public suspend fun describeTheme(input: DescribeThemeRequest): DescribeThemeResponse

    /**
     * Describes the alias for a theme.
     */
    public suspend fun describeThemeAlias(input: DescribeThemeAliasRequest): DescribeThemeAliasResponse

    /**
     * Describes the read and write permissions for a theme.
     */
    public suspend fun describeThemePermissions(input: DescribeThemePermissionsRequest): DescribeThemePermissionsResponse

    /**
     * Describes a topic.
     */
    public suspend fun describeTopic(input: DescribeTopicRequest): DescribeTopicResponse

    /**
     * Describes the permissions of a topic.
     */
    public suspend fun describeTopicPermissions(input: DescribeTopicPermissionsRequest): DescribeTopicPermissionsResponse

    /**
     * Describes the status of a topic refresh.
     */
    public suspend fun describeTopicRefresh(input: DescribeTopicRefreshRequest): DescribeTopicRefreshResponse

    /**
     * Deletes a topic refresh schedule.
     */
    public suspend fun describeTopicRefreshSchedule(input: DescribeTopicRefreshScheduleRequest): DescribeTopicRefreshScheduleResponse

    /**
     * Returns information about a user, given the user name.
     */
    public suspend fun describeUser(input: DescribeUserRequest): DescribeUserResponse

    /**
     * Describes a VPC connection.
     */
    public suspend fun describeVpcConnection(input: DescribeVpcConnectionRequest): DescribeVpcConnectionResponse

    /**
     * Generates an embed URL that you can use to embed an Amazon QuickSight dashboard or visual in your website, without having to register any reader users. Before you use this action, make sure that you have configured the dashboards and permissions.
     *
     * The following rules apply to the generated URL:
     * + It contains a temporary bearer token. It is valid for 5 minutes after it is generated. Once redeemed within this period, it cannot be re-used again.
     * + The URL validity period should not be confused with the actual session lifetime that can be customized using the ` <a href="https://docs.aws.amazon.com/quicksight/latest/APIReference/API_GenerateEmbedUrlForAnonymousUser.html#QS-GenerateEmbedUrlForAnonymousUser-request-SessionLifetimeInMinutes">SessionLifetimeInMinutes</a> ` parameter. The resulting user session is valid for 15 minutes (minimum) to 10 hours (maximum). The default session duration is 10 hours.
     * + You are charged only when the URL is used or there is interaction with Amazon QuickSight.
     *
     * For more information, see [Embedded Analytics](https://docs.aws.amazon.com/quicksight/latest/user/embedded-analytics.html) in the *Amazon QuickSight User Guide*.
     *
     * For more information about the high-level steps for embedding and for an interactive demo of the ways you can customize embedding, visit the [Amazon QuickSight Developer Portal](https://docs.aws.amazon.com/quicksight/latest/user/quicksight-dev-portal.html).
     */
    public suspend fun generateEmbedUrlForAnonymousUser(input: GenerateEmbedUrlForAnonymousUserRequest): GenerateEmbedUrlForAnonymousUserResponse

    /**
     * Generates an embed URL that you can use to embed an Amazon QuickSight experience in your website. This action can be used for any type of user registered in an Amazon QuickSight account. Before you use this action, make sure that you have configured the relevant Amazon QuickSight resource and permissions.
     *
     * The following rules apply to the generated URL:
     * + It contains a temporary bearer token. It is valid for 5 minutes after it is generated. Once redeemed within this period, it cannot be re-used again.
     * + The URL validity period should not be confused with the actual session lifetime that can be customized using the ` <a href="https://docs.aws.amazon.com/quicksight/latest/APIReference/API_GenerateEmbedUrlForRegisteredUser.html#QS-GenerateEmbedUrlForRegisteredUser-request-SessionLifetimeInMinutes">SessionLifetimeInMinutes</a> ` parameter.The resulting user session is valid for 15 minutes (minimum) to 10 hours (maximum). The default session duration is 10 hours.
     * + You are charged only when the URL is used or there is interaction with Amazon QuickSight.
     *
     * For more information, see [Embedded Analytics](https://docs.aws.amazon.com/quicksight/latest/user/embedded-analytics.html) in the *Amazon QuickSight User Guide*.
     *
     * For more information about the high-level steps for embedding and for an interactive demo of the ways you can customize embedding, visit the [Amazon QuickSight Developer Portal](https://docs.aws.amazon.com/quicksight/latest/user/quicksight-dev-portal.html).
     */
    public suspend fun generateEmbedUrlForRegisteredUser(input: GenerateEmbedUrlForRegisteredUserRequest): GenerateEmbedUrlForRegisteredUserResponse

    /**
     * Generates an embed URL that you can use to embed an Amazon QuickSight experience in your website. This action can be used for any type of user that is registered in an Amazon QuickSight account that uses IAM Identity Center for authentication. This API requires [identity-enhanced IAM Role sessions](https://docs.aws.amazon.com/singlesignon/latest/userguide/trustedidentitypropagation-overview.html#types-identity-enhanced-iam-role-sessions) for the authenticated user that the API call is being made for.
     *
     * This API uses [trusted identity propagation](https://docs.aws.amazon.com/singlesignon/latest/userguide/trustedidentitypropagation.html) to ensure that an end user is authenticated and receives the embed URL that is specific to that user. The IAM Identity Center application that the user has logged into needs to have [trusted Identity Propagation enabled for Amazon QuickSight](https://docs.aws.amazon.com/singlesignon/latest/userguide/trustedidentitypropagation-using-customermanagedapps-specify-trusted-apps.html) with the scope value set to `quicksight:read`. Before you use this action, make sure that you have configured the relevant Amazon QuickSight resource and permissions.
     */
    public suspend fun generateEmbedUrlForRegisteredUserWithIdentity(input: GenerateEmbedUrlForRegisteredUserWithIdentityRequest): GenerateEmbedUrlForRegisteredUserWithIdentityResponse

    /**
     * Generates a temporary session URL and authorization code(bearer token) that you can use to embed an Amazon QuickSight read-only dashboard in your website or application. Before you use this command, make sure that you have configured the dashboards and permissions.
     *
     * Currently, you can use `GetDashboardEmbedURL` only from the server, not from the user's browser. The following rules apply to the generated URL:
     * + They must be used together.
     * + They can be used one time only.
     * + They are valid for 5 minutes after you run this command.
     * + You are charged only when the URL is used or there is interaction with Amazon QuickSight.
     * + The resulting user session is valid for 15 minutes (default) up to 10 hours (maximum). You can use the optional `SessionLifetimeInMinutes` parameter to customize session duration.
     *
     * For more information, see [Embedding Analytics Using GetDashboardEmbedUrl](https://docs.aws.amazon.com/quicksight/latest/user/embedded-analytics-deprecated.html) in the *Amazon QuickSight User Guide*.
     *
     * For more information about the high-level steps for embedding and for an interactive demo of the ways you can customize embedding, visit the [Amazon QuickSight Developer Portal](https://docs.aws.amazon.com/quicksight/latest/user/quicksight-dev-portal.html).
     */
    public suspend fun getDashboardEmbedUrl(input: GetDashboardEmbedUrlRequest): GetDashboardEmbedUrlResponse

    /**
     * Generates a session URL and authorization code that you can use to embed the Amazon Amazon QuickSight console in your web server code. Use `GetSessionEmbedUrl` where you want to provide an authoring portal that allows users to create data sources, datasets, analyses, and dashboards. The users who access an embedded Amazon QuickSight console need belong to the author or admin security cohort. If you want to restrict permissions to some of these features, add a custom permissions profile to the user with the ` <a href="https://docs.aws.amazon.com/quicksight/latest/APIReference/API_UpdateUser.html">UpdateUser</a> ` API operation. Use ` <a href="https://docs.aws.amazon.com/quicksight/latest/APIReference/API_RegisterUser.html">RegisterUser</a> ` API operation to add a new user with a custom permission profile attached. For more information, see the following sections in the *Amazon QuickSight User Guide*:
     * + [Embedding Analytics](https://docs.aws.amazon.com/quicksight/latest/user/embedded-analytics.html)
     * + [Customizing Access to the Amazon QuickSight Console](https://docs.aws.amazon.com/quicksight/latest/user/customizing-permissions-to-the-quicksight-console.html)
     */
    public suspend fun getSessionEmbedUrl(input: GetSessionEmbedUrlRequest): GetSessionEmbedUrlResponse

    /**
     * Lists Amazon QuickSight analyses that exist in the specified Amazon Web Services account.
     */
    public suspend fun listAnalyses(input: ListAnalysesRequest): ListAnalysesResponse

    /**
     * Lists all asset bundle export jobs that have been taken place in the last 14 days. Jobs created more than 14 days ago are deleted forever and are not returned. If you are using the same job ID for multiple jobs, `ListAssetBundleExportJobs` only returns the most recent job that uses the repeated job ID.
     */
    public suspend fun listAssetBundleExportJobs(input: ListAssetBundleExportJobsRequest): ListAssetBundleExportJobsResponse

    /**
     * Lists all asset bundle import jobs that have taken place in the last 14 days. Jobs created more than 14 days ago are deleted forever and are not returned. If you are using the same job ID for multiple jobs, `ListAssetBundleImportJobs` only returns the most recent job that uses the repeated job ID.
     */
    public suspend fun listAssetBundleImportJobs(input: ListAssetBundleImportJobsRequest): ListAssetBundleImportJobsResponse

    /**
     * Lists all brands in an Amazon QuickSight account.
     */
    public suspend fun listBrands(input: ListBrandsRequest): ListBrandsResponse

    /**
     * Returns a list of all the custom permissions profiles.
     */
    public suspend fun listCustomPermissions(input: ListCustomPermissionsRequest): ListCustomPermissionsResponse

    /**
     * Lists all the versions of the dashboards in the Amazon QuickSight subscription.
     */
    public suspend fun listDashboardVersions(input: ListDashboardVersionsRequest): ListDashboardVersionsResponse

    /**
     * Lists dashboards in an Amazon Web Services account.
     */
    public suspend fun listDashboards(input: ListDashboardsRequest): ListDashboardsResponse

    /**
     * Lists all of the datasets belonging to the current Amazon Web Services account in an Amazon Web Services Region.
     *
     * The permissions resource is `arn:aws:quicksight:region:aws-account-id:dataset&#47;*`.
     */
    public suspend fun listDataSets(input: ListDataSetsRequest): ListDataSetsResponse

    /**
     * Lists data sources in current Amazon Web Services Region that belong to this Amazon Web Services account.
     */
    public suspend fun listDataSources(input: ListDataSourcesRequest): ListDataSourcesResponse

    /**
     * List all assets (`DASHBOARD`, `ANALYSIS`, and `DATASET`) in a folder.
     */
    public suspend fun listFolderMembers(input: ListFolderMembersRequest): ListFolderMembersResponse

    /**
     * Lists all folders in an account.
     */
    public suspend fun listFolders(input: ListFoldersRequest): ListFoldersResponse

    /**
     * List all folders that a resource is a member of.
     */
    public suspend fun listFoldersForResource(input: ListFoldersForResourceRequest): ListFoldersForResourceResponse

    /**
     * Lists member users in a group.
     */
    public suspend fun listGroupMemberships(input: ListGroupMembershipsRequest): ListGroupMembershipsResponse

    /**
     * Lists all user groups in Amazon QuickSight.
     */
    public suspend fun listGroups(input: ListGroupsRequest): ListGroupsResponse

    /**
     * Lists the IAM policy assignments in the current Amazon QuickSight account.
     */
    public suspend fun listIamPolicyAssignments(input: ListIamPolicyAssignmentsRequest): ListIamPolicyAssignmentsResponse

    /**
     * Lists all of the IAM policy assignments, including the Amazon Resource Names (ARNs), for the IAM policies assigned to the specified user and group, or groups that the user belongs to.
     */
    public suspend fun listIamPolicyAssignmentsForUser(input: ListIamPolicyAssignmentsForUserRequest): ListIamPolicyAssignmentsForUserResponse

    /**
     * Lists all services and authorized targets that the Amazon QuickSight IAM Identity Center application can access.
     *
     * This operation is only supported for Amazon QuickSight accounts that use IAM Identity Center.
     */
    public suspend fun listIdentityPropagationConfigs(input: ListIdentityPropagationConfigsRequest): ListIdentityPropagationConfigsResponse

    /**
     * Lists the history of SPICE ingestions for a dataset. Limited to 5 TPS per user and 25 TPS per account.
     */
    public suspend fun listIngestions(input: ListIngestionsRequest): ListIngestionsResponse

    /**
     * Lists the namespaces for the specified Amazon Web Services account. This operation doesn't list deleted namespaces.
     */
    public suspend fun listNamespaces(input: ListNamespacesRequest): ListNamespacesResponse

    /**
     * Lists the refresh schedules of a dataset. Each dataset can have up to 5 schedules.
     */
    public suspend fun listRefreshSchedules(input: ListRefreshSchedulesRequest): ListRefreshSchedulesResponse

    /**
     * Lists all groups that are associated with a role.
     */
    public suspend fun listRoleMemberships(input: ListRoleMembershipsRequest): ListRoleMembershipsResponse

    /**
     * Lists the tags assigned to a resource.
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Lists all the aliases of a template.
     */
    public suspend fun listTemplateAliases(input: ListTemplateAliasesRequest): ListTemplateAliasesResponse

    /**
     * Lists all the versions of the templates in the current Amazon QuickSight account.
     */
    public suspend fun listTemplateVersions(input: ListTemplateVersionsRequest): ListTemplateVersionsResponse

    /**
     * Lists all the templates in the current Amazon QuickSight account.
     */
    public suspend fun listTemplates(input: ListTemplatesRequest): ListTemplatesResponse

    /**
     * Lists all the aliases of a theme.
     */
    public suspend fun listThemeAliases(input: ListThemeAliasesRequest): ListThemeAliasesResponse

    /**
     * Lists all the versions of the themes in the current Amazon Web Services account.
     */
    public suspend fun listThemeVersions(input: ListThemeVersionsRequest): ListThemeVersionsResponse

    /**
     * Lists all the themes in the current Amazon Web Services account.
     */
    public suspend fun listThemes(input: ListThemesRequest): ListThemesResponse

    /**
     * Lists all of the refresh schedules for a topic.
     */
    public suspend fun listTopicRefreshSchedules(input: ListTopicRefreshSchedulesRequest): ListTopicRefreshSchedulesResponse

    /**
     * Lists all reviewed answers for a Q Topic.
     */
    public suspend fun listTopicReviewedAnswers(input: ListTopicReviewedAnswersRequest): ListTopicReviewedAnswersResponse

    /**
     * Lists all of the topics within an account.
     */
    public suspend fun listTopics(input: ListTopicsRequest): ListTopicsResponse

    /**
     * Lists the Amazon QuickSight groups that an Amazon QuickSight user is a member of.
     */
    public suspend fun listUserGroups(input: ListUserGroupsRequest): ListUserGroupsResponse

    /**
     * Returns a list of all of the Amazon QuickSight users belonging to this account.
     */
    public suspend fun listUsers(input: ListUsersRequest): ListUsersResponse

    /**
     * Lists all of the VPC connections in the current set Amazon Web Services Region of an Amazon Web Services account.
     */
    public suspend fun listVpcConnections(input: ListVpcConnectionsRequest): ListVpcConnectionsResponse

    /**
     * Predicts existing visuals or generates new visuals to answer a given query.
     *
     * This API uses [trusted identity propagation](https://docs.aws.amazon.com/singlesignon/latest/userguide/trustedidentitypropagation.html) to ensure that an end user is authenticated and receives the embed URL that is specific to that user. The IAM Identity Center application that the user has logged into needs to have [trusted Identity Propagation enabled for Amazon QuickSight](https://docs.aws.amazon.com/singlesignon/latest/userguide/trustedidentitypropagation-using-customermanagedapps-specify-trusted-apps.html) with the scope value set to `quicksight:read`. Before you use this action, make sure that you have configured the relevant Amazon QuickSight resource and permissions.
     *
     * We recommend enabling the `QSearchStatus` API to unlock the full potential of `PredictQnA`. When `QSearchStatus` is enabled, it first checks the specified dashboard for any existing visuals that match the question. If no matching visuals are found, `PredictQnA` uses generative Q&A to provide an answer. To update the `QSearchStatus`, see [UpdateQuickSightQSearchConfiguration](https://docs.aws.amazon.com/quicksight/latest/APIReference/API_UpdateQuickSightQSearchConfiguration.html).
     */
    public suspend fun predictQaResults(input: PredictQaResultsRequest): PredictQaResultsResponse

    /**
     * Creates or updates the dataset refresh properties for the dataset.
     */
    public suspend fun putDataSetRefreshProperties(input: PutDataSetRefreshPropertiesRequest): PutDataSetRefreshPropertiesResponse

    /**
     * Creates an Amazon QuickSight user whose identity is associated with the Identity and Access Management (IAM) identity or role specified in the request. When you register a new user from the Amazon QuickSight API, Amazon QuickSight generates a registration URL. The user accesses this registration URL to create their account. Amazon QuickSight doesn't send a registration email to users who are registered from the Amazon QuickSight API. If you want new users to receive a registration email, then add those users in the Amazon QuickSight console. For more information on registering a new user in the Amazon QuickSight console, see [ Inviting users to access Amazon QuickSight](https://docs.aws.amazon.com/quicksight/latest/user/managing-users.html#inviting-users).
     */
    public suspend fun registerUser(input: RegisterUserRequest): RegisterUserResponse

    /**
     * Restores an analysis.
     */
    public suspend fun restoreAnalysis(input: RestoreAnalysisRequest): RestoreAnalysisResponse

    /**
     * Searches for analyses that belong to the user specified in the filter.
     *
     * This operation is eventually consistent. The results are best effort and may not reflect very recent updates and changes.
     */
    public suspend fun searchAnalyses(input: SearchAnalysesRequest): SearchAnalysesResponse

    /**
     * Searches for dashboards that belong to a user.
     *
     * This operation is eventually consistent. The results are best effort and may not reflect very recent updates and changes.
     */
    public suspend fun searchDashboards(input: SearchDashboardsRequest): SearchDashboardsResponse

    /**
     * Use the `SearchDataSets` operation to search for datasets that belong to an account.
     */
    public suspend fun searchDataSets(input: SearchDataSetsRequest): SearchDataSetsResponse

    /**
     * Use the `SearchDataSources` operation to search for data sources that belong to an account.
     */
    public suspend fun searchDataSources(input: SearchDataSourcesRequest): SearchDataSourcesResponse

    /**
     * Searches the subfolders in a folder.
     */
    public suspend fun searchFolders(input: SearchFoldersRequest): SearchFoldersResponse

    /**
     * Use the `SearchGroups` operation to search groups in a specified Amazon QuickSight namespace using the supplied filters.
     */
    public suspend fun searchGroups(input: SearchGroupsRequest): SearchGroupsResponse

    /**
     * Searches for any Q topic that exists in an Amazon QuickSight account.
     */
    public suspend fun searchTopics(input: SearchTopicsRequest): SearchTopicsResponse

    /**
     * Starts an Asset Bundle export job.
     *
     * An Asset Bundle export job exports specified Amazon QuickSight assets. You can also choose to export any asset dependencies in the same job. Export jobs run asynchronously and can be polled with a `DescribeAssetBundleExportJob` API call. When a job is successfully completed, a download URL that contains the exported assets is returned. The URL is valid for 5 minutes and can be refreshed with a `DescribeAssetBundleExportJob` API call. Each Amazon QuickSight account can run up to 5 export jobs concurrently.
     *
     * The API caller must have the necessary permissions in their IAM role to access each resource before the resources can be exported.
     */
    public suspend fun startAssetBundleExportJob(input: StartAssetBundleExportJobRequest): StartAssetBundleExportJobResponse

    /**
     * Starts an Asset Bundle import job.
     *
     * An Asset Bundle import job imports specified Amazon QuickSight assets into an Amazon QuickSight account. You can also choose to import a naming prefix and specified configuration overrides. The assets that are contained in the bundle file that you provide are used to create or update a new or existing asset in your Amazon QuickSight account. Each Amazon QuickSight account can run up to 5 import jobs concurrently.
     *
     * The API caller must have the necessary `"create"`, `"describe"`, and `"update"` permissions in their IAM role to access each resource type that is contained in the bundle file before the resources can be imported.
     */
    public suspend fun startAssetBundleImportJob(input: StartAssetBundleImportJobRequest): StartAssetBundleImportJobResponse

    /**
     * Starts an asynchronous job that generates a snapshot of a dashboard's output. You can request one or several of the following format configurations in each API call.
     * + 1 Paginated PDF
     * + 1 Excel workbook that includes up to 5 table or pivot table visuals
     * + 5 CSVs from table or pivot table visuals
     *
     * The status of a submitted job can be polled with the `DescribeDashboardSnapshotJob` API. When you call the `DescribeDashboardSnapshotJob` API, check the `JobStatus` field in the response. Once the job reaches a `COMPLETED` or `FAILED` status, use the `DescribeDashboardSnapshotJobResult` API to obtain the URLs for the generated files. If the job fails, the `DescribeDashboardSnapshotJobResult` API returns detailed information about the error that occurred.
     *
     * **StartDashboardSnapshotJob API throttling**
     *
     * Amazon QuickSight utilizes API throttling to create a more consistent user experience within a time span for customers when they call the `StartDashboardSnapshotJob`. By default, 12 jobs can run simlutaneously in one Amazon Web Services account and users can submit up 10 API requests per second before an account is throttled. If an overwhelming number of API requests are made by the same user in a short period of time, Amazon QuickSight throttles the API calls to maintin an optimal experience and reliability for all Amazon QuickSight users.
     *
     * **Common throttling scenarios**
     *
     * The following list provides information about the most commin throttling scenarios that can occur.
     * + **A large number of `SnapshotExport` API jobs are running simultaneously on an Amazon Web Services account.** When a new `StartDashboardSnapshotJob` is created and there are already 12 jobs with the `RUNNING` status, the new job request fails and returns a `LimitExceededException` error. Wait for a current job to comlpete before you resubmit the new job.
     * + **A large number of API requests are submitted on an Amazon Web Services account.** When a user makes more than 10 API calls to the Amazon QuickSight API in one second, a `ThrottlingException` is returned.
     *
     * If your use case requires a higher throttling limit, contact your account admin or [Amazon Web ServicesSupport](http://aws.amazon.com/contact-us/) to explore options to tailor a more optimal expereince for your account.
     *
     * **Best practices to handle throttling**
     *
     * If your use case projects high levels of API traffic, try to reduce the degree of frequency and parallelism of API calls as much as you can to avoid throttling. You can also perform a timing test to calculate an estimate for the total processing time of your projected load that stays within the throttling limits of the Amazon QuickSight APIs. For example, if your projected traffic is 100 snapshot jobs before 12:00 PM per day, start 12 jobs in parallel and measure the amount of time it takes to proccess all 12 jobs. Once you obtain the result, multiply the duration by 9, for example `(12 minutes * 9 = 108 minutes)`. Use the new result to determine the latest time at which the jobs need to be started to meet your target deadline.
     *
     * The time that it takes to process a job can be impacted by the following factors:
     * + The dataset type (Direct Query or SPICE).
     * + The size of the dataset.
     * + The complexity of the calculated fields that are used in the dashboard.
     * + The number of visuals that are on a sheet.
     * + The types of visuals that are on the sheet.
     * + The number of formats and snapshots that are requested in the job configuration.
     * + The size of the generated snapshots.
     */
    public suspend fun startDashboardSnapshotJob(input: StartDashboardSnapshotJobRequest): StartDashboardSnapshotJobResponse

    /**
     * Starts an asynchronous job that runs an existing dashboard schedule and sends the dashboard snapshot through email.
     *
     * Only one job can run simultaneously in a given schedule. Repeated requests are skipped with a `202` HTTP status code.
     *
     * For more information, see [Scheduling and sending Amazon QuickSight reports by email](https://docs.aws.amazon.com/quicksight/latest/user/sending-reports.html) and [Configuring email report settings for a Amazon QuickSight dashboard](https://docs.aws.amazon.com/quicksight/latest/user/email-reports-from-dashboard.html) in the *Amazon QuickSight User Guide*.
     */
    public suspend fun startDashboardSnapshotJobSchedule(input: StartDashboardSnapshotJobScheduleRequest): StartDashboardSnapshotJobScheduleResponse

    /**
     * Assigns one or more tags (key-value pairs) to the specified Amazon QuickSight resource.
     *
     * Tags can help you organize and categorize your resources. You can also use them to scope user permissions, by granting a user permission to access or change only resources with certain tag values. You can use the `TagResource` operation with a resource that already has tags. If you specify a new tag key for the resource, this tag is appended to the list of tags associated with the resource. If you specify a tag key that is already associated with the resource, the new tag value that you specify replaces the previous value for that tag.
     *
     * You can associate as many as 50 tags with a resource. Amazon QuickSight supports tagging on data set, data source, dashboard, template, topic, and user.
     *
     * Tagging for Amazon QuickSight works in a similar way to tagging for other Amazon Web Services services, except for the following:
     * + Tags are used to track costs for users in Amazon QuickSight. You can't tag other resources that Amazon QuickSight costs are based on, such as storage capacoty (SPICE), session usage, alert consumption, or reporting units.
     * + Amazon QuickSight doesn't currently support the tag editor for Resource Groups.
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Removes a tag or tags from a resource.
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Updates Amazon QuickSight customizations for the current Amazon Web Services Region. Currently, the only customization that you can use is a theme.
     *
     * You can use customizations for your Amazon Web Services account or, if you specify a namespace, for a Amazon QuickSight namespace instead. Customizations that apply to a namespace override customizations that apply to an Amazon Web Services account. To find out which customizations apply, use the `DescribeAccountCustomization` API operation.
     */
    public suspend fun updateAccountCustomization(input: UpdateAccountCustomizationRequest): UpdateAccountCustomizationResponse

    /**
     * Updates the Amazon QuickSight settings in your Amazon Web Services account.
     */
    public suspend fun updateAccountSettings(input: UpdateAccountSettingsRequest): UpdateAccountSettingsResponse

    /**
     * Updates an analysis in Amazon QuickSight
     */
    public suspend fun updateAnalysis(input: UpdateAnalysisRequest): UpdateAnalysisResponse

    /**
     * Updates the read and write permissions for an analysis.
     */
    public suspend fun updateAnalysisPermissions(input: UpdateAnalysisPermissionsRequest): UpdateAnalysisPermissionsResponse

    /**
     * Updates an Amazon QuickSight application with a token exchange grant. This operation only supports Amazon QuickSight applications that are registered with IAM Identity Center.
     */
    public suspend fun updateApplicationWithTokenExchangeGrant(input: UpdateApplicationWithTokenExchangeGrantRequest): UpdateApplicationWithTokenExchangeGrantResponse

    /**
     * Updates a brand.
     */
    public suspend fun updateBrand(input: UpdateBrandRequest): UpdateBrandResponse

    /**
     * Updates a brand assignment.
     */
    public suspend fun updateBrandAssignment(input: UpdateBrandAssignmentRequest): UpdateBrandAssignmentResponse

    /**
     * Updates the published version of a brand.
     */
    public suspend fun updateBrandPublishedVersion(input: UpdateBrandPublishedVersionRequest): UpdateBrandPublishedVersionResponse

    /**
     * Updates a custom permissions profile.
     */
    public suspend fun updateCustomPermissions(input: UpdateCustomPermissionsRequest): UpdateCustomPermissionsResponse

    /**
     * Updates a dashboard in an Amazon Web Services account.
     *
     * Updating a Dashboard creates a new dashboard version but does not immediately publish the new version. You can update the published version of a dashboard by using the ` <a href="https://docs.aws.amazon.com/quicksight/latest/APIReference/API_UpdateDashboardPublishedVersion.html">UpdateDashboardPublishedVersion</a> ` API operation.
     */
    public suspend fun updateDashboard(input: UpdateDashboardRequest): UpdateDashboardResponse

    /**
     * Updates the linked analyses on a dashboard.
     */
    public suspend fun updateDashboardLinks(input: UpdateDashboardLinksRequest): UpdateDashboardLinksResponse

    /**
     * Updates read and write permissions on a dashboard.
     */
    public suspend fun updateDashboardPermissions(input: UpdateDashboardPermissionsRequest): UpdateDashboardPermissionsResponse

    /**
     * Updates the published version of a dashboard.
     */
    public suspend fun updateDashboardPublishedVersion(input: UpdateDashboardPublishedVersionRequest): UpdateDashboardPublishedVersionResponse

    /**
     * Updates a Dashboard QA configuration.
     */
    public suspend fun updateDashboardsQaConfiguration(input: UpdateDashboardsQaConfigurationRequest): UpdateDashboardsQaConfigurationResponse

    /**
     * Updates a dataset. This operation doesn't support datasets that include uploaded files as a source. Partial updates are not supported by this operation.
     */
    public suspend fun updateDataSet(input: UpdateDataSetRequest): UpdateDataSetResponse

    /**
     * Updates the permissions on a dataset.
     *
     * The permissions resource is `arn:aws:quicksight:region:aws-account-id:dataset/data-set-id`.
     */
    public suspend fun updateDataSetPermissions(input: UpdateDataSetPermissionsRequest): UpdateDataSetPermissionsResponse

    /**
     * Updates a data source.
     */
    public suspend fun updateDataSource(input: UpdateDataSourceRequest): UpdateDataSourceResponse

    /**
     * Updates the permissions to a data source.
     */
    public suspend fun updateDataSourcePermissions(input: UpdateDataSourcePermissionsRequest): UpdateDataSourcePermissionsResponse

    /**
     * Updates a Amazon Q Business application that is linked to a Amazon QuickSight account.
     */
    public suspend fun updateDefaultQBusinessApplication(input: UpdateDefaultQBusinessApplicationRequest): UpdateDefaultQBusinessApplicationResponse

    /**
     * Updates the name of a folder.
     */
    public suspend fun updateFolder(input: UpdateFolderRequest): UpdateFolderResponse

    /**
     * Updates permissions of a folder.
     */
    public suspend fun updateFolderPermissions(input: UpdateFolderPermissionsRequest): UpdateFolderPermissionsResponse

    /**
     * Changes a group description.
     */
    public suspend fun updateGroup(input: UpdateGroupRequest): UpdateGroupResponse

    /**
     * Updates an existing IAM policy assignment. This operation updates only the optional parameter or parameters that are specified in the request. This overwrites all of the users included in `Identities`.
     */
    public suspend fun updateIamPolicyAssignment(input: UpdateIamPolicyAssignmentRequest): UpdateIamPolicyAssignmentResponse

    /**
     * Adds or updates services and authorized targets to configure what the Amazon QuickSight IAM Identity Center application can access.
     *
     * This operation is only supported for Amazon QuickSight accounts using IAM Identity Center
     */
    public suspend fun updateIdentityPropagationConfig(input: UpdateIdentityPropagationConfigRequest): UpdateIdentityPropagationConfigResponse

    /**
     * Updates the content and status of IP rules. Traffic from a source is allowed when the source satisfies either the `IpRestrictionRule`, `VpcIdRestrictionRule`, or `VpcEndpointIdRestrictionRule`. To use this operation, you must provide the entire map of rules. You can use the `DescribeIpRestriction` operation to get the current rule map.
     */
    public suspend fun updateIpRestriction(input: UpdateIpRestrictionRequest): UpdateIpRestrictionResponse

    /**
     * Updates a customer managed key in a Amazon QuickSight account.
     */
    public suspend fun updateKeyRegistration(input: UpdateKeyRegistrationRequest): UpdateKeyRegistrationResponse

    /**
     * Use the `UpdatePublicSharingSettings` operation to turn on or turn off the public sharing settings of an Amazon QuickSight dashboard.
     *
     * To use this operation, turn on session capacity pricing for your Amazon QuickSight account.
     *
     * Before you can turn on public sharing on your account, make sure to give public sharing permissions to an administrative user in the Identity and Access Management (IAM) console. For more information on using IAM with Amazon QuickSight, see [Using Amazon QuickSight with IAM](https://docs.aws.amazon.com/quicksight/latest/user/security_iam_service-with-iam.html) in the *Amazon QuickSight User Guide*.
     */
    public suspend fun updatePublicSharingSettings(input: UpdatePublicSharingSettingsRequest): UpdatePublicSharingSettingsResponse

    /**
     * Updates a personalization configuration.
     */
    public suspend fun updateQPersonalizationConfiguration(input: UpdateQPersonalizationConfigurationRequest): UpdateQPersonalizationConfigurationResponse

    /**
     * Updates the state of a Amazon QuickSight Q Search configuration.
     */
    public suspend fun updateQuickSightQSearchConfiguration(input: UpdateQuickSightQSearchConfigurationRequest): UpdateQuickSightQSearchConfigurationResponse

    /**
     * Updates a refresh schedule for a dataset.
     */
    public suspend fun updateRefreshSchedule(input: UpdateRefreshScheduleRequest): UpdateRefreshScheduleResponse

    /**
     * Updates the custom permissions that are associated with a role.
     */
    public suspend fun updateRoleCustomPermission(input: UpdateRoleCustomPermissionRequest): UpdateRoleCustomPermissionResponse

    /**
     * Updates the SPICE capacity configuration for a Amazon QuickSight account.
     */
    public suspend fun updateSpiceCapacityConfiguration(input: UpdateSpiceCapacityConfigurationRequest): UpdateSpiceCapacityConfigurationResponse

    /**
     * Updates a template from an existing Amazon QuickSight analysis or another template.
     */
    public suspend fun updateTemplate(input: UpdateTemplateRequest): UpdateTemplateResponse

    /**
     * Updates the template alias of a template.
     */
    public suspend fun updateTemplateAlias(input: UpdateTemplateAliasRequest): UpdateTemplateAliasResponse

    /**
     * Updates the resource permissions for a template.
     */
    public suspend fun updateTemplatePermissions(input: UpdateTemplatePermissionsRequest): UpdateTemplatePermissionsResponse

    /**
     * Updates a theme.
     */
    public suspend fun updateTheme(input: UpdateThemeRequest): UpdateThemeResponse

    /**
     * Updates an alias of a theme.
     */
    public suspend fun updateThemeAlias(input: UpdateThemeAliasRequest): UpdateThemeAliasResponse

    /**
     * Updates the resource permissions for a theme. Permissions apply to the action to grant or revoke permissions on, for example `"quicksight:DescribeTheme"`.
     *
     * Theme permissions apply in groupings. Valid groupings include the following for the three levels of permissions, which are user, owner, or no permissions:
     * + User
     *    + `"quicksight:DescribeTheme"`
     *    + `"quicksight:DescribeThemeAlias"`
     *    + `"quicksight:ListThemeAliases"`
     *    + `"quicksight:ListThemeVersions"`
     * + Owner
     *    + `"quicksight:DescribeTheme"`
     *    + `"quicksight:DescribeThemeAlias"`
     *    + `"quicksight:ListThemeAliases"`
     *    + `"quicksight:ListThemeVersions"`
     *    + `"quicksight:DeleteTheme"`
     *    + `"quicksight:UpdateTheme"`
     *    + `"quicksight:CreateThemeAlias"`
     *    + `"quicksight:DeleteThemeAlias"`
     *    + `"quicksight:UpdateThemeAlias"`
     *    + `"quicksight:UpdateThemePermissions"`
     *    + `"quicksight:DescribeThemePermissions"`
     * + To specify no permissions, omit the permissions list.
     */
    public suspend fun updateThemePermissions(input: UpdateThemePermissionsRequest): UpdateThemePermissionsResponse

    /**
     * Updates a topic.
     */
    public suspend fun updateTopic(input: UpdateTopicRequest): UpdateTopicResponse

    /**
     * Updates the permissions of a topic.
     */
    public suspend fun updateTopicPermissions(input: UpdateTopicPermissionsRequest): UpdateTopicPermissionsResponse

    /**
     * Updates a topic refresh schedule.
     */
    public suspend fun updateTopicRefreshSchedule(input: UpdateTopicRefreshScheduleRequest): UpdateTopicRefreshScheduleResponse

    /**
     * Updates an Amazon QuickSight user.
     */
    public suspend fun updateUser(input: UpdateUserRequest): UpdateUserResponse

    /**
     * Updates a custom permissions profile for a user.
     */
    public suspend fun updateUserCustomPermission(input: UpdateUserCustomPermissionRequest): UpdateUserCustomPermissionResponse

    /**
     * Updates a VPC connection.
     */
    public suspend fun updateVpcConnection(input: UpdateVpcConnectionRequest): UpdateVpcConnectionResponse
}

/**
 * Create a copy of the client with one or more configuration values overridden.
 * This method allows the caller to perform scoped config overrides for one or more client operations.
 *
 * Any resources created on your behalf will be shared between clients, and will only be closed when ALL clients using them are closed.
 * If you provide a resource (e.g. [HttpClientEngine]) to the SDK, you are responsible for managing the lifetime of that resource.
 */
public fun QuickSightClient.withConfig(block: QuickSightClient.Config.Builder.() -> Unit): QuickSightClient {
    val newConfig = config.toBuilder().apply(block).build()
    return DefaultQuickSightClient(newConfig)
}

/**
 * Creates new reviewed answers for a Q Topic.
 */
public suspend inline fun QuickSightClient.batchCreateTopicReviewedAnswer(crossinline block: BatchCreateTopicReviewedAnswerRequest.Builder.() -> Unit): BatchCreateTopicReviewedAnswerResponse = batchCreateTopicReviewedAnswer(BatchCreateTopicReviewedAnswerRequest.Builder().apply(block).build())

/**
 * Deletes reviewed answers for Q Topic.
 */
public suspend inline fun QuickSightClient.batchDeleteTopicReviewedAnswer(crossinline block: BatchDeleteTopicReviewedAnswerRequest.Builder.() -> Unit): BatchDeleteTopicReviewedAnswerResponse = batchDeleteTopicReviewedAnswer(BatchDeleteTopicReviewedAnswerRequest.Builder().apply(block).build())

/**
 * Cancels an ongoing ingestion of data into SPICE.
 */
public suspend inline fun QuickSightClient.cancelIngestion(crossinline block: CancelIngestionRequest.Builder.() -> Unit): CancelIngestionResponse = cancelIngestion(CancelIngestionRequest.Builder().apply(block).build())

/**
 * Creates Amazon QuickSight customizations for the current Amazon Web Services Region. Currently, you can add a custom default theme by using the `CreateAccountCustomization` or `UpdateAccountCustomization` API operation. To further customize Amazon QuickSight by removing Amazon QuickSight sample assets and videos for all new users, see [Customizing Amazon QuickSight](https://docs.aws.amazon.com/quicksight/latest/user/customizing-quicksight.html) in the *Amazon QuickSight User Guide.*
 *
 * You can create customizations for your Amazon Web Services account or, if you specify a namespace, for a QuickSight namespace instead. Customizations that apply to a namespace always override customizations that apply to an Amazon Web Services account. To find out which customizations apply, use the `DescribeAccountCustomization` API operation.
 *
 * Before you use the `CreateAccountCustomization` API operation to add a theme as the namespace default, make sure that you first share the theme with the namespace. If you don't share it with the namespace, the theme isn't visible to your users even if you make it the default theme. To check if the theme is shared, view the current permissions by using the ` <a href="https://docs.aws.amazon.com/quicksight/latest/APIReference/API_DescribeThemePermissions.html">DescribeThemePermissions</a> ` API operation. To share the theme, grant permissions by using the ` <a href="https://docs.aws.amazon.com/quicksight/latest/APIReference/API_UpdateThemePermissions.html">UpdateThemePermissions</a> ` API operation.
 */
public suspend inline fun QuickSightClient.createAccountCustomization(crossinline block: CreateAccountCustomizationRequest.Builder.() -> Unit): CreateAccountCustomizationResponse = createAccountCustomization(CreateAccountCustomizationRequest.Builder().apply(block).build())

/**
 * Creates an Amazon QuickSight account, or subscribes to Amazon QuickSight Q.
 *
 * The Amazon Web Services Region for the account is derived from what is configured in the CLI or SDK.
 *
 * Before you use this operation, make sure that you can connect to an existing Amazon Web Services account. If you don't have an Amazon Web Services account, see [Sign up for Amazon Web Services](https://docs.aws.amazon.com/quicksight/latest/user/setting-up-aws-sign-up.html) in the *Amazon QuickSight User Guide*. The person who signs up for Amazon QuickSight needs to have the correct Identity and Access Management (IAM) permissions. For more information, see [IAM Policy Examples for Amazon QuickSight](https://docs.aws.amazon.com/quicksight/latest/user/iam-policy-examples.html) in the *Amazon QuickSight User Guide*.
 *
 * If your IAM policy includes both the `Subscribe` and `CreateAccountSubscription` actions, make sure that both actions are set to `Allow`. If either action is set to `Deny`, the `Deny` action prevails and your API call fails.
 *
 * You can't pass an existing IAM role to access other Amazon Web Services services using this API operation. To pass your existing IAM role to Amazon QuickSight, see [Passing IAM roles to Amazon QuickSight](https://docs.aws.amazon.com/quicksight/latest/user/security_iam_service-with-iam.html#security-create-iam-role) in the *Amazon QuickSight User Guide*.
 *
 * You can't set default resource access on the new account from the Amazon QuickSight API. Instead, add default resource access from the Amazon QuickSight console. For more information about setting default resource access to Amazon Web Services services, see [Setting default resource access to Amazon Web Services services](https://docs.aws.amazon.com/quicksight/latest/user/scoping-policies-defaults.html) in the *Amazon QuickSight User Guide*.
 */
public suspend inline fun QuickSightClient.createAccountSubscription(crossinline block: CreateAccountSubscriptionRequest.Builder.() -> Unit): CreateAccountSubscriptionResponse = createAccountSubscription(CreateAccountSubscriptionRequest.Builder().apply(block).build())

/**
 * Creates an analysis in Amazon QuickSight. Analyses can be created either from a template or from an `AnalysisDefinition`.
 */
public suspend inline fun QuickSightClient.createAnalysis(crossinline block: CreateAnalysisRequest.Builder.() -> Unit): CreateAnalysisResponse = createAnalysis(CreateAnalysisRequest.Builder().apply(block).build())

/**
 * Creates an Amazon QuickSight brand.
 */
public suspend inline fun QuickSightClient.createBrand(crossinline block: CreateBrandRequest.Builder.() -> Unit): CreateBrandResponse = createBrand(CreateBrandRequest.Builder().apply(block).build())

/**
 * Creates a custom permissions profile.
 */
public suspend inline fun QuickSightClient.createCustomPermissions(crossinline block: CreateCustomPermissionsRequest.Builder.() -> Unit): CreateCustomPermissionsResponse = createCustomPermissions(CreateCustomPermissionsRequest.Builder().apply(block).build())

/**
 * Creates a dashboard from either a template or directly with a `DashboardDefinition`. To first create a template, see the ` <a href="https://docs.aws.amazon.com/quicksight/latest/APIReference/API_CreateTemplate.html">CreateTemplate</a> ` API operation.
 *
 * A dashboard is an entity in Amazon QuickSight that identifies Amazon QuickSight reports, created from analyses. You can share Amazon QuickSight dashboards. With the right permissions, you can create scheduled email reports from them. If you have the correct permissions, you can create a dashboard from a template that exists in a different Amazon Web Services account.
 */
public suspend inline fun QuickSightClient.createDashboard(crossinline block: CreateDashboardRequest.Builder.() -> Unit): CreateDashboardResponse = createDashboard(CreateDashboardRequest.Builder().apply(block).build())

/**
 * Creates a dataset. This operation doesn't support datasets that include uploaded files as a source.
 */
public suspend inline fun QuickSightClient.createDataSet(crossinline block: CreateDataSetRequest.Builder.() -> Unit): CreateDataSetResponse = createDataSet(CreateDataSetRequest.Builder().apply(block).build())

/**
 * Creates a data source.
 */
public suspend inline fun QuickSightClient.createDataSource(crossinline block: CreateDataSourceRequest.Builder.() -> Unit): CreateDataSourceResponse = createDataSource(CreateDataSourceRequest.Builder().apply(block).build())

/**
 * Creates an empty shared folder.
 */
public suspend inline fun QuickSightClient.createFolder(crossinline block: CreateFolderRequest.Builder.() -> Unit): CreateFolderResponse = createFolder(CreateFolderRequest.Builder().apply(block).build())

/**
 * Adds an asset, such as a dashboard, analysis, or dataset into a folder.
 */
public suspend inline fun QuickSightClient.createFolderMembership(crossinline block: CreateFolderMembershipRequest.Builder.() -> Unit): CreateFolderMembershipResponse = createFolderMembership(CreateFolderMembershipRequest.Builder().apply(block).build())

/**
 * Use the `CreateGroup` operation to create a group in Amazon QuickSight. You can create up to 10,000 groups in a namespace. If you want to create more than 10,000 groups in a namespace, contact Amazon Web Services Support.
 *
 * The permissions resource is `arn:aws:quicksight:<your-region>:<i><relevant-aws-account-id></i>:group/default/<i><group-name></i> `.
 *
 * The response is a group object.
 */
public suspend inline fun QuickSightClient.createGroup(crossinline block: CreateGroupRequest.Builder.() -> Unit): CreateGroupResponse = createGroup(CreateGroupRequest.Builder().apply(block).build())

/**
 * Adds an Amazon QuickSight user to an Amazon QuickSight group.
 */
public suspend inline fun QuickSightClient.createGroupMembership(crossinline block: CreateGroupMembershipRequest.Builder.() -> Unit): CreateGroupMembershipResponse = createGroupMembership(CreateGroupMembershipRequest.Builder().apply(block).build())

/**
 * Creates an assignment with one specified IAM policy, identified by its Amazon Resource Name (ARN). This policy assignment is attached to the specified groups or users of Amazon QuickSight. Assignment names are unique per Amazon Web Services account. To avoid overwriting rules in other namespaces, use assignment names that are unique.
 */
public suspend inline fun QuickSightClient.createIamPolicyAssignment(crossinline block: CreateIamPolicyAssignmentRequest.Builder.() -> Unit): CreateIamPolicyAssignmentResponse = createIamPolicyAssignment(CreateIamPolicyAssignmentRequest.Builder().apply(block).build())

/**
 * Creates and starts a new SPICE ingestion for a dataset. You can manually refresh datasets in an Enterprise edition account 32 times in a 24-hour period. You can manually refresh datasets in a Standard edition account 8 times in a 24-hour period. Each 24-hour period is measured starting 24 hours before the current date and time.
 *
 * Any ingestions operating on tagged datasets inherit the same tags automatically for use in access control. For an example, see [How do I create an IAM policy to control access to Amazon EC2 resources using tags?](http://aws.amazon.com/premiumsupport/knowledge-center/iam-ec2-resource-tags/) in the Amazon Web Services Knowledge Center. Tags are visible on the tagged dataset, but not on the ingestion resource.
 */
public suspend inline fun QuickSightClient.createIngestion(crossinline block: CreateIngestionRequest.Builder.() -> Unit): CreateIngestionResponse = createIngestion(CreateIngestionRequest.Builder().apply(block).build())

/**
 * (Enterprise edition only) Creates a new namespace for you to use with Amazon QuickSight.
 *
 * A namespace allows you to isolate the Amazon QuickSight users and groups that are registered for that namespace. Users that access the namespace can share assets only with other users or groups in the same namespace. They can't see users and groups in other namespaces. You can create a namespace after your Amazon Web Services account is subscribed to Amazon QuickSight. The namespace must be unique within the Amazon Web Services account. By default, there is a limit of 100 namespaces per Amazon Web Services account. To increase your limit, create a ticket with Amazon Web ServicesSupport.
 */
public suspend inline fun QuickSightClient.createNamespace(crossinline block: CreateNamespaceRequest.Builder.() -> Unit): CreateNamespaceResponse = createNamespace(CreateNamespaceRequest.Builder().apply(block).build())

/**
 * Creates a refresh schedule for a dataset. You can create up to 5 different schedules for a single dataset.
 */
public suspend inline fun QuickSightClient.createRefreshSchedule(crossinline block: CreateRefreshScheduleRequest.Builder.() -> Unit): CreateRefreshScheduleResponse = createRefreshSchedule(CreateRefreshScheduleRequest.Builder().apply(block).build())

/**
 * Use `CreateRoleMembership` to add an existing Amazon QuickSight group to an existing role.
 */
public suspend inline fun QuickSightClient.createRoleMembership(crossinline block: CreateRoleMembershipRequest.Builder.() -> Unit): CreateRoleMembershipResponse = createRoleMembership(CreateRoleMembershipRequest.Builder().apply(block).build())

/**
 * Creates a template either from a `TemplateDefinition` or from an existing Amazon QuickSight analysis or template. You can use the resulting template to create additional dashboards, templates, or analyses.
 *
 * A *template* is an entity in Amazon QuickSight that encapsulates the metadata required to create an analysis and that you can use to create s dashboard. A template adds a layer of abstraction by using placeholders to replace the dataset associated with the analysis. You can use templates to create dashboards by replacing dataset placeholders with datasets that follow the same schema that was used to create the source analysis and template.
 */
public suspend inline fun QuickSightClient.createTemplate(crossinline block: CreateTemplateRequest.Builder.() -> Unit): CreateTemplateResponse = createTemplate(CreateTemplateRequest.Builder().apply(block).build())

/**
 * Creates a template alias for a template.
 */
public suspend inline fun QuickSightClient.createTemplateAlias(crossinline block: CreateTemplateAliasRequest.Builder.() -> Unit): CreateTemplateAliasResponse = createTemplateAlias(CreateTemplateAliasRequest.Builder().apply(block).build())

/**
 * Creates a theme.
 *
 * A *theme* is set of configuration options for color and layout. Themes apply to analyses and dashboards. For more information, see [Using Themes in Amazon QuickSight](https://docs.aws.amazon.com/quicksight/latest/user/themes-in-quicksight.html) in the *Amazon QuickSight User Guide*.
 */
public suspend inline fun QuickSightClient.createTheme(crossinline block: CreateThemeRequest.Builder.() -> Unit): CreateThemeResponse = createTheme(CreateThemeRequest.Builder().apply(block).build())

/**
 * Creates a theme alias for a theme.
 */
public suspend inline fun QuickSightClient.createThemeAlias(crossinline block: CreateThemeAliasRequest.Builder.() -> Unit): CreateThemeAliasResponse = createThemeAlias(CreateThemeAliasRequest.Builder().apply(block).build())

/**
 * Creates a new Q topic.
 */
public suspend inline fun QuickSightClient.createTopic(crossinline block: CreateTopicRequest.Builder.() -> Unit): CreateTopicResponse = createTopic(CreateTopicRequest.Builder().apply(block).build())

/**
 * Creates a topic refresh schedule.
 */
public suspend inline fun QuickSightClient.createTopicRefreshSchedule(crossinline block: CreateTopicRefreshScheduleRequest.Builder.() -> Unit): CreateTopicRefreshScheduleResponse = createTopicRefreshSchedule(CreateTopicRefreshScheduleRequest.Builder().apply(block).build())

/**
 * Creates a new VPC connection.
 */
public suspend inline fun QuickSightClient.createVpcConnection(crossinline block: CreateVpcConnectionRequest.Builder.() -> Unit): CreateVpcConnectionResponse = createVpcConnection(CreateVpcConnectionRequest.Builder().apply(block).build())

/**
 * Deletes all Amazon QuickSight customizations in this Amazon Web Services Region for the specified Amazon Web Services account and Amazon QuickSight namespace.
 */
public suspend inline fun QuickSightClient.deleteAccountCustomization(crossinline block: DeleteAccountCustomizationRequest.Builder.() -> Unit): DeleteAccountCustomizationResponse = deleteAccountCustomization(DeleteAccountCustomizationRequest.Builder().apply(block).build())

/**
 * Use the `DeleteAccountSubscription` operation to delete an Amazon QuickSight account. This operation will result in an error message if you have configured your account termination protection settings to `True`. To change this setting and delete your account, call the `UpdateAccountSettings` API and set the value of the `TerminationProtectionEnabled` parameter to `False`, then make another call to the `DeleteAccountSubscription` API.
 */
public suspend inline fun QuickSightClient.deleteAccountSubscription(crossinline block: DeleteAccountSubscriptionRequest.Builder.() -> Unit): DeleteAccountSubscriptionResponse = deleteAccountSubscription(DeleteAccountSubscriptionRequest.Builder().apply(block).build())

/**
 * Deletes an analysis from Amazon QuickSight. You can optionally include a recovery window during which you can restore the analysis. If you don't specify a recovery window value, the operation defaults to 30 days. Amazon QuickSight attaches a `DeletionTime` stamp to the response that specifies the end of the recovery window. At the end of the recovery window, Amazon QuickSight deletes the analysis permanently.
 *
 * At any time before recovery window ends, you can use the `RestoreAnalysis` API operation to remove the `DeletionTime` stamp and cancel the deletion of the analysis. The analysis remains visible in the API until it's deleted, so you can describe it but you can't make a template from it.
 *
 * An analysis that's scheduled for deletion isn't accessible in the Amazon QuickSight console. To access it in the console, restore it. Deleting an analysis doesn't delete the dashboards that you publish from it.
 */
public suspend inline fun QuickSightClient.deleteAnalysis(crossinline block: DeleteAnalysisRequest.Builder.() -> Unit): DeleteAnalysisResponse = deleteAnalysis(DeleteAnalysisRequest.Builder().apply(block).build())

/**
 * Deletes an Amazon QuickSight brand.
 */
public suspend inline fun QuickSightClient.deleteBrand(crossinline block: DeleteBrandRequest.Builder.() -> Unit): DeleteBrandResponse = deleteBrand(DeleteBrandRequest.Builder().apply(block).build())

/**
 * Deletes a brand assignment.
 */
public suspend inline fun QuickSightClient.deleteBrandAssignment(crossinline block: DeleteBrandAssignmentRequest.Builder.() -> Unit): DeleteBrandAssignmentResponse = deleteBrandAssignment(DeleteBrandAssignmentRequest.Builder().apply(block).build())

/**
 * Deletes a custom permissions profile.
 */
public suspend inline fun QuickSightClient.deleteCustomPermissions(crossinline block: DeleteCustomPermissionsRequest.Builder.() -> Unit): DeleteCustomPermissionsResponse = deleteCustomPermissions(DeleteCustomPermissionsRequest.Builder().apply(block).build())

/**
 * Deletes a dashboard.
 */
public suspend inline fun QuickSightClient.deleteDashboard(crossinline block: DeleteDashboardRequest.Builder.() -> Unit): DeleteDashboardResponse = deleteDashboard(DeleteDashboardRequest.Builder().apply(block).build())

/**
 * Deletes a dataset.
 */
public suspend inline fun QuickSightClient.deleteDataSet(crossinline block: DeleteDataSetRequest.Builder.() -> Unit): DeleteDataSetResponse = deleteDataSet(DeleteDataSetRequest.Builder().apply(block).build())

/**
 * Deletes the dataset refresh properties of the dataset.
 */
public suspend inline fun QuickSightClient.deleteDataSetRefreshProperties(crossinline block: DeleteDataSetRefreshPropertiesRequest.Builder.() -> Unit): DeleteDataSetRefreshPropertiesResponse = deleteDataSetRefreshProperties(DeleteDataSetRefreshPropertiesRequest.Builder().apply(block).build())

/**
 * Deletes the data source permanently. This operation breaks all the datasets that reference the deleted data source.
 */
public suspend inline fun QuickSightClient.deleteDataSource(crossinline block: DeleteDataSourceRequest.Builder.() -> Unit): DeleteDataSourceResponse = deleteDataSource(DeleteDataSourceRequest.Builder().apply(block).build())

/**
 * Deletes a linked Amazon Q Business application from an Amazon QuickSight account
 */
public suspend inline fun QuickSightClient.deleteDefaultQBusinessApplication(crossinline block: DeleteDefaultQBusinessApplicationRequest.Builder.() -> Unit): DeleteDefaultQBusinessApplicationResponse = deleteDefaultQBusinessApplication(DeleteDefaultQBusinessApplicationRequest.Builder().apply(block).build())

/**
 * Deletes an empty folder.
 */
public suspend inline fun QuickSightClient.deleteFolder(crossinline block: DeleteFolderRequest.Builder.() -> Unit): DeleteFolderResponse = deleteFolder(DeleteFolderRequest.Builder().apply(block).build())

/**
 * Removes an asset, such as a dashboard, analysis, or dataset, from a folder.
 */
public suspend inline fun QuickSightClient.deleteFolderMembership(crossinline block: DeleteFolderMembershipRequest.Builder.() -> Unit): DeleteFolderMembershipResponse = deleteFolderMembership(DeleteFolderMembershipRequest.Builder().apply(block).build())

/**
 * Removes a user group from Amazon QuickSight.
 */
public suspend inline fun QuickSightClient.deleteGroup(crossinline block: DeleteGroupRequest.Builder.() -> Unit): DeleteGroupResponse = deleteGroup(DeleteGroupRequest.Builder().apply(block).build())

/**
 * Removes a user from a group so that the user is no longer a member of the group.
 */
public suspend inline fun QuickSightClient.deleteGroupMembership(crossinline block: DeleteGroupMembershipRequest.Builder.() -> Unit): DeleteGroupMembershipResponse = deleteGroupMembership(DeleteGroupMembershipRequest.Builder().apply(block).build())

/**
 * Deletes an existing IAM policy assignment.
 */
public suspend inline fun QuickSightClient.deleteIamPolicyAssignment(crossinline block: DeleteIamPolicyAssignmentRequest.Builder.() -> Unit): DeleteIamPolicyAssignmentResponse = deleteIamPolicyAssignment(DeleteIamPolicyAssignmentRequest.Builder().apply(block).build())

/**
 * Deletes all access scopes and authorized targets that are associated with a service from the Amazon QuickSight IAM Identity Center application.
 *
 * This operation is only supported for Amazon QuickSight accounts that use IAM Identity Center.
 */
public suspend inline fun QuickSightClient.deleteIdentityPropagationConfig(crossinline block: DeleteIdentityPropagationConfigRequest.Builder.() -> Unit): DeleteIdentityPropagationConfigResponse = deleteIdentityPropagationConfig(DeleteIdentityPropagationConfigRequest.Builder().apply(block).build())

/**
 * Deletes a namespace and the users and groups that are associated with the namespace. This is an asynchronous process. Assets including dashboards, analyses, datasets and data sources are not deleted. To delete these assets, you use the API operations for the relevant asset.
 */
public suspend inline fun QuickSightClient.deleteNamespace(crossinline block: DeleteNamespaceRequest.Builder.() -> Unit): DeleteNamespaceResponse = deleteNamespace(DeleteNamespaceRequest.Builder().apply(block).build())

/**
 * Deletes a refresh schedule from a dataset.
 */
public suspend inline fun QuickSightClient.deleteRefreshSchedule(crossinline block: DeleteRefreshScheduleRequest.Builder.() -> Unit): DeleteRefreshScheduleResponse = deleteRefreshSchedule(DeleteRefreshScheduleRequest.Builder().apply(block).build())

/**
 * Removes custom permissions from the role.
 */
public suspend inline fun QuickSightClient.deleteRoleCustomPermission(crossinline block: DeleteRoleCustomPermissionRequest.Builder.() -> Unit): DeleteRoleCustomPermissionResponse = deleteRoleCustomPermission(DeleteRoleCustomPermissionRequest.Builder().apply(block).build())

/**
 * Removes a group from a role.
 */
public suspend inline fun QuickSightClient.deleteRoleMembership(crossinline block: DeleteRoleMembershipRequest.Builder.() -> Unit): DeleteRoleMembershipResponse = deleteRoleMembership(DeleteRoleMembershipRequest.Builder().apply(block).build())

/**
 * Deletes a template.
 */
public suspend inline fun QuickSightClient.deleteTemplate(crossinline block: DeleteTemplateRequest.Builder.() -> Unit): DeleteTemplateResponse = deleteTemplate(DeleteTemplateRequest.Builder().apply(block).build())

/**
 * Deletes the item that the specified template alias points to. If you provide a specific alias, you delete the version of the template that the alias points to.
 */
public suspend inline fun QuickSightClient.deleteTemplateAlias(crossinline block: DeleteTemplateAliasRequest.Builder.() -> Unit): DeleteTemplateAliasResponse = deleteTemplateAlias(DeleteTemplateAliasRequest.Builder().apply(block).build())

/**
 * Deletes a theme.
 */
public suspend inline fun QuickSightClient.deleteTheme(crossinline block: DeleteThemeRequest.Builder.() -> Unit): DeleteThemeResponse = deleteTheme(DeleteThemeRequest.Builder().apply(block).build())

/**
 * Deletes the version of the theme that the specified theme alias points to. If you provide a specific alias, you delete the version of the theme that the alias points to.
 */
public suspend inline fun QuickSightClient.deleteThemeAlias(crossinline block: DeleteThemeAliasRequest.Builder.() -> Unit): DeleteThemeAliasResponse = deleteThemeAlias(DeleteThemeAliasRequest.Builder().apply(block).build())

/**
 * Deletes a topic.
 */
public suspend inline fun QuickSightClient.deleteTopic(crossinline block: DeleteTopicRequest.Builder.() -> Unit): DeleteTopicResponse = deleteTopic(DeleteTopicRequest.Builder().apply(block).build())

/**
 * Deletes a topic refresh schedule.
 */
public suspend inline fun QuickSightClient.deleteTopicRefreshSchedule(crossinline block: DeleteTopicRefreshScheduleRequest.Builder.() -> Unit): DeleteTopicRefreshScheduleResponse = deleteTopicRefreshSchedule(DeleteTopicRefreshScheduleRequest.Builder().apply(block).build())

/**
 * Deletes the Amazon QuickSight user that is associated with the identity of the IAM user or role that's making the call. The IAM user isn't deleted as a result of this call.
 */
public suspend inline fun QuickSightClient.deleteUser(crossinline block: DeleteUserRequest.Builder.() -> Unit): DeleteUserResponse = deleteUser(DeleteUserRequest.Builder().apply(block).build())

/**
 * Deletes a user identified by its principal ID.
 */
public suspend inline fun QuickSightClient.deleteUserByPrincipalId(crossinline block: DeleteUserByPrincipalIdRequest.Builder.() -> Unit): DeleteUserByPrincipalIdResponse = deleteUserByPrincipalId(DeleteUserByPrincipalIdRequest.Builder().apply(block).build())

/**
 * Deletes a custom permissions profile from a user.
 */
public suspend inline fun QuickSightClient.deleteUserCustomPermission(crossinline block: DeleteUserCustomPermissionRequest.Builder.() -> Unit): DeleteUserCustomPermissionResponse = deleteUserCustomPermission(DeleteUserCustomPermissionRequest.Builder().apply(block).build())

/**
 * Deletes a VPC connection.
 */
public suspend inline fun QuickSightClient.deleteVpcConnection(crossinline block: DeleteVpcConnectionRequest.Builder.() -> Unit): DeleteVpcConnectionResponse = deleteVpcConnection(DeleteVpcConnectionRequest.Builder().apply(block).build())

/**
 * Describes the customizations associated with the provided Amazon Web Services account and Amazon Amazon QuickSight namespace in an Amazon Web Services Region. The Amazon QuickSight console evaluates which customizations to apply by running this API operation with the `Resolved` flag included.
 *
 * To determine what customizations display when you run this command, it can help to visualize the relationship of the entities involved.
 * + `Amazon Web Services account` - The Amazon Web Services account exists at the top of the hierarchy. It has the potential to use all of the Amazon Web Services Regions and Amazon Web Services Services. When you subscribe to Amazon QuickSight, you choose one Amazon Web Services Region to use as your home Region. That's where your free SPICE capacity is located. You can use Amazon QuickSight in any supported Amazon Web Services Region.
 * + `Amazon Web Services Region` - In each Amazon Web Services Region where you sign in to Amazon QuickSight at least once, Amazon QuickSight acts as a separate instance of the same service. If you have a user directory, it resides in us-east-1, which is the US East (N. Virginia). Generally speaking, these users have access to Amazon QuickSight in any Amazon Web Services Region, unless they are constrained to a namespace. To run the command in a different Amazon Web Services Region, you change your Region settings. If you're using the CLI, you can use one of the following options:
 *    + Use [command line options](https://docs.aws.amazon.com/cli/latest/userguide/cli-configure-options.html).
 *    + Use [named profiles](https://docs.aws.amazon.com/cli/latest/userguide/cli-configure-profiles.html).
 *    + Run `aws configure` to change your default Amazon Web Services Region. Use Enter to key the same settings for your keys. For more information, see [Configuring the CLI](https://docs.aws.amazon.com/cli/latest/userguide/cli-chap-configure.html).
 * + `Namespace` - A QuickSight namespace is a partition that contains users and assets (data sources, datasets, dashboards, and so on). To access assets that are in a specific namespace, users and groups must also be part of the same namespace. People who share a namespace are completely isolated from users and assets in other namespaces, even if they are in the same Amazon Web Services account and Amazon Web Services Region.
 * + `Applied customizations` - Within an Amazon Web Services Region, a set of Amazon QuickSight customizations can apply to an Amazon Web Services account or to a namespace. Settings that you apply to a namespace override settings that you apply to an Amazon Web Services account. All settings are isolated to a single Amazon Web Services Region. To apply them in other Amazon Web Services Regions, run the `CreateAccountCustomization` command in each Amazon Web Services Region where you want to apply the same customizations.
 */
public suspend inline fun QuickSightClient.describeAccountCustomization(crossinline block: DescribeAccountCustomizationRequest.Builder.() -> Unit): DescribeAccountCustomizationResponse = describeAccountCustomization(DescribeAccountCustomizationRequest.Builder().apply(block).build())

/**
 * Describes the settings that were used when your Amazon QuickSight subscription was first created in this Amazon Web Services account.
 */
public suspend inline fun QuickSightClient.describeAccountSettings(crossinline block: DescribeAccountSettingsRequest.Builder.() -> Unit): DescribeAccountSettingsResponse = describeAccountSettings(DescribeAccountSettingsRequest.Builder().apply(block).build())

/**
 * Use the DescribeAccountSubscription operation to receive a description of an Amazon QuickSight account's subscription. A successful API call returns an `AccountInfo` object that includes an account's name, subscription status, authentication type, edition, and notification email address.
 */
public suspend inline fun QuickSightClient.describeAccountSubscription(crossinline block: DescribeAccountSubscriptionRequest.Builder.() -> Unit): DescribeAccountSubscriptionResponse = describeAccountSubscription(DescribeAccountSubscriptionRequest.Builder().apply(block).build())

/**
 * Provides a summary of the metadata for an analysis.
 */
public suspend inline fun QuickSightClient.describeAnalysis(crossinline block: DescribeAnalysisRequest.Builder.() -> Unit): DescribeAnalysisResponse = describeAnalysis(DescribeAnalysisRequest.Builder().apply(block).build())

/**
 * Provides a detailed description of the definition of an analysis.
 *
 * If you do not need to know details about the content of an Analysis, for instance if you are trying to check the status of a recently created or updated Analysis, use the `DescribeAnalysis`[](https://docs.aws.amazon.com/quicksight/latest/APIReference/API_DescribeAnalysis.html) instead.
 */
public suspend inline fun QuickSightClient.describeAnalysisDefinition(crossinline block: DescribeAnalysisDefinitionRequest.Builder.() -> Unit): DescribeAnalysisDefinitionResponse = describeAnalysisDefinition(DescribeAnalysisDefinitionRequest.Builder().apply(block).build())

/**
 * Provides the read and write permissions for an analysis.
 */
public suspend inline fun QuickSightClient.describeAnalysisPermissions(crossinline block: DescribeAnalysisPermissionsRequest.Builder.() -> Unit): DescribeAnalysisPermissionsResponse = describeAnalysisPermissions(DescribeAnalysisPermissionsRequest.Builder().apply(block).build())

/**
 * Describes an existing export job.
 *
 * Poll job descriptions after a job starts to know the status of the job. When a job succeeds, a URL is provided to download the exported assets' data from. Download URLs are valid for five minutes after they are generated. You can call the `DescribeAssetBundleExportJob` API for a new download URL as needed.
 *
 * Job descriptions are available for 14 days after the job starts.
 */
public suspend inline fun QuickSightClient.describeAssetBundleExportJob(crossinline block: DescribeAssetBundleExportJobRequest.Builder.() -> Unit): DescribeAssetBundleExportJobResponse = describeAssetBundleExportJob(DescribeAssetBundleExportJobRequest.Builder().apply(block).build())

/**
 * Describes an existing import job.
 *
 * Poll job descriptions after starting a job to know when it has succeeded or failed. Job descriptions are available for 14 days after job starts.
 */
public suspend inline fun QuickSightClient.describeAssetBundleImportJob(crossinline block: DescribeAssetBundleImportJobRequest.Builder.() -> Unit): DescribeAssetBundleImportJobResponse = describeAssetBundleImportJob(DescribeAssetBundleImportJobRequest.Builder().apply(block).build())

/**
 * Describes a brand.
 */
public suspend inline fun QuickSightClient.describeBrand(crossinline block: DescribeBrandRequest.Builder.() -> Unit): DescribeBrandResponse = describeBrand(DescribeBrandRequest.Builder().apply(block).build())

/**
 * Describes a brand assignment.
 */
public suspend inline fun QuickSightClient.describeBrandAssignment(crossinline block: DescribeBrandAssignmentRequest.Builder.() -> Unit): DescribeBrandAssignmentResponse = describeBrandAssignment(DescribeBrandAssignmentRequest.Builder().apply(block).build())

/**
 * Describes the published version of the brand.
 */
public suspend inline fun QuickSightClient.describeBrandPublishedVersion(crossinline block: DescribeBrandPublishedVersionRequest.Builder.() -> Unit): DescribeBrandPublishedVersionResponse = describeBrandPublishedVersion(DescribeBrandPublishedVersionRequest.Builder().apply(block).build())

/**
 * Describes a custom permissions profile.
 */
public suspend inline fun QuickSightClient.describeCustomPermissions(crossinline block: DescribeCustomPermissionsRequest.Builder.() -> Unit): DescribeCustomPermissionsResponse = describeCustomPermissions(DescribeCustomPermissionsRequest.Builder().apply(block).build())

/**
 * Provides a summary for a dashboard.
 */
public suspend inline fun QuickSightClient.describeDashboard(crossinline block: DescribeDashboardRequest.Builder.() -> Unit): DescribeDashboardResponse = describeDashboard(DescribeDashboardRequest.Builder().apply(block).build())

/**
 * Provides a detailed description of the definition of a dashboard.
 *
 * If you do not need to know details about the content of a dashboard, for instance if you are trying to check the status of a recently created or updated dashboard, use the `DescribeDashboard`[](https://docs.aws.amazon.com/quicksight/latest/APIReference/API_DescribeDashboard.html) instead.
 */
public suspend inline fun QuickSightClient.describeDashboardDefinition(crossinline block: DescribeDashboardDefinitionRequest.Builder.() -> Unit): DescribeDashboardDefinitionResponse = describeDashboardDefinition(DescribeDashboardDefinitionRequest.Builder().apply(block).build())

/**
 * Describes read and write permissions for a dashboard.
 */
public suspend inline fun QuickSightClient.describeDashboardPermissions(crossinline block: DescribeDashboardPermissionsRequest.Builder.() -> Unit): DescribeDashboardPermissionsResponse = describeDashboardPermissions(DescribeDashboardPermissionsRequest.Builder().apply(block).build())

/**
 * Describes an existing snapshot job.
 *
 * Poll job descriptions after a job starts to know the status of the job. For information on available status codes, see `JobStatus`.
 */
public suspend inline fun QuickSightClient.describeDashboardSnapshotJob(crossinline block: DescribeDashboardSnapshotJobRequest.Builder.() -> Unit): DescribeDashboardSnapshotJobResponse = describeDashboardSnapshotJob(DescribeDashboardSnapshotJobRequest.Builder().apply(block).build())

/**
 * Describes the result of an existing snapshot job that has finished running.
 *
 * A finished snapshot job will return a `COMPLETED` or `FAILED` status when you poll the job with a `DescribeDashboardSnapshotJob` API call.
 *
 * If the job has not finished running, this operation returns a message that says `Dashboard Snapshot Job with id <SnapshotjobId> has not reached a terminal state.`.
 */
public suspend inline fun QuickSightClient.describeDashboardSnapshotJobResult(crossinline block: DescribeDashboardSnapshotJobResultRequest.Builder.() -> Unit): DescribeDashboardSnapshotJobResultResponse = describeDashboardSnapshotJobResult(DescribeDashboardSnapshotJobResultRequest.Builder().apply(block).build())

/**
 * Describes an existing dashboard QA configuration.
 */
public suspend inline fun QuickSightClient.describeDashboardsQaConfiguration(crossinline block: DescribeDashboardsQaConfigurationRequest.Builder.() -> Unit): DescribeDashboardsQaConfigurationResponse = describeDashboardsQaConfiguration(DescribeDashboardsQaConfigurationRequest.Builder().apply(block).build())

/**
 * Describes a dataset. This operation doesn't support datasets that include uploaded files as a source.
 */
public suspend inline fun QuickSightClient.describeDataSet(crossinline block: DescribeDataSetRequest.Builder.() -> Unit): DescribeDataSetResponse = describeDataSet(DescribeDataSetRequest.Builder().apply(block).build())

/**
 * Describes the permissions on a dataset.
 *
 * The permissions resource is `arn:aws:quicksight:region:aws-account-id:dataset/data-set-id`.
 */
public suspend inline fun QuickSightClient.describeDataSetPermissions(crossinline block: DescribeDataSetPermissionsRequest.Builder.() -> Unit): DescribeDataSetPermissionsResponse = describeDataSetPermissions(DescribeDataSetPermissionsRequest.Builder().apply(block).build())

/**
 * Describes the refresh properties of a dataset.
 */
public suspend inline fun QuickSightClient.describeDataSetRefreshProperties(crossinline block: DescribeDataSetRefreshPropertiesRequest.Builder.() -> Unit): DescribeDataSetRefreshPropertiesResponse = describeDataSetRefreshProperties(DescribeDataSetRefreshPropertiesRequest.Builder().apply(block).build())

/**
 * Describes a data source.
 */
public suspend inline fun QuickSightClient.describeDataSource(crossinline block: DescribeDataSourceRequest.Builder.() -> Unit): DescribeDataSourceResponse = describeDataSource(DescribeDataSourceRequest.Builder().apply(block).build())

/**
 * Describes the resource permissions for a data source.
 */
public suspend inline fun QuickSightClient.describeDataSourcePermissions(crossinline block: DescribeDataSourcePermissionsRequest.Builder.() -> Unit): DescribeDataSourcePermissionsResponse = describeDataSourcePermissions(DescribeDataSourcePermissionsRequest.Builder().apply(block).build())

/**
 * Describes a Amazon Q Business application that is linked to an Amazon QuickSight account.
 */
public suspend inline fun QuickSightClient.describeDefaultQBusinessApplication(crossinline block: DescribeDefaultQBusinessApplicationRequest.Builder.() -> Unit): DescribeDefaultQBusinessApplicationResponse = describeDefaultQBusinessApplication(DescribeDefaultQBusinessApplicationRequest.Builder().apply(block).build())

/**
 * Describes a folder.
 */
public suspend inline fun QuickSightClient.describeFolder(crossinline block: DescribeFolderRequest.Builder.() -> Unit): DescribeFolderResponse = describeFolder(DescribeFolderRequest.Builder().apply(block).build())

/**
 * Describes permissions for a folder.
 */
public suspend inline fun QuickSightClient.describeFolderPermissions(crossinline block: DescribeFolderPermissionsRequest.Builder.() -> Unit): DescribeFolderPermissionsResponse = describeFolderPermissions(DescribeFolderPermissionsRequest.Builder().apply(block).build())

/**
 * Describes the folder resolved permissions. Permissions consists of both folder direct permissions and the inherited permissions from the ancestor folders.
 */
public suspend inline fun QuickSightClient.describeFolderResolvedPermissions(crossinline block: DescribeFolderResolvedPermissionsRequest.Builder.() -> Unit): DescribeFolderResolvedPermissionsResponse = describeFolderResolvedPermissions(DescribeFolderResolvedPermissionsRequest.Builder().apply(block).build())

/**
 * Returns an Amazon QuickSight group's description and Amazon Resource Name (ARN).
 */
public suspend inline fun QuickSightClient.describeGroup(crossinline block: DescribeGroupRequest.Builder.() -> Unit): DescribeGroupResponse = describeGroup(DescribeGroupRequest.Builder().apply(block).build())

/**
 * Use the `DescribeGroupMembership` operation to determine if a user is a member of the specified group. If the user exists and is a member of the specified group, an associated `GroupMember` object is returned.
 */
public suspend inline fun QuickSightClient.describeGroupMembership(crossinline block: DescribeGroupMembershipRequest.Builder.() -> Unit): DescribeGroupMembershipResponse = describeGroupMembership(DescribeGroupMembershipRequest.Builder().apply(block).build())

/**
 * Describes an existing IAM policy assignment, as specified by the assignment name.
 */
public suspend inline fun QuickSightClient.describeIamPolicyAssignment(crossinline block: DescribeIamPolicyAssignmentRequest.Builder.() -> Unit): DescribeIamPolicyAssignmentResponse = describeIamPolicyAssignment(DescribeIamPolicyAssignmentRequest.Builder().apply(block).build())

/**
 * Describes a SPICE ingestion.
 */
public suspend inline fun QuickSightClient.describeIngestion(crossinline block: DescribeIngestionRequest.Builder.() -> Unit): DescribeIngestionResponse = describeIngestion(DescribeIngestionRequest.Builder().apply(block).build())

/**
 * Provides a summary and status of IP rules.
 */
public suspend inline fun QuickSightClient.describeIpRestriction(crossinline block: DescribeIpRestrictionRequest.Builder.() -> Unit): DescribeIpRestrictionResponse = describeIpRestriction(DescribeIpRestrictionRequest.Builder().apply(block).build())

/**
 * Describes all customer managed key registrations in a Amazon QuickSight account.
 */
public suspend inline fun QuickSightClient.describeKeyRegistration(crossinline block: DescribeKeyRegistrationRequest.Builder.() -> Unit): DescribeKeyRegistrationResponse = describeKeyRegistration(DescribeKeyRegistrationRequest.Builder().apply(block).build())

/**
 * Describes the current namespace.
 */
public suspend inline fun QuickSightClient.describeNamespace(crossinline block: DescribeNamespaceRequest.Builder.() -> Unit): DescribeNamespaceResponse = describeNamespace(DescribeNamespaceRequest.Builder().apply(block).build())

/**
 * Describes a personalization configuration.
 */
public suspend inline fun QuickSightClient.describeQPersonalizationConfiguration(crossinline block: DescribeQPersonalizationConfigurationRequest.Builder.() -> Unit): DescribeQPersonalizationConfigurationResponse = describeQPersonalizationConfiguration(DescribeQPersonalizationConfigurationRequest.Builder().apply(block).build())

/**
 * Describes the state of a Amazon QuickSight Q Search configuration.
 */
public suspend inline fun QuickSightClient.describeQuickSightQSearchConfiguration(crossinline block: DescribeQuickSightQSearchConfigurationRequest.Builder.() -> Unit): DescribeQuickSightQSearchConfigurationResponse = describeQuickSightQSearchConfiguration(DescribeQuickSightQSearchConfigurationRequest.Builder().apply(block).build())

/**
 * Provides a summary of a refresh schedule.
 */
public suspend inline fun QuickSightClient.describeRefreshSchedule(crossinline block: DescribeRefreshScheduleRequest.Builder.() -> Unit): DescribeRefreshScheduleResponse = describeRefreshSchedule(DescribeRefreshScheduleRequest.Builder().apply(block).build())

/**
 * Describes all custom permissions that are mapped to a role.
 */
public suspend inline fun QuickSightClient.describeRoleCustomPermission(crossinline block: DescribeRoleCustomPermissionRequest.Builder.() -> Unit): DescribeRoleCustomPermissionResponse = describeRoleCustomPermission(DescribeRoleCustomPermissionRequest.Builder().apply(block).build())

/**
 * Describes a template's metadata.
 */
public suspend inline fun QuickSightClient.describeTemplate(crossinline block: DescribeTemplateRequest.Builder.() -> Unit): DescribeTemplateResponse = describeTemplate(DescribeTemplateRequest.Builder().apply(block).build())

/**
 * Describes the template alias for a template.
 */
public suspend inline fun QuickSightClient.describeTemplateAlias(crossinline block: DescribeTemplateAliasRequest.Builder.() -> Unit): DescribeTemplateAliasResponse = describeTemplateAlias(DescribeTemplateAliasRequest.Builder().apply(block).build())

/**
 * Provides a detailed description of the definition of a template.
 *
 * If you do not need to know details about the content of a template, for instance if you are trying to check the status of a recently created or updated template, use the `DescribeTemplate`[](https://docs.aws.amazon.com/quicksight/latest/APIReference/API_DescribeTemplate.html) instead.
 */
public suspend inline fun QuickSightClient.describeTemplateDefinition(crossinline block: DescribeTemplateDefinitionRequest.Builder.() -> Unit): DescribeTemplateDefinitionResponse = describeTemplateDefinition(DescribeTemplateDefinitionRequest.Builder().apply(block).build())

/**
 * Describes read and write permissions on a template.
 */
public suspend inline fun QuickSightClient.describeTemplatePermissions(crossinline block: DescribeTemplatePermissionsRequest.Builder.() -> Unit): DescribeTemplatePermissionsResponse = describeTemplatePermissions(DescribeTemplatePermissionsRequest.Builder().apply(block).build())

/**
 * Describes a theme.
 */
public suspend inline fun QuickSightClient.describeTheme(crossinline block: DescribeThemeRequest.Builder.() -> Unit): DescribeThemeResponse = describeTheme(DescribeThemeRequest.Builder().apply(block).build())

/**
 * Describes the alias for a theme.
 */
public suspend inline fun QuickSightClient.describeThemeAlias(crossinline block: DescribeThemeAliasRequest.Builder.() -> Unit): DescribeThemeAliasResponse = describeThemeAlias(DescribeThemeAliasRequest.Builder().apply(block).build())

/**
 * Describes the read and write permissions for a theme.
 */
public suspend inline fun QuickSightClient.describeThemePermissions(crossinline block: DescribeThemePermissionsRequest.Builder.() -> Unit): DescribeThemePermissionsResponse = describeThemePermissions(DescribeThemePermissionsRequest.Builder().apply(block).build())

/**
 * Describes a topic.
 */
public suspend inline fun QuickSightClient.describeTopic(crossinline block: DescribeTopicRequest.Builder.() -> Unit): DescribeTopicResponse = describeTopic(DescribeTopicRequest.Builder().apply(block).build())

/**
 * Describes the permissions of a topic.
 */
public suspend inline fun QuickSightClient.describeTopicPermissions(crossinline block: DescribeTopicPermissionsRequest.Builder.() -> Unit): DescribeTopicPermissionsResponse = describeTopicPermissions(DescribeTopicPermissionsRequest.Builder().apply(block).build())

/**
 * Describes the status of a topic refresh.
 */
public suspend inline fun QuickSightClient.describeTopicRefresh(crossinline block: DescribeTopicRefreshRequest.Builder.() -> Unit): DescribeTopicRefreshResponse = describeTopicRefresh(DescribeTopicRefreshRequest.Builder().apply(block).build())

/**
 * Deletes a topic refresh schedule.
 */
public suspend inline fun QuickSightClient.describeTopicRefreshSchedule(crossinline block: DescribeTopicRefreshScheduleRequest.Builder.() -> Unit): DescribeTopicRefreshScheduleResponse = describeTopicRefreshSchedule(DescribeTopicRefreshScheduleRequest.Builder().apply(block).build())

/**
 * Returns information about a user, given the user name.
 */
public suspend inline fun QuickSightClient.describeUser(crossinline block: DescribeUserRequest.Builder.() -> Unit): DescribeUserResponse = describeUser(DescribeUserRequest.Builder().apply(block).build())

/**
 * Describes a VPC connection.
 */
public suspend inline fun QuickSightClient.describeVpcConnection(crossinline block: DescribeVpcConnectionRequest.Builder.() -> Unit): DescribeVpcConnectionResponse = describeVpcConnection(DescribeVpcConnectionRequest.Builder().apply(block).build())

/**
 * Generates an embed URL that you can use to embed an Amazon QuickSight dashboard or visual in your website, without having to register any reader users. Before you use this action, make sure that you have configured the dashboards and permissions.
 *
 * The following rules apply to the generated URL:
 * + It contains a temporary bearer token. It is valid for 5 minutes after it is generated. Once redeemed within this period, it cannot be re-used again.
 * + The URL validity period should not be confused with the actual session lifetime that can be customized using the ` <a href="https://docs.aws.amazon.com/quicksight/latest/APIReference/API_GenerateEmbedUrlForAnonymousUser.html#QS-GenerateEmbedUrlForAnonymousUser-request-SessionLifetimeInMinutes">SessionLifetimeInMinutes</a> ` parameter. The resulting user session is valid for 15 minutes (minimum) to 10 hours (maximum). The default session duration is 10 hours.
 * + You are charged only when the URL is used or there is interaction with Amazon QuickSight.
 *
 * For more information, see [Embedded Analytics](https://docs.aws.amazon.com/quicksight/latest/user/embedded-analytics.html) in the *Amazon QuickSight User Guide*.
 *
 * For more information about the high-level steps for embedding and for an interactive demo of the ways you can customize embedding, visit the [Amazon QuickSight Developer Portal](https://docs.aws.amazon.com/quicksight/latest/user/quicksight-dev-portal.html).
 */
public suspend inline fun QuickSightClient.generateEmbedUrlForAnonymousUser(crossinline block: GenerateEmbedUrlForAnonymousUserRequest.Builder.() -> Unit): GenerateEmbedUrlForAnonymousUserResponse = generateEmbedUrlForAnonymousUser(GenerateEmbedUrlForAnonymousUserRequest.Builder().apply(block).build())

/**
 * Generates an embed URL that you can use to embed an Amazon QuickSight experience in your website. This action can be used for any type of user registered in an Amazon QuickSight account. Before you use this action, make sure that you have configured the relevant Amazon QuickSight resource and permissions.
 *
 * The following rules apply to the generated URL:
 * + It contains a temporary bearer token. It is valid for 5 minutes after it is generated. Once redeemed within this period, it cannot be re-used again.
 * + The URL validity period should not be confused with the actual session lifetime that can be customized using the ` <a href="https://docs.aws.amazon.com/quicksight/latest/APIReference/API_GenerateEmbedUrlForRegisteredUser.html#QS-GenerateEmbedUrlForRegisteredUser-request-SessionLifetimeInMinutes">SessionLifetimeInMinutes</a> ` parameter.The resulting user session is valid for 15 minutes (minimum) to 10 hours (maximum). The default session duration is 10 hours.
 * + You are charged only when the URL is used or there is interaction with Amazon QuickSight.
 *
 * For more information, see [Embedded Analytics](https://docs.aws.amazon.com/quicksight/latest/user/embedded-analytics.html) in the *Amazon QuickSight User Guide*.
 *
 * For more information about the high-level steps for embedding and for an interactive demo of the ways you can customize embedding, visit the [Amazon QuickSight Developer Portal](https://docs.aws.amazon.com/quicksight/latest/user/quicksight-dev-portal.html).
 */
public suspend inline fun QuickSightClient.generateEmbedUrlForRegisteredUser(crossinline block: GenerateEmbedUrlForRegisteredUserRequest.Builder.() -> Unit): GenerateEmbedUrlForRegisteredUserResponse = generateEmbedUrlForRegisteredUser(GenerateEmbedUrlForRegisteredUserRequest.Builder().apply(block).build())

/**
 * Generates an embed URL that you can use to embed an Amazon QuickSight experience in your website. This action can be used for any type of user that is registered in an Amazon QuickSight account that uses IAM Identity Center for authentication. This API requires [identity-enhanced IAM Role sessions](https://docs.aws.amazon.com/singlesignon/latest/userguide/trustedidentitypropagation-overview.html#types-identity-enhanced-iam-role-sessions) for the authenticated user that the API call is being made for.
 *
 * This API uses [trusted identity propagation](https://docs.aws.amazon.com/singlesignon/latest/userguide/trustedidentitypropagation.html) to ensure that an end user is authenticated and receives the embed URL that is specific to that user. The IAM Identity Center application that the user has logged into needs to have [trusted Identity Propagation enabled for Amazon QuickSight](https://docs.aws.amazon.com/singlesignon/latest/userguide/trustedidentitypropagation-using-customermanagedapps-specify-trusted-apps.html) with the scope value set to `quicksight:read`. Before you use this action, make sure that you have configured the relevant Amazon QuickSight resource and permissions.
 */
public suspend inline fun QuickSightClient.generateEmbedUrlForRegisteredUserWithIdentity(crossinline block: GenerateEmbedUrlForRegisteredUserWithIdentityRequest.Builder.() -> Unit): GenerateEmbedUrlForRegisteredUserWithIdentityResponse = generateEmbedUrlForRegisteredUserWithIdentity(GenerateEmbedUrlForRegisteredUserWithIdentityRequest.Builder().apply(block).build())

/**
 * Generates a temporary session URL and authorization code(bearer token) that you can use to embed an Amazon QuickSight read-only dashboard in your website or application. Before you use this command, make sure that you have configured the dashboards and permissions.
 *
 * Currently, you can use `GetDashboardEmbedURL` only from the server, not from the user's browser. The following rules apply to the generated URL:
 * + They must be used together.
 * + They can be used one time only.
 * + They are valid for 5 minutes after you run this command.
 * + You are charged only when the URL is used or there is interaction with Amazon QuickSight.
 * + The resulting user session is valid for 15 minutes (default) up to 10 hours (maximum). You can use the optional `SessionLifetimeInMinutes` parameter to customize session duration.
 *
 * For more information, see [Embedding Analytics Using GetDashboardEmbedUrl](https://docs.aws.amazon.com/quicksight/latest/user/embedded-analytics-deprecated.html) in the *Amazon QuickSight User Guide*.
 *
 * For more information about the high-level steps for embedding and for an interactive demo of the ways you can customize embedding, visit the [Amazon QuickSight Developer Portal](https://docs.aws.amazon.com/quicksight/latest/user/quicksight-dev-portal.html).
 */
public suspend inline fun QuickSightClient.getDashboardEmbedUrl(crossinline block: GetDashboardEmbedUrlRequest.Builder.() -> Unit): GetDashboardEmbedUrlResponse = getDashboardEmbedUrl(GetDashboardEmbedUrlRequest.Builder().apply(block).build())

/**
 * Generates a session URL and authorization code that you can use to embed the Amazon Amazon QuickSight console in your web server code. Use `GetSessionEmbedUrl` where you want to provide an authoring portal that allows users to create data sources, datasets, analyses, and dashboards. The users who access an embedded Amazon QuickSight console need belong to the author or admin security cohort. If you want to restrict permissions to some of these features, add a custom permissions profile to the user with the ` <a href="https://docs.aws.amazon.com/quicksight/latest/APIReference/API_UpdateUser.html">UpdateUser</a> ` API operation. Use ` <a href="https://docs.aws.amazon.com/quicksight/latest/APIReference/API_RegisterUser.html">RegisterUser</a> ` API operation to add a new user with a custom permission profile attached. For more information, see the following sections in the *Amazon QuickSight User Guide*:
 * + [Embedding Analytics](https://docs.aws.amazon.com/quicksight/latest/user/embedded-analytics.html)
 * + [Customizing Access to the Amazon QuickSight Console](https://docs.aws.amazon.com/quicksight/latest/user/customizing-permissions-to-the-quicksight-console.html)
 */
public suspend inline fun QuickSightClient.getSessionEmbedUrl(crossinline block: GetSessionEmbedUrlRequest.Builder.() -> Unit): GetSessionEmbedUrlResponse = getSessionEmbedUrl(GetSessionEmbedUrlRequest.Builder().apply(block).build())

/**
 * Lists Amazon QuickSight analyses that exist in the specified Amazon Web Services account.
 */
public suspend inline fun QuickSightClient.listAnalyses(crossinline block: ListAnalysesRequest.Builder.() -> Unit): ListAnalysesResponse = listAnalyses(ListAnalysesRequest.Builder().apply(block).build())

/**
 * Lists all asset bundle export jobs that have been taken place in the last 14 days. Jobs created more than 14 days ago are deleted forever and are not returned. If you are using the same job ID for multiple jobs, `ListAssetBundleExportJobs` only returns the most recent job that uses the repeated job ID.
 */
public suspend inline fun QuickSightClient.listAssetBundleExportJobs(crossinline block: ListAssetBundleExportJobsRequest.Builder.() -> Unit): ListAssetBundleExportJobsResponse = listAssetBundleExportJobs(ListAssetBundleExportJobsRequest.Builder().apply(block).build())

/**
 * Lists all asset bundle import jobs that have taken place in the last 14 days. Jobs created more than 14 days ago are deleted forever and are not returned. If you are using the same job ID for multiple jobs, `ListAssetBundleImportJobs` only returns the most recent job that uses the repeated job ID.
 */
public suspend inline fun QuickSightClient.listAssetBundleImportJobs(crossinline block: ListAssetBundleImportJobsRequest.Builder.() -> Unit): ListAssetBundleImportJobsResponse = listAssetBundleImportJobs(ListAssetBundleImportJobsRequest.Builder().apply(block).build())

/**
 * Lists all brands in an Amazon QuickSight account.
 */
public suspend inline fun QuickSightClient.listBrands(crossinline block: ListBrandsRequest.Builder.() -> Unit): ListBrandsResponse = listBrands(ListBrandsRequest.Builder().apply(block).build())

/**
 * Returns a list of all the custom permissions profiles.
 */
public suspend inline fun QuickSightClient.listCustomPermissions(crossinline block: ListCustomPermissionsRequest.Builder.() -> Unit): ListCustomPermissionsResponse = listCustomPermissions(ListCustomPermissionsRequest.Builder().apply(block).build())

/**
 * Lists all the versions of the dashboards in the Amazon QuickSight subscription.
 */
public suspend inline fun QuickSightClient.listDashboardVersions(crossinline block: ListDashboardVersionsRequest.Builder.() -> Unit): ListDashboardVersionsResponse = listDashboardVersions(ListDashboardVersionsRequest.Builder().apply(block).build())

/**
 * Lists dashboards in an Amazon Web Services account.
 */
public suspend inline fun QuickSightClient.listDashboards(crossinline block: ListDashboardsRequest.Builder.() -> Unit): ListDashboardsResponse = listDashboards(ListDashboardsRequest.Builder().apply(block).build())

/**
 * Lists all of the datasets belonging to the current Amazon Web Services account in an Amazon Web Services Region.
 *
 * The permissions resource is `arn:aws:quicksight:region:aws-account-id:dataset&#47;*`.
 */
public suspend inline fun QuickSightClient.listDataSets(crossinline block: ListDataSetsRequest.Builder.() -> Unit): ListDataSetsResponse = listDataSets(ListDataSetsRequest.Builder().apply(block).build())

/**
 * Lists data sources in current Amazon Web Services Region that belong to this Amazon Web Services account.
 */
public suspend inline fun QuickSightClient.listDataSources(crossinline block: ListDataSourcesRequest.Builder.() -> Unit): ListDataSourcesResponse = listDataSources(ListDataSourcesRequest.Builder().apply(block).build())

/**
 * List all assets (`DASHBOARD`, `ANALYSIS`, and `DATASET`) in a folder.
 */
public suspend inline fun QuickSightClient.listFolderMembers(crossinline block: ListFolderMembersRequest.Builder.() -> Unit): ListFolderMembersResponse = listFolderMembers(ListFolderMembersRequest.Builder().apply(block).build())

/**
 * Lists all folders in an account.
 */
public suspend inline fun QuickSightClient.listFolders(crossinline block: ListFoldersRequest.Builder.() -> Unit): ListFoldersResponse = listFolders(ListFoldersRequest.Builder().apply(block).build())

/**
 * List all folders that a resource is a member of.
 */
public suspend inline fun QuickSightClient.listFoldersForResource(crossinline block: ListFoldersForResourceRequest.Builder.() -> Unit): ListFoldersForResourceResponse = listFoldersForResource(ListFoldersForResourceRequest.Builder().apply(block).build())

/**
 * Lists member users in a group.
 */
public suspend inline fun QuickSightClient.listGroupMemberships(crossinline block: ListGroupMembershipsRequest.Builder.() -> Unit): ListGroupMembershipsResponse = listGroupMemberships(ListGroupMembershipsRequest.Builder().apply(block).build())

/**
 * Lists all user groups in Amazon QuickSight.
 */
public suspend inline fun QuickSightClient.listGroups(crossinline block: ListGroupsRequest.Builder.() -> Unit): ListGroupsResponse = listGroups(ListGroupsRequest.Builder().apply(block).build())

/**
 * Lists the IAM policy assignments in the current Amazon QuickSight account.
 */
public suspend inline fun QuickSightClient.listIamPolicyAssignments(crossinline block: ListIamPolicyAssignmentsRequest.Builder.() -> Unit): ListIamPolicyAssignmentsResponse = listIamPolicyAssignments(ListIamPolicyAssignmentsRequest.Builder().apply(block).build())

/**
 * Lists all of the IAM policy assignments, including the Amazon Resource Names (ARNs), for the IAM policies assigned to the specified user and group, or groups that the user belongs to.
 */
public suspend inline fun QuickSightClient.listIamPolicyAssignmentsForUser(crossinline block: ListIamPolicyAssignmentsForUserRequest.Builder.() -> Unit): ListIamPolicyAssignmentsForUserResponse = listIamPolicyAssignmentsForUser(ListIamPolicyAssignmentsForUserRequest.Builder().apply(block).build())

/**
 * Lists all services and authorized targets that the Amazon QuickSight IAM Identity Center application can access.
 *
 * This operation is only supported for Amazon QuickSight accounts that use IAM Identity Center.
 */
public suspend inline fun QuickSightClient.listIdentityPropagationConfigs(crossinline block: ListIdentityPropagationConfigsRequest.Builder.() -> Unit): ListIdentityPropagationConfigsResponse = listIdentityPropagationConfigs(ListIdentityPropagationConfigsRequest.Builder().apply(block).build())

/**
 * Lists the history of SPICE ingestions for a dataset. Limited to 5 TPS per user and 25 TPS per account.
 */
public suspend inline fun QuickSightClient.listIngestions(crossinline block: ListIngestionsRequest.Builder.() -> Unit): ListIngestionsResponse = listIngestions(ListIngestionsRequest.Builder().apply(block).build())

/**
 * Lists the namespaces for the specified Amazon Web Services account. This operation doesn't list deleted namespaces.
 */
public suspend inline fun QuickSightClient.listNamespaces(crossinline block: ListNamespacesRequest.Builder.() -> Unit): ListNamespacesResponse = listNamespaces(ListNamespacesRequest.Builder().apply(block).build())

/**
 * Lists the refresh schedules of a dataset. Each dataset can have up to 5 schedules.
 */
public suspend inline fun QuickSightClient.listRefreshSchedules(crossinline block: ListRefreshSchedulesRequest.Builder.() -> Unit): ListRefreshSchedulesResponse = listRefreshSchedules(ListRefreshSchedulesRequest.Builder().apply(block).build())

/**
 * Lists all groups that are associated with a role.
 */
public suspend inline fun QuickSightClient.listRoleMemberships(crossinline block: ListRoleMembershipsRequest.Builder.() -> Unit): ListRoleMembershipsResponse = listRoleMemberships(ListRoleMembershipsRequest.Builder().apply(block).build())

/**
 * Lists the tags assigned to a resource.
 */
public suspend inline fun QuickSightClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Lists all the aliases of a template.
 */
public suspend inline fun QuickSightClient.listTemplateAliases(crossinline block: ListTemplateAliasesRequest.Builder.() -> Unit): ListTemplateAliasesResponse = listTemplateAliases(ListTemplateAliasesRequest.Builder().apply(block).build())

/**
 * Lists all the versions of the templates in the current Amazon QuickSight account.
 */
public suspend inline fun QuickSightClient.listTemplateVersions(crossinline block: ListTemplateVersionsRequest.Builder.() -> Unit): ListTemplateVersionsResponse = listTemplateVersions(ListTemplateVersionsRequest.Builder().apply(block).build())

/**
 * Lists all the templates in the current Amazon QuickSight account.
 */
public suspend inline fun QuickSightClient.listTemplates(crossinline block: ListTemplatesRequest.Builder.() -> Unit): ListTemplatesResponse = listTemplates(ListTemplatesRequest.Builder().apply(block).build())

/**
 * Lists all the aliases of a theme.
 */
public suspend inline fun QuickSightClient.listThemeAliases(crossinline block: ListThemeAliasesRequest.Builder.() -> Unit): ListThemeAliasesResponse = listThemeAliases(ListThemeAliasesRequest.Builder().apply(block).build())

/**
 * Lists all the versions of the themes in the current Amazon Web Services account.
 */
public suspend inline fun QuickSightClient.listThemeVersions(crossinline block: ListThemeVersionsRequest.Builder.() -> Unit): ListThemeVersionsResponse = listThemeVersions(ListThemeVersionsRequest.Builder().apply(block).build())

/**
 * Lists all the themes in the current Amazon Web Services account.
 */
public suspend inline fun QuickSightClient.listThemes(crossinline block: ListThemesRequest.Builder.() -> Unit): ListThemesResponse = listThemes(ListThemesRequest.Builder().apply(block).build())

/**
 * Lists all of the refresh schedules for a topic.
 */
public suspend inline fun QuickSightClient.listTopicRefreshSchedules(crossinline block: ListTopicRefreshSchedulesRequest.Builder.() -> Unit): ListTopicRefreshSchedulesResponse = listTopicRefreshSchedules(ListTopicRefreshSchedulesRequest.Builder().apply(block).build())

/**
 * Lists all reviewed answers for a Q Topic.
 */
public suspend inline fun QuickSightClient.listTopicReviewedAnswers(crossinline block: ListTopicReviewedAnswersRequest.Builder.() -> Unit): ListTopicReviewedAnswersResponse = listTopicReviewedAnswers(ListTopicReviewedAnswersRequest.Builder().apply(block).build())

/**
 * Lists all of the topics within an account.
 */
public suspend inline fun QuickSightClient.listTopics(crossinline block: ListTopicsRequest.Builder.() -> Unit): ListTopicsResponse = listTopics(ListTopicsRequest.Builder().apply(block).build())

/**
 * Lists the Amazon QuickSight groups that an Amazon QuickSight user is a member of.
 */
public suspend inline fun QuickSightClient.listUserGroups(crossinline block: ListUserGroupsRequest.Builder.() -> Unit): ListUserGroupsResponse = listUserGroups(ListUserGroupsRequest.Builder().apply(block).build())

/**
 * Returns a list of all of the Amazon QuickSight users belonging to this account.
 */
public suspend inline fun QuickSightClient.listUsers(crossinline block: ListUsersRequest.Builder.() -> Unit): ListUsersResponse = listUsers(ListUsersRequest.Builder().apply(block).build())

/**
 * Lists all of the VPC connections in the current set Amazon Web Services Region of an Amazon Web Services account.
 */
public suspend inline fun QuickSightClient.listVpcConnections(crossinline block: ListVpcConnectionsRequest.Builder.() -> Unit): ListVpcConnectionsResponse = listVpcConnections(ListVpcConnectionsRequest.Builder().apply(block).build())

/**
 * Predicts existing visuals or generates new visuals to answer a given query.
 *
 * This API uses [trusted identity propagation](https://docs.aws.amazon.com/singlesignon/latest/userguide/trustedidentitypropagation.html) to ensure that an end user is authenticated and receives the embed URL that is specific to that user. The IAM Identity Center application that the user has logged into needs to have [trusted Identity Propagation enabled for Amazon QuickSight](https://docs.aws.amazon.com/singlesignon/latest/userguide/trustedidentitypropagation-using-customermanagedapps-specify-trusted-apps.html) with the scope value set to `quicksight:read`. Before you use this action, make sure that you have configured the relevant Amazon QuickSight resource and permissions.
 *
 * We recommend enabling the `QSearchStatus` API to unlock the full potential of `PredictQnA`. When `QSearchStatus` is enabled, it first checks the specified dashboard for any existing visuals that match the question. If no matching visuals are found, `PredictQnA` uses generative Q&A to provide an answer. To update the `QSearchStatus`, see [UpdateQuickSightQSearchConfiguration](https://docs.aws.amazon.com/quicksight/latest/APIReference/API_UpdateQuickSightQSearchConfiguration.html).
 */
public suspend inline fun QuickSightClient.predictQaResults(crossinline block: PredictQaResultsRequest.Builder.() -> Unit): PredictQaResultsResponse = predictQaResults(PredictQaResultsRequest.Builder().apply(block).build())

/**
 * Creates or updates the dataset refresh properties for the dataset.
 */
public suspend inline fun QuickSightClient.putDataSetRefreshProperties(crossinline block: PutDataSetRefreshPropertiesRequest.Builder.() -> Unit): PutDataSetRefreshPropertiesResponse = putDataSetRefreshProperties(PutDataSetRefreshPropertiesRequest.Builder().apply(block).build())

/**
 * Creates an Amazon QuickSight user whose identity is associated with the Identity and Access Management (IAM) identity or role specified in the request. When you register a new user from the Amazon QuickSight API, Amazon QuickSight generates a registration URL. The user accesses this registration URL to create their account. Amazon QuickSight doesn't send a registration email to users who are registered from the Amazon QuickSight API. If you want new users to receive a registration email, then add those users in the Amazon QuickSight console. For more information on registering a new user in the Amazon QuickSight console, see [ Inviting users to access Amazon QuickSight](https://docs.aws.amazon.com/quicksight/latest/user/managing-users.html#inviting-users).
 */
public suspend inline fun QuickSightClient.registerUser(crossinline block: RegisterUserRequest.Builder.() -> Unit): RegisterUserResponse = registerUser(RegisterUserRequest.Builder().apply(block).build())

/**
 * Restores an analysis.
 */
public suspend inline fun QuickSightClient.restoreAnalysis(crossinline block: RestoreAnalysisRequest.Builder.() -> Unit): RestoreAnalysisResponse = restoreAnalysis(RestoreAnalysisRequest.Builder().apply(block).build())

/**
 * Searches for analyses that belong to the user specified in the filter.
 *
 * This operation is eventually consistent. The results are best effort and may not reflect very recent updates and changes.
 */
public suspend inline fun QuickSightClient.searchAnalyses(crossinline block: SearchAnalysesRequest.Builder.() -> Unit): SearchAnalysesResponse = searchAnalyses(SearchAnalysesRequest.Builder().apply(block).build())

/**
 * Searches for dashboards that belong to a user.
 *
 * This operation is eventually consistent. The results are best effort and may not reflect very recent updates and changes.
 */
public suspend inline fun QuickSightClient.searchDashboards(crossinline block: SearchDashboardsRequest.Builder.() -> Unit): SearchDashboardsResponse = searchDashboards(SearchDashboardsRequest.Builder().apply(block).build())

/**
 * Use the `SearchDataSets` operation to search for datasets that belong to an account.
 */
public suspend inline fun QuickSightClient.searchDataSets(crossinline block: SearchDataSetsRequest.Builder.() -> Unit): SearchDataSetsResponse = searchDataSets(SearchDataSetsRequest.Builder().apply(block).build())

/**
 * Use the `SearchDataSources` operation to search for data sources that belong to an account.
 */
public suspend inline fun QuickSightClient.searchDataSources(crossinline block: SearchDataSourcesRequest.Builder.() -> Unit): SearchDataSourcesResponse = searchDataSources(SearchDataSourcesRequest.Builder().apply(block).build())

/**
 * Searches the subfolders in a folder.
 */
public suspend inline fun QuickSightClient.searchFolders(crossinline block: SearchFoldersRequest.Builder.() -> Unit): SearchFoldersResponse = searchFolders(SearchFoldersRequest.Builder().apply(block).build())

/**
 * Use the `SearchGroups` operation to search groups in a specified Amazon QuickSight namespace using the supplied filters.
 */
public suspend inline fun QuickSightClient.searchGroups(crossinline block: SearchGroupsRequest.Builder.() -> Unit): SearchGroupsResponse = searchGroups(SearchGroupsRequest.Builder().apply(block).build())

/**
 * Searches for any Q topic that exists in an Amazon QuickSight account.
 */
public suspend inline fun QuickSightClient.searchTopics(crossinline block: SearchTopicsRequest.Builder.() -> Unit): SearchTopicsResponse = searchTopics(SearchTopicsRequest.Builder().apply(block).build())

/**
 * Starts an Asset Bundle export job.
 *
 * An Asset Bundle export job exports specified Amazon QuickSight assets. You can also choose to export any asset dependencies in the same job. Export jobs run asynchronously and can be polled with a `DescribeAssetBundleExportJob` API call. When a job is successfully completed, a download URL that contains the exported assets is returned. The URL is valid for 5 minutes and can be refreshed with a `DescribeAssetBundleExportJob` API call. Each Amazon QuickSight account can run up to 5 export jobs concurrently.
 *
 * The API caller must have the necessary permissions in their IAM role to access each resource before the resources can be exported.
 */
public suspend inline fun QuickSightClient.startAssetBundleExportJob(crossinline block: StartAssetBundleExportJobRequest.Builder.() -> Unit): StartAssetBundleExportJobResponse = startAssetBundleExportJob(StartAssetBundleExportJobRequest.Builder().apply(block).build())

/**
 * Starts an Asset Bundle import job.
 *
 * An Asset Bundle import job imports specified Amazon QuickSight assets into an Amazon QuickSight account. You can also choose to import a naming prefix and specified configuration overrides. The assets that are contained in the bundle file that you provide are used to create or update a new or existing asset in your Amazon QuickSight account. Each Amazon QuickSight account can run up to 5 import jobs concurrently.
 *
 * The API caller must have the necessary `"create"`, `"describe"`, and `"update"` permissions in their IAM role to access each resource type that is contained in the bundle file before the resources can be imported.
 */
public suspend inline fun QuickSightClient.startAssetBundleImportJob(crossinline block: StartAssetBundleImportJobRequest.Builder.() -> Unit): StartAssetBundleImportJobResponse = startAssetBundleImportJob(StartAssetBundleImportJobRequest.Builder().apply(block).build())

/**
 * Starts an asynchronous job that generates a snapshot of a dashboard's output. You can request one or several of the following format configurations in each API call.
 * + 1 Paginated PDF
 * + 1 Excel workbook that includes up to 5 table or pivot table visuals
 * + 5 CSVs from table or pivot table visuals
 *
 * The status of a submitted job can be polled with the `DescribeDashboardSnapshotJob` API. When you call the `DescribeDashboardSnapshotJob` API, check the `JobStatus` field in the response. Once the job reaches a `COMPLETED` or `FAILED` status, use the `DescribeDashboardSnapshotJobResult` API to obtain the URLs for the generated files. If the job fails, the `DescribeDashboardSnapshotJobResult` API returns detailed information about the error that occurred.
 *
 * **StartDashboardSnapshotJob API throttling**
 *
 * Amazon QuickSight utilizes API throttling to create a more consistent user experience within a time span for customers when they call the `StartDashboardSnapshotJob`. By default, 12 jobs can run simlutaneously in one Amazon Web Services account and users can submit up 10 API requests per second before an account is throttled. If an overwhelming number of API requests are made by the same user in a short period of time, Amazon QuickSight throttles the API calls to maintin an optimal experience and reliability for all Amazon QuickSight users.
 *
 * **Common throttling scenarios**
 *
 * The following list provides information about the most commin throttling scenarios that can occur.
 * + **A large number of `SnapshotExport` API jobs are running simultaneously on an Amazon Web Services account.** When a new `StartDashboardSnapshotJob` is created and there are already 12 jobs with the `RUNNING` status, the new job request fails and returns a `LimitExceededException` error. Wait for a current job to comlpete before you resubmit the new job.
 * + **A large number of API requests are submitted on an Amazon Web Services account.** When a user makes more than 10 API calls to the Amazon QuickSight API in one second, a `ThrottlingException` is returned.
 *
 * If your use case requires a higher throttling limit, contact your account admin or [Amazon Web ServicesSupport](http://aws.amazon.com/contact-us/) to explore options to tailor a more optimal expereince for your account.
 *
 * **Best practices to handle throttling**
 *
 * If your use case projects high levels of API traffic, try to reduce the degree of frequency and parallelism of API calls as much as you can to avoid throttling. You can also perform a timing test to calculate an estimate for the total processing time of your projected load that stays within the throttling limits of the Amazon QuickSight APIs. For example, if your projected traffic is 100 snapshot jobs before 12:00 PM per day, start 12 jobs in parallel and measure the amount of time it takes to proccess all 12 jobs. Once you obtain the result, multiply the duration by 9, for example `(12 minutes * 9 = 108 minutes)`. Use the new result to determine the latest time at which the jobs need to be started to meet your target deadline.
 *
 * The time that it takes to process a job can be impacted by the following factors:
 * + The dataset type (Direct Query or SPICE).
 * + The size of the dataset.
 * + The complexity of the calculated fields that are used in the dashboard.
 * + The number of visuals that are on a sheet.
 * + The types of visuals that are on the sheet.
 * + The number of formats and snapshots that are requested in the job configuration.
 * + The size of the generated snapshots.
 */
public suspend inline fun QuickSightClient.startDashboardSnapshotJob(crossinline block: StartDashboardSnapshotJobRequest.Builder.() -> Unit): StartDashboardSnapshotJobResponse = startDashboardSnapshotJob(StartDashboardSnapshotJobRequest.Builder().apply(block).build())

/**
 * Starts an asynchronous job that runs an existing dashboard schedule and sends the dashboard snapshot through email.
 *
 * Only one job can run simultaneously in a given schedule. Repeated requests are skipped with a `202` HTTP status code.
 *
 * For more information, see [Scheduling and sending Amazon QuickSight reports by email](https://docs.aws.amazon.com/quicksight/latest/user/sending-reports.html) and [Configuring email report settings for a Amazon QuickSight dashboard](https://docs.aws.amazon.com/quicksight/latest/user/email-reports-from-dashboard.html) in the *Amazon QuickSight User Guide*.
 */
public suspend inline fun QuickSightClient.startDashboardSnapshotJobSchedule(crossinline block: StartDashboardSnapshotJobScheduleRequest.Builder.() -> Unit): StartDashboardSnapshotJobScheduleResponse = startDashboardSnapshotJobSchedule(StartDashboardSnapshotJobScheduleRequest.Builder().apply(block).build())

/**
 * Assigns one or more tags (key-value pairs) to the specified Amazon QuickSight resource.
 *
 * Tags can help you organize and categorize your resources. You can also use them to scope user permissions, by granting a user permission to access or change only resources with certain tag values. You can use the `TagResource` operation with a resource that already has tags. If you specify a new tag key for the resource, this tag is appended to the list of tags associated with the resource. If you specify a tag key that is already associated with the resource, the new tag value that you specify replaces the previous value for that tag.
 *
 * You can associate as many as 50 tags with a resource. Amazon QuickSight supports tagging on data set, data source, dashboard, template, topic, and user.
 *
 * Tagging for Amazon QuickSight works in a similar way to tagging for other Amazon Web Services services, except for the following:
 * + Tags are used to track costs for users in Amazon QuickSight. You can't tag other resources that Amazon QuickSight costs are based on, such as storage capacoty (SPICE), session usage, alert consumption, or reporting units.
 * + Amazon QuickSight doesn't currently support the tag editor for Resource Groups.
 */
public suspend inline fun QuickSightClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Removes a tag or tags from a resource.
 */
public suspend inline fun QuickSightClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * Updates Amazon QuickSight customizations for the current Amazon Web Services Region. Currently, the only customization that you can use is a theme.
 *
 * You can use customizations for your Amazon Web Services account or, if you specify a namespace, for a Amazon QuickSight namespace instead. Customizations that apply to a namespace override customizations that apply to an Amazon Web Services account. To find out which customizations apply, use the `DescribeAccountCustomization` API operation.
 */
public suspend inline fun QuickSightClient.updateAccountCustomization(crossinline block: UpdateAccountCustomizationRequest.Builder.() -> Unit): UpdateAccountCustomizationResponse = updateAccountCustomization(UpdateAccountCustomizationRequest.Builder().apply(block).build())

/**
 * Updates the Amazon QuickSight settings in your Amazon Web Services account.
 */
public suspend inline fun QuickSightClient.updateAccountSettings(crossinline block: UpdateAccountSettingsRequest.Builder.() -> Unit): UpdateAccountSettingsResponse = updateAccountSettings(UpdateAccountSettingsRequest.Builder().apply(block).build())

/**
 * Updates an analysis in Amazon QuickSight
 */
public suspend inline fun QuickSightClient.updateAnalysis(crossinline block: UpdateAnalysisRequest.Builder.() -> Unit): UpdateAnalysisResponse = updateAnalysis(UpdateAnalysisRequest.Builder().apply(block).build())

/**
 * Updates the read and write permissions for an analysis.
 */
public suspend inline fun QuickSightClient.updateAnalysisPermissions(crossinline block: UpdateAnalysisPermissionsRequest.Builder.() -> Unit): UpdateAnalysisPermissionsResponse = updateAnalysisPermissions(UpdateAnalysisPermissionsRequest.Builder().apply(block).build())

/**
 * Updates an Amazon QuickSight application with a token exchange grant. This operation only supports Amazon QuickSight applications that are registered with IAM Identity Center.
 */
public suspend inline fun QuickSightClient.updateApplicationWithTokenExchangeGrant(crossinline block: UpdateApplicationWithTokenExchangeGrantRequest.Builder.() -> Unit): UpdateApplicationWithTokenExchangeGrantResponse = updateApplicationWithTokenExchangeGrant(UpdateApplicationWithTokenExchangeGrantRequest.Builder().apply(block).build())

/**
 * Updates a brand.
 */
public suspend inline fun QuickSightClient.updateBrand(crossinline block: UpdateBrandRequest.Builder.() -> Unit): UpdateBrandResponse = updateBrand(UpdateBrandRequest.Builder().apply(block).build())

/**
 * Updates a brand assignment.
 */
public suspend inline fun QuickSightClient.updateBrandAssignment(crossinline block: UpdateBrandAssignmentRequest.Builder.() -> Unit): UpdateBrandAssignmentResponse = updateBrandAssignment(UpdateBrandAssignmentRequest.Builder().apply(block).build())

/**
 * Updates the published version of a brand.
 */
public suspend inline fun QuickSightClient.updateBrandPublishedVersion(crossinline block: UpdateBrandPublishedVersionRequest.Builder.() -> Unit): UpdateBrandPublishedVersionResponse = updateBrandPublishedVersion(UpdateBrandPublishedVersionRequest.Builder().apply(block).build())

/**
 * Updates a custom permissions profile.
 */
public suspend inline fun QuickSightClient.updateCustomPermissions(crossinline block: UpdateCustomPermissionsRequest.Builder.() -> Unit): UpdateCustomPermissionsResponse = updateCustomPermissions(UpdateCustomPermissionsRequest.Builder().apply(block).build())

/**
 * Updates a dashboard in an Amazon Web Services account.
 *
 * Updating a Dashboard creates a new dashboard version but does not immediately publish the new version. You can update the published version of a dashboard by using the ` <a href="https://docs.aws.amazon.com/quicksight/latest/APIReference/API_UpdateDashboardPublishedVersion.html">UpdateDashboardPublishedVersion</a> ` API operation.
 */
public suspend inline fun QuickSightClient.updateDashboard(crossinline block: UpdateDashboardRequest.Builder.() -> Unit): UpdateDashboardResponse = updateDashboard(UpdateDashboardRequest.Builder().apply(block).build())

/**
 * Updates the linked analyses on a dashboard.
 */
public suspend inline fun QuickSightClient.updateDashboardLinks(crossinline block: UpdateDashboardLinksRequest.Builder.() -> Unit): UpdateDashboardLinksResponse = updateDashboardLinks(UpdateDashboardLinksRequest.Builder().apply(block).build())

/**
 * Updates read and write permissions on a dashboard.
 */
public suspend inline fun QuickSightClient.updateDashboardPermissions(crossinline block: UpdateDashboardPermissionsRequest.Builder.() -> Unit): UpdateDashboardPermissionsResponse = updateDashboardPermissions(UpdateDashboardPermissionsRequest.Builder().apply(block).build())

/**
 * Updates the published version of a dashboard.
 */
public suspend inline fun QuickSightClient.updateDashboardPublishedVersion(crossinline block: UpdateDashboardPublishedVersionRequest.Builder.() -> Unit): UpdateDashboardPublishedVersionResponse = updateDashboardPublishedVersion(UpdateDashboardPublishedVersionRequest.Builder().apply(block).build())

/**
 * Updates a Dashboard QA configuration.
 */
public suspend inline fun QuickSightClient.updateDashboardsQaConfiguration(crossinline block: UpdateDashboardsQaConfigurationRequest.Builder.() -> Unit): UpdateDashboardsQaConfigurationResponse = updateDashboardsQaConfiguration(UpdateDashboardsQaConfigurationRequest.Builder().apply(block).build())

/**
 * Updates a dataset. This operation doesn't support datasets that include uploaded files as a source. Partial updates are not supported by this operation.
 */
public suspend inline fun QuickSightClient.updateDataSet(crossinline block: UpdateDataSetRequest.Builder.() -> Unit): UpdateDataSetResponse = updateDataSet(UpdateDataSetRequest.Builder().apply(block).build())

/**
 * Updates the permissions on a dataset.
 *
 * The permissions resource is `arn:aws:quicksight:region:aws-account-id:dataset/data-set-id`.
 */
public suspend inline fun QuickSightClient.updateDataSetPermissions(crossinline block: UpdateDataSetPermissionsRequest.Builder.() -> Unit): UpdateDataSetPermissionsResponse = updateDataSetPermissions(UpdateDataSetPermissionsRequest.Builder().apply(block).build())

/**
 * Updates a data source.
 */
public suspend inline fun QuickSightClient.updateDataSource(crossinline block: UpdateDataSourceRequest.Builder.() -> Unit): UpdateDataSourceResponse = updateDataSource(UpdateDataSourceRequest.Builder().apply(block).build())

/**
 * Updates the permissions to a data source.
 */
public suspend inline fun QuickSightClient.updateDataSourcePermissions(crossinline block: UpdateDataSourcePermissionsRequest.Builder.() -> Unit): UpdateDataSourcePermissionsResponse = updateDataSourcePermissions(UpdateDataSourcePermissionsRequest.Builder().apply(block).build())

/**
 * Updates a Amazon Q Business application that is linked to a Amazon QuickSight account.
 */
public suspend inline fun QuickSightClient.updateDefaultQBusinessApplication(crossinline block: UpdateDefaultQBusinessApplicationRequest.Builder.() -> Unit): UpdateDefaultQBusinessApplicationResponse = updateDefaultQBusinessApplication(UpdateDefaultQBusinessApplicationRequest.Builder().apply(block).build())

/**
 * Updates the name of a folder.
 */
public suspend inline fun QuickSightClient.updateFolder(crossinline block: UpdateFolderRequest.Builder.() -> Unit): UpdateFolderResponse = updateFolder(UpdateFolderRequest.Builder().apply(block).build())

/**
 * Updates permissions of a folder.
 */
public suspend inline fun QuickSightClient.updateFolderPermissions(crossinline block: UpdateFolderPermissionsRequest.Builder.() -> Unit): UpdateFolderPermissionsResponse = updateFolderPermissions(UpdateFolderPermissionsRequest.Builder().apply(block).build())

/**
 * Changes a group description.
 */
public suspend inline fun QuickSightClient.updateGroup(crossinline block: UpdateGroupRequest.Builder.() -> Unit): UpdateGroupResponse = updateGroup(UpdateGroupRequest.Builder().apply(block).build())

/**
 * Updates an existing IAM policy assignment. This operation updates only the optional parameter or parameters that are specified in the request. This overwrites all of the users included in `Identities`.
 */
public suspend inline fun QuickSightClient.updateIamPolicyAssignment(crossinline block: UpdateIamPolicyAssignmentRequest.Builder.() -> Unit): UpdateIamPolicyAssignmentResponse = updateIamPolicyAssignment(UpdateIamPolicyAssignmentRequest.Builder().apply(block).build())

/**
 * Adds or updates services and authorized targets to configure what the Amazon QuickSight IAM Identity Center application can access.
 *
 * This operation is only supported for Amazon QuickSight accounts using IAM Identity Center
 */
public suspend inline fun QuickSightClient.updateIdentityPropagationConfig(crossinline block: UpdateIdentityPropagationConfigRequest.Builder.() -> Unit): UpdateIdentityPropagationConfigResponse = updateIdentityPropagationConfig(UpdateIdentityPropagationConfigRequest.Builder().apply(block).build())

/**
 * Updates the content and status of IP rules. Traffic from a source is allowed when the source satisfies either the `IpRestrictionRule`, `VpcIdRestrictionRule`, or `VpcEndpointIdRestrictionRule`. To use this operation, you must provide the entire map of rules. You can use the `DescribeIpRestriction` operation to get the current rule map.
 */
public suspend inline fun QuickSightClient.updateIpRestriction(crossinline block: UpdateIpRestrictionRequest.Builder.() -> Unit): UpdateIpRestrictionResponse = updateIpRestriction(UpdateIpRestrictionRequest.Builder().apply(block).build())

/**
 * Updates a customer managed key in a Amazon QuickSight account.
 */
public suspend inline fun QuickSightClient.updateKeyRegistration(crossinline block: UpdateKeyRegistrationRequest.Builder.() -> Unit): UpdateKeyRegistrationResponse = updateKeyRegistration(UpdateKeyRegistrationRequest.Builder().apply(block).build())

/**
 * Use the `UpdatePublicSharingSettings` operation to turn on or turn off the public sharing settings of an Amazon QuickSight dashboard.
 *
 * To use this operation, turn on session capacity pricing for your Amazon QuickSight account.
 *
 * Before you can turn on public sharing on your account, make sure to give public sharing permissions to an administrative user in the Identity and Access Management (IAM) console. For more information on using IAM with Amazon QuickSight, see [Using Amazon QuickSight with IAM](https://docs.aws.amazon.com/quicksight/latest/user/security_iam_service-with-iam.html) in the *Amazon QuickSight User Guide*.
 */
public suspend inline fun QuickSightClient.updatePublicSharingSettings(crossinline block: UpdatePublicSharingSettingsRequest.Builder.() -> Unit): UpdatePublicSharingSettingsResponse = updatePublicSharingSettings(UpdatePublicSharingSettingsRequest.Builder().apply(block).build())

/**
 * Updates a personalization configuration.
 */
public suspend inline fun QuickSightClient.updateQPersonalizationConfiguration(crossinline block: UpdateQPersonalizationConfigurationRequest.Builder.() -> Unit): UpdateQPersonalizationConfigurationResponse = updateQPersonalizationConfiguration(UpdateQPersonalizationConfigurationRequest.Builder().apply(block).build())

/**
 * Updates the state of a Amazon QuickSight Q Search configuration.
 */
public suspend inline fun QuickSightClient.updateQuickSightQSearchConfiguration(crossinline block: UpdateQuickSightQSearchConfigurationRequest.Builder.() -> Unit): UpdateQuickSightQSearchConfigurationResponse = updateQuickSightQSearchConfiguration(UpdateQuickSightQSearchConfigurationRequest.Builder().apply(block).build())

/**
 * Updates a refresh schedule for a dataset.
 */
public suspend inline fun QuickSightClient.updateRefreshSchedule(crossinline block: UpdateRefreshScheduleRequest.Builder.() -> Unit): UpdateRefreshScheduleResponse = updateRefreshSchedule(UpdateRefreshScheduleRequest.Builder().apply(block).build())

/**
 * Updates the custom permissions that are associated with a role.
 */
public suspend inline fun QuickSightClient.updateRoleCustomPermission(crossinline block: UpdateRoleCustomPermissionRequest.Builder.() -> Unit): UpdateRoleCustomPermissionResponse = updateRoleCustomPermission(UpdateRoleCustomPermissionRequest.Builder().apply(block).build())

/**
 * Updates the SPICE capacity configuration for a Amazon QuickSight account.
 */
public suspend inline fun QuickSightClient.updateSpiceCapacityConfiguration(crossinline block: UpdateSpiceCapacityConfigurationRequest.Builder.() -> Unit): UpdateSpiceCapacityConfigurationResponse = updateSpiceCapacityConfiguration(UpdateSpiceCapacityConfigurationRequest.Builder().apply(block).build())

/**
 * Updates a template from an existing Amazon QuickSight analysis or another template.
 */
public suspend inline fun QuickSightClient.updateTemplate(crossinline block: UpdateTemplateRequest.Builder.() -> Unit): UpdateTemplateResponse = updateTemplate(UpdateTemplateRequest.Builder().apply(block).build())

/**
 * Updates the template alias of a template.
 */
public suspend inline fun QuickSightClient.updateTemplateAlias(crossinline block: UpdateTemplateAliasRequest.Builder.() -> Unit): UpdateTemplateAliasResponse = updateTemplateAlias(UpdateTemplateAliasRequest.Builder().apply(block).build())

/**
 * Updates the resource permissions for a template.
 */
public suspend inline fun QuickSightClient.updateTemplatePermissions(crossinline block: UpdateTemplatePermissionsRequest.Builder.() -> Unit): UpdateTemplatePermissionsResponse = updateTemplatePermissions(UpdateTemplatePermissionsRequest.Builder().apply(block).build())

/**
 * Updates a theme.
 */
public suspend inline fun QuickSightClient.updateTheme(crossinline block: UpdateThemeRequest.Builder.() -> Unit): UpdateThemeResponse = updateTheme(UpdateThemeRequest.Builder().apply(block).build())

/**
 * Updates an alias of a theme.
 */
public suspend inline fun QuickSightClient.updateThemeAlias(crossinline block: UpdateThemeAliasRequest.Builder.() -> Unit): UpdateThemeAliasResponse = updateThemeAlias(UpdateThemeAliasRequest.Builder().apply(block).build())

/**
 * Updates the resource permissions for a theme. Permissions apply to the action to grant or revoke permissions on, for example `"quicksight:DescribeTheme"`.
 *
 * Theme permissions apply in groupings. Valid groupings include the following for the three levels of permissions, which are user, owner, or no permissions:
 * + User
 *    + `"quicksight:DescribeTheme"`
 *    + `"quicksight:DescribeThemeAlias"`
 *    + `"quicksight:ListThemeAliases"`
 *    + `"quicksight:ListThemeVersions"`
 * + Owner
 *    + `"quicksight:DescribeTheme"`
 *    + `"quicksight:DescribeThemeAlias"`
 *    + `"quicksight:ListThemeAliases"`
 *    + `"quicksight:ListThemeVersions"`
 *    + `"quicksight:DeleteTheme"`
 *    + `"quicksight:UpdateTheme"`
 *    + `"quicksight:CreateThemeAlias"`
 *    + `"quicksight:DeleteThemeAlias"`
 *    + `"quicksight:UpdateThemeAlias"`
 *    + `"quicksight:UpdateThemePermissions"`
 *    + `"quicksight:DescribeThemePermissions"`
 * + To specify no permissions, omit the permissions list.
 */
public suspend inline fun QuickSightClient.updateThemePermissions(crossinline block: UpdateThemePermissionsRequest.Builder.() -> Unit): UpdateThemePermissionsResponse = updateThemePermissions(UpdateThemePermissionsRequest.Builder().apply(block).build())

/**
 * Updates a topic.
 */
public suspend inline fun QuickSightClient.updateTopic(crossinline block: UpdateTopicRequest.Builder.() -> Unit): UpdateTopicResponse = updateTopic(UpdateTopicRequest.Builder().apply(block).build())

/**
 * Updates the permissions of a topic.
 */
public suspend inline fun QuickSightClient.updateTopicPermissions(crossinline block: UpdateTopicPermissionsRequest.Builder.() -> Unit): UpdateTopicPermissionsResponse = updateTopicPermissions(UpdateTopicPermissionsRequest.Builder().apply(block).build())

/**
 * Updates a topic refresh schedule.
 */
public suspend inline fun QuickSightClient.updateTopicRefreshSchedule(crossinline block: UpdateTopicRefreshScheduleRequest.Builder.() -> Unit): UpdateTopicRefreshScheduleResponse = updateTopicRefreshSchedule(UpdateTopicRefreshScheduleRequest.Builder().apply(block).build())

/**
 * Updates an Amazon QuickSight user.
 */
public suspend inline fun QuickSightClient.updateUser(crossinline block: UpdateUserRequest.Builder.() -> Unit): UpdateUserResponse = updateUser(UpdateUserRequest.Builder().apply(block).build())

/**
 * Updates a custom permissions profile for a user.
 */
public suspend inline fun QuickSightClient.updateUserCustomPermission(crossinline block: UpdateUserCustomPermissionRequest.Builder.() -> Unit): UpdateUserCustomPermissionResponse = updateUserCustomPermission(UpdateUserCustomPermissionRequest.Builder().apply(block).build())

/**
 * Updates a VPC connection.
 */
public suspend inline fun QuickSightClient.updateVpcConnection(crossinline block: UpdateVpcConnectionRequest.Builder.() -> Unit): UpdateVpcConnectionResponse = updateVpcConnection(UpdateVpcConnectionRequest.Builder().apply(block).build())
