// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.qldbsession.serde

import aws.sdk.kotlin.services.qldbsession.model.AbortTransactionResult
import aws.sdk.kotlin.services.qldbsession.model.CommitTransactionResult
import aws.sdk.kotlin.services.qldbsession.model.EndSessionResult
import aws.sdk.kotlin.services.qldbsession.model.ExecuteStatementResult
import aws.sdk.kotlin.services.qldbsession.model.FetchPageResult
import aws.sdk.kotlin.services.qldbsession.model.QldbSessionException
import aws.sdk.kotlin.services.qldbsession.model.SendCommandResponse
import aws.sdk.kotlin.services.qldbsession.model.StartSessionResult
import aws.sdk.kotlin.services.qldbsession.model.StartTransactionResult
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class SendCommandOperationDeserializer: HttpDeserialize<SendCommandResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): SendCommandResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwSendCommandError(context, call)
        }
        val builder = SendCommandResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeSendCommandOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwSendCommandError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw QldbSessionException("Failed to parse response as 'awsJson1_0' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "CapacityExceededException" -> CapacityExceededExceptionDeserializer().deserialize(context, wrappedCall)
        "InvalidSessionException" -> InvalidSessionExceptionDeserializer().deserialize(context, wrappedCall)
        "OccConflictException" -> OccConflictExceptionDeserializer().deserialize(context, wrappedCall)
        "RateExceededException" -> RateExceededExceptionDeserializer().deserialize(context, wrappedCall)
        "BadRequestException" -> BadRequestExceptionDeserializer().deserialize(context, wrappedCall)
        "LimitExceededException" -> LimitExceededExceptionDeserializer().deserialize(context, wrappedCall)
        else -> QldbSessionException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeSendCommandOperationBody(builder: SendCommandResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ABORTTRANSACTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("AbortTransaction"))
    val COMMITTRANSACTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("CommitTransaction"))
    val ENDSESSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("EndSession"))
    val EXECUTESTATEMENT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("ExecuteStatement"))
    val FETCHPAGE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("FetchPage"))
    val STARTSESSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("StartSession"))
    val STARTTRANSACTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("StartTransaction"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ABORTTRANSACTION_DESCRIPTOR)
        field(COMMITTRANSACTION_DESCRIPTOR)
        field(ENDSESSION_DESCRIPTOR)
        field(EXECUTESTATEMENT_DESCRIPTOR)
        field(FETCHPAGE_DESCRIPTOR)
        field(STARTSESSION_DESCRIPTOR)
        field(STARTTRANSACTION_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ABORTTRANSACTION_DESCRIPTOR.index -> builder.abortTransaction = deserializeAbortTransactionResultDocument(deserializer)
                COMMITTRANSACTION_DESCRIPTOR.index -> builder.commitTransaction = deserializeCommitTransactionResultDocument(deserializer)
                ENDSESSION_DESCRIPTOR.index -> builder.endSession = deserializeEndSessionResultDocument(deserializer)
                EXECUTESTATEMENT_DESCRIPTOR.index -> builder.executeStatement = deserializeExecuteStatementResultDocument(deserializer)
                FETCHPAGE_DESCRIPTOR.index -> builder.fetchPage = deserializeFetchPageResultDocument(deserializer)
                STARTSESSION_DESCRIPTOR.index -> builder.startSession = deserializeStartSessionResultDocument(deserializer)
                STARTTRANSACTION_DESCRIPTOR.index -> builder.startTransaction = deserializeStartTransactionResultDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
