// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.qldbsession.model



/**
 * Contains the details of the transaction to commit.
 */
public class CommitTransactionRequest private constructor(builder: Builder) {
    /**
     * Specifies the commit digest for the transaction to commit. For every active transaction, the commit digest must be passed. QLDB validates `CommitDigest` and rejects the commit with an error if the digest computed on the client does not match the digest computed by QLDB.
     *
     * The purpose of the `CommitDigest` parameter is to ensure that QLDB commits a transaction if and only if the server has processed the exact set of statements sent by the client, in the same order that client sent them, and with no duplicates.
     */
    public val commitDigest: kotlin.ByteArray = requireNotNull(builder.commitDigest) { "A non-null value must be provided for commitDigest" }
    /**
     * Specifies the transaction ID of the transaction to commit.
     */
    public val transactionId: kotlin.String = requireNotNull(builder.transactionId) { "A non-null value must be provided for transactionId" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.qldbsession.model.CommitTransactionRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CommitTransactionRequest(")
        append("commitDigest=$commitDigest,")
        append("transactionId=$transactionId")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = commitDigest.contentHashCode()
        result = 31 * result + (transactionId.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CommitTransactionRequest

        if (commitDigest != null) {
            if (other.commitDigest == null) return false
            if (!commitDigest.contentEquals(other.commitDigest)) return false
        } else if (other.commitDigest != null) return false
        if (transactionId != other.transactionId) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.qldbsession.model.CommitTransactionRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Specifies the commit digest for the transaction to commit. For every active transaction, the commit digest must be passed. QLDB validates `CommitDigest` and rejects the commit with an error if the digest computed on the client does not match the digest computed by QLDB.
         *
         * The purpose of the `CommitDigest` parameter is to ensure that QLDB commits a transaction if and only if the server has processed the exact set of statements sent by the client, in the same order that client sent them, and with no duplicates.
         */
        public var commitDigest: kotlin.ByteArray? = null
        /**
         * Specifies the transaction ID of the transaction to commit.
         */
        public var transactionId: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.qldbsession.model.CommitTransactionRequest) : this() {
            this.commitDigest = x.commitDigest
            this.transactionId = x.transactionId
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.qldbsession.model.CommitTransactionRequest = CommitTransactionRequest(this)

        internal fun correctErrors(): Builder {
            if (commitDigest == null) commitDigest = ByteArray(0)
            if (transactionId == null) transactionId = ""
            return this
        }
    }
}
