// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.qldb.transform

import aws.sdk.kotlin.runtime.UnknownServiceErrorException
import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.qldb.model.GetRevisionResponse
import aws.sdk.kotlin.services.qldb.model.QldbException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class GetRevisionOperationDeserializer: HttpDeserialize<GetRevisionResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GetRevisionResponse {
        if (!response.status.isSuccess()) {
            throwGetRevisionError(context, response)
        }
        val builder = GetRevisionResponse.builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetRevisionOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun deserializeGetRevisionOperationBody(builder: GetRevisionResponse.DslBuilder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val PROOF_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("Proof"))
    val REVISION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("Revision"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(PROOF_DESCRIPTOR)
        field(REVISION_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                PROOF_DESCRIPTOR.index -> builder.proof = deserializeValueHolderDocument(deserializer)
                REVISION_DESCRIPTOR.index -> builder.revision = deserializeValueHolderDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}

private suspend fun throwGetRevisionError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw UnknownServiceErrorException("failed to parse response as restJson1 error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val modeledExceptionDeserializer = when(errorDetails.code) {
        "InvalidParameterException" -> InvalidParameterExceptionDeserializer()
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer()
        "ResourcePreconditionNotMetException" -> ResourcePreconditionNotMetExceptionDeserializer()
        else -> throw QldbException(errorDetails.message)
    }

    val modeledException = modeledExceptionDeserializer.deserialize(context, wrappedResponse)
    setAseErrorMetadata(modeledException, wrappedResponse, errorDetails)
    throw modeledException
}
