// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.qldb.model



class UpdateLedgerRequest private constructor(builder: BuilderImpl) {
    /**
     * The flag that prevents a ledger from being deleted by any user. If not provided on
     * ledger creation, this feature is enabled (true) by default.
     * If deletion protection is enabled, you must first disable it before you can delete the
     * ledger. You can disable it by calling the UpdateLedger operation to set the flag to false.
     */
    val deletionProtection: Boolean? = builder.deletionProtection
    /**
     * The key in Key Management Service (KMS) to use for encryption of data at rest in the ledger. For
     * more information, see <a href="https://docs.aws.amazon.com/qldb/latest/developerguide/encryption-at-rest.html">Encryption at rest in
     * the Amazon QLDB Developer Guide.
     * Use one of the following options to specify this parameter:
     * AWS_OWNED_KMS_KEY: Use an KMS key that is owned and managed by Amazon Web Services
     * on your behalf.
     * Undefined: Make no changes to the KMS key of the
     * ledger.
     * A valid symmetric customer managed KMS key: Use
     * the specified KMS key in your account that you create, own, and manage.
     * Amazon QLDB does not support asymmetric keys. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/symmetric-asymmetric.html">Using symmetric and asymmetric keys in the Key Management Service Developer
     * Guide.
     * To specify a customer managed KMS key, you can use its key ID, Amazon Resource Name
     * (ARN), alias name, or alias ARN. When using an alias name, prefix it with
     * "alias/". To specify a key in a different account, you must use the key
     * ARN or alias ARN.
     * For example:
     * Key ID: 1234abcd-12ab-34cd-56ef-1234567890ab
     * Key ARN:
     * arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab
     * Alias name: alias/ExampleAlias
     * Alias ARN:
     * arn:aws:kms:us-east-2:111122223333:alias/ExampleAlias
     * For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id">Key identifiers (KeyId) in
     * the Key Management Service Developer Guide.
     */
    val kmsKey: String? = builder.kmsKey
    /**
     * The name of the ledger.
     */
    val name: String? = builder.name

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): UpdateLedgerRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateLedgerRequest(")
        append("deletionProtection=$deletionProtection,")
        append("kmsKey=$kmsKey,")
        append("name=$name)")
    }

    override fun hashCode(): kotlin.Int {
        var result = deletionProtection?.hashCode() ?: 0
        result = 31 * result + (kmsKey?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as UpdateLedgerRequest

        if (deletionProtection != other.deletionProtection) return false
        if (kmsKey != other.kmsKey) return false
        if (name != other.name) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): UpdateLedgerRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): UpdateLedgerRequest
        /**
         * The flag that prevents a ledger from being deleted by any user. If not provided on
         * ledger creation, this feature is enabled (true) by default.
         * If deletion protection is enabled, you must first disable it before you can delete the
         * ledger. You can disable it by calling the UpdateLedger operation to set the flag to false.
         */
        fun deletionProtection(deletionProtection: Boolean): FluentBuilder
        /**
         * The key in Key Management Service (KMS) to use for encryption of data at rest in the ledger. For
         * more information, see <a href="https://docs.aws.amazon.com/qldb/latest/developerguide/encryption-at-rest.html">Encryption at rest in
         * the Amazon QLDB Developer Guide.
         * Use one of the following options to specify this parameter:
         * AWS_OWNED_KMS_KEY: Use an KMS key that is owned and managed by Amazon Web Services
         * on your behalf.
         * Undefined: Make no changes to the KMS key of the
         * ledger.
         * A valid symmetric customer managed KMS key: Use
         * the specified KMS key in your account that you create, own, and manage.
         * Amazon QLDB does not support asymmetric keys. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/symmetric-asymmetric.html">Using symmetric and asymmetric keys in the Key Management Service Developer
         * Guide.
         * To specify a customer managed KMS key, you can use its key ID, Amazon Resource Name
         * (ARN), alias name, or alias ARN. When using an alias name, prefix it with
         * "alias/". To specify a key in a different account, you must use the key
         * ARN or alias ARN.
         * For example:
         * Key ID: 1234abcd-12ab-34cd-56ef-1234567890ab
         * Key ARN:
         * arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab
         * Alias name: alias/ExampleAlias
         * Alias ARN:
         * arn:aws:kms:us-east-2:111122223333:alias/ExampleAlias
         * For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id">Key identifiers (KeyId) in
         * the Key Management Service Developer Guide.
         */
        fun kmsKey(kmsKey: String): FluentBuilder
        /**
         * The name of the ledger.
         */
        fun name(name: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The flag that prevents a ledger from being deleted by any user. If not provided on
         * ledger creation, this feature is enabled (true) by default.
         * If deletion protection is enabled, you must first disable it before you can delete the
         * ledger. You can disable it by calling the UpdateLedger operation to set the flag to false.
         */
        var deletionProtection: Boolean?
        /**
         * The key in Key Management Service (KMS) to use for encryption of data at rest in the ledger. For
         * more information, see <a href="https://docs.aws.amazon.com/qldb/latest/developerguide/encryption-at-rest.html">Encryption at rest in
         * the Amazon QLDB Developer Guide.
         * Use one of the following options to specify this parameter:
         * AWS_OWNED_KMS_KEY: Use an KMS key that is owned and managed by Amazon Web Services
         * on your behalf.
         * Undefined: Make no changes to the KMS key of the
         * ledger.
         * A valid symmetric customer managed KMS key: Use
         * the specified KMS key in your account that you create, own, and manage.
         * Amazon QLDB does not support asymmetric keys. For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/symmetric-asymmetric.html">Using symmetric and asymmetric keys in the Key Management Service Developer
         * Guide.
         * To specify a customer managed KMS key, you can use its key ID, Amazon Resource Name
         * (ARN), alias name, or alias ARN. When using an alias name, prefix it with
         * "alias/". To specify a key in a different account, you must use the key
         * ARN or alias ARN.
         * For example:
         * Key ID: 1234abcd-12ab-34cd-56ef-1234567890ab
         * Key ARN:
         * arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab
         * Alias name: alias/ExampleAlias
         * Alias ARN:
         * arn:aws:kms:us-east-2:111122223333:alias/ExampleAlias
         * For more information, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id">Key identifiers (KeyId) in
         * the Key Management Service Developer Guide.
         */
        var kmsKey: String?
        /**
         * The name of the ledger.
         */
        var name: String?

        fun build(): UpdateLedgerRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var deletionProtection: Boolean? = null
        override var kmsKey: String? = null
        override var name: String? = null

        constructor(x: UpdateLedgerRequest) : this() {
            this.deletionProtection = x.deletionProtection
            this.kmsKey = x.kmsKey
            this.name = x.name
        }

        override fun build(): UpdateLedgerRequest = UpdateLedgerRequest(this)
        override fun deletionProtection(deletionProtection: Boolean): FluentBuilder = apply { this.deletionProtection = deletionProtection }
        override fun kmsKey(kmsKey: String): FluentBuilder = apply { this.kmsKey = kmsKey }
        override fun name(name: String): FluentBuilder = apply { this.name = name }
    }
}
