// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.qldb.model



class UpdateLedgerPermissionsModeRequest private constructor(builder: BuilderImpl) {
    /**
     * The name of the ledger.
     */
    val name: String? = builder.name
    /**
     * The permissions mode to assign to the ledger. This parameter can have one of the
     * following values:
     * ALLOW_ALL: A legacy permissions mode that enables access control with
     * API-level granularity for ledgers.
     * This mode allows users who have the SendCommand API permission for
     * this ledger to run all PartiQL commands (hence, ALLOW_ALL) on any tables
     * in the specified ledger. This mode disregards any table-level or command-level IAM
     * permissions policies that you create for the ledger.
     * STANDARD: (Recommended) A permissions mode that
     * enables access control with finer granularity for ledgers, tables, and PartiQL
     * commands.
     * By default, this mode denies all user requests to run any PartiQL commands on any
     * tables in this ledger. To allow PartiQL commands to run, you must create IAM
     * permissions policies for specific table resources and PartiQL actions, in addition to
     * the SendCommand API permission for the ledger. For information, see
     * <a href="https://docs.aws.amazon.com/qldb/latest/developerguide/getting-started-standard-mode.html">Getting
     * started with the standard permissions mode in the Amazon QLDB
     * Developer Guide.
     * We strongly recommend using the STANDARD permissions mode to maximize
     * the security of your ledger data.
     */
    val permissionsMode: PermissionsMode? = builder.permissionsMode

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): UpdateLedgerPermissionsModeRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateLedgerPermissionsModeRequest(")
        append("name=$name,")
        append("permissionsMode=$permissionsMode)")
    }

    override fun hashCode(): kotlin.Int {
        var result = name?.hashCode() ?: 0
        result = 31 * result + (permissionsMode?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as UpdateLedgerPermissionsModeRequest

        if (name != other.name) return false
        if (permissionsMode != other.permissionsMode) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): UpdateLedgerPermissionsModeRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): UpdateLedgerPermissionsModeRequest
        /**
         * The name of the ledger.
         */
        fun name(name: String): FluentBuilder
        /**
         * The permissions mode to assign to the ledger. This parameter can have one of the
         * following values:
         * ALLOW_ALL: A legacy permissions mode that enables access control with
         * API-level granularity for ledgers.
         * This mode allows users who have the SendCommand API permission for
         * this ledger to run all PartiQL commands (hence, ALLOW_ALL) on any tables
         * in the specified ledger. This mode disregards any table-level or command-level IAM
         * permissions policies that you create for the ledger.
         * STANDARD: (Recommended) A permissions mode that
         * enables access control with finer granularity for ledgers, tables, and PartiQL
         * commands.
         * By default, this mode denies all user requests to run any PartiQL commands on any
         * tables in this ledger. To allow PartiQL commands to run, you must create IAM
         * permissions policies for specific table resources and PartiQL actions, in addition to
         * the SendCommand API permission for the ledger. For information, see
         * <a href="https://docs.aws.amazon.com/qldb/latest/developerguide/getting-started-standard-mode.html">Getting
         * started with the standard permissions mode in the Amazon QLDB
         * Developer Guide.
         * We strongly recommend using the STANDARD permissions mode to maximize
         * the security of your ledger data.
         */
        fun permissionsMode(permissionsMode: PermissionsMode): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The name of the ledger.
         */
        var name: String?
        /**
         * The permissions mode to assign to the ledger. This parameter can have one of the
         * following values:
         * ALLOW_ALL: A legacy permissions mode that enables access control with
         * API-level granularity for ledgers.
         * This mode allows users who have the SendCommand API permission for
         * this ledger to run all PartiQL commands (hence, ALLOW_ALL) on any tables
         * in the specified ledger. This mode disregards any table-level or command-level IAM
         * permissions policies that you create for the ledger.
         * STANDARD: (Recommended) A permissions mode that
         * enables access control with finer granularity for ledgers, tables, and PartiQL
         * commands.
         * By default, this mode denies all user requests to run any PartiQL commands on any
         * tables in this ledger. To allow PartiQL commands to run, you must create IAM
         * permissions policies for specific table resources and PartiQL actions, in addition to
         * the SendCommand API permission for the ledger. For information, see
         * <a href="https://docs.aws.amazon.com/qldb/latest/developerguide/getting-started-standard-mode.html">Getting
         * started with the standard permissions mode in the Amazon QLDB
         * Developer Guide.
         * We strongly recommend using the STANDARD permissions mode to maximize
         * the security of your ledger data.
         */
        var permissionsMode: PermissionsMode?

        fun build(): UpdateLedgerPermissionsModeRequest
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var name: String? = null
        override var permissionsMode: PermissionsMode? = null

        constructor(x: UpdateLedgerPermissionsModeRequest) : this() {
            this.name = x.name
            this.permissionsMode = x.permissionsMode
        }

        override fun build(): UpdateLedgerPermissionsModeRequest = UpdateLedgerPermissionsModeRequest(this)
        override fun name(name: String): FluentBuilder = apply { this.name = name }
        override fun permissionsMode(permissionsMode: PermissionsMode): FluentBuilder = apply { this.permissionsMode = permissionsMode }
    }
}
