// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.qldb.model

import aws.smithy.kotlin.runtime.time.Instant

class StreamJournalToKinesisRequest private constructor(builder: BuilderImpl) {
    /**
     * The exclusive date and time that specifies when the stream ends. If you don't define
     * this parameter, the stream runs indefinitely until you cancel it.
     * The ExclusiveEndTime must be in ISO 8601 date and time format
     * and in Universal Coordinated Time (UTC). For example:
     * 2019-06-13T21:36:34Z.
     */
    val exclusiveEndTime: Instant? = builder.exclusiveEndTime
    /**
     * The inclusive start date and time from which to start streaming journal data. This
     * parameter must be in ISO 8601 date and time format and in Universal
     * Coordinated Time (UTC). For example: 2019-06-13T21:36:34Z.
     * The InclusiveStartTime cannot be in the future and must be before
     * ExclusiveEndTime.
     * If you provide an InclusiveStartTime that is before the ledger's
     * CreationDateTime, QLDB effectively defaults it to the ledger's
     * CreationDateTime.
     */
    val inclusiveStartTime: Instant? = builder.inclusiveStartTime
    /**
     * The configuration settings of the Kinesis Data Streams destination for your stream request.
     */
    val kinesisConfiguration: KinesisConfiguration? = builder.kinesisConfiguration
    /**
     * The name of the ledger.
     */
    val ledgerName: String? = builder.ledgerName
    /**
     * The Amazon Resource Name (ARN) of the IAM role that grants QLDB permissions for a
     * journal stream to write data records to a Kinesis Data Streams resource.
     */
    val roleArn: String? = builder.roleArn
    /**
     * The name that you want to assign to the QLDB journal stream. User-defined names can
     * help identify and indicate the purpose of a stream.
     * Your stream name must be unique among other active streams for a
     * given ledger. Stream names have the same naming constraints as ledger names, as defined in
     * <a href="https://docs.aws.amazon.com/qldb/latest/developerguide/limits.html#limits.naming">Quotas in Amazon QLDB in the Amazon QLDB Developer
     * Guide.
     */
    val streamName: String? = builder.streamName
    /**
     * The key-value pairs to add as tags to the stream that you want to create. Tag keys are
     * case sensitive. Tag values are case sensitive and can be null.
     */
    val tags: Map<String, String?>? = builder.tags

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): StreamJournalToKinesisRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("StreamJournalToKinesisRequest(")
        append("exclusiveEndTime=$exclusiveEndTime,")
        append("inclusiveStartTime=$inclusiveStartTime,")
        append("kinesisConfiguration=$kinesisConfiguration,")
        append("ledgerName=$ledgerName,")
        append("roleArn=$roleArn,")
        append("streamName=$streamName,")
        append("tags=$tags)")
    }

    override fun hashCode(): kotlin.Int {
        var result = exclusiveEndTime?.hashCode() ?: 0
        result = 31 * result + (inclusiveStartTime?.hashCode() ?: 0)
        result = 31 * result + (kinesisConfiguration?.hashCode() ?: 0)
        result = 31 * result + (ledgerName?.hashCode() ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        result = 31 * result + (streamName?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as StreamJournalToKinesisRequest

        if (exclusiveEndTime != other.exclusiveEndTime) return false
        if (inclusiveStartTime != other.inclusiveStartTime) return false
        if (kinesisConfiguration != other.kinesisConfiguration) return false
        if (ledgerName != other.ledgerName) return false
        if (roleArn != other.roleArn) return false
        if (streamName != other.streamName) return false
        if (tags != other.tags) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): StreamJournalToKinesisRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): StreamJournalToKinesisRequest
        /**
         * The exclusive date and time that specifies when the stream ends. If you don't define
         * this parameter, the stream runs indefinitely until you cancel it.
         * The ExclusiveEndTime must be in ISO 8601 date and time format
         * and in Universal Coordinated Time (UTC). For example:
         * 2019-06-13T21:36:34Z.
         */
        fun exclusiveEndTime(exclusiveEndTime: Instant): FluentBuilder
        /**
         * The inclusive start date and time from which to start streaming journal data. This
         * parameter must be in ISO 8601 date and time format and in Universal
         * Coordinated Time (UTC). For example: 2019-06-13T21:36:34Z.
         * The InclusiveStartTime cannot be in the future and must be before
         * ExclusiveEndTime.
         * If you provide an InclusiveStartTime that is before the ledger's
         * CreationDateTime, QLDB effectively defaults it to the ledger's
         * CreationDateTime.
         */
        fun inclusiveStartTime(inclusiveStartTime: Instant): FluentBuilder
        /**
         * The configuration settings of the Kinesis Data Streams destination for your stream request.
         */
        fun kinesisConfiguration(kinesisConfiguration: KinesisConfiguration): FluentBuilder
        /**
         * The name of the ledger.
         */
        fun ledgerName(ledgerName: String): FluentBuilder
        /**
         * The Amazon Resource Name (ARN) of the IAM role that grants QLDB permissions for a
         * journal stream to write data records to a Kinesis Data Streams resource.
         */
        fun roleArn(roleArn: String): FluentBuilder
        /**
         * The name that you want to assign to the QLDB journal stream. User-defined names can
         * help identify and indicate the purpose of a stream.
         * Your stream name must be unique among other active streams for a
         * given ledger. Stream names have the same naming constraints as ledger names, as defined in
         * <a href="https://docs.aws.amazon.com/qldb/latest/developerguide/limits.html#limits.naming">Quotas in Amazon QLDB in the Amazon QLDB Developer
         * Guide.
         */
        fun streamName(streamName: String): FluentBuilder
        /**
         * The key-value pairs to add as tags to the stream that you want to create. Tag keys are
         * case sensitive. Tag values are case sensitive and can be null.
         */
        fun tags(tags: Map<String, String?>): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The exclusive date and time that specifies when the stream ends. If you don't define
         * this parameter, the stream runs indefinitely until you cancel it.
         * The ExclusiveEndTime must be in ISO 8601 date and time format
         * and in Universal Coordinated Time (UTC). For example:
         * 2019-06-13T21:36:34Z.
         */
        var exclusiveEndTime: Instant?
        /**
         * The inclusive start date and time from which to start streaming journal data. This
         * parameter must be in ISO 8601 date and time format and in Universal
         * Coordinated Time (UTC). For example: 2019-06-13T21:36:34Z.
         * The InclusiveStartTime cannot be in the future and must be before
         * ExclusiveEndTime.
         * If you provide an InclusiveStartTime that is before the ledger's
         * CreationDateTime, QLDB effectively defaults it to the ledger's
         * CreationDateTime.
         */
        var inclusiveStartTime: Instant?
        /**
         * The configuration settings of the Kinesis Data Streams destination for your stream request.
         */
        var kinesisConfiguration: KinesisConfiguration?
        /**
         * The name of the ledger.
         */
        var ledgerName: String?
        /**
         * The Amazon Resource Name (ARN) of the IAM role that grants QLDB permissions for a
         * journal stream to write data records to a Kinesis Data Streams resource.
         */
        var roleArn: String?
        /**
         * The name that you want to assign to the QLDB journal stream. User-defined names can
         * help identify and indicate the purpose of a stream.
         * Your stream name must be unique among other active streams for a
         * given ledger. Stream names have the same naming constraints as ledger names, as defined in
         * <a href="https://docs.aws.amazon.com/qldb/latest/developerguide/limits.html#limits.naming">Quotas in Amazon QLDB in the Amazon QLDB Developer
         * Guide.
         */
        var streamName: String?
        /**
         * The key-value pairs to add as tags to the stream that you want to create. Tag keys are
         * case sensitive. Tag values are case sensitive and can be null.
         */
        var tags: Map<String, String?>?

        fun build(): StreamJournalToKinesisRequest
        /**
         * construct an [aws.sdk.kotlin.services.qldb.model.KinesisConfiguration] inside the given [block]
         */
        fun kinesisConfiguration(block: KinesisConfiguration.DslBuilder.() -> kotlin.Unit) {
            this.kinesisConfiguration = KinesisConfiguration.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var exclusiveEndTime: Instant? = null
        override var inclusiveStartTime: Instant? = null
        override var kinesisConfiguration: KinesisConfiguration? = null
        override var ledgerName: String? = null
        override var roleArn: String? = null
        override var streamName: String? = null
        override var tags: Map<String, String?>? = null

        constructor(x: StreamJournalToKinesisRequest) : this() {
            this.exclusiveEndTime = x.exclusiveEndTime
            this.inclusiveStartTime = x.inclusiveStartTime
            this.kinesisConfiguration = x.kinesisConfiguration
            this.ledgerName = x.ledgerName
            this.roleArn = x.roleArn
            this.streamName = x.streamName
            this.tags = x.tags
        }

        override fun build(): StreamJournalToKinesisRequest = StreamJournalToKinesisRequest(this)
        override fun exclusiveEndTime(exclusiveEndTime: Instant): FluentBuilder = apply { this.exclusiveEndTime = exclusiveEndTime }
        override fun inclusiveStartTime(inclusiveStartTime: Instant): FluentBuilder = apply { this.inclusiveStartTime = inclusiveStartTime }
        override fun kinesisConfiguration(kinesisConfiguration: KinesisConfiguration): FluentBuilder = apply { this.kinesisConfiguration = kinesisConfiguration }
        override fun ledgerName(ledgerName: String): FluentBuilder = apply { this.ledgerName = ledgerName }
        override fun roleArn(roleArn: String): FluentBuilder = apply { this.roleArn = roleArn }
        override fun streamName(streamName: String): FluentBuilder = apply { this.streamName = streamName }
        override fun tags(tags: Map<String, String?>): FluentBuilder = apply { this.tags = tags }
    }
}
