// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.qldb.model



/**
 * The Amazon Simple Storage Service (Amazon S3) bucket location in which a journal export job writes the journal
 * contents.
 */
class S3ExportConfiguration private constructor(builder: BuilderImpl) {
    /**
     * The Amazon S3 bucket name in which a journal export job writes the journal contents.
     * The bucket name must comply with the Amazon S3 bucket naming conventions. For more
     * information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/BucketRestrictions.html">Bucket Restrictions and
     * Limitations in the Amazon S3 Developer Guide.
     */
    val bucket: String? = builder.bucket
    /**
     * The encryption settings that are used by a journal export job to write data in an Amazon S3
     * bucket.
     */
    val encryptionConfiguration: S3EncryptionConfiguration? = builder.encryptionConfiguration
    /**
     * The prefix for the Amazon S3 bucket in which a journal export job writes the journal
     * contents.
     * The prefix must comply with Amazon S3 key naming rules and restrictions. For more
     * information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingMetadata.html">Object Key and Metadata in the Amazon S3 Developer
     * Guide.
     * The following are examples of valid Prefix values:
     * JournalExports-ForMyLedger/Testing/
     * JournalExports
     * My:Tests/
     */
    val prefix: String? = builder.prefix

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): S3ExportConfiguration = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("S3ExportConfiguration(")
        append("bucket=$bucket,")
        append("encryptionConfiguration=$encryptionConfiguration,")
        append("prefix=$prefix)")
    }

    override fun hashCode(): kotlin.Int {
        var result = bucket?.hashCode() ?: 0
        result = 31 * result + (encryptionConfiguration?.hashCode() ?: 0)
        result = 31 * result + (prefix?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as S3ExportConfiguration

        if (bucket != other.bucket) return false
        if (encryptionConfiguration != other.encryptionConfiguration) return false
        if (prefix != other.prefix) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): S3ExportConfiguration = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): S3ExportConfiguration
        /**
         * The Amazon S3 bucket name in which a journal export job writes the journal contents.
         * The bucket name must comply with the Amazon S3 bucket naming conventions. For more
         * information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/BucketRestrictions.html">Bucket Restrictions and
         * Limitations in the Amazon S3 Developer Guide.
         */
        fun bucket(bucket: String): FluentBuilder
        /**
         * The encryption settings that are used by a journal export job to write data in an Amazon S3
         * bucket.
         */
        fun encryptionConfiguration(encryptionConfiguration: S3EncryptionConfiguration): FluentBuilder
        /**
         * The prefix for the Amazon S3 bucket in which a journal export job writes the journal
         * contents.
         * The prefix must comply with Amazon S3 key naming rules and restrictions. For more
         * information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingMetadata.html">Object Key and Metadata in the Amazon S3 Developer
         * Guide.
         * The following are examples of valid Prefix values:
         * JournalExports-ForMyLedger/Testing/
         * JournalExports
         * My:Tests/
         */
        fun prefix(prefix: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The Amazon S3 bucket name in which a journal export job writes the journal contents.
         * The bucket name must comply with the Amazon S3 bucket naming conventions. For more
         * information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/BucketRestrictions.html">Bucket Restrictions and
         * Limitations in the Amazon S3 Developer Guide.
         */
        var bucket: String?
        /**
         * The encryption settings that are used by a journal export job to write data in an Amazon S3
         * bucket.
         */
        var encryptionConfiguration: S3EncryptionConfiguration?
        /**
         * The prefix for the Amazon S3 bucket in which a journal export job writes the journal
         * contents.
         * The prefix must comply with Amazon S3 key naming rules and restrictions. For more
         * information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingMetadata.html">Object Key and Metadata in the Amazon S3 Developer
         * Guide.
         * The following are examples of valid Prefix values:
         * JournalExports-ForMyLedger/Testing/
         * JournalExports
         * My:Tests/
         */
        var prefix: String?

        fun build(): S3ExportConfiguration
        /**
         * construct an [aws.sdk.kotlin.services.qldb.model.S3EncryptionConfiguration] inside the given [block]
         */
        fun encryptionConfiguration(block: S3EncryptionConfiguration.DslBuilder.() -> kotlin.Unit) {
            this.encryptionConfiguration = S3EncryptionConfiguration.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var bucket: String? = null
        override var encryptionConfiguration: S3EncryptionConfiguration? = null
        override var prefix: String? = null

        constructor(x: S3ExportConfiguration) : this() {
            this.bucket = x.bucket
            this.encryptionConfiguration = x.encryptionConfiguration
            this.prefix = x.prefix
        }

        override fun build(): S3ExportConfiguration = S3ExportConfiguration(this)
        override fun bucket(bucket: String): FluentBuilder = apply { this.bucket = bucket }
        override fun encryptionConfiguration(encryptionConfiguration: S3EncryptionConfiguration): FluentBuilder = apply { this.encryptionConfiguration = encryptionConfiguration }
        override fun prefix(prefix: String): FluentBuilder = apply { this.prefix = prefix }
    }
}
