// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.qldb.model



/**
 * The encryption settings that are used by a journal export job to write data in an
 * Amazon Simple Storage Service (Amazon S3) bucket.
 */
class S3EncryptionConfiguration private constructor(builder: BuilderImpl) {
    /**
     * The Amazon Resource Name (ARN) of a symmetric customer master key (CMK) in Key Management Service
     * (KMS). Amazon S3 does not support asymmetric CMKs.
     * You must provide a KmsKeyArn if you specify SSE_KMS as the
     * ObjectEncryptionType.
     * KmsKeyArn is not required if you specify SSE_S3 as the
     * ObjectEncryptionType.
     */
    val kmsKeyArn: String? = builder.kmsKeyArn
    /**
     * The Amazon S3 object encryption type.
     * To learn more about server-side encryption options in Amazon S3, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/serv-side-encryption.html">Protecting Data
     * Using Server-Side Encryption in the Amazon S3 Developer
     * Guide.
     */
    val objectEncryptionType: S3ObjectEncryptionType? = builder.objectEncryptionType

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): S3EncryptionConfiguration = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("S3EncryptionConfiguration(")
        append("kmsKeyArn=$kmsKeyArn,")
        append("objectEncryptionType=$objectEncryptionType)")
    }

    override fun hashCode(): kotlin.Int {
        var result = kmsKeyArn?.hashCode() ?: 0
        result = 31 * result + (objectEncryptionType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as S3EncryptionConfiguration

        if (kmsKeyArn != other.kmsKeyArn) return false
        if (objectEncryptionType != other.objectEncryptionType) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): S3EncryptionConfiguration = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): S3EncryptionConfiguration
        /**
         * The Amazon Resource Name (ARN) of a symmetric customer master key (CMK) in Key Management Service
         * (KMS). Amazon S3 does not support asymmetric CMKs.
         * You must provide a KmsKeyArn if you specify SSE_KMS as the
         * ObjectEncryptionType.
         * KmsKeyArn is not required if you specify SSE_S3 as the
         * ObjectEncryptionType.
         */
        fun kmsKeyArn(kmsKeyArn: String): FluentBuilder
        /**
         * The Amazon S3 object encryption type.
         * To learn more about server-side encryption options in Amazon S3, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/serv-side-encryption.html">Protecting Data
         * Using Server-Side Encryption in the Amazon S3 Developer
         * Guide.
         */
        fun objectEncryptionType(objectEncryptionType: S3ObjectEncryptionType): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The Amazon Resource Name (ARN) of a symmetric customer master key (CMK) in Key Management Service
         * (KMS). Amazon S3 does not support asymmetric CMKs.
         * You must provide a KmsKeyArn if you specify SSE_KMS as the
         * ObjectEncryptionType.
         * KmsKeyArn is not required if you specify SSE_S3 as the
         * ObjectEncryptionType.
         */
        var kmsKeyArn: String?
        /**
         * The Amazon S3 object encryption type.
         * To learn more about server-side encryption options in Amazon S3, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/dev/serv-side-encryption.html">Protecting Data
         * Using Server-Side Encryption in the Amazon S3 Developer
         * Guide.
         */
        var objectEncryptionType: S3ObjectEncryptionType?

        fun build(): S3EncryptionConfiguration
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var kmsKeyArn: String? = null
        override var objectEncryptionType: S3ObjectEncryptionType? = null

        constructor(x: S3EncryptionConfiguration) : this() {
            this.kmsKeyArn = x.kmsKeyArn
            this.objectEncryptionType = x.objectEncryptionType
        }

        override fun build(): S3EncryptionConfiguration = S3EncryptionConfiguration(this)
        override fun kmsKeyArn(kmsKeyArn: String): FluentBuilder = apply { this.kmsKeyArn = kmsKeyArn }
        override fun objectEncryptionType(objectEncryptionType: S3ObjectEncryptionType): FluentBuilder = apply { this.objectEncryptionType = objectEncryptionType }
    }
}
