// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.qldb.model



/**
 * The configuration settings of the Amazon Kinesis Data Streams destination for an Amazon QLDB journal
 * stream.
 */
class KinesisConfiguration private constructor(builder: BuilderImpl) {
    /**
     * Enables QLDB to publish multiple data records in a single Kinesis Data Streams record, increasing the
     * number of records sent per API call.
     * This option is enabled by default. Record aggregation has important
     * implications for processing records and requires de-aggregation in your stream consumer. To
     * learn more, see <a href="https://docs.aws.amazon.com/streams/latest/dev/kinesis-kpl-concepts.html">KPL Key Concepts and <a href="https://docs.aws.amazon.com/streams/latest/dev/kinesis-kpl-consumer-deaggregation.html">Consumer De-aggregation in the Amazon Kinesis Data Streams Developer
     * Guide.
     */
    val aggregationEnabled: Boolean? = builder.aggregationEnabled
    /**
     * The Amazon Resource Name (ARN) of the Kinesis Data Streams resource.
     */
    val streamArn: String? = builder.streamArn

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): KinesisConfiguration = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("KinesisConfiguration(")
        append("aggregationEnabled=$aggregationEnabled,")
        append("streamArn=$streamArn)")
    }

    override fun hashCode(): kotlin.Int {
        var result = aggregationEnabled?.hashCode() ?: 0
        result = 31 * result + (streamArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as KinesisConfiguration

        if (aggregationEnabled != other.aggregationEnabled) return false
        if (streamArn != other.streamArn) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): KinesisConfiguration = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): KinesisConfiguration
        /**
         * Enables QLDB to publish multiple data records in a single Kinesis Data Streams record, increasing the
         * number of records sent per API call.
         * This option is enabled by default. Record aggregation has important
         * implications for processing records and requires de-aggregation in your stream consumer. To
         * learn more, see <a href="https://docs.aws.amazon.com/streams/latest/dev/kinesis-kpl-concepts.html">KPL Key Concepts and <a href="https://docs.aws.amazon.com/streams/latest/dev/kinesis-kpl-consumer-deaggregation.html">Consumer De-aggregation in the Amazon Kinesis Data Streams Developer
         * Guide.
         */
        fun aggregationEnabled(aggregationEnabled: Boolean): FluentBuilder
        /**
         * The Amazon Resource Name (ARN) of the Kinesis Data Streams resource.
         */
        fun streamArn(streamArn: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * Enables QLDB to publish multiple data records in a single Kinesis Data Streams record, increasing the
         * number of records sent per API call.
         * This option is enabled by default. Record aggregation has important
         * implications for processing records and requires de-aggregation in your stream consumer. To
         * learn more, see <a href="https://docs.aws.amazon.com/streams/latest/dev/kinesis-kpl-concepts.html">KPL Key Concepts and <a href="https://docs.aws.amazon.com/streams/latest/dev/kinesis-kpl-consumer-deaggregation.html">Consumer De-aggregation in the Amazon Kinesis Data Streams Developer
         * Guide.
         */
        var aggregationEnabled: Boolean?
        /**
         * The Amazon Resource Name (ARN) of the Kinesis Data Streams resource.
         */
        var streamArn: String?

        fun build(): KinesisConfiguration
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var aggregationEnabled: Boolean? = null
        override var streamArn: String? = null

        constructor(x: KinesisConfiguration) : this() {
            this.aggregationEnabled = x.aggregationEnabled
            this.streamArn = x.streamArn
        }

        override fun build(): KinesisConfiguration = KinesisConfiguration(this)
        override fun aggregationEnabled(aggregationEnabled: Boolean): FluentBuilder = apply { this.aggregationEnabled = aggregationEnabled }
        override fun streamArn(streamArn: String): FluentBuilder = apply { this.streamArn = streamArn }
    }
}
