// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.qldb.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Information about a journal export job, including the ledger name, export ID, creation
 * time, current status, and the parameters of the original export creation request.
 */
class JournalS3ExportDescription private constructor(builder: BuilderImpl) {
    /**
     * The exclusive end date and time for the range of journal contents that are specified in
     * the original export request.
     */
    val exclusiveEndTime: Instant? = builder.exclusiveEndTime
    /**
     * The date and time, in epoch time format, when the export job was created. (Epoch time
     * format is the number of seconds elapsed since 12:00:00 AM January 1, 1970 UTC.)
     */
    val exportCreationTime: Instant? = builder.exportCreationTime
    /**
     * The UUID (represented in Base62-encoded text) of the journal export job.
     */
    val exportId: String? = builder.exportId
    /**
     * The inclusive start date and time for the range of journal contents that are specified
     * in the original export request.
     */
    val inclusiveStartTime: Instant? = builder.inclusiveStartTime
    /**
     * The name of the ledger.
     */
    val ledgerName: String? = builder.ledgerName
    /**
     * The Amazon Resource Name (ARN) of the IAM role that grants QLDB permissions for a
     * journal export job to do the following:
     * Write objects into your Amazon Simple Storage Service (Amazon S3) bucket.
     * (Optional) Use your customer master key (CMK) in Key Management Service (KMS) for server-side
     * encryption of your exported data.
     */
    val roleArn: String? = builder.roleArn
    /**
     * The Amazon Simple Storage Service (Amazon S3) bucket location in which a journal export job writes the journal
     * contents.
     */
    val s3ExportConfiguration: S3ExportConfiguration? = builder.s3ExportConfiguration
    /**
     * The current state of the journal export job.
     */
    val status: ExportStatus? = builder.status

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): JournalS3ExportDescription = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("JournalS3ExportDescription(")
        append("exclusiveEndTime=$exclusiveEndTime,")
        append("exportCreationTime=$exportCreationTime,")
        append("exportId=$exportId,")
        append("inclusiveStartTime=$inclusiveStartTime,")
        append("ledgerName=$ledgerName,")
        append("roleArn=$roleArn,")
        append("s3ExportConfiguration=$s3ExportConfiguration,")
        append("status=$status)")
    }

    override fun hashCode(): kotlin.Int {
        var result = exclusiveEndTime?.hashCode() ?: 0
        result = 31 * result + (exportCreationTime?.hashCode() ?: 0)
        result = 31 * result + (exportId?.hashCode() ?: 0)
        result = 31 * result + (inclusiveStartTime?.hashCode() ?: 0)
        result = 31 * result + (ledgerName?.hashCode() ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        result = 31 * result + (s3ExportConfiguration?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as JournalS3ExportDescription

        if (exclusiveEndTime != other.exclusiveEndTime) return false
        if (exportCreationTime != other.exportCreationTime) return false
        if (exportId != other.exportId) return false
        if (inclusiveStartTime != other.inclusiveStartTime) return false
        if (ledgerName != other.ledgerName) return false
        if (roleArn != other.roleArn) return false
        if (s3ExportConfiguration != other.s3ExportConfiguration) return false
        if (status != other.status) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): JournalS3ExportDescription = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): JournalS3ExportDescription
        /**
         * The exclusive end date and time for the range of journal contents that are specified in
         * the original export request.
         */
        fun exclusiveEndTime(exclusiveEndTime: Instant): FluentBuilder
        /**
         * The date and time, in epoch time format, when the export job was created. (Epoch time
         * format is the number of seconds elapsed since 12:00:00 AM January 1, 1970 UTC.)
         */
        fun exportCreationTime(exportCreationTime: Instant): FluentBuilder
        /**
         * The UUID (represented in Base62-encoded text) of the journal export job.
         */
        fun exportId(exportId: String): FluentBuilder
        /**
         * The inclusive start date and time for the range of journal contents that are specified
         * in the original export request.
         */
        fun inclusiveStartTime(inclusiveStartTime: Instant): FluentBuilder
        /**
         * The name of the ledger.
         */
        fun ledgerName(ledgerName: String): FluentBuilder
        /**
         * The Amazon Resource Name (ARN) of the IAM role that grants QLDB permissions for a
         * journal export job to do the following:
         * Write objects into your Amazon Simple Storage Service (Amazon S3) bucket.
         * (Optional) Use your customer master key (CMK) in Key Management Service (KMS) for server-side
         * encryption of your exported data.
         */
        fun roleArn(roleArn: String): FluentBuilder
        /**
         * The Amazon Simple Storage Service (Amazon S3) bucket location in which a journal export job writes the journal
         * contents.
         */
        fun s3ExportConfiguration(s3ExportConfiguration: S3ExportConfiguration): FluentBuilder
        /**
         * The current state of the journal export job.
         */
        fun status(status: ExportStatus): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The exclusive end date and time for the range of journal contents that are specified in
         * the original export request.
         */
        var exclusiveEndTime: Instant?
        /**
         * The date and time, in epoch time format, when the export job was created. (Epoch time
         * format is the number of seconds elapsed since 12:00:00 AM January 1, 1970 UTC.)
         */
        var exportCreationTime: Instant?
        /**
         * The UUID (represented in Base62-encoded text) of the journal export job.
         */
        var exportId: String?
        /**
         * The inclusive start date and time for the range of journal contents that are specified
         * in the original export request.
         */
        var inclusiveStartTime: Instant?
        /**
         * The name of the ledger.
         */
        var ledgerName: String?
        /**
         * The Amazon Resource Name (ARN) of the IAM role that grants QLDB permissions for a
         * journal export job to do the following:
         * Write objects into your Amazon Simple Storage Service (Amazon S3) bucket.
         * (Optional) Use your customer master key (CMK) in Key Management Service (KMS) for server-side
         * encryption of your exported data.
         */
        var roleArn: String?
        /**
         * The Amazon Simple Storage Service (Amazon S3) bucket location in which a journal export job writes the journal
         * contents.
         */
        var s3ExportConfiguration: S3ExportConfiguration?
        /**
         * The current state of the journal export job.
         */
        var status: ExportStatus?

        fun build(): JournalS3ExportDescription
        /**
         * construct an [aws.sdk.kotlin.services.qldb.model.S3ExportConfiguration] inside the given [block]
         */
        fun s3ExportConfiguration(block: S3ExportConfiguration.DslBuilder.() -> kotlin.Unit) {
            this.s3ExportConfiguration = S3ExportConfiguration.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var exclusiveEndTime: Instant? = null
        override var exportCreationTime: Instant? = null
        override var exportId: String? = null
        override var inclusiveStartTime: Instant? = null
        override var ledgerName: String? = null
        override var roleArn: String? = null
        override var s3ExportConfiguration: S3ExportConfiguration? = null
        override var status: ExportStatus? = null

        constructor(x: JournalS3ExportDescription) : this() {
            this.exclusiveEndTime = x.exclusiveEndTime
            this.exportCreationTime = x.exportCreationTime
            this.exportId = x.exportId
            this.inclusiveStartTime = x.inclusiveStartTime
            this.ledgerName = x.ledgerName
            this.roleArn = x.roleArn
            this.s3ExportConfiguration = x.s3ExportConfiguration
            this.status = x.status
        }

        override fun build(): JournalS3ExportDescription = JournalS3ExportDescription(this)
        override fun exclusiveEndTime(exclusiveEndTime: Instant): FluentBuilder = apply { this.exclusiveEndTime = exclusiveEndTime }
        override fun exportCreationTime(exportCreationTime: Instant): FluentBuilder = apply { this.exportCreationTime = exportCreationTime }
        override fun exportId(exportId: String): FluentBuilder = apply { this.exportId = exportId }
        override fun inclusiveStartTime(inclusiveStartTime: Instant): FluentBuilder = apply { this.inclusiveStartTime = inclusiveStartTime }
        override fun ledgerName(ledgerName: String): FluentBuilder = apply { this.ledgerName = ledgerName }
        override fun roleArn(roleArn: String): FluentBuilder = apply { this.roleArn = roleArn }
        override fun s3ExportConfiguration(s3ExportConfiguration: S3ExportConfiguration): FluentBuilder = apply { this.s3ExportConfiguration = s3ExportConfiguration }
        override fun status(status: ExportStatus): FluentBuilder = apply { this.status = status }
    }
}
