// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.qldb.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Information about an Amazon QLDB journal stream, including the Amazon Resource Name
 * (ARN), stream name, creation time, current status, and the parameters of the original
 * stream creation request.
 */
class JournalKinesisStreamDescription private constructor(builder: BuilderImpl) {
    /**
     * The Amazon Resource Name (ARN) of the QLDB journal stream.
     */
    val arn: String? = builder.arn
    /**
     * The date and time, in epoch time format, when the QLDB journal stream was created.
     * (Epoch time format is the number of seconds elapsed since 12:00:00 AM January 1, 1970
     * UTC.)
     */
    val creationTime: Instant? = builder.creationTime
    /**
     * The error message that describes the reason that a stream has a status of
     * IMPAIRED or FAILED. This is not applicable to streams that
     * have other status values.
     */
    val errorCause: ErrorCause? = builder.errorCause
    /**
     * The exclusive date and time that specifies when the stream ends. If this parameter is
     * undefined, the stream runs indefinitely until you cancel it.
     */
    val exclusiveEndTime: Instant? = builder.exclusiveEndTime
    /**
     * The inclusive start date and time from which to start streaming journal data.
     */
    val inclusiveStartTime: Instant? = builder.inclusiveStartTime
    /**
     * The configuration settings of the Amazon Kinesis Data Streams destination for a QLDB journal
     * stream.
     */
    val kinesisConfiguration: KinesisConfiguration? = builder.kinesisConfiguration
    /**
     * The name of the ledger.
     */
    val ledgerName: String? = builder.ledgerName
    /**
     * The Amazon Resource Name (ARN) of the IAM role that grants QLDB permissions for a
     * journal stream to write data records to a Kinesis Data Streams resource.
     */
    val roleArn: String? = builder.roleArn
    /**
     * The current state of the QLDB journal stream.
     */
    val status: StreamStatus? = builder.status
    /**
     * The UUID (represented in Base62-encoded text) of the QLDB journal stream.
     */
    val streamId: String? = builder.streamId
    /**
     * The user-defined name of the QLDB journal stream.
     */
    val streamName: String? = builder.streamName

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): JournalKinesisStreamDescription = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("JournalKinesisStreamDescription(")
        append("arn=$arn,")
        append("creationTime=$creationTime,")
        append("errorCause=$errorCause,")
        append("exclusiveEndTime=$exclusiveEndTime,")
        append("inclusiveStartTime=$inclusiveStartTime,")
        append("kinesisConfiguration=$kinesisConfiguration,")
        append("ledgerName=$ledgerName,")
        append("roleArn=$roleArn,")
        append("status=$status,")
        append("streamId=$streamId,")
        append("streamName=$streamName)")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (creationTime?.hashCode() ?: 0)
        result = 31 * result + (errorCause?.hashCode() ?: 0)
        result = 31 * result + (exclusiveEndTime?.hashCode() ?: 0)
        result = 31 * result + (inclusiveStartTime?.hashCode() ?: 0)
        result = 31 * result + (kinesisConfiguration?.hashCode() ?: 0)
        result = 31 * result + (ledgerName?.hashCode() ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (streamId?.hashCode() ?: 0)
        result = 31 * result + (streamName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as JournalKinesisStreamDescription

        if (arn != other.arn) return false
        if (creationTime != other.creationTime) return false
        if (errorCause != other.errorCause) return false
        if (exclusiveEndTime != other.exclusiveEndTime) return false
        if (inclusiveStartTime != other.inclusiveStartTime) return false
        if (kinesisConfiguration != other.kinesisConfiguration) return false
        if (ledgerName != other.ledgerName) return false
        if (roleArn != other.roleArn) return false
        if (status != other.status) return false
        if (streamId != other.streamId) return false
        if (streamName != other.streamName) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): JournalKinesisStreamDescription = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): JournalKinesisStreamDescription
        /**
         * The Amazon Resource Name (ARN) of the QLDB journal stream.
         */
        fun arn(arn: String): FluentBuilder
        /**
         * The date and time, in epoch time format, when the QLDB journal stream was created.
         * (Epoch time format is the number of seconds elapsed since 12:00:00 AM January 1, 1970
         * UTC.)
         */
        fun creationTime(creationTime: Instant): FluentBuilder
        /**
         * The error message that describes the reason that a stream has a status of
         * IMPAIRED or FAILED. This is not applicable to streams that
         * have other status values.
         */
        fun errorCause(errorCause: ErrorCause): FluentBuilder
        /**
         * The exclusive date and time that specifies when the stream ends. If this parameter is
         * undefined, the stream runs indefinitely until you cancel it.
         */
        fun exclusiveEndTime(exclusiveEndTime: Instant): FluentBuilder
        /**
         * The inclusive start date and time from which to start streaming journal data.
         */
        fun inclusiveStartTime(inclusiveStartTime: Instant): FluentBuilder
        /**
         * The configuration settings of the Amazon Kinesis Data Streams destination for a QLDB journal
         * stream.
         */
        fun kinesisConfiguration(kinesisConfiguration: KinesisConfiguration): FluentBuilder
        /**
         * The name of the ledger.
         */
        fun ledgerName(ledgerName: String): FluentBuilder
        /**
         * The Amazon Resource Name (ARN) of the IAM role that grants QLDB permissions for a
         * journal stream to write data records to a Kinesis Data Streams resource.
         */
        fun roleArn(roleArn: String): FluentBuilder
        /**
         * The current state of the QLDB journal stream.
         */
        fun status(status: StreamStatus): FluentBuilder
        /**
         * The UUID (represented in Base62-encoded text) of the QLDB journal stream.
         */
        fun streamId(streamId: String): FluentBuilder
        /**
         * The user-defined name of the QLDB journal stream.
         */
        fun streamName(streamName: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The Amazon Resource Name (ARN) of the QLDB journal stream.
         */
        var arn: String?
        /**
         * The date and time, in epoch time format, when the QLDB journal stream was created.
         * (Epoch time format is the number of seconds elapsed since 12:00:00 AM January 1, 1970
         * UTC.)
         */
        var creationTime: Instant?
        /**
         * The error message that describes the reason that a stream has a status of
         * IMPAIRED or FAILED. This is not applicable to streams that
         * have other status values.
         */
        var errorCause: ErrorCause?
        /**
         * The exclusive date and time that specifies when the stream ends. If this parameter is
         * undefined, the stream runs indefinitely until you cancel it.
         */
        var exclusiveEndTime: Instant?
        /**
         * The inclusive start date and time from which to start streaming journal data.
         */
        var inclusiveStartTime: Instant?
        /**
         * The configuration settings of the Amazon Kinesis Data Streams destination for a QLDB journal
         * stream.
         */
        var kinesisConfiguration: KinesisConfiguration?
        /**
         * The name of the ledger.
         */
        var ledgerName: String?
        /**
         * The Amazon Resource Name (ARN) of the IAM role that grants QLDB permissions for a
         * journal stream to write data records to a Kinesis Data Streams resource.
         */
        var roleArn: String?
        /**
         * The current state of the QLDB journal stream.
         */
        var status: StreamStatus?
        /**
         * The UUID (represented in Base62-encoded text) of the QLDB journal stream.
         */
        var streamId: String?
        /**
         * The user-defined name of the QLDB journal stream.
         */
        var streamName: String?

        fun build(): JournalKinesisStreamDescription
        /**
         * construct an [aws.sdk.kotlin.services.qldb.model.KinesisConfiguration] inside the given [block]
         */
        fun kinesisConfiguration(block: KinesisConfiguration.DslBuilder.() -> kotlin.Unit) {
            this.kinesisConfiguration = KinesisConfiguration.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var arn: String? = null
        override var creationTime: Instant? = null
        override var errorCause: ErrorCause? = null
        override var exclusiveEndTime: Instant? = null
        override var inclusiveStartTime: Instant? = null
        override var kinesisConfiguration: KinesisConfiguration? = null
        override var ledgerName: String? = null
        override var roleArn: String? = null
        override var status: StreamStatus? = null
        override var streamId: String? = null
        override var streamName: String? = null

        constructor(x: JournalKinesisStreamDescription) : this() {
            this.arn = x.arn
            this.creationTime = x.creationTime
            this.errorCause = x.errorCause
            this.exclusiveEndTime = x.exclusiveEndTime
            this.inclusiveStartTime = x.inclusiveStartTime
            this.kinesisConfiguration = x.kinesisConfiguration
            this.ledgerName = x.ledgerName
            this.roleArn = x.roleArn
            this.status = x.status
            this.streamId = x.streamId
            this.streamName = x.streamName
        }

        override fun build(): JournalKinesisStreamDescription = JournalKinesisStreamDescription(this)
        override fun arn(arn: String): FluentBuilder = apply { this.arn = arn }
        override fun creationTime(creationTime: Instant): FluentBuilder = apply { this.creationTime = creationTime }
        override fun errorCause(errorCause: ErrorCause): FluentBuilder = apply { this.errorCause = errorCause }
        override fun exclusiveEndTime(exclusiveEndTime: Instant): FluentBuilder = apply { this.exclusiveEndTime = exclusiveEndTime }
        override fun inclusiveStartTime(inclusiveStartTime: Instant): FluentBuilder = apply { this.inclusiveStartTime = inclusiveStartTime }
        override fun kinesisConfiguration(kinesisConfiguration: KinesisConfiguration): FluentBuilder = apply { this.kinesisConfiguration = kinesisConfiguration }
        override fun ledgerName(ledgerName: String): FluentBuilder = apply { this.ledgerName = ledgerName }
        override fun roleArn(roleArn: String): FluentBuilder = apply { this.roleArn = roleArn }
        override fun status(status: StreamStatus): FluentBuilder = apply { this.status = status }
        override fun streamId(streamId: String): FluentBuilder = apply { this.streamId = streamId }
        override fun streamName(streamName: String): FluentBuilder = apply { this.streamName = streamName }
    }
}
