// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.qldb.model



class GetBlockRequest private constructor(builder: BuilderImpl) {
    /**
     * The location of the block that you want to request. An address is an Amazon Ion
     * structure that has two fields: strandId and sequenceNo.
     * For example: {strandId:"BlFTjlSXze9BIh1KOszcE3",sequenceNo:14}.
     */
    val blockAddress: ValueHolder? = builder.blockAddress
    /**
     * The latest block location covered by the digest for which to request a proof. An address
     * is an Amazon Ion structure that has two fields: strandId and
     * sequenceNo.
     * For example: {strandId:"BlFTjlSXze9BIh1KOszcE3",sequenceNo:49}.
     */
    val digestTipAddress: ValueHolder? = builder.digestTipAddress
    /**
     * The name of the ledger.
     */
    val name: String? = builder.name

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): GetBlockRequest = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("GetBlockRequest(")
        append("blockAddress=*** Sensitive Data Redacted ***,")
        append("digestTipAddress=*** Sensitive Data Redacted ***,")
        append("name=$name)")
    }

    override fun hashCode(): kotlin.Int {
        var result = blockAddress?.hashCode() ?: 0
        result = 31 * result + (digestTipAddress?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as GetBlockRequest

        if (blockAddress != other.blockAddress) return false
        if (digestTipAddress != other.digestTipAddress) return false
        if (name != other.name) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): GetBlockRequest = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): GetBlockRequest
        /**
         * The location of the block that you want to request. An address is an Amazon Ion
         * structure that has two fields: strandId and sequenceNo.
         * For example: {strandId:"BlFTjlSXze9BIh1KOszcE3",sequenceNo:14}.
         */
        fun blockAddress(blockAddress: ValueHolder): FluentBuilder
        /**
         * The latest block location covered by the digest for which to request a proof. An address
         * is an Amazon Ion structure that has two fields: strandId and
         * sequenceNo.
         * For example: {strandId:"BlFTjlSXze9BIh1KOszcE3",sequenceNo:49}.
         */
        fun digestTipAddress(digestTipAddress: ValueHolder): FluentBuilder
        /**
         * The name of the ledger.
         */
        fun name(name: String): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The location of the block that you want to request. An address is an Amazon Ion
         * structure that has two fields: strandId and sequenceNo.
         * For example: {strandId:"BlFTjlSXze9BIh1KOszcE3",sequenceNo:14}.
         */
        var blockAddress: ValueHolder?
        /**
         * The latest block location covered by the digest for which to request a proof. An address
         * is an Amazon Ion structure that has two fields: strandId and
         * sequenceNo.
         * For example: {strandId:"BlFTjlSXze9BIh1KOszcE3",sequenceNo:49}.
         */
        var digestTipAddress: ValueHolder?
        /**
         * The name of the ledger.
         */
        var name: String?

        fun build(): GetBlockRequest
        /**
         * construct an [aws.sdk.kotlin.services.qldb.model.ValueHolder] inside the given [block]
         */
        fun blockAddress(block: ValueHolder.DslBuilder.() -> kotlin.Unit) {
            this.blockAddress = ValueHolder.invoke(block)
        }
        /**
         * construct an [aws.sdk.kotlin.services.qldb.model.ValueHolder] inside the given [block]
         */
        fun digestTipAddress(block: ValueHolder.DslBuilder.() -> kotlin.Unit) {
            this.digestTipAddress = ValueHolder.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var blockAddress: ValueHolder? = null
        override var digestTipAddress: ValueHolder? = null
        override var name: String? = null

        constructor(x: GetBlockRequest) : this() {
            this.blockAddress = x.blockAddress
            this.digestTipAddress = x.digestTipAddress
            this.name = x.name
        }

        override fun build(): GetBlockRequest = GetBlockRequest(this)
        override fun blockAddress(blockAddress: ValueHolder): FluentBuilder = apply { this.blockAddress = blockAddress }
        override fun digestTipAddress(digestTipAddress: ValueHolder): FluentBuilder = apply { this.digestTipAddress = digestTipAddress }
        override fun name(name: String): FluentBuilder = apply { this.name = name }
    }
}
