// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.qldb.model

import aws.smithy.kotlin.runtime.time.Instant

class ExportJournalToS3Request private constructor(builder: BuilderImpl) {
    /**
     * The exclusive end date and time for the range of journal contents to export.
     * The ExclusiveEndTime must be in ISO 8601 date and time format
     * and in Universal Coordinated Time (UTC). For example:
     * 2019-06-13T21:36:34Z.
     * The ExclusiveEndTime must be less than or equal to the current UTC date and
     * time.
     */
    val exclusiveEndTime: Instant? = builder.exclusiveEndTime
    /**
     * The inclusive start date and time for the range of journal contents to export.
     * The InclusiveStartTime must be in ISO 8601 date and time
     * format and in Universal Coordinated Time (UTC). For example:
     * 2019-06-13T21:36:34Z.
     * The InclusiveStartTime must be before ExclusiveEndTime.
     * If you provide an InclusiveStartTime that is before the ledger's
     * CreationDateTime, Amazon QLDB defaults it to the ledger's
     * CreationDateTime.
     */
    val inclusiveStartTime: Instant? = builder.inclusiveStartTime
    /**
     * The name of the ledger.
     */
    val name: String? = builder.name
    /**
     * The Amazon Resource Name (ARN) of the IAM role that grants QLDB permissions for a
     * journal export job to do the following:
     * Write objects into your Amazon Simple Storage Service (Amazon S3) bucket.
     * (Optional) Use your customer master key (CMK) in Key Management Service (KMS) for server-side
     * encryption of your exported data.
     */
    val roleArn: String? = builder.roleArn
    /**
     * The configuration settings of the Amazon S3 bucket destination for your export
     * request.
     */
    val s3ExportConfiguration: S3ExportConfiguration? = builder.s3ExportConfiguration

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): ExportJournalToS3Request = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("ExportJournalToS3Request(")
        append("exclusiveEndTime=$exclusiveEndTime,")
        append("inclusiveStartTime=$inclusiveStartTime,")
        append("name=$name,")
        append("roleArn=$roleArn,")
        append("s3ExportConfiguration=$s3ExportConfiguration)")
    }

    override fun hashCode(): kotlin.Int {
        var result = exclusiveEndTime?.hashCode() ?: 0
        result = 31 * result + (inclusiveStartTime?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        result = 31 * result + (s3ExportConfiguration?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as ExportJournalToS3Request

        if (exclusiveEndTime != other.exclusiveEndTime) return false
        if (inclusiveStartTime != other.inclusiveStartTime) return false
        if (name != other.name) return false
        if (roleArn != other.roleArn) return false
        if (s3ExportConfiguration != other.s3ExportConfiguration) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): ExportJournalToS3Request = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): ExportJournalToS3Request
        /**
         * The exclusive end date and time for the range of journal contents to export.
         * The ExclusiveEndTime must be in ISO 8601 date and time format
         * and in Universal Coordinated Time (UTC). For example:
         * 2019-06-13T21:36:34Z.
         * The ExclusiveEndTime must be less than or equal to the current UTC date and
         * time.
         */
        fun exclusiveEndTime(exclusiveEndTime: Instant): FluentBuilder
        /**
         * The inclusive start date and time for the range of journal contents to export.
         * The InclusiveStartTime must be in ISO 8601 date and time
         * format and in Universal Coordinated Time (UTC). For example:
         * 2019-06-13T21:36:34Z.
         * The InclusiveStartTime must be before ExclusiveEndTime.
         * If you provide an InclusiveStartTime that is before the ledger's
         * CreationDateTime, Amazon QLDB defaults it to the ledger's
         * CreationDateTime.
         */
        fun inclusiveStartTime(inclusiveStartTime: Instant): FluentBuilder
        /**
         * The name of the ledger.
         */
        fun name(name: String): FluentBuilder
        /**
         * The Amazon Resource Name (ARN) of the IAM role that grants QLDB permissions for a
         * journal export job to do the following:
         * Write objects into your Amazon Simple Storage Service (Amazon S3) bucket.
         * (Optional) Use your customer master key (CMK) in Key Management Service (KMS) for server-side
         * encryption of your exported data.
         */
        fun roleArn(roleArn: String): FluentBuilder
        /**
         * The configuration settings of the Amazon S3 bucket destination for your export
         * request.
         */
        fun s3ExportConfiguration(s3ExportConfiguration: S3ExportConfiguration): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The exclusive end date and time for the range of journal contents to export.
         * The ExclusiveEndTime must be in ISO 8601 date and time format
         * and in Universal Coordinated Time (UTC). For example:
         * 2019-06-13T21:36:34Z.
         * The ExclusiveEndTime must be less than or equal to the current UTC date and
         * time.
         */
        var exclusiveEndTime: Instant?
        /**
         * The inclusive start date and time for the range of journal contents to export.
         * The InclusiveStartTime must be in ISO 8601 date and time
         * format and in Universal Coordinated Time (UTC). For example:
         * 2019-06-13T21:36:34Z.
         * The InclusiveStartTime must be before ExclusiveEndTime.
         * If you provide an InclusiveStartTime that is before the ledger's
         * CreationDateTime, Amazon QLDB defaults it to the ledger's
         * CreationDateTime.
         */
        var inclusiveStartTime: Instant?
        /**
         * The name of the ledger.
         */
        var name: String?
        /**
         * The Amazon Resource Name (ARN) of the IAM role that grants QLDB permissions for a
         * journal export job to do the following:
         * Write objects into your Amazon Simple Storage Service (Amazon S3) bucket.
         * (Optional) Use your customer master key (CMK) in Key Management Service (KMS) for server-side
         * encryption of your exported data.
         */
        var roleArn: String?
        /**
         * The configuration settings of the Amazon S3 bucket destination for your export
         * request.
         */
        var s3ExportConfiguration: S3ExportConfiguration?

        fun build(): ExportJournalToS3Request
        /**
         * construct an [aws.sdk.kotlin.services.qldb.model.S3ExportConfiguration] inside the given [block]
         */
        fun s3ExportConfiguration(block: S3ExportConfiguration.DslBuilder.() -> kotlin.Unit) {
            this.s3ExportConfiguration = S3ExportConfiguration.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var exclusiveEndTime: Instant? = null
        override var inclusiveStartTime: Instant? = null
        override var name: String? = null
        override var roleArn: String? = null
        override var s3ExportConfiguration: S3ExportConfiguration? = null

        constructor(x: ExportJournalToS3Request) : this() {
            this.exclusiveEndTime = x.exclusiveEndTime
            this.inclusiveStartTime = x.inclusiveStartTime
            this.name = x.name
            this.roleArn = x.roleArn
            this.s3ExportConfiguration = x.s3ExportConfiguration
        }

        override fun build(): ExportJournalToS3Request = ExportJournalToS3Request(this)
        override fun exclusiveEndTime(exclusiveEndTime: Instant): FluentBuilder = apply { this.exclusiveEndTime = exclusiveEndTime }
        override fun inclusiveStartTime(inclusiveStartTime: Instant): FluentBuilder = apply { this.inclusiveStartTime = inclusiveStartTime }
        override fun name(name: String): FluentBuilder = apply { this.name = name }
        override fun roleArn(roleArn: String): FluentBuilder = apply { this.roleArn = roleArn }
        override fun s3ExportConfiguration(s3ExportConfiguration: S3ExportConfiguration): FluentBuilder = apply { this.s3ExportConfiguration = s3ExportConfiguration }
    }
}
