// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.qldb.model

import aws.smithy.kotlin.runtime.time.Instant

class DescribeLedgerResponse private constructor(builder: BuilderImpl) {
    /**
     * The Amazon Resource Name (ARN) for the ledger.
     */
    val arn: String? = builder.arn
    /**
     * The date and time, in epoch time format, when the ledger was created. (Epoch time format
     * is the number of seconds elapsed since 12:00:00 AM January 1, 1970 UTC.)
     */
    val creationDateTime: Instant? = builder.creationDateTime
    /**
     * The flag that prevents a ledger from being deleted by any user. If not provided on
     * ledger creation, this feature is enabled (true) by default.
     * If deletion protection is enabled, you must first disable it before you can delete the
     * ledger. You can disable it by calling the UpdateLedger operation to set the flag to false.
     */
    val deletionProtection: Boolean? = builder.deletionProtection
    /**
     * Information about the encryption of data at rest in the ledger. This includes the
     * current status, the KMS key, and when the key became inaccessible (in the case of an
     * error).
     */
    val encryptionDescription: LedgerEncryptionDescription? = builder.encryptionDescription
    /**
     * The name of the ledger.
     */
    val name: String? = builder.name
    /**
     * The permissions mode of the ledger.
     */
    val permissionsMode: PermissionsMode? = builder.permissionsMode
    /**
     * The current status of the ledger.
     */
    val state: LedgerState? = builder.state

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): DescribeLedgerResponse = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeLedgerResponse(")
        append("arn=$arn,")
        append("creationDateTime=$creationDateTime,")
        append("deletionProtection=$deletionProtection,")
        append("encryptionDescription=$encryptionDescription,")
        append("name=$name,")
        append("permissionsMode=$permissionsMode,")
        append("state=$state)")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (creationDateTime?.hashCode() ?: 0)
        result = 31 * result + (deletionProtection?.hashCode() ?: 0)
        result = 31 * result + (encryptionDescription?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (permissionsMode?.hashCode() ?: 0)
        result = 31 * result + (state?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as DescribeLedgerResponse

        if (arn != other.arn) return false
        if (creationDateTime != other.creationDateTime) return false
        if (deletionProtection != other.deletionProtection) return false
        if (encryptionDescription != other.encryptionDescription) return false
        if (name != other.name) return false
        if (permissionsMode != other.permissionsMode) return false
        if (state != other.state) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): DescribeLedgerResponse = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): DescribeLedgerResponse
        /**
         * The Amazon Resource Name (ARN) for the ledger.
         */
        fun arn(arn: String): FluentBuilder
        /**
         * The date and time, in epoch time format, when the ledger was created. (Epoch time format
         * is the number of seconds elapsed since 12:00:00 AM January 1, 1970 UTC.)
         */
        fun creationDateTime(creationDateTime: Instant): FluentBuilder
        /**
         * The flag that prevents a ledger from being deleted by any user. If not provided on
         * ledger creation, this feature is enabled (true) by default.
         * If deletion protection is enabled, you must first disable it before you can delete the
         * ledger. You can disable it by calling the UpdateLedger operation to set the flag to false.
         */
        fun deletionProtection(deletionProtection: Boolean): FluentBuilder
        /**
         * Information about the encryption of data at rest in the ledger. This includes the
         * current status, the KMS key, and when the key became inaccessible (in the case of an
         * error).
         */
        fun encryptionDescription(encryptionDescription: LedgerEncryptionDescription): FluentBuilder
        /**
         * The name of the ledger.
         */
        fun name(name: String): FluentBuilder
        /**
         * The permissions mode of the ledger.
         */
        fun permissionsMode(permissionsMode: PermissionsMode): FluentBuilder
        /**
         * The current status of the ledger.
         */
        fun state(state: LedgerState): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The Amazon Resource Name (ARN) for the ledger.
         */
        var arn: String?
        /**
         * The date and time, in epoch time format, when the ledger was created. (Epoch time format
         * is the number of seconds elapsed since 12:00:00 AM January 1, 1970 UTC.)
         */
        var creationDateTime: Instant?
        /**
         * The flag that prevents a ledger from being deleted by any user. If not provided on
         * ledger creation, this feature is enabled (true) by default.
         * If deletion protection is enabled, you must first disable it before you can delete the
         * ledger. You can disable it by calling the UpdateLedger operation to set the flag to false.
         */
        var deletionProtection: Boolean?
        /**
         * Information about the encryption of data at rest in the ledger. This includes the
         * current status, the KMS key, and when the key became inaccessible (in the case of an
         * error).
         */
        var encryptionDescription: LedgerEncryptionDescription?
        /**
         * The name of the ledger.
         */
        var name: String?
        /**
         * The permissions mode of the ledger.
         */
        var permissionsMode: PermissionsMode?
        /**
         * The current status of the ledger.
         */
        var state: LedgerState?

        fun build(): DescribeLedgerResponse
        /**
         * construct an [aws.sdk.kotlin.services.qldb.model.LedgerEncryptionDescription] inside the given [block]
         */
        fun encryptionDescription(block: LedgerEncryptionDescription.DslBuilder.() -> kotlin.Unit) {
            this.encryptionDescription = LedgerEncryptionDescription.invoke(block)
        }
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var arn: String? = null
        override var creationDateTime: Instant? = null
        override var deletionProtection: Boolean? = null
        override var encryptionDescription: LedgerEncryptionDescription? = null
        override var name: String? = null
        override var permissionsMode: PermissionsMode? = null
        override var state: LedgerState? = null

        constructor(x: DescribeLedgerResponse) : this() {
            this.arn = x.arn
            this.creationDateTime = x.creationDateTime
            this.deletionProtection = x.deletionProtection
            this.encryptionDescription = x.encryptionDescription
            this.name = x.name
            this.permissionsMode = x.permissionsMode
            this.state = x.state
        }

        override fun build(): DescribeLedgerResponse = DescribeLedgerResponse(this)
        override fun arn(arn: String): FluentBuilder = apply { this.arn = arn }
        override fun creationDateTime(creationDateTime: Instant): FluentBuilder = apply { this.creationDateTime = creationDateTime }
        override fun deletionProtection(deletionProtection: Boolean): FluentBuilder = apply { this.deletionProtection = deletionProtection }
        override fun encryptionDescription(encryptionDescription: LedgerEncryptionDescription): FluentBuilder = apply { this.encryptionDescription = encryptionDescription }
        override fun name(name: String): FluentBuilder = apply { this.name = name }
        override fun permissionsMode(permissionsMode: PermissionsMode): FluentBuilder = apply { this.permissionsMode = permissionsMode }
        override fun state(state: LedgerState): FluentBuilder = apply { this.state = state }
    }
}
