// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.qldb.model

import aws.smithy.kotlin.runtime.time.Instant

class CreateLedgerResponse private constructor(builder: BuilderImpl) {
    /**
     * The Amazon Resource Name (ARN) for the ledger.
     */
    val arn: String? = builder.arn
    /**
     * The date and time, in epoch time format, when the ledger was created. (Epoch time format
     * is the number of seconds elapsed since 12:00:00 AM January 1, 1970 UTC.)
     */
    val creationDateTime: Instant? = builder.creationDateTime
    /**
     * The flag that prevents a ledger from being deleted by any user. If not provided on
     * ledger creation, this feature is enabled (true) by default.
     * If deletion protection is enabled, you must first disable it before you can delete the
     * ledger. You can disable it by calling the UpdateLedger operation to set the flag to false.
     */
    val deletionProtection: Boolean? = builder.deletionProtection
    /**
     * The ARN of the customer managed KMS key that the ledger uses for encryption at rest. If
     * this parameter is undefined, the ledger uses an Amazon Web Services owned KMS key for encryption.
     */
    val kmsKeyArn: String? = builder.kmsKeyArn
    /**
     * The name of the ledger.
     */
    val name: String? = builder.name
    /**
     * The permissions mode of the ledger that you created.
     */
    val permissionsMode: PermissionsMode? = builder.permissionsMode
    /**
     * The current status of the ledger.
     */
    val state: LedgerState? = builder.state

    companion object {
        @JvmStatic
        fun fluentBuilder(): FluentBuilder = BuilderImpl()

        internal fun builder(): DslBuilder = BuilderImpl()

        operator fun invoke(block: DslBuilder.() -> kotlin.Unit): CreateLedgerResponse = BuilderImpl().apply(block).build()

    }

    override fun toString(): kotlin.String = buildString {
        append("CreateLedgerResponse(")
        append("arn=$arn,")
        append("creationDateTime=$creationDateTime,")
        append("deletionProtection=$deletionProtection,")
        append("kmsKeyArn=$kmsKeyArn,")
        append("name=$name,")
        append("permissionsMode=$permissionsMode,")
        append("state=$state)")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (creationDateTime?.hashCode() ?: 0)
        result = 31 * result + (deletionProtection?.hashCode() ?: 0)
        result = 31 * result + (kmsKeyArn?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (permissionsMode?.hashCode() ?: 0)
        result = 31 * result + (state?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as CreateLedgerResponse

        if (arn != other.arn) return false
        if (creationDateTime != other.creationDateTime) return false
        if (deletionProtection != other.deletionProtection) return false
        if (kmsKeyArn != other.kmsKeyArn) return false
        if (name != other.name) return false
        if (permissionsMode != other.permissionsMode) return false
        if (state != other.state) return false

        return true
    }

    fun copy(block: DslBuilder.() -> kotlin.Unit = {}): CreateLedgerResponse = BuilderImpl(this).apply(block).build()

    interface FluentBuilder {
        fun build(): CreateLedgerResponse
        /**
         * The Amazon Resource Name (ARN) for the ledger.
         */
        fun arn(arn: String): FluentBuilder
        /**
         * The date and time, in epoch time format, when the ledger was created. (Epoch time format
         * is the number of seconds elapsed since 12:00:00 AM January 1, 1970 UTC.)
         */
        fun creationDateTime(creationDateTime: Instant): FluentBuilder
        /**
         * The flag that prevents a ledger from being deleted by any user. If not provided on
         * ledger creation, this feature is enabled (true) by default.
         * If deletion protection is enabled, you must first disable it before you can delete the
         * ledger. You can disable it by calling the UpdateLedger operation to set the flag to false.
         */
        fun deletionProtection(deletionProtection: Boolean): FluentBuilder
        /**
         * The ARN of the customer managed KMS key that the ledger uses for encryption at rest. If
         * this parameter is undefined, the ledger uses an Amazon Web Services owned KMS key for encryption.
         */
        fun kmsKeyArn(kmsKeyArn: String): FluentBuilder
        /**
         * The name of the ledger.
         */
        fun name(name: String): FluentBuilder
        /**
         * The permissions mode of the ledger that you created.
         */
        fun permissionsMode(permissionsMode: PermissionsMode): FluentBuilder
        /**
         * The current status of the ledger.
         */
        fun state(state: LedgerState): FluentBuilder
    }

    interface DslBuilder {
        /**
         * The Amazon Resource Name (ARN) for the ledger.
         */
        var arn: String?
        /**
         * The date and time, in epoch time format, when the ledger was created. (Epoch time format
         * is the number of seconds elapsed since 12:00:00 AM January 1, 1970 UTC.)
         */
        var creationDateTime: Instant?
        /**
         * The flag that prevents a ledger from being deleted by any user. If not provided on
         * ledger creation, this feature is enabled (true) by default.
         * If deletion protection is enabled, you must first disable it before you can delete the
         * ledger. You can disable it by calling the UpdateLedger operation to set the flag to false.
         */
        var deletionProtection: Boolean?
        /**
         * The ARN of the customer managed KMS key that the ledger uses for encryption at rest. If
         * this parameter is undefined, the ledger uses an Amazon Web Services owned KMS key for encryption.
         */
        var kmsKeyArn: String?
        /**
         * The name of the ledger.
         */
        var name: String?
        /**
         * The permissions mode of the ledger that you created.
         */
        var permissionsMode: PermissionsMode?
        /**
         * The current status of the ledger.
         */
        var state: LedgerState?

        fun build(): CreateLedgerResponse
    }

    private class BuilderImpl() : FluentBuilder, DslBuilder {
        override var arn: String? = null
        override var creationDateTime: Instant? = null
        override var deletionProtection: Boolean? = null
        override var kmsKeyArn: String? = null
        override var name: String? = null
        override var permissionsMode: PermissionsMode? = null
        override var state: LedgerState? = null

        constructor(x: CreateLedgerResponse) : this() {
            this.arn = x.arn
            this.creationDateTime = x.creationDateTime
            this.deletionProtection = x.deletionProtection
            this.kmsKeyArn = x.kmsKeyArn
            this.name = x.name
            this.permissionsMode = x.permissionsMode
            this.state = x.state
        }

        override fun build(): CreateLedgerResponse = CreateLedgerResponse(this)
        override fun arn(arn: String): FluentBuilder = apply { this.arn = arn }
        override fun creationDateTime(creationDateTime: Instant): FluentBuilder = apply { this.creationDateTime = creationDateTime }
        override fun deletionProtection(deletionProtection: Boolean): FluentBuilder = apply { this.deletionProtection = deletionProtection }
        override fun kmsKeyArn(kmsKeyArn: String): FluentBuilder = apply { this.kmsKeyArn = kmsKeyArn }
        override fun name(name: String): FluentBuilder = apply { this.name = name }
        override fun permissionsMode(permissionsMode: PermissionsMode): FluentBuilder = apply { this.permissionsMode = permissionsMode }
        override fun state(state: LedgerState): FluentBuilder = apply { this.state = state }
    }
}
