// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.qldb

import aws.sdk.kotlin.runtime.auth.credentials.CredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.client.AwsClientConfig
import aws.sdk.kotlin.runtime.config.AwsClientConfigLoadOptions
import aws.sdk.kotlin.runtime.config.fromEnvironment
import aws.sdk.kotlin.runtime.endpoint.AwsEndpointResolver
import aws.sdk.kotlin.services.qldb.internal.DefaultEndpointResolver
import aws.sdk.kotlin.services.qldb.model.*
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.operation.EndpointResolver
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.impl.ExponentialBackoffWithJitter
import aws.smithy.kotlin.runtime.retries.impl.ExponentialBackoffWithJitterOptions
import aws.smithy.kotlin.runtime.retries.impl.StandardRetryStrategy
import aws.smithy.kotlin.runtime.retries.impl.StandardRetryStrategyOptions
import aws.smithy.kotlin.runtime.retries.impl.StandardRetryTokenBucket
import aws.smithy.kotlin.runtime.retries.impl.StandardRetryTokenBucketOptions

/**
 * The control plane for Amazon QLDB
 */
interface QldbClient : SdkClient {

    override val serviceName: String
        get() = "QLDB"
    /**
     * QldbClient's configuration
     */
    val config: Config

    companion object {
        operator fun invoke(sharedConfig: AwsClientConfig? = null, block: Config.DslBuilder.() -> Unit = {}): QldbClient {
            val config = Config.BuilderImpl().apply {
                region = sharedConfig?.region
                credentialsProvider = sharedConfig?.credentialsProvider
            }.apply(block).build()
            return DefaultQldbClient(config)
        }

        operator fun invoke(config: Config): QldbClient = DefaultQldbClient(config)

        /**
         * Construct a [QldbClient] by resolving the configuration from the current environment.
         * NOTE: If you are using multiple AWS service clients you may wish to share the configuration among them
         * by constructing a [aws.sdk.kotlin.runtime.client.AwsClientConfig] and passing it to each client at construction.
         */
        suspend fun fromEnvironment(block: AwsClientConfigLoadOptions.() -> Unit = {}): QldbClient {
            val sharedConfig = AwsClientConfig.fromEnvironment(block)
            return QldbClient(sharedConfig)
        }
    }

    class Config private constructor(builder: BuilderImpl): AwsClientConfig, HttpClientConfig, SdkClientConfig {
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider()
        val endpointResolver: AwsEndpointResolver = builder.endpointResolver ?: DefaultEndpointResolver()
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        override val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        val retryStrategy: RetryStrategy = run {
            val strategyOptions = StandardRetryStrategyOptions.Default
            val tokenBucket = StandardRetryTokenBucket(StandardRetryTokenBucketOptions.Default)
            val delayer = ExponentialBackoffWithJitter(ExponentialBackoffWithJitterOptions.Default)
            StandardRetryStrategy(strategyOptions, tokenBucket, delayer)
        }
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        companion object {
            @JvmStatic
            fun fluentBuilder(): FluentBuilder = BuilderImpl()

            operator fun invoke(block: DslBuilder.() -> kotlin.Unit): Config = BuilderImpl().apply(block).build()
        }

        interface FluentBuilder {
            fun credentialsProvider(credentialsProvider: CredentialsProvider): FluentBuilder
            fun endpointResolver(endpointResolver: AwsEndpointResolver): FluentBuilder
            fun httpClientEngine(httpClientEngine: HttpClientEngine): FluentBuilder
            fun region(region: String): FluentBuilder
            fun sdkLogMode(sdkLogMode: SdkLogMode): FluentBuilder
            fun build(): Config
        }

        interface DslBuilder {
            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             */
            var credentialsProvider: CredentialsProvider?

            /**
             * Determines the endpoint (hostname) to make requests to. When not provided a default
             * resolver is configured automatically. This is an advanced client option.
             */
            var endpointResolver: AwsEndpointResolver?

            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc)
             */
            var httpClientEngine: HttpClientEngine?

            /**
             * AWS region to make requests to
             */
            var region: String?

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            var sdkLogMode: SdkLogMode

        }

        internal class BuilderImpl() : FluentBuilder, DslBuilder {
            override var credentialsProvider: CredentialsProvider? = null
            override var endpointResolver: AwsEndpointResolver? = null
            override var httpClientEngine: HttpClientEngine? = null
            override var region: String? = null
            override var sdkLogMode: SdkLogMode = SdkLogMode.Default

            override fun build(): Config = Config(this)
            override fun credentialsProvider(credentialsProvider: CredentialsProvider): FluentBuilder = apply { this.credentialsProvider = credentialsProvider }
            override fun endpointResolver(endpointResolver: AwsEndpointResolver): FluentBuilder = apply { this.endpointResolver = endpointResolver }
            override fun httpClientEngine(httpClientEngine: HttpClientEngine): FluentBuilder = apply { this.httpClientEngine = httpClientEngine }
            override fun region(region: String): FluentBuilder = apply { this.region = region }
            override fun sdkLogMode(sdkLogMode: SdkLogMode): FluentBuilder = apply { this.sdkLogMode = sdkLogMode }
        }
    }

    /**
     * Ends a given Amazon QLDB journal stream. Before a stream can be canceled, its current
     * status must be ACTIVE.
     * You can't restart a stream after you cancel it. Canceled QLDB stream resources are
     * subject to a 7-day retention period, so they are automatically deleted after this limit
     * expires.
     */
    suspend fun cancelJournalKinesisStream(input: CancelJournalKinesisStreamRequest): CancelJournalKinesisStreamResponse

    /**
     * Ends a given Amazon QLDB journal stream. Before a stream can be canceled, its current
     * status must be ACTIVE.
     * You can't restart a stream after you cancel it. Canceled QLDB stream resources are
     * subject to a 7-day retention period, so they are automatically deleted after this limit
     * expires.
     */
    suspend fun cancelJournalKinesisStream(block: CancelJournalKinesisStreamRequest.DslBuilder.() -> Unit) = cancelJournalKinesisStream(CancelJournalKinesisStreamRequest.builder().apply(block).build())

    /**
     * Creates a new ledger in your account in the current Region.
     */
    suspend fun createLedger(input: CreateLedgerRequest): CreateLedgerResponse

    /**
     * Creates a new ledger in your account in the current Region.
     */
    suspend fun createLedger(block: CreateLedgerRequest.DslBuilder.() -> Unit) = createLedger(CreateLedgerRequest.builder().apply(block).build())

    /**
     * Deletes a ledger and all of its contents. This action is irreversible.
     * If deletion protection is enabled, you must first disable it before you can delete the
     * ledger. You can disable it by calling the UpdateLedger operation to set the flag to false.
     */
    suspend fun deleteLedger(input: DeleteLedgerRequest): DeleteLedgerResponse

    /**
     * Deletes a ledger and all of its contents. This action is irreversible.
     * If deletion protection is enabled, you must first disable it before you can delete the
     * ledger. You can disable it by calling the UpdateLedger operation to set the flag to false.
     */
    suspend fun deleteLedger(block: DeleteLedgerRequest.DslBuilder.() -> Unit) = deleteLedger(DeleteLedgerRequest.builder().apply(block).build())

    /**
     * Returns detailed information about a given Amazon QLDB journal stream. The output
     * includes the Amazon Resource Name (ARN), stream name, current status, creation time, and
     * the parameters of the original stream creation request.
     * This action does not return any expired journal streams. For more information, see
     * <a href="https://docs.aws.amazon.com/qldb/latest/developerguide/streams.create.html#streams.create.states.expiration">Expiration for terminal streams in the Amazon QLDB Developer
     * Guide.
     */
    suspend fun describeJournalKinesisStream(input: DescribeJournalKinesisStreamRequest): DescribeJournalKinesisStreamResponse

    /**
     * Returns detailed information about a given Amazon QLDB journal stream. The output
     * includes the Amazon Resource Name (ARN), stream name, current status, creation time, and
     * the parameters of the original stream creation request.
     * This action does not return any expired journal streams. For more information, see
     * <a href="https://docs.aws.amazon.com/qldb/latest/developerguide/streams.create.html#streams.create.states.expiration">Expiration for terminal streams in the Amazon QLDB Developer
     * Guide.
     */
    suspend fun describeJournalKinesisStream(block: DescribeJournalKinesisStreamRequest.DslBuilder.() -> Unit) = describeJournalKinesisStream(DescribeJournalKinesisStreamRequest.builder().apply(block).build())

    /**
     * Returns information about a journal export job, including the ledger name, export ID,
     * creation time, current status, and the parameters of the original export creation
     * request.
     * This action does not return any expired export jobs. For more information, see <a href="https://docs.aws.amazon.com/qldb/latest/developerguide/export-journal.request.html#export-journal.request.expiration">Export job expiration in the Amazon QLDB Developer
     * Guide.
     * If the export job with the given ExportId doesn't exist, then throws
     * ResourceNotFoundException.
     * If the ledger with the given Name doesn't exist, then throws
     * ResourceNotFoundException.
     */
    suspend fun describeJournalS3Export(input: DescribeJournalS3ExportRequest): DescribeJournalS3ExportResponse

    /**
     * Returns information about a journal export job, including the ledger name, export ID,
     * creation time, current status, and the parameters of the original export creation
     * request.
     * This action does not return any expired export jobs. For more information, see <a href="https://docs.aws.amazon.com/qldb/latest/developerguide/export-journal.request.html#export-journal.request.expiration">Export job expiration in the Amazon QLDB Developer
     * Guide.
     * If the export job with the given ExportId doesn't exist, then throws
     * ResourceNotFoundException.
     * If the ledger with the given Name doesn't exist, then throws
     * ResourceNotFoundException.
     */
    suspend fun describeJournalS3Export(block: DescribeJournalS3ExportRequest.DslBuilder.() -> Unit) = describeJournalS3Export(DescribeJournalS3ExportRequest.builder().apply(block).build())

    /**
     * Returns information about a ledger, including its state, permissions mode, encryption at
     * rest settings, and when it was created.
     */
    suspend fun describeLedger(input: DescribeLedgerRequest): DescribeLedgerResponse

    /**
     * Returns information about a ledger, including its state, permissions mode, encryption at
     * rest settings, and when it was created.
     */
    suspend fun describeLedger(block: DescribeLedgerRequest.DslBuilder.() -> Unit) = describeLedger(DescribeLedgerRequest.builder().apply(block).build())

    /**
     * Exports journal contents within a date and time range from a ledger into a specified
     * Amazon Simple Storage Service (Amazon S3) bucket. The data is written as files in Amazon Ion format.
     * If the ledger with the given Name doesn't exist, then throws
     * ResourceNotFoundException.
     * If the ledger with the given Name is in CREATING status, then
     * throws ResourcePreconditionNotMetException.
     * You can initiate up to two concurrent journal export requests for each ledger. Beyond
     * this limit, journal export requests throw LimitExceededException.
     */
    suspend fun exportJournalToS3(input: ExportJournalToS3Request): ExportJournalToS3Response

    /**
     * Exports journal contents within a date and time range from a ledger into a specified
     * Amazon Simple Storage Service (Amazon S3) bucket. The data is written as files in Amazon Ion format.
     * If the ledger with the given Name doesn't exist, then throws
     * ResourceNotFoundException.
     * If the ledger with the given Name is in CREATING status, then
     * throws ResourcePreconditionNotMetException.
     * You can initiate up to two concurrent journal export requests for each ledger. Beyond
     * this limit, journal export requests throw LimitExceededException.
     */
    suspend fun exportJournalToS3(block: ExportJournalToS3Request.DslBuilder.() -> Unit) = exportJournalToS3(ExportJournalToS3Request.builder().apply(block).build())

    /**
     * Returns a block object at a specified address in a journal. Also returns a proof of the
     * specified block for verification if DigestTipAddress is provided.
     * For information about the data contents in a block, see <a href="https://docs.aws.amazon.com/qldb/latest/developerguide/journal-contents.html">Journal contents in the
     * Amazon QLDB Developer Guide.
     * If the specified ledger doesn't exist or is in DELETING status, then throws
     * ResourceNotFoundException.
     * If the specified ledger is in CREATING status, then throws
     * ResourcePreconditionNotMetException.
     * If no block exists with the specified address, then throws
     * InvalidParameterException.
     */
    suspend fun getBlock(input: GetBlockRequest): GetBlockResponse

    /**
     * Returns a block object at a specified address in a journal. Also returns a proof of the
     * specified block for verification if DigestTipAddress is provided.
     * For information about the data contents in a block, see <a href="https://docs.aws.amazon.com/qldb/latest/developerguide/journal-contents.html">Journal contents in the
     * Amazon QLDB Developer Guide.
     * If the specified ledger doesn't exist or is in DELETING status, then throws
     * ResourceNotFoundException.
     * If the specified ledger is in CREATING status, then throws
     * ResourcePreconditionNotMetException.
     * If no block exists with the specified address, then throws
     * InvalidParameterException.
     */
    suspend fun getBlock(block: GetBlockRequest.DslBuilder.() -> Unit) = getBlock(GetBlockRequest.builder().apply(block).build())

    /**
     * Returns the digest of a ledger at the latest committed block in the journal. The
     * response includes a 256-bit hash value and a block address.
     */
    suspend fun getDigest(input: GetDigestRequest): GetDigestResponse

    /**
     * Returns the digest of a ledger at the latest committed block in the journal. The
     * response includes a 256-bit hash value and a block address.
     */
    suspend fun getDigest(block: GetDigestRequest.DslBuilder.() -> Unit) = getDigest(GetDigestRequest.builder().apply(block).build())

    /**
     * Returns a revision data object for a specified document ID and block address. Also
     * returns a proof of the specified revision for verification if DigestTipAddress
     * is provided.
     */
    suspend fun getRevision(input: GetRevisionRequest): GetRevisionResponse

    /**
     * Returns a revision data object for a specified document ID and block address. Also
     * returns a proof of the specified revision for verification if DigestTipAddress
     * is provided.
     */
    suspend fun getRevision(block: GetRevisionRequest.DslBuilder.() -> Unit) = getRevision(GetRevisionRequest.builder().apply(block).build())

    /**
     * Returns an array of all Amazon QLDB journal stream descriptors for a given ledger. The
     * output of each stream descriptor includes the same details that are returned by
     * DescribeJournalKinesisStream.
     * This action does not return any expired journal streams. For more information, see
     * <a href="https://docs.aws.amazon.com/qldb/latest/developerguide/streams.create.html#streams.create.states.expiration">Expiration for terminal streams in the Amazon QLDB Developer
     * Guide.
     * This action returns a maximum of MaxResults items. It is paginated so that
     * you can retrieve all the items by calling ListJournalKinesisStreamsForLedger
     * multiple times.
     */
    suspend fun listJournalKinesisStreamsForLedger(input: ListJournalKinesisStreamsForLedgerRequest): ListJournalKinesisStreamsForLedgerResponse

    /**
     * Returns an array of all Amazon QLDB journal stream descriptors for a given ledger. The
     * output of each stream descriptor includes the same details that are returned by
     * DescribeJournalKinesisStream.
     * This action does not return any expired journal streams. For more information, see
     * <a href="https://docs.aws.amazon.com/qldb/latest/developerguide/streams.create.html#streams.create.states.expiration">Expiration for terminal streams in the Amazon QLDB Developer
     * Guide.
     * This action returns a maximum of MaxResults items. It is paginated so that
     * you can retrieve all the items by calling ListJournalKinesisStreamsForLedger
     * multiple times.
     */
    suspend fun listJournalKinesisStreamsForLedger(block: ListJournalKinesisStreamsForLedgerRequest.DslBuilder.() -> Unit) = listJournalKinesisStreamsForLedger(ListJournalKinesisStreamsForLedgerRequest.builder().apply(block).build())

    /**
     * Returns an array of journal export job descriptions for all ledgers that are associated
     * with the current account and Region.
     * This action returns a maximum of MaxResults items, and is paginated so that
     * you can retrieve all the items by calling ListJournalS3Exports multiple
     * times.
     * This action does not return any expired export jobs. For more information, see <a href="https://docs.aws.amazon.com/qldb/latest/developerguide/export-journal.request.html#export-journal.request.expiration">Export job expiration in the Amazon QLDB Developer
     * Guide.
     */
    suspend fun listJournalS3Exports(input: ListJournalS3ExportsRequest): ListJournalS3ExportsResponse

    /**
     * Returns an array of journal export job descriptions for all ledgers that are associated
     * with the current account and Region.
     * This action returns a maximum of MaxResults items, and is paginated so that
     * you can retrieve all the items by calling ListJournalS3Exports multiple
     * times.
     * This action does not return any expired export jobs. For more information, see <a href="https://docs.aws.amazon.com/qldb/latest/developerguide/export-journal.request.html#export-journal.request.expiration">Export job expiration in the Amazon QLDB Developer
     * Guide.
     */
    suspend fun listJournalS3Exports(block: ListJournalS3ExportsRequest.DslBuilder.() -> Unit) = listJournalS3Exports(ListJournalS3ExportsRequest.builder().apply(block).build())

    /**
     * Returns an array of journal export job descriptions for a specified ledger.
     * This action returns a maximum of MaxResults items, and is paginated so that
     * you can retrieve all the items by calling ListJournalS3ExportsForLedger
     * multiple times.
     * This action does not return any expired export jobs. For more information, see <a href="https://docs.aws.amazon.com/qldb/latest/developerguide/export-journal.request.html#export-journal.request.expiration">Export job expiration in the Amazon QLDB Developer
     * Guide.
     */
    suspend fun listJournalS3ExportsForLedger(input: ListJournalS3ExportsForLedgerRequest): ListJournalS3ExportsForLedgerResponse

    /**
     * Returns an array of journal export job descriptions for a specified ledger.
     * This action returns a maximum of MaxResults items, and is paginated so that
     * you can retrieve all the items by calling ListJournalS3ExportsForLedger
     * multiple times.
     * This action does not return any expired export jobs. For more information, see <a href="https://docs.aws.amazon.com/qldb/latest/developerguide/export-journal.request.html#export-journal.request.expiration">Export job expiration in the Amazon QLDB Developer
     * Guide.
     */
    suspend fun listJournalS3ExportsForLedger(block: ListJournalS3ExportsForLedgerRequest.DslBuilder.() -> Unit) = listJournalS3ExportsForLedger(ListJournalS3ExportsForLedgerRequest.builder().apply(block).build())

    /**
     * Returns an array of ledger summaries that are associated with the current account
     * and Region.
     * This action returns a maximum of 100 items and is paginated so that you can
     * retrieve all the items by calling ListLedgers multiple times.
     */
    suspend fun listLedgers(input: ListLedgersRequest): ListLedgersResponse

    /**
     * Returns an array of ledger summaries that are associated with the current account
     * and Region.
     * This action returns a maximum of 100 items and is paginated so that you can
     * retrieve all the items by calling ListLedgers multiple times.
     */
    suspend fun listLedgers(block: ListLedgersRequest.DslBuilder.() -> Unit) = listLedgers(ListLedgersRequest.builder().apply(block).build())

    /**
     * Returns all tags for a specified Amazon QLDB resource.
     */
    suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Returns all tags for a specified Amazon QLDB resource.
     */
    suspend fun listTagsForResource(block: ListTagsForResourceRequest.DslBuilder.() -> Unit) = listTagsForResource(ListTagsForResourceRequest.builder().apply(block).build())

    /**
     * Creates a journal stream for a given Amazon QLDB ledger. The stream captures every
     * document revision that is committed to the ledger's journal and delivers the data to a
     * specified Amazon Kinesis Data Streams resource.
     */
    suspend fun streamJournalToKinesis(input: StreamJournalToKinesisRequest): StreamJournalToKinesisResponse

    /**
     * Creates a journal stream for a given Amazon QLDB ledger. The stream captures every
     * document revision that is committed to the ledger's journal and delivers the data to a
     * specified Amazon Kinesis Data Streams resource.
     */
    suspend fun streamJournalToKinesis(block: StreamJournalToKinesisRequest.DslBuilder.() -> Unit) = streamJournalToKinesis(StreamJournalToKinesisRequest.builder().apply(block).build())

    /**
     * Adds one or more tags to a specified Amazon QLDB resource.
     * A resource can have up to 50 tags. If you try to create more than 50 tags for a
     * resource, your request fails and returns an error.
     */
    suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Adds one or more tags to a specified Amazon QLDB resource.
     * A resource can have up to 50 tags. If you try to create more than 50 tags for a
     * resource, your request fails and returns an error.
     */
    suspend fun tagResource(block: TagResourceRequest.DslBuilder.() -> Unit) = tagResource(TagResourceRequest.builder().apply(block).build())

    /**
     * Removes one or more tags from a specified Amazon QLDB resource. You can specify up to 50
     * tag keys to remove.
     */
    suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Removes one or more tags from a specified Amazon QLDB resource. You can specify up to 50
     * tag keys to remove.
     */
    suspend fun untagResource(block: UntagResourceRequest.DslBuilder.() -> Unit) = untagResource(UntagResourceRequest.builder().apply(block).build())

    /**
     * Updates properties on a ledger.
     */
    suspend fun updateLedger(input: UpdateLedgerRequest): UpdateLedgerResponse

    /**
     * Updates properties on a ledger.
     */
    suspend fun updateLedger(block: UpdateLedgerRequest.DslBuilder.() -> Unit) = updateLedger(UpdateLedgerRequest.builder().apply(block).build())

    /**
     * Updates the permissions mode of a ledger.
     * Before you switch to the STANDARD permissions mode, you must first
     * create all required IAM policies and table tags to avoid disruption to your users. To
     * learn more, see <a href="https://docs.aws.amazon.com/qldb/latest/developerguide/ledger-management.basics.html#ledger-mgmt.basics.update-permissions.migrating">Migrating to the standard permissions mode in the Amazon QLDB
     * Developer Guide.
     */
    suspend fun updateLedgerPermissionsMode(input: UpdateLedgerPermissionsModeRequest): UpdateLedgerPermissionsModeResponse

    /**
     * Updates the permissions mode of a ledger.
     * Before you switch to the STANDARD permissions mode, you must first
     * create all required IAM policies and table tags to avoid disruption to your users. To
     * learn more, see <a href="https://docs.aws.amazon.com/qldb/latest/developerguide/ledger-management.basics.html#ledger-mgmt.basics.update-permissions.migrating">Migrating to the standard permissions mode in the Amazon QLDB
     * Developer Guide.
     */
    suspend fun updateLedgerPermissionsMode(block: UpdateLedgerPermissionsModeRequest.DslBuilder.() -> Unit) = updateLedgerPermissionsMode(UpdateLedgerPermissionsModeRequest.builder().apply(block).build())
}
