// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.qldb

import aws.sdk.kotlin.runtime.client.AwsClientOption
import aws.sdk.kotlin.runtime.execution.AuthAttributes
import aws.sdk.kotlin.runtime.http.engine.crt.CrtHttpEngine
import aws.sdk.kotlin.services.qldb.model.*
import aws.sdk.kotlin.services.qldb.transform.*
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.http.SdkHttpClient
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperation
import aws.smithy.kotlin.runtime.http.operation.context
import aws.smithy.kotlin.runtime.http.operation.roundTrip
import aws.smithy.kotlin.runtime.http.sdkHttpClient
import aws.smithy.kotlin.runtime.util.putIfAbsent


const val ServiceId: String = "QLDB"
const val ServiceApiVersion: String = "2019-01-02"
const val SdkVersion: String = "0.9.0-alpha"

internal class DefaultQldbClient(override val config: QldbClient.Config) : QldbClient {
    private val client: SdkHttpClient
    init {
        val httpClientEngine = config.httpClientEngine ?: CrtHttpEngine()
        client = sdkHttpClient(httpClientEngine, manageEngine = config.httpClientEngine == null)
    }

    /**
     * Ends a given Amazon QLDB journal stream. Before a stream can be canceled, its current
     * status must be ACTIVE.
     * You can't restart a stream after you cancel it. Canceled QLDB stream resources are
     * subject to a 7-day retention period, so they are automatically deleted after this limit
     * expires.
     */
    override suspend fun cancelJournalKinesisStream(input: CancelJournalKinesisStreamRequest): CancelJournalKinesisStreamResponse {
        val op = SdkHttpOperation.build<CancelJournalKinesisStreamRequest, CancelJournalKinesisStreamResponse> {
            serializer = CancelJournalKinesisStreamOperationSerializer()
            deserializer = CancelJournalKinesisStreamOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CancelJournalKinesisStream"
            }
        }
        registerCancelJournalKinesisStreamMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a new ledger in your account in the current Region.
     */
    override suspend fun createLedger(input: CreateLedgerRequest): CreateLedgerResponse {
        val op = SdkHttpOperation.build<CreateLedgerRequest, CreateLedgerResponse> {
            serializer = CreateLedgerOperationSerializer()
            deserializer = CreateLedgerOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateLedger"
            }
        }
        registerCreateLedgerMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Deletes a ledger and all of its contents. This action is irreversible.
     * If deletion protection is enabled, you must first disable it before you can delete the
     * ledger. You can disable it by calling the UpdateLedger operation to set the flag to false.
     */
    override suspend fun deleteLedger(input: DeleteLedgerRequest): DeleteLedgerResponse {
        val op = SdkHttpOperation.build<DeleteLedgerRequest, DeleteLedgerResponse> {
            serializer = DeleteLedgerOperationSerializer()
            deserializer = DeleteLedgerOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteLedger"
            }
        }
        registerDeleteLedgerMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Returns detailed information about a given Amazon QLDB journal stream. The output
     * includes the Amazon Resource Name (ARN), stream name, current status, creation time, and
     * the parameters of the original stream creation request.
     * This action does not return any expired journal streams. For more information, see
     * <a href="https://docs.aws.amazon.com/qldb/latest/developerguide/streams.create.html#streams.create.states.expiration">Expiration for terminal streams in the Amazon QLDB Developer
     * Guide.
     */
    override suspend fun describeJournalKinesisStream(input: DescribeJournalKinesisStreamRequest): DescribeJournalKinesisStreamResponse {
        val op = SdkHttpOperation.build<DescribeJournalKinesisStreamRequest, DescribeJournalKinesisStreamResponse> {
            serializer = DescribeJournalKinesisStreamOperationSerializer()
            deserializer = DescribeJournalKinesisStreamOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeJournalKinesisStream"
            }
        }
        registerDescribeJournalKinesisStreamMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Returns information about a journal export job, including the ledger name, export ID,
     * creation time, current status, and the parameters of the original export creation
     * request.
     * This action does not return any expired export jobs. For more information, see <a href="https://docs.aws.amazon.com/qldb/latest/developerguide/export-journal.request.html#export-journal.request.expiration">Export job expiration in the Amazon QLDB Developer
     * Guide.
     * If the export job with the given ExportId doesn't exist, then throws
     * ResourceNotFoundException.
     * If the ledger with the given Name doesn't exist, then throws
     * ResourceNotFoundException.
     */
    override suspend fun describeJournalS3Export(input: DescribeJournalS3ExportRequest): DescribeJournalS3ExportResponse {
        val op = SdkHttpOperation.build<DescribeJournalS3ExportRequest, DescribeJournalS3ExportResponse> {
            serializer = DescribeJournalS3ExportOperationSerializer()
            deserializer = DescribeJournalS3ExportOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeJournalS3Export"
            }
        }
        registerDescribeJournalS3ExportMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Returns information about a ledger, including its state, permissions mode, encryption at
     * rest settings, and when it was created.
     */
    override suspend fun describeLedger(input: DescribeLedgerRequest): DescribeLedgerResponse {
        val op = SdkHttpOperation.build<DescribeLedgerRequest, DescribeLedgerResponse> {
            serializer = DescribeLedgerOperationSerializer()
            deserializer = DescribeLedgerOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeLedger"
            }
        }
        registerDescribeLedgerMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Exports journal contents within a date and time range from a ledger into a specified
     * Amazon Simple Storage Service (Amazon S3) bucket. The data is written as files in Amazon Ion format.
     * If the ledger with the given Name doesn't exist, then throws
     * ResourceNotFoundException.
     * If the ledger with the given Name is in CREATING status, then
     * throws ResourcePreconditionNotMetException.
     * You can initiate up to two concurrent journal export requests for each ledger. Beyond
     * this limit, journal export requests throw LimitExceededException.
     */
    override suspend fun exportJournalToS3(input: ExportJournalToS3Request): ExportJournalToS3Response {
        val op = SdkHttpOperation.build<ExportJournalToS3Request, ExportJournalToS3Response> {
            serializer = ExportJournalToS3OperationSerializer()
            deserializer = ExportJournalToS3OperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ExportJournalToS3"
            }
        }
        registerExportJournalToS3Middleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Returns a block object at a specified address in a journal. Also returns a proof of the
     * specified block for verification if DigestTipAddress is provided.
     * For information about the data contents in a block, see <a href="https://docs.aws.amazon.com/qldb/latest/developerguide/journal-contents.html">Journal contents in the
     * Amazon QLDB Developer Guide.
     * If the specified ledger doesn't exist or is in DELETING status, then throws
     * ResourceNotFoundException.
     * If the specified ledger is in CREATING status, then throws
     * ResourcePreconditionNotMetException.
     * If no block exists with the specified address, then throws
     * InvalidParameterException.
     */
    override suspend fun getBlock(input: GetBlockRequest): GetBlockResponse {
        val op = SdkHttpOperation.build<GetBlockRequest, GetBlockResponse> {
            serializer = GetBlockOperationSerializer()
            deserializer = GetBlockOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetBlock"
            }
        }
        registerGetBlockMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Returns the digest of a ledger at the latest committed block in the journal. The
     * response includes a 256-bit hash value and a block address.
     */
    override suspend fun getDigest(input: GetDigestRequest): GetDigestResponse {
        val op = SdkHttpOperation.build<GetDigestRequest, GetDigestResponse> {
            serializer = GetDigestOperationSerializer()
            deserializer = GetDigestOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetDigest"
            }
        }
        registerGetDigestMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Returns a revision data object for a specified document ID and block address. Also
     * returns a proof of the specified revision for verification if DigestTipAddress
     * is provided.
     */
    override suspend fun getRevision(input: GetRevisionRequest): GetRevisionResponse {
        val op = SdkHttpOperation.build<GetRevisionRequest, GetRevisionResponse> {
            serializer = GetRevisionOperationSerializer()
            deserializer = GetRevisionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetRevision"
            }
        }
        registerGetRevisionMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Returns an array of all Amazon QLDB journal stream descriptors for a given ledger. The
     * output of each stream descriptor includes the same details that are returned by
     * DescribeJournalKinesisStream.
     * This action does not return any expired journal streams. For more information, see
     * <a href="https://docs.aws.amazon.com/qldb/latest/developerguide/streams.create.html#streams.create.states.expiration">Expiration for terminal streams in the Amazon QLDB Developer
     * Guide.
     * This action returns a maximum of MaxResults items. It is paginated so that
     * you can retrieve all the items by calling ListJournalKinesisStreamsForLedger
     * multiple times.
     */
    override suspend fun listJournalKinesisStreamsForLedger(input: ListJournalKinesisStreamsForLedgerRequest): ListJournalKinesisStreamsForLedgerResponse {
        val op = SdkHttpOperation.build<ListJournalKinesisStreamsForLedgerRequest, ListJournalKinesisStreamsForLedgerResponse> {
            serializer = ListJournalKinesisStreamsForLedgerOperationSerializer()
            deserializer = ListJournalKinesisStreamsForLedgerOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListJournalKinesisStreamsForLedger"
            }
        }
        registerListJournalKinesisStreamsForLedgerMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Returns an array of journal export job descriptions for all ledgers that are associated
     * with the current account and Region.
     * This action returns a maximum of MaxResults items, and is paginated so that
     * you can retrieve all the items by calling ListJournalS3Exports multiple
     * times.
     * This action does not return any expired export jobs. For more information, see <a href="https://docs.aws.amazon.com/qldb/latest/developerguide/export-journal.request.html#export-journal.request.expiration">Export job expiration in the Amazon QLDB Developer
     * Guide.
     */
    override suspend fun listJournalS3Exports(input: ListJournalS3ExportsRequest): ListJournalS3ExportsResponse {
        val op = SdkHttpOperation.build<ListJournalS3ExportsRequest, ListJournalS3ExportsResponse> {
            serializer = ListJournalS3ExportsOperationSerializer()
            deserializer = ListJournalS3ExportsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListJournalS3Exports"
            }
        }
        registerListJournalS3ExportsMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Returns an array of journal export job descriptions for a specified ledger.
     * This action returns a maximum of MaxResults items, and is paginated so that
     * you can retrieve all the items by calling ListJournalS3ExportsForLedger
     * multiple times.
     * This action does not return any expired export jobs. For more information, see <a href="https://docs.aws.amazon.com/qldb/latest/developerguide/export-journal.request.html#export-journal.request.expiration">Export job expiration in the Amazon QLDB Developer
     * Guide.
     */
    override suspend fun listJournalS3ExportsForLedger(input: ListJournalS3ExportsForLedgerRequest): ListJournalS3ExportsForLedgerResponse {
        val op = SdkHttpOperation.build<ListJournalS3ExportsForLedgerRequest, ListJournalS3ExportsForLedgerResponse> {
            serializer = ListJournalS3ExportsForLedgerOperationSerializer()
            deserializer = ListJournalS3ExportsForLedgerOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListJournalS3ExportsForLedger"
            }
        }
        registerListJournalS3ExportsForLedgerMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Returns an array of ledger summaries that are associated with the current account
     * and Region.
     * This action returns a maximum of 100 items and is paginated so that you can
     * retrieve all the items by calling ListLedgers multiple times.
     */
    override suspend fun listLedgers(input: ListLedgersRequest): ListLedgersResponse {
        val op = SdkHttpOperation.build<ListLedgersRequest, ListLedgersResponse> {
            serializer = ListLedgersOperationSerializer()
            deserializer = ListLedgersOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListLedgers"
            }
        }
        registerListLedgersMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Returns all tags for a specified Amazon QLDB resource.
     */
    override suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse {
        val op = SdkHttpOperation.build<ListTagsForResourceRequest, ListTagsForResourceResponse> {
            serializer = ListTagsForResourceOperationSerializer()
            deserializer = ListTagsForResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListTagsForResource"
            }
        }
        registerListTagsForResourceMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Creates a journal stream for a given Amazon QLDB ledger. The stream captures every
     * document revision that is committed to the ledger's journal and delivers the data to a
     * specified Amazon Kinesis Data Streams resource.
     */
    override suspend fun streamJournalToKinesis(input: StreamJournalToKinesisRequest): StreamJournalToKinesisResponse {
        val op = SdkHttpOperation.build<StreamJournalToKinesisRequest, StreamJournalToKinesisResponse> {
            serializer = StreamJournalToKinesisOperationSerializer()
            deserializer = StreamJournalToKinesisOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "StreamJournalToKinesis"
            }
        }
        registerStreamJournalToKinesisMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Adds one or more tags to a specified Amazon QLDB resource.
     * A resource can have up to 50 tags. If you try to create more than 50 tags for a
     * resource, your request fails and returns an error.
     */
    override suspend fun tagResource(input: TagResourceRequest): TagResourceResponse {
        val op = SdkHttpOperation.build<TagResourceRequest, TagResourceResponse> {
            serializer = TagResourceOperationSerializer()
            deserializer = TagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "TagResource"
            }
        }
        registerTagResourceMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Removes one or more tags from a specified Amazon QLDB resource. You can specify up to 50
     * tag keys to remove.
     */
    override suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse {
        val op = SdkHttpOperation.build<UntagResourceRequest, UntagResourceResponse> {
            serializer = UntagResourceOperationSerializer()
            deserializer = UntagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UntagResource"
            }
        }
        registerUntagResourceMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Updates properties on a ledger.
     */
    override suspend fun updateLedger(input: UpdateLedgerRequest): UpdateLedgerResponse {
        val op = SdkHttpOperation.build<UpdateLedgerRequest, UpdateLedgerResponse> {
            serializer = UpdateLedgerOperationSerializer()
            deserializer = UpdateLedgerOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateLedger"
            }
        }
        registerUpdateLedgerMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    /**
     * Updates the permissions mode of a ledger.
     * Before you switch to the STANDARD permissions mode, you must first
     * create all required IAM policies and table tags to avoid disruption to your users. To
     * learn more, see <a href="https://docs.aws.amazon.com/qldb/latest/developerguide/ledger-management.basics.html#ledger-mgmt.basics.update-permissions.migrating">Migrating to the standard permissions mode in the Amazon QLDB
     * Developer Guide.
     */
    override suspend fun updateLedgerPermissionsMode(input: UpdateLedgerPermissionsModeRequest): UpdateLedgerPermissionsModeResponse {
        val op = SdkHttpOperation.build<UpdateLedgerPermissionsModeRequest, UpdateLedgerPermissionsModeResponse> {
            serializer = UpdateLedgerPermissionsModeOperationSerializer()
            deserializer = UpdateLedgerPermissionsModeOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateLedgerPermissionsMode"
            }
        }
        registerUpdateLedgerPermissionsModeMiddleware(config, op)
        mergeServiceDefaults(op.context)
        return op.roundTrip(client, input)
    }

    override fun close() {
        client.close()
    }

    /**
     * merge the defaults configured for the service into the execution context before firing off a request
     */
    private suspend fun mergeServiceDefaults(ctx: ExecutionContext) {
        ctx.putIfAbsent(AwsClientOption.Region, config.region)
        ctx.putIfAbsent(AuthAttributes.SigningRegion, config.region)
        ctx.putIfAbsent(SdkClientOption.ServiceName, serviceName)
        ctx.putIfAbsent(SdkClientOption.LogMode, config.sdkLogMode)
    }
}
