// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.qldb.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Information about an Amazon QLDB journal stream, including the Amazon Resource Name (ARN), stream name, creation time, current status, and the parameters of the original stream creation request.
 */
public class JournalKinesisStreamDescription private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the QLDB journal stream.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * The date and time, in epoch time format, when the QLDB journal stream was created. (Epoch time format is the number of seconds elapsed since 12:00:00 AM January 1, 1970 UTC.)
     */
    public val creationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.creationTime
    /**
     * The error message that describes the reason that a stream has a status of `IMPAIRED` or `FAILED`. This is not applicable to streams that have other status values.
     */
    public val errorCause: aws.sdk.kotlin.services.qldb.model.ErrorCause? = builder.errorCause
    /**
     * The exclusive date and time that specifies when the stream ends. If this parameter is undefined, the stream runs indefinitely until you cancel it.
     */
    public val exclusiveEndTime: aws.smithy.kotlin.runtime.time.Instant? = builder.exclusiveEndTime
    /**
     * The inclusive start date and time from which to start streaming journal data.
     */
    public val inclusiveStartTime: aws.smithy.kotlin.runtime.time.Instant? = builder.inclusiveStartTime
    /**
     * The configuration settings of the Amazon Kinesis Data Streams destination for a QLDB journal stream.
     */
    public val kinesisConfiguration: aws.sdk.kotlin.services.qldb.model.KinesisConfiguration? = builder.kinesisConfiguration
    /**
     * The name of the ledger.
     */
    public val ledgerName: kotlin.String? = builder.ledgerName
    /**
     * The Amazon Resource Name (ARN) of the IAM role that grants QLDB permissions for a journal stream to write data records to a Kinesis Data Streams resource.
     */
    public val roleArn: kotlin.String? = builder.roleArn
    /**
     * The current state of the QLDB journal stream.
     */
    public val status: aws.sdk.kotlin.services.qldb.model.StreamStatus? = builder.status
    /**
     * The UUID (represented in Base62-encoded text) of the QLDB journal stream.
     */
    public val streamId: kotlin.String? = builder.streamId
    /**
     * The user-defined name of the QLDB journal stream.
     */
    public val streamName: kotlin.String? = builder.streamName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.qldb.model.JournalKinesisStreamDescription = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("JournalKinesisStreamDescription(")
        append("arn=$arn,")
        append("creationTime=$creationTime,")
        append("errorCause=$errorCause,")
        append("exclusiveEndTime=$exclusiveEndTime,")
        append("inclusiveStartTime=$inclusiveStartTime,")
        append("kinesisConfiguration=$kinesisConfiguration,")
        append("ledgerName=$ledgerName,")
        append("roleArn=$roleArn,")
        append("status=$status,")
        append("streamId=$streamId,")
        append("streamName=$streamName)")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (creationTime?.hashCode() ?: 0)
        result = 31 * result + (errorCause?.hashCode() ?: 0)
        result = 31 * result + (exclusiveEndTime?.hashCode() ?: 0)
        result = 31 * result + (inclusiveStartTime?.hashCode() ?: 0)
        result = 31 * result + (kinesisConfiguration?.hashCode() ?: 0)
        result = 31 * result + (ledgerName?.hashCode() ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (streamId?.hashCode() ?: 0)
        result = 31 * result + (streamName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as JournalKinesisStreamDescription

        if (arn != other.arn) return false
        if (creationTime != other.creationTime) return false
        if (errorCause != other.errorCause) return false
        if (exclusiveEndTime != other.exclusiveEndTime) return false
        if (inclusiveStartTime != other.inclusiveStartTime) return false
        if (kinesisConfiguration != other.kinesisConfiguration) return false
        if (ledgerName != other.ledgerName) return false
        if (roleArn != other.roleArn) return false
        if (status != other.status) return false
        if (streamId != other.streamId) return false
        if (streamName != other.streamName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.qldb.model.JournalKinesisStreamDescription = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the QLDB journal stream.
         */
        public var arn: kotlin.String? = null
        /**
         * The date and time, in epoch time format, when the QLDB journal stream was created. (Epoch time format is the number of seconds elapsed since 12:00:00 AM January 1, 1970 UTC.)
         */
        public var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The error message that describes the reason that a stream has a status of `IMPAIRED` or `FAILED`. This is not applicable to streams that have other status values.
         */
        public var errorCause: aws.sdk.kotlin.services.qldb.model.ErrorCause? = null
        /**
         * The exclusive date and time that specifies when the stream ends. If this parameter is undefined, the stream runs indefinitely until you cancel it.
         */
        public var exclusiveEndTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The inclusive start date and time from which to start streaming journal data.
         */
        public var inclusiveStartTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The configuration settings of the Amazon Kinesis Data Streams destination for a QLDB journal stream.
         */
        public var kinesisConfiguration: aws.sdk.kotlin.services.qldb.model.KinesisConfiguration? = null
        /**
         * The name of the ledger.
         */
        public var ledgerName: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the IAM role that grants QLDB permissions for a journal stream to write data records to a Kinesis Data Streams resource.
         */
        public var roleArn: kotlin.String? = null
        /**
         * The current state of the QLDB journal stream.
         */
        public var status: aws.sdk.kotlin.services.qldb.model.StreamStatus? = null
        /**
         * The UUID (represented in Base62-encoded text) of the QLDB journal stream.
         */
        public var streamId: kotlin.String? = null
        /**
         * The user-defined name of the QLDB journal stream.
         */
        public var streamName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.qldb.model.JournalKinesisStreamDescription) : this() {
            this.arn = x.arn
            this.creationTime = x.creationTime
            this.errorCause = x.errorCause
            this.exclusiveEndTime = x.exclusiveEndTime
            this.inclusiveStartTime = x.inclusiveStartTime
            this.kinesisConfiguration = x.kinesisConfiguration
            this.ledgerName = x.ledgerName
            this.roleArn = x.roleArn
            this.status = x.status
            this.streamId = x.streamId
            this.streamName = x.streamName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.qldb.model.JournalKinesisStreamDescription = JournalKinesisStreamDescription(this)

        /**
         * construct an [aws.sdk.kotlin.services.qldb.model.KinesisConfiguration] inside the given [block]
         */
        public fun kinesisConfiguration(block: aws.sdk.kotlin.services.qldb.model.KinesisConfiguration.Builder.() -> kotlin.Unit) {
            this.kinesisConfiguration = aws.sdk.kotlin.services.qldb.model.KinesisConfiguration.invoke(block)
        }
    }
}
