// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.qldb.model



public class GetRevisionRequest private constructor(builder: Builder) {
    /**
     * The block location of the document revision to be verified. An address is an Amazon Ion structure that has two fields: `strandId` and `sequenceNo`.
     *
     * For example: `{strandId:"BlFTjlSXze9BIh1KOszcE3",sequenceNo:14}`.
     */
    public val blockAddress: aws.sdk.kotlin.services.qldb.model.ValueHolder? = builder.blockAddress
    /**
     * The latest block location covered by the digest for which to request a proof. An address is an Amazon Ion structure that has two fields: `strandId` and `sequenceNo`.
     *
     * For example: `{strandId:"BlFTjlSXze9BIh1KOszcE3",sequenceNo:49}`.
     */
    public val digestTipAddress: aws.sdk.kotlin.services.qldb.model.ValueHolder? = builder.digestTipAddress
    /**
     * The UUID (represented in Base62-encoded text) of the document to be verified.
     */
    public val documentId: kotlin.String? = builder.documentId
    /**
     * The name of the ledger.
     */
    public val name: kotlin.String? = requireNotNull(builder.name) { "A non-null value must be provided for name" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.qldb.model.GetRevisionRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetRevisionRequest(")
        append("blockAddress=*** Sensitive Data Redacted ***,")
        append("digestTipAddress=*** Sensitive Data Redacted ***,")
        append("documentId=$documentId,")
        append("name=$name)")
    }

    override fun hashCode(): kotlin.Int {
        var result = blockAddress?.hashCode() ?: 0
        result = 31 * result + (digestTipAddress?.hashCode() ?: 0)
        result = 31 * result + (documentId?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetRevisionRequest

        if (blockAddress != other.blockAddress) return false
        if (digestTipAddress != other.digestTipAddress) return false
        if (documentId != other.documentId) return false
        if (name != other.name) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.qldb.model.GetRevisionRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The block location of the document revision to be verified. An address is an Amazon Ion structure that has two fields: `strandId` and `sequenceNo`.
         *
         * For example: `{strandId:"BlFTjlSXze9BIh1KOszcE3",sequenceNo:14}`.
         */
        public var blockAddress: aws.sdk.kotlin.services.qldb.model.ValueHolder? = null
        /**
         * The latest block location covered by the digest for which to request a proof. An address is an Amazon Ion structure that has two fields: `strandId` and `sequenceNo`.
         *
         * For example: `{strandId:"BlFTjlSXze9BIh1KOszcE3",sequenceNo:49}`.
         */
        public var digestTipAddress: aws.sdk.kotlin.services.qldb.model.ValueHolder? = null
        /**
         * The UUID (represented in Base62-encoded text) of the document to be verified.
         */
        public var documentId: kotlin.String? = null
        /**
         * The name of the ledger.
         */
        public var name: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.qldb.model.GetRevisionRequest) : this() {
            this.blockAddress = x.blockAddress
            this.digestTipAddress = x.digestTipAddress
            this.documentId = x.documentId
            this.name = x.name
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.qldb.model.GetRevisionRequest = GetRevisionRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.qldb.model.ValueHolder] inside the given [block]
         */
        public fun blockAddress(block: aws.sdk.kotlin.services.qldb.model.ValueHolder.Builder.() -> kotlin.Unit) {
            this.blockAddress = aws.sdk.kotlin.services.qldb.model.ValueHolder.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.qldb.model.ValueHolder] inside the given [block]
         */
        public fun digestTipAddress(block: aws.sdk.kotlin.services.qldb.model.ValueHolder.Builder.() -> kotlin.Unit) {
            this.digestTipAddress = aws.sdk.kotlin.services.qldb.model.ValueHolder.invoke(block)
        }
    }
}
