// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.qldb

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.manage
import aws.sdk.kotlin.runtime.config.AbstractAwsSdkClientFactory
import aws.sdk.kotlin.runtime.config.AwsSdkClientConfig
import aws.sdk.kotlin.runtime.config.endpoints.resolveEndpointUrl
import aws.sdk.kotlin.runtime.config.profile.AwsProfile
import aws.sdk.kotlin.runtime.config.profile.AwsSharedConfig
import aws.sdk.kotlin.runtime.http.retries.AwsRetryPolicy
import aws.sdk.kotlin.runtime.region.DefaultRegionProviderChain
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.qldb.auth.DefaultQldbAuthSchemeProvider
import aws.sdk.kotlin.services.qldb.auth.QldbAuthSchemeProvider
import aws.sdk.kotlin.services.qldb.endpoints.DefaultQldbEndpointProvider
import aws.sdk.kotlin.services.qldb.endpoints.QldbEndpointParameters
import aws.sdk.kotlin.services.qldb.endpoints.QldbEndpointProvider
import aws.sdk.kotlin.services.qldb.model.CancelJournalKinesisStreamRequest
import aws.sdk.kotlin.services.qldb.model.CancelJournalKinesisStreamResponse
import aws.sdk.kotlin.services.qldb.model.CreateLedgerRequest
import aws.sdk.kotlin.services.qldb.model.CreateLedgerResponse
import aws.sdk.kotlin.services.qldb.model.DeleteLedgerRequest
import aws.sdk.kotlin.services.qldb.model.DeleteLedgerResponse
import aws.sdk.kotlin.services.qldb.model.DescribeJournalKinesisStreamRequest
import aws.sdk.kotlin.services.qldb.model.DescribeJournalKinesisStreamResponse
import aws.sdk.kotlin.services.qldb.model.DescribeJournalS3ExportRequest
import aws.sdk.kotlin.services.qldb.model.DescribeJournalS3ExportResponse
import aws.sdk.kotlin.services.qldb.model.DescribeLedgerRequest
import aws.sdk.kotlin.services.qldb.model.DescribeLedgerResponse
import aws.sdk.kotlin.services.qldb.model.ExportJournalToS3Request
import aws.sdk.kotlin.services.qldb.model.ExportJournalToS3Response
import aws.sdk.kotlin.services.qldb.model.GetBlockRequest
import aws.sdk.kotlin.services.qldb.model.GetBlockResponse
import aws.sdk.kotlin.services.qldb.model.GetDigestRequest
import aws.sdk.kotlin.services.qldb.model.GetDigestResponse
import aws.sdk.kotlin.services.qldb.model.GetRevisionRequest
import aws.sdk.kotlin.services.qldb.model.GetRevisionResponse
import aws.sdk.kotlin.services.qldb.model.ListJournalKinesisStreamsForLedgerRequest
import aws.sdk.kotlin.services.qldb.model.ListJournalKinesisStreamsForLedgerResponse
import aws.sdk.kotlin.services.qldb.model.ListJournalS3ExportsForLedgerRequest
import aws.sdk.kotlin.services.qldb.model.ListJournalS3ExportsForLedgerResponse
import aws.sdk.kotlin.services.qldb.model.ListJournalS3ExportsRequest
import aws.sdk.kotlin.services.qldb.model.ListJournalS3ExportsResponse
import aws.sdk.kotlin.services.qldb.model.ListLedgersRequest
import aws.sdk.kotlin.services.qldb.model.ListLedgersResponse
import aws.sdk.kotlin.services.qldb.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.qldb.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.qldb.model.StreamJournalToKinesisRequest
import aws.sdk.kotlin.services.qldb.model.StreamJournalToKinesisResponse
import aws.sdk.kotlin.services.qldb.model.TagResourceRequest
import aws.sdk.kotlin.services.qldb.model.TagResourceResponse
import aws.sdk.kotlin.services.qldb.model.UntagResourceRequest
import aws.sdk.kotlin.services.qldb.model.UntagResourceResponse
import aws.sdk.kotlin.services.qldb.model.UpdateLedgerPermissionsModeRequest
import aws.sdk.kotlin.services.qldb.model.UpdateLedgerPermissionsModeResponse
import aws.sdk.kotlin.services.qldb.model.UpdateLedgerRequest
import aws.sdk.kotlin.services.qldb.model.UpdateLedgerResponse
import aws.smithy.kotlin.runtime.auth.AuthSchemeId
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProviderConfig
import aws.smithy.kotlin.runtime.awsprotocol.ClockSkewInterceptor
import aws.smithy.kotlin.runtime.client.AbstractSdkClientBuilder
import aws.smithy.kotlin.runtime.client.AbstractSdkClientFactory
import aws.smithy.kotlin.runtime.client.LogMode
import aws.smithy.kotlin.runtime.client.RetryClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfigImpl
import aws.smithy.kotlin.runtime.client.SdkClient
import aws.smithy.kotlin.runtime.client.SdkClientConfig
import aws.smithy.kotlin.runtime.client.region.RegionProvider
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.HttpAuthConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpEngineConfig
import aws.smithy.kotlin.runtime.http.config.TimeoutConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.engine.HttpEngineConfigImpl
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.net.url.Url
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.policy.RetryPolicy
import aws.smithy.kotlin.runtime.telemetry.Global
import aws.smithy.kotlin.runtime.telemetry.TelemetryConfig
import aws.smithy.kotlin.runtime.telemetry.TelemetryProvider
import aws.smithy.kotlin.runtime.util.LazyAsyncValue
import kotlin.collections.List
import kotlin.jvm.JvmStatic
import kotlin.time.Duration
import kotlinx.coroutines.runBlocking


public const val ServiceId: String = "QLDB"
public const val SdkVersion: String = "1.5.36"
public const val ServiceApiVersion: String = "2019-01-02"

/**
 * The resource management API for Amazon QLDB
 */
public interface QldbClient : SdkClient {
    /**
     * QldbClient's configuration
     */
    public override val config: Config

    public companion object : AbstractAwsSdkClientFactory<Config, Config.Builder, QldbClient, Builder>()
     {
        @JvmStatic
        override fun builder(): Builder = Builder()

        override fun finalizeConfig(builder: Builder) {
            super.finalizeConfig(builder)
            builder.config.interceptors.add(0, ClockSkewInterceptor())
        }

        override suspend fun finalizeEnvironmentalConfig(builder: Builder, sharedConfig: LazyAsyncValue<AwsSharedConfig>, activeProfile: LazyAsyncValue<AwsProfile>) {
            super.finalizeEnvironmentalConfig(builder, sharedConfig, activeProfile)
            builder.config.endpointUrl = builder.config.endpointUrl ?: resolveEndpointUrl(
                sharedConfig,
                "Qldb",
                "QLDB",
                "qldb",
            )
        }
    }

    public class Builder internal constructor(): AbstractSdkClientBuilder<Config, Config.Builder, QldbClient>() {
        override val config: Config.Builder = Config.Builder()
        override fun newClient(config: Config): QldbClient = DefaultQldbClient(config)
    }

    public class Config private constructor(builder: Builder) : AwsSdkClientConfig, CredentialsProviderConfig, HttpAuthConfig, HttpClientConfig, HttpEngineConfig by builder.buildHttpEngineConfig(), RetryClientConfig, RetryStrategyClientConfig by builder.buildRetryStrategyClientConfig(), SdkClientConfig, TelemetryConfig, TimeoutConfig {
        override val clientName: String = builder.clientName
        override val region: String? = builder.region ?: runBlocking { builder.regionProvider?.getRegion() ?: resolveRegion() }
        override val regionProvider: RegionProvider = builder.regionProvider ?: DefaultRegionProviderChain()
        override val attemptTimeout: Duration? = builder.attemptTimeout
        override val authSchemePreference: kotlin.collections.List<aws.smithy.kotlin.runtime.auth.AuthSchemeId>? = builder.authSchemePreference
        override val authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = builder.authSchemes
        override val callTimeout: Duration? = builder.callTimeout
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider(httpClient = httpClient, region = region).manage()
        public val endpointProvider: QldbEndpointProvider = builder.endpointProvider ?: DefaultQldbEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        override val logMode: LogMode = builder.logMode ?: LogMode.Default
        override val retryPolicy: RetryPolicy<Any?> = builder.retryPolicy ?: AwsRetryPolicy.Default
        override val telemetryProvider: TelemetryProvider = builder.telemetryProvider ?: TelemetryProvider.Global
        override val useDualStack: Boolean = builder.useDualStack ?: false
        override val useFips: Boolean = builder.useFips ?: false
        override val applicationId: String? = builder.applicationId
        public val authSchemeProvider: QldbAuthSchemeProvider = builder.authSchemeProvider ?: DefaultQldbAuthSchemeProvider(authSchemePreference = authSchemePreference)
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public fun toBuilder(): Builder = Builder().apply {
            clientName = this@Config.clientName
            region = this@Config.region
            regionProvider = this@Config.regionProvider
            attemptTimeout = this@Config.attemptTimeout
            authSchemePreference = this@Config.authSchemePreference
            authSchemes = this@Config.authSchemes
            callTimeout = this@Config.callTimeout
            credentialsProvider = this@Config.credentialsProvider
            endpointProvider = this@Config.endpointProvider
            endpointUrl = this@Config.endpointUrl
            httpClient = this@Config.httpClient
            interceptors = this@Config.interceptors.toMutableList()
            logMode = this@Config.logMode
            retryPolicy = this@Config.retryPolicy
            retryStrategy = this@Config.retryStrategy
            telemetryProvider = this@Config.telemetryProvider
            useDualStack = this@Config.useDualStack
            useFips = this@Config.useFips
            applicationId = this@Config.applicationId
            authSchemeProvider = this@Config.authSchemeProvider
        }

        public class Builder : AwsSdkClientConfig.Builder, CredentialsProviderConfig.Builder, HttpAuthConfig.Builder, HttpClientConfig.Builder, HttpEngineConfig.Builder by HttpEngineConfigImpl.BuilderImpl(), RetryClientConfig.Builder, RetryStrategyClientConfig.Builder by RetryStrategyClientConfigImpl.BuilderImpl(), SdkClientConfig.Builder<Config>, TelemetryConfig.Builder, TimeoutConfig.Builder {
            /**
             * A reader-friendly name for the client.
             */
            override var clientName: String = "QLDB"

            /**
             * The AWS region (e.g. `us-west-2`) to make requests to. See about AWS
             * [global infrastructure](https://aws.amazon.com/about-aws/global-infrastructure/regions_az/) for more information.
             * When specified, this static region configuration takes precedence over other region resolution methods.
             *
             * The region resolution order is:
             * 1. Static region (if specified)
             * 2. Custom region provider (if configured)
             * 3. Default region provider chain
             */
            override var region: String? = null

            /**
             * An optional region provider that determines the AWS region for client operations. When specified, this provider
             * takes precedence over the default region provider chain, unless a static region is explicitly configured.
             *
             * The region resolution order is:
             * 1. Static region (if specified)
             * 2. Custom region provider (if configured)
             * 3. Default region provider chain
             */
            override var regionProvider: RegionProvider? = null

            /**
             * The maximum amount of time to wait for any single attempt of a request within the retry loop. By default,
             * the value is `null` indicating no timeout is enforced. Attempt timeouts may be retried if allowed by the
             * current retry policy and retry capacity.
             */
            override var attemptTimeout: Duration? = null

            /**
             * The ordered preference of [AuthScheme] that this client will use.
             */
            override var authSchemePreference: kotlin.collections.List<aws.smithy.kotlin.runtime.auth.AuthSchemeId>? = null

            /**
             * Register new or override default [AuthScheme]s configured for this client. By default, the set
             * of auth schemes configured comes from the service model. An auth scheme configured explicitly takes
             * precedence over the defaults and can be used to customize identity resolution and signing for specific
             * authentication schemes.
             */
            override var authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = emptyList()

            /**
             * The maximum amount of time to wait for completion of a call, including any retries after the first attempt.
             * By default, the value is `null` indicating no timeout is enforced. Call timeouts are not retried.
             */
            override var callTimeout: Duration? = null

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            override var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint provider used to determine where to make service requests. **This is an advanced config
             * option.**
             *
             * Endpoint resolution occurs as part of the workflow for every request made via the service client.
             *
             * The inputs to endpoint resolution are defined on a per-service basis (see [EndpointParameters]).
             */
            public var endpointProvider: QldbEndpointProvider? = null

            /**
             * A custom endpoint to route requests to. The endpoint set here is passed to the configured
             * [endpointProvider], which may inspect and modify it as needed.
             *
             * Setting a custom endpointUrl should generally be preferred to overriding the [endpointProvider] and is
             * the recommended way to route requests to development or preview instances of a service.
             *
             * **This is an advanced config option.**
             */
            public var endpointUrl: Url? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            override var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            override var logMode: LogMode? = null

            /**
             * The policy to use for evaluating operation results and determining whether/how to retry.
             */
            override var retryPolicy: RetryPolicy<Any?>? = null

            /**
             * The telemetry provider used to instrument the SDK operations with. By default, the global telemetry
             * provider will be used.
             */
            override var telemetryProvider: TelemetryProvider? = null

            /**
             *            Flag to toggle whether to use dual-stack endpoints when making requests.
             *            See [https://docs.aws.amazon.com/sdkref/latest/guide/feature-endpoints.html] for more information.
             * `          Disabled by default.
             */
            override var useDualStack: Boolean? = null

            /**
             *            Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             * `          Disabled by default.
             */
            override var useFips: Boolean? = null

            /**
             * An optional application specific identifier.
             * When set it will be appended to the User-Agent header of every request in the form of: `app/{applicationId}`.
             * When not explicitly set, the value will be loaded from the following locations:
             *
             * - JVM System Property: `aws.userAgentAppId`
             * - Environment variable: `AWS_SDK_UA_APP_ID`
             * - Shared configuration profile attribute: `sdk_ua_app_id`
             *
             * See [shared configuration settings](https://docs.aws.amazon.com/sdkref/latest/guide/settings-reference.html)
             * reference for more information on environment variables and shared config settings.
             */
            override var applicationId: String? = null

            /**
             * Configure the provider used to resolve the authentication scheme to use for a particular operation.
             */
            public var authSchemeProvider: QldbAuthSchemeProvider? = null

            override fun build(): Config = Config(this)
        }
    }

    /**
     * Ends a given Amazon QLDB journal stream. Before a stream can be canceled, its current status must be `ACTIVE`.
     *
     * You can't restart a stream after you cancel it. Canceled QLDB stream resources are subject to a 7-day retention period, so they are automatically deleted after this limit expires.
     */
    public suspend fun cancelJournalKinesisStream(input: CancelJournalKinesisStreamRequest): CancelJournalKinesisStreamResponse

    /**
     * Creates a new ledger in your Amazon Web Services account in the current Region.
     */
    public suspend fun createLedger(input: CreateLedgerRequest): CreateLedgerResponse

    /**
     * Deletes a ledger and all of its contents. This action is irreversible.
     *
     * If deletion protection is enabled, you must first disable it before you can delete the ledger. You can disable it by calling the `UpdateLedger` operation to set this parameter to `false`.
     */
    public suspend fun deleteLedger(input: DeleteLedgerRequest): DeleteLedgerResponse

    /**
     * Returns detailed information about a given Amazon QLDB journal stream. The output includes the Amazon Resource Name (ARN), stream name, current status, creation time, and the parameters of the original stream creation request.
     *
     * This action does not return any expired journal streams. For more information, see [Expiration for terminal streams](https://docs.aws.amazon.com/qldb/latest/developerguide/streams.create.html#streams.create.states.expiration) in the *Amazon QLDB Developer Guide*.
     */
    public suspend fun describeJournalKinesisStream(input: DescribeJournalKinesisStreamRequest): DescribeJournalKinesisStreamResponse

    /**
     * Returns information about a journal export job, including the ledger name, export ID, creation time, current status, and the parameters of the original export creation request.
     *
     * This action does not return any expired export jobs. For more information, see [Export job expiration](https://docs.aws.amazon.com/qldb/latest/developerguide/export-journal.request.html#export-journal.request.expiration) in the *Amazon QLDB Developer Guide*.
     *
     * If the export job with the given `ExportId` doesn't exist, then throws `ResourceNotFoundException`.
     *
     * If the ledger with the given `Name` doesn't exist, then throws `ResourceNotFoundException`.
     */
    public suspend fun describeJournalS3Export(input: DescribeJournalS3ExportRequest): DescribeJournalS3ExportResponse

    /**
     * Returns information about a ledger, including its state, permissions mode, encryption at rest settings, and when it was created.
     */
    public suspend fun describeLedger(input: DescribeLedgerRequest): DescribeLedgerResponse

    /**
     * Exports journal contents within a date and time range from a ledger into a specified Amazon Simple Storage Service (Amazon S3) bucket. A journal export job can write the data objects in either the text or binary representation of Amazon Ion format, or in *JSON Lines* text format.
     *
     * If the ledger with the given `Name` doesn't exist, then throws `ResourceNotFoundException`.
     *
     * If the ledger with the given `Name` is in `CREATING` status, then throws `ResourcePreconditionNotMetException`.
     *
     * You can initiate up to two concurrent journal export requests for each ledger. Beyond this limit, journal export requests throw `LimitExceededException`.
     */
    public suspend fun exportJournalToS3(input: ExportJournalToS3Request): ExportJournalToS3Response

    /**
     * Returns a block object at a specified address in a journal. Also returns a proof of the specified block for verification if `DigestTipAddress` is provided.
     *
     * For information about the data contents in a block, see [Journal contents](https://docs.aws.amazon.com/qldb/latest/developerguide/journal-contents.html) in the *Amazon QLDB Developer Guide*.
     *
     * If the specified ledger doesn't exist or is in `DELETING` status, then throws `ResourceNotFoundException`.
     *
     * If the specified ledger is in `CREATING` status, then throws `ResourcePreconditionNotMetException`.
     *
     * If no block exists with the specified address, then throws `InvalidParameterException`.
     */
    public suspend fun getBlock(input: GetBlockRequest): GetBlockResponse

    /**
     * Returns the digest of a ledger at the latest committed block in the journal. The response includes a 256-bit hash value and a block address.
     */
    public suspend fun getDigest(input: GetDigestRequest): GetDigestResponse

    /**
     * Returns a revision data object for a specified document ID and block address. Also returns a proof of the specified revision for verification if `DigestTipAddress` is provided.
     */
    public suspend fun getRevision(input: GetRevisionRequest): GetRevisionResponse

    /**
     * Returns all Amazon QLDB journal streams for a given ledger.
     *
     * This action does not return any expired journal streams. For more information, see [Expiration for terminal streams](https://docs.aws.amazon.com/qldb/latest/developerguide/streams.create.html#streams.create.states.expiration) in the *Amazon QLDB Developer Guide*.
     *
     * This action returns a maximum of `MaxResults` items. It is paginated so that you can retrieve all the items by calling `ListJournalKinesisStreamsForLedger` multiple times.
     */
    public suspend fun listJournalKinesisStreamsForLedger(input: ListJournalKinesisStreamsForLedgerRequest): ListJournalKinesisStreamsForLedgerResponse

    /**
     * Returns all journal export jobs for all ledgers that are associated with the current Amazon Web Services account and Region.
     *
     * This action returns a maximum of `MaxResults` items, and is paginated so that you can retrieve all the items by calling `ListJournalS3Exports` multiple times.
     *
     * This action does not return any expired export jobs. For more information, see [Export job expiration](https://docs.aws.amazon.com/qldb/latest/developerguide/export-journal.request.html#export-journal.request.expiration) in the *Amazon QLDB Developer Guide*.
     */
    public suspend fun listJournalS3Exports(input: ListJournalS3ExportsRequest = ListJournalS3ExportsRequest { }): ListJournalS3ExportsResponse

    /**
     * Returns all journal export jobs for a specified ledger.
     *
     * This action returns a maximum of `MaxResults` items, and is paginated so that you can retrieve all the items by calling `ListJournalS3ExportsForLedger` multiple times.
     *
     * This action does not return any expired export jobs. For more information, see [Export job expiration](https://docs.aws.amazon.com/qldb/latest/developerguide/export-journal.request.html#export-journal.request.expiration) in the *Amazon QLDB Developer Guide*.
     */
    public suspend fun listJournalS3ExportsForLedger(input: ListJournalS3ExportsForLedgerRequest): ListJournalS3ExportsForLedgerResponse

    /**
     * Returns all ledgers that are associated with the current Amazon Web Services account and Region.
     *
     * This action returns a maximum of `MaxResults` items and is paginated so that you can retrieve all the items by calling `ListLedgers` multiple times.
     */
    public suspend fun listLedgers(input: ListLedgersRequest = ListLedgersRequest { }): ListLedgersResponse

    /**
     * Returns all tags for a specified Amazon QLDB resource.
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Creates a journal stream for a given Amazon QLDB ledger. The stream captures every document revision that is committed to the ledger's journal and delivers the data to a specified Amazon Kinesis Data Streams resource.
     */
    public suspend fun streamJournalToKinesis(input: StreamJournalToKinesisRequest): StreamJournalToKinesisResponse

    /**
     * Adds one or more tags to a specified Amazon QLDB resource.
     *
     * A resource can have up to 50 tags. If you try to create more than 50 tags for a resource, your request fails and returns an error.
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Removes one or more tags from a specified Amazon QLDB resource. You can specify up to 50 tag keys to remove.
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Updates properties on a ledger.
     */
    public suspend fun updateLedger(input: UpdateLedgerRequest): UpdateLedgerResponse

    /**
     * Updates the permissions mode of a ledger.
     *
     * Before you switch to the `STANDARD` permissions mode, you must first create all required IAM policies and table tags to avoid disruption to your users. To learn more, see [Migrating to the standard permissions mode](https://docs.aws.amazon.com/qldb/latest/developerguide/ledger-management.basics.html#ledger-mgmt.basics.update-permissions.migrating) in the *Amazon QLDB Developer Guide*.
     */
    public suspend fun updateLedgerPermissionsMode(input: UpdateLedgerPermissionsModeRequest): UpdateLedgerPermissionsModeResponse
}

/**
 * Create a copy of the client with one or more configuration values overridden.
 * This method allows the caller to perform scoped config overrides for one or more client operations.
 *
 * Any resources created on your behalf will be shared between clients, and will only be closed when ALL clients using them are closed.
 * If you provide a resource (e.g. [HttpClientEngine]) to the SDK, you are responsible for managing the lifetime of that resource.
 */
public fun QldbClient.withConfig(block: QldbClient.Config.Builder.() -> Unit): QldbClient {
    val newConfig = config.toBuilder().apply(block).build()
    return DefaultQldbClient(newConfig)
}

/**
 * Ends a given Amazon QLDB journal stream. Before a stream can be canceled, its current status must be `ACTIVE`.
 *
 * You can't restart a stream after you cancel it. Canceled QLDB stream resources are subject to a 7-day retention period, so they are automatically deleted after this limit expires.
 */
public suspend inline fun QldbClient.cancelJournalKinesisStream(crossinline block: CancelJournalKinesisStreamRequest.Builder.() -> Unit): CancelJournalKinesisStreamResponse = cancelJournalKinesisStream(CancelJournalKinesisStreamRequest.Builder().apply(block).build())

/**
 * Creates a new ledger in your Amazon Web Services account in the current Region.
 */
public suspend inline fun QldbClient.createLedger(crossinline block: CreateLedgerRequest.Builder.() -> Unit): CreateLedgerResponse = createLedger(CreateLedgerRequest.Builder().apply(block).build())

/**
 * Deletes a ledger and all of its contents. This action is irreversible.
 *
 * If deletion protection is enabled, you must first disable it before you can delete the ledger. You can disable it by calling the `UpdateLedger` operation to set this parameter to `false`.
 */
public suspend inline fun QldbClient.deleteLedger(crossinline block: DeleteLedgerRequest.Builder.() -> Unit): DeleteLedgerResponse = deleteLedger(DeleteLedgerRequest.Builder().apply(block).build())

/**
 * Returns detailed information about a given Amazon QLDB journal stream. The output includes the Amazon Resource Name (ARN), stream name, current status, creation time, and the parameters of the original stream creation request.
 *
 * This action does not return any expired journal streams. For more information, see [Expiration for terminal streams](https://docs.aws.amazon.com/qldb/latest/developerguide/streams.create.html#streams.create.states.expiration) in the *Amazon QLDB Developer Guide*.
 */
public suspend inline fun QldbClient.describeJournalKinesisStream(crossinline block: DescribeJournalKinesisStreamRequest.Builder.() -> Unit): DescribeJournalKinesisStreamResponse = describeJournalKinesisStream(DescribeJournalKinesisStreamRequest.Builder().apply(block).build())

/**
 * Returns information about a journal export job, including the ledger name, export ID, creation time, current status, and the parameters of the original export creation request.
 *
 * This action does not return any expired export jobs. For more information, see [Export job expiration](https://docs.aws.amazon.com/qldb/latest/developerguide/export-journal.request.html#export-journal.request.expiration) in the *Amazon QLDB Developer Guide*.
 *
 * If the export job with the given `ExportId` doesn't exist, then throws `ResourceNotFoundException`.
 *
 * If the ledger with the given `Name` doesn't exist, then throws `ResourceNotFoundException`.
 */
public suspend inline fun QldbClient.describeJournalS3Export(crossinline block: DescribeJournalS3ExportRequest.Builder.() -> Unit): DescribeJournalS3ExportResponse = describeJournalS3Export(DescribeJournalS3ExportRequest.Builder().apply(block).build())

/**
 * Returns information about a ledger, including its state, permissions mode, encryption at rest settings, and when it was created.
 */
public suspend inline fun QldbClient.describeLedger(crossinline block: DescribeLedgerRequest.Builder.() -> Unit): DescribeLedgerResponse = describeLedger(DescribeLedgerRequest.Builder().apply(block).build())

/**
 * Exports journal contents within a date and time range from a ledger into a specified Amazon Simple Storage Service (Amazon S3) bucket. A journal export job can write the data objects in either the text or binary representation of Amazon Ion format, or in *JSON Lines* text format.
 *
 * If the ledger with the given `Name` doesn't exist, then throws `ResourceNotFoundException`.
 *
 * If the ledger with the given `Name` is in `CREATING` status, then throws `ResourcePreconditionNotMetException`.
 *
 * You can initiate up to two concurrent journal export requests for each ledger. Beyond this limit, journal export requests throw `LimitExceededException`.
 */
public suspend inline fun QldbClient.exportJournalToS3(crossinline block: ExportJournalToS3Request.Builder.() -> Unit): ExportJournalToS3Response = exportJournalToS3(ExportJournalToS3Request.Builder().apply(block).build())

/**
 * Returns a block object at a specified address in a journal. Also returns a proof of the specified block for verification if `DigestTipAddress` is provided.
 *
 * For information about the data contents in a block, see [Journal contents](https://docs.aws.amazon.com/qldb/latest/developerguide/journal-contents.html) in the *Amazon QLDB Developer Guide*.
 *
 * If the specified ledger doesn't exist or is in `DELETING` status, then throws `ResourceNotFoundException`.
 *
 * If the specified ledger is in `CREATING` status, then throws `ResourcePreconditionNotMetException`.
 *
 * If no block exists with the specified address, then throws `InvalidParameterException`.
 */
public suspend inline fun QldbClient.getBlock(crossinline block: GetBlockRequest.Builder.() -> Unit): GetBlockResponse = getBlock(GetBlockRequest.Builder().apply(block).build())

/**
 * Returns the digest of a ledger at the latest committed block in the journal. The response includes a 256-bit hash value and a block address.
 */
public suspend inline fun QldbClient.getDigest(crossinline block: GetDigestRequest.Builder.() -> Unit): GetDigestResponse = getDigest(GetDigestRequest.Builder().apply(block).build())

/**
 * Returns a revision data object for a specified document ID and block address. Also returns a proof of the specified revision for verification if `DigestTipAddress` is provided.
 */
public suspend inline fun QldbClient.getRevision(crossinline block: GetRevisionRequest.Builder.() -> Unit): GetRevisionResponse = getRevision(GetRevisionRequest.Builder().apply(block).build())

/**
 * Returns all Amazon QLDB journal streams for a given ledger.
 *
 * This action does not return any expired journal streams. For more information, see [Expiration for terminal streams](https://docs.aws.amazon.com/qldb/latest/developerguide/streams.create.html#streams.create.states.expiration) in the *Amazon QLDB Developer Guide*.
 *
 * This action returns a maximum of `MaxResults` items. It is paginated so that you can retrieve all the items by calling `ListJournalKinesisStreamsForLedger` multiple times.
 */
public suspend inline fun QldbClient.listJournalKinesisStreamsForLedger(crossinline block: ListJournalKinesisStreamsForLedgerRequest.Builder.() -> Unit): ListJournalKinesisStreamsForLedgerResponse = listJournalKinesisStreamsForLedger(ListJournalKinesisStreamsForLedgerRequest.Builder().apply(block).build())

/**
 * Returns all journal export jobs for all ledgers that are associated with the current Amazon Web Services account and Region.
 *
 * This action returns a maximum of `MaxResults` items, and is paginated so that you can retrieve all the items by calling `ListJournalS3Exports` multiple times.
 *
 * This action does not return any expired export jobs. For more information, see [Export job expiration](https://docs.aws.amazon.com/qldb/latest/developerguide/export-journal.request.html#export-journal.request.expiration) in the *Amazon QLDB Developer Guide*.
 */
public suspend inline fun QldbClient.listJournalS3Exports(crossinline block: ListJournalS3ExportsRequest.Builder.() -> Unit): ListJournalS3ExportsResponse = listJournalS3Exports(ListJournalS3ExportsRequest.Builder().apply(block).build())

/**
 * Returns all journal export jobs for a specified ledger.
 *
 * This action returns a maximum of `MaxResults` items, and is paginated so that you can retrieve all the items by calling `ListJournalS3ExportsForLedger` multiple times.
 *
 * This action does not return any expired export jobs. For more information, see [Export job expiration](https://docs.aws.amazon.com/qldb/latest/developerguide/export-journal.request.html#export-journal.request.expiration) in the *Amazon QLDB Developer Guide*.
 */
public suspend inline fun QldbClient.listJournalS3ExportsForLedger(crossinline block: ListJournalS3ExportsForLedgerRequest.Builder.() -> Unit): ListJournalS3ExportsForLedgerResponse = listJournalS3ExportsForLedger(ListJournalS3ExportsForLedgerRequest.Builder().apply(block).build())

/**
 * Returns all ledgers that are associated with the current Amazon Web Services account and Region.
 *
 * This action returns a maximum of `MaxResults` items and is paginated so that you can retrieve all the items by calling `ListLedgers` multiple times.
 */
public suspend inline fun QldbClient.listLedgers(crossinline block: ListLedgersRequest.Builder.() -> Unit): ListLedgersResponse = listLedgers(ListLedgersRequest.Builder().apply(block).build())

/**
 * Returns all tags for a specified Amazon QLDB resource.
 */
public suspend inline fun QldbClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Creates a journal stream for a given Amazon QLDB ledger. The stream captures every document revision that is committed to the ledger's journal and delivers the data to a specified Amazon Kinesis Data Streams resource.
 */
public suspend inline fun QldbClient.streamJournalToKinesis(crossinline block: StreamJournalToKinesisRequest.Builder.() -> Unit): StreamJournalToKinesisResponse = streamJournalToKinesis(StreamJournalToKinesisRequest.Builder().apply(block).build())

/**
 * Adds one or more tags to a specified Amazon QLDB resource.
 *
 * A resource can have up to 50 tags. If you try to create more than 50 tags for a resource, your request fails and returns an error.
 */
public suspend inline fun QldbClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Removes one or more tags from a specified Amazon QLDB resource. You can specify up to 50 tag keys to remove.
 */
public suspend inline fun QldbClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * Updates properties on a ledger.
 */
public suspend inline fun QldbClient.updateLedger(crossinline block: UpdateLedgerRequest.Builder.() -> Unit): UpdateLedgerResponse = updateLedger(UpdateLedgerRequest.Builder().apply(block).build())

/**
 * Updates the permissions mode of a ledger.
 *
 * Before you switch to the `STANDARD` permissions mode, you must first create all required IAM policies and table tags to avoid disruption to your users. To learn more, see [Migrating to the standard permissions mode](https://docs.aws.amazon.com/qldb/latest/developerguide/ledger-management.basics.html#ledger-mgmt.basics.update-permissions.migrating) in the *Amazon QLDB Developer Guide*.
 */
public suspend inline fun QldbClient.updateLedgerPermissionsMode(crossinline block: UpdateLedgerPermissionsModeRequest.Builder.() -> Unit): UpdateLedgerPermissionsModeResponse = updateLedgerPermissionsMode(UpdateLedgerPermissionsModeRequest.Builder().apply(block).build())
