// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.qldb.serde

import aws.sdk.kotlin.services.qldb.model.ExportJournalToS3Response
import aws.sdk.kotlin.services.qldb.model.QldbException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class ExportJournalToS3OperationDeserializer: HttpDeserializer.NonStreaming<ExportJournalToS3Response> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): ExportJournalToS3Response {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwExportJournalToS3Error(context, call, payload)
        }
        val builder = ExportJournalToS3Response.Builder()

        if (payload != null) {
            deserializeExportJournalToS3OperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwExportJournalToS3Error(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw QldbException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourcePreconditionNotMetException" -> ResourcePreconditionNotMetExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> QldbException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeExportJournalToS3OperationBody(builder: ExportJournalToS3Response.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val EXPORTID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("ExportId"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(EXPORTID_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                EXPORTID_DESCRIPTOR.index -> builder.exportId = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
