// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.qldb.model

import aws.smithy.kotlin.runtime.SdkDsl

public class UpdateLedgerRequest private constructor(builder: Builder) {
    /**
     * Specifies whether the ledger is protected from being deleted by any user. If not defined during ledger creation, this feature is enabled (`true`) by default.
     *
     * If deletion protection is enabled, you must first disable it before you can delete the ledger. You can disable it by calling the `UpdateLedger` operation to set this parameter to `false`.
     */
    public val deletionProtection: kotlin.Boolean? = builder.deletionProtection
    /**
     * The key in Key Management Service (KMS) to use for encryption of data at rest in the ledger. For more information, see [Encryption at rest](https://docs.aws.amazon.com/qldb/latest/developerguide/encryption-at-rest.html) in the *Amazon QLDB Developer Guide*.
     *
     * Use one of the following options to specify this parameter:
     * + `AWS_OWNED_KMS_KEY`: Use an KMS key that is owned and managed by Amazon Web Services on your behalf.
     * + **Undefined**: Make no changes to the KMS key of the ledger.
     * + **A valid symmetric customer managed KMS key**: Use the specified symmetric encryption KMS key in your account that you create, own, and manage.Amazon QLDB does not support asymmetric keys. For more information, see [Using symmetric and asymmetric keys](https://docs.aws.amazon.com/kms/latest/developerguide/symmetric-asymmetric.html) in the *Key Management Service Developer Guide*.
     *
     * To specify a customer managed KMS key, you can use its key ID, Amazon Resource Name (ARN), alias name, or alias ARN. When using an alias name, prefix it with `"alias/"`. To specify a key in a different Amazon Web Services account, you must use the key ARN or alias ARN.
     *
     * For example:
     * + Key ID: `1234abcd-12ab-34cd-56ef-1234567890ab`
     * + Key ARN: `arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab`
     * + Alias name: `alias/ExampleAlias`
     * + Alias ARN: `arn:aws:kms:us-east-2:111122223333:alias/ExampleAlias`
     *
     * For more information, see [Key identifiers (KeyId)](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id) in the *Key Management Service Developer Guide*.
     */
    public val kmsKey: kotlin.String? = builder.kmsKey
    /**
     * The name of the ledger.
     */
    public val name: kotlin.String? = builder.name

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.qldb.model.UpdateLedgerRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateLedgerRequest(")
        append("deletionProtection=$deletionProtection,")
        append("kmsKey=$kmsKey,")
        append("name=$name")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = deletionProtection?.hashCode() ?: 0
        result = 31 * result + (kmsKey?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateLedgerRequest

        if (deletionProtection != other.deletionProtection) return false
        if (kmsKey != other.kmsKey) return false
        if (name != other.name) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.qldb.model.UpdateLedgerRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Specifies whether the ledger is protected from being deleted by any user. If not defined during ledger creation, this feature is enabled (`true`) by default.
         *
         * If deletion protection is enabled, you must first disable it before you can delete the ledger. You can disable it by calling the `UpdateLedger` operation to set this parameter to `false`.
         */
        public var deletionProtection: kotlin.Boolean? = null
        /**
         * The key in Key Management Service (KMS) to use for encryption of data at rest in the ledger. For more information, see [Encryption at rest](https://docs.aws.amazon.com/qldb/latest/developerguide/encryption-at-rest.html) in the *Amazon QLDB Developer Guide*.
         *
         * Use one of the following options to specify this parameter:
         * + `AWS_OWNED_KMS_KEY`: Use an KMS key that is owned and managed by Amazon Web Services on your behalf.
         * + **Undefined**: Make no changes to the KMS key of the ledger.
         * + **A valid symmetric customer managed KMS key**: Use the specified symmetric encryption KMS key in your account that you create, own, and manage.Amazon QLDB does not support asymmetric keys. For more information, see [Using symmetric and asymmetric keys](https://docs.aws.amazon.com/kms/latest/developerguide/symmetric-asymmetric.html) in the *Key Management Service Developer Guide*.
         *
         * To specify a customer managed KMS key, you can use its key ID, Amazon Resource Name (ARN), alias name, or alias ARN. When using an alias name, prefix it with `"alias/"`. To specify a key in a different Amazon Web Services account, you must use the key ARN or alias ARN.
         *
         * For example:
         * + Key ID: `1234abcd-12ab-34cd-56ef-1234567890ab`
         * + Key ARN: `arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab`
         * + Alias name: `alias/ExampleAlias`
         * + Alias ARN: `arn:aws:kms:us-east-2:111122223333:alias/ExampleAlias`
         *
         * For more information, see [Key identifiers (KeyId)](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#key-id) in the *Key Management Service Developer Guide*.
         */
        public var kmsKey: kotlin.String? = null
        /**
         * The name of the ledger.
         */
        public var name: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.qldb.model.UpdateLedgerRequest) : this() {
            this.deletionProtection = x.deletionProtection
            this.kmsKey = x.kmsKey
            this.name = x.name
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.qldb.model.UpdateLedgerRequest = UpdateLedgerRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
