// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.qldb.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

public class StreamJournalToKinesisRequest private constructor(builder: Builder) {
    /**
     * The exclusive date and time that specifies when the stream ends. If you don't define this parameter, the stream runs indefinitely until you cancel it.
     *
     * The `ExclusiveEndTime` must be in `ISO 8601` date and time format and in Universal Coordinated Time (UTC). For example: `2019-06-13T21:36:34Z`.
     */
    public val exclusiveEndTime: aws.smithy.kotlin.runtime.time.Instant? = builder.exclusiveEndTime
    /**
     * The inclusive start date and time from which to start streaming journal data. This parameter must be in `ISO 8601` date and time format and in Universal Coordinated Time (UTC). For example: `2019-06-13T21:36:34Z`.
     *
     * The `InclusiveStartTime` cannot be in the future and must be before `ExclusiveEndTime`.
     *
     * If you provide an `InclusiveStartTime` that is before the ledger's `CreationDateTime`, QLDB effectively defaults it to the ledger's `CreationDateTime`.
     */
    public val inclusiveStartTime: aws.smithy.kotlin.runtime.time.Instant? = builder.inclusiveStartTime
    /**
     * The configuration settings of the Kinesis Data Streams destination for your stream request.
     */
    public val kinesisConfiguration: aws.sdk.kotlin.services.qldb.model.KinesisConfiguration? = builder.kinesisConfiguration
    /**
     * The name of the ledger.
     */
    public val ledgerName: kotlin.String? = builder.ledgerName
    /**
     * The Amazon Resource Name (ARN) of the IAM role that grants QLDB permissions for a journal stream to write data records to a Kinesis Data Streams resource.
     *
     * To pass a role to QLDB when requesting a journal stream, you must have permissions to perform the `iam:PassRole` action on the IAM role resource. This is required for all journal stream requests.
     */
    public val roleArn: kotlin.String? = builder.roleArn
    /**
     * The name that you want to assign to the QLDB journal stream. User-defined names can help identify and indicate the purpose of a stream.
     *
     * Your stream name must be unique among other *active* streams for a given ledger. Stream names have the same naming constraints as ledger names, as defined in [Quotas in Amazon QLDB](https://docs.aws.amazon.com/qldb/latest/developerguide/limits.html#limits.naming) in the *Amazon QLDB Developer Guide*.
     */
    public val streamName: kotlin.String? = builder.streamName
    /**
     * The key-value pairs to add as tags to the stream that you want to create. Tag keys are case sensitive. Tag values are case sensitive and can be null.
     */
    public val tags: Map<String, String?>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.qldb.model.StreamJournalToKinesisRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("StreamJournalToKinesisRequest(")
        append("exclusiveEndTime=$exclusiveEndTime,")
        append("inclusiveStartTime=$inclusiveStartTime,")
        append("kinesisConfiguration=$kinesisConfiguration,")
        append("ledgerName=$ledgerName,")
        append("roleArn=$roleArn,")
        append("streamName=$streamName,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = exclusiveEndTime?.hashCode() ?: 0
        result = 31 * result + (inclusiveStartTime?.hashCode() ?: 0)
        result = 31 * result + (kinesisConfiguration?.hashCode() ?: 0)
        result = 31 * result + (ledgerName?.hashCode() ?: 0)
        result = 31 * result + (roleArn?.hashCode() ?: 0)
        result = 31 * result + (streamName?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as StreamJournalToKinesisRequest

        if (exclusiveEndTime != other.exclusiveEndTime) return false
        if (inclusiveStartTime != other.inclusiveStartTime) return false
        if (kinesisConfiguration != other.kinesisConfiguration) return false
        if (ledgerName != other.ledgerName) return false
        if (roleArn != other.roleArn) return false
        if (streamName != other.streamName) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.qldb.model.StreamJournalToKinesisRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The exclusive date and time that specifies when the stream ends. If you don't define this parameter, the stream runs indefinitely until you cancel it.
         *
         * The `ExclusiveEndTime` must be in `ISO 8601` date and time format and in Universal Coordinated Time (UTC). For example: `2019-06-13T21:36:34Z`.
         */
        public var exclusiveEndTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The inclusive start date and time from which to start streaming journal data. This parameter must be in `ISO 8601` date and time format and in Universal Coordinated Time (UTC). For example: `2019-06-13T21:36:34Z`.
         *
         * The `InclusiveStartTime` cannot be in the future and must be before `ExclusiveEndTime`.
         *
         * If you provide an `InclusiveStartTime` that is before the ledger's `CreationDateTime`, QLDB effectively defaults it to the ledger's `CreationDateTime`.
         */
        public var inclusiveStartTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The configuration settings of the Kinesis Data Streams destination for your stream request.
         */
        public var kinesisConfiguration: aws.sdk.kotlin.services.qldb.model.KinesisConfiguration? = null
        /**
         * The name of the ledger.
         */
        public var ledgerName: kotlin.String? = null
        /**
         * The Amazon Resource Name (ARN) of the IAM role that grants QLDB permissions for a journal stream to write data records to a Kinesis Data Streams resource.
         *
         * To pass a role to QLDB when requesting a journal stream, you must have permissions to perform the `iam:PassRole` action on the IAM role resource. This is required for all journal stream requests.
         */
        public var roleArn: kotlin.String? = null
        /**
         * The name that you want to assign to the QLDB journal stream. User-defined names can help identify and indicate the purpose of a stream.
         *
         * Your stream name must be unique among other *active* streams for a given ledger. Stream names have the same naming constraints as ledger names, as defined in [Quotas in Amazon QLDB](https://docs.aws.amazon.com/qldb/latest/developerguide/limits.html#limits.naming) in the *Amazon QLDB Developer Guide*.
         */
        public var streamName: kotlin.String? = null
        /**
         * The key-value pairs to add as tags to the stream that you want to create. Tag keys are case sensitive. Tag values are case sensitive and can be null.
         */
        public var tags: Map<String, String?>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.qldb.model.StreamJournalToKinesisRequest) : this() {
            this.exclusiveEndTime = x.exclusiveEndTime
            this.inclusiveStartTime = x.inclusiveStartTime
            this.kinesisConfiguration = x.kinesisConfiguration
            this.ledgerName = x.ledgerName
            this.roleArn = x.roleArn
            this.streamName = x.streamName
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.qldb.model.StreamJournalToKinesisRequest = StreamJournalToKinesisRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.qldb.model.KinesisConfiguration] inside the given [block]
         */
        public fun kinesisConfiguration(block: aws.sdk.kotlin.services.qldb.model.KinesisConfiguration.Builder.() -> kotlin.Unit) {
            this.kinesisConfiguration = aws.sdk.kotlin.services.qldb.model.KinesisConfiguration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
