// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.qldb.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The Amazon Simple Storage Service (Amazon S3) bucket location in which a journal export job writes the journal contents.
 */
public class S3ExportConfiguration private constructor(builder: Builder) {
    /**
     * The Amazon S3 bucket name in which a journal export job writes the journal contents.
     *
     * The bucket name must comply with the Amazon S3 bucket naming conventions. For more information, see [Bucket Restrictions and Limitations](https://docs.aws.amazon.com/AmazonS3/latest/dev/BucketRestrictions.html) in the *Amazon S3 Developer Guide*.
     */
    public val bucket: kotlin.String = requireNotNull(builder.bucket) { "A non-null value must be provided for bucket" }
    /**
     * The encryption settings that are used by a journal export job to write data in an Amazon S3 bucket.
     */
    public val encryptionConfiguration: aws.sdk.kotlin.services.qldb.model.S3EncryptionConfiguration? = builder.encryptionConfiguration
    /**
     * The prefix for the Amazon S3 bucket in which a journal export job writes the journal contents.
     *
     * The prefix must comply with Amazon S3 key naming rules and restrictions. For more information, see [Object Key and Metadata](https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingMetadata.html) in the *Amazon S3 Developer Guide*.
     *
     * The following are examples of valid `Prefix` values:
     * + `JournalExports-ForMyLedger/Testing/`
     * + `JournalExports`
     * + `My:Tests/`
     */
    public val prefix: kotlin.String = requireNotNull(builder.prefix) { "A non-null value must be provided for prefix" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.qldb.model.S3ExportConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("S3ExportConfiguration(")
        append("bucket=$bucket,")
        append("encryptionConfiguration=$encryptionConfiguration,")
        append("prefix=$prefix")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = bucket.hashCode()
        result = 31 * result + (encryptionConfiguration?.hashCode() ?: 0)
        result = 31 * result + (prefix.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as S3ExportConfiguration

        if (bucket != other.bucket) return false
        if (encryptionConfiguration != other.encryptionConfiguration) return false
        if (prefix != other.prefix) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.qldb.model.S3ExportConfiguration = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon S3 bucket name in which a journal export job writes the journal contents.
         *
         * The bucket name must comply with the Amazon S3 bucket naming conventions. For more information, see [Bucket Restrictions and Limitations](https://docs.aws.amazon.com/AmazonS3/latest/dev/BucketRestrictions.html) in the *Amazon S3 Developer Guide*.
         */
        public var bucket: kotlin.String? = null
        /**
         * The encryption settings that are used by a journal export job to write data in an Amazon S3 bucket.
         */
        public var encryptionConfiguration: aws.sdk.kotlin.services.qldb.model.S3EncryptionConfiguration? = null
        /**
         * The prefix for the Amazon S3 bucket in which a journal export job writes the journal contents.
         *
         * The prefix must comply with Amazon S3 key naming rules and restrictions. For more information, see [Object Key and Metadata](https://docs.aws.amazon.com/AmazonS3/latest/dev/UsingMetadata.html) in the *Amazon S3 Developer Guide*.
         *
         * The following are examples of valid `Prefix` values:
         * + `JournalExports-ForMyLedger/Testing/`
         * + `JournalExports`
         * + `My:Tests/`
         */
        public var prefix: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.qldb.model.S3ExportConfiguration) : this() {
            this.bucket = x.bucket
            this.encryptionConfiguration = x.encryptionConfiguration
            this.prefix = x.prefix
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.qldb.model.S3ExportConfiguration = S3ExportConfiguration(this)

        /**
         * construct an [aws.sdk.kotlin.services.qldb.model.S3EncryptionConfiguration] inside the given [block]
         */
        public fun encryptionConfiguration(block: aws.sdk.kotlin.services.qldb.model.S3EncryptionConfiguration.Builder.() -> kotlin.Unit) {
            this.encryptionConfiguration = aws.sdk.kotlin.services.qldb.model.S3EncryptionConfiguration.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (bucket == null) bucket = ""
            if (prefix == null) prefix = ""
            return this
        }
    }
}
