// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.qldb.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The configuration settings of the Amazon Kinesis Data Streams destination for an Amazon QLDB journal stream.
 */
public class KinesisConfiguration private constructor(builder: Builder) {
    /**
     * Enables QLDB to publish multiple data records in a single Kinesis Data Streams record, increasing the number of records sent per API call.
     *
     * Default: `True`
     *
     * Record aggregation has important implications for processing records and requires de-aggregation in your stream consumer. To learn more, see [KPL Key Concepts](https://docs.aws.amazon.com/streams/latest/dev/kinesis-kpl-concepts.html) and [Consumer De-aggregation](https://docs.aws.amazon.com/streams/latest/dev/kinesis-kpl-consumer-deaggregation.html) in the *Amazon Kinesis Data Streams Developer Guide*.
     */
    public val aggregationEnabled: kotlin.Boolean? = builder.aggregationEnabled
    /**
     * The Amazon Resource Name (ARN) of the Kinesis Data Streams resource.
     */
    public val streamArn: kotlin.String = requireNotNull(builder.streamArn) { "A non-null value must be provided for streamArn" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.qldb.model.KinesisConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("KinesisConfiguration(")
        append("aggregationEnabled=$aggregationEnabled,")
        append("streamArn=$streamArn")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = aggregationEnabled?.hashCode() ?: 0
        result = 31 * result + (streamArn.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as KinesisConfiguration

        if (aggregationEnabled != other.aggregationEnabled) return false
        if (streamArn != other.streamArn) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.qldb.model.KinesisConfiguration = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Enables QLDB to publish multiple data records in a single Kinesis Data Streams record, increasing the number of records sent per API call.
         *
         * Default: `True`
         *
         * Record aggregation has important implications for processing records and requires de-aggregation in your stream consumer. To learn more, see [KPL Key Concepts](https://docs.aws.amazon.com/streams/latest/dev/kinesis-kpl-concepts.html) and [Consumer De-aggregation](https://docs.aws.amazon.com/streams/latest/dev/kinesis-kpl-consumer-deaggregation.html) in the *Amazon Kinesis Data Streams Developer Guide*.
         */
        public var aggregationEnabled: kotlin.Boolean? = null
        /**
         * The Amazon Resource Name (ARN) of the Kinesis Data Streams resource.
         */
        public var streamArn: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.qldb.model.KinesisConfiguration) : this() {
            this.aggregationEnabled = x.aggregationEnabled
            this.streamArn = x.streamArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.qldb.model.KinesisConfiguration = KinesisConfiguration(this)

        internal fun correctErrors(): Builder {
            if (streamArn == null) streamArn = ""
            return this
        }
    }
}
