// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.qldb.model

import aws.smithy.kotlin.runtime.SdkDsl

public class GetBlockRequest private constructor(builder: Builder) {
    /**
     * The location of the block that you want to request. An address is an Amazon Ion structure that has two fields: `strandId` and `sequenceNo`.
     *
     * For example: `{strandId:"BlFTjlSXze9BIh1KOszcE3",sequenceNo:14}`.
     */
    public val blockAddress: aws.sdk.kotlin.services.qldb.model.ValueHolder? = builder.blockAddress
    /**
     * The latest block location covered by the digest for which to request a proof. An address is an Amazon Ion structure that has two fields: `strandId` and `sequenceNo`.
     *
     * For example: `{strandId:"BlFTjlSXze9BIh1KOszcE3",sequenceNo:49}`.
     */
    public val digestTipAddress: aws.sdk.kotlin.services.qldb.model.ValueHolder? = builder.digestTipAddress
    /**
     * The name of the ledger.
     */
    public val name: kotlin.String? = builder.name

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.qldb.model.GetBlockRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GetBlockRequest(")
        append("blockAddress=*** Sensitive Data Redacted ***,")
        append("digestTipAddress=*** Sensitive Data Redacted ***,")
        append("name=$name")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = blockAddress?.hashCode() ?: 0
        result = 31 * result + (digestTipAddress?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GetBlockRequest

        if (blockAddress != other.blockAddress) return false
        if (digestTipAddress != other.digestTipAddress) return false
        if (name != other.name) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.qldb.model.GetBlockRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The location of the block that you want to request. An address is an Amazon Ion structure that has two fields: `strandId` and `sequenceNo`.
         *
         * For example: `{strandId:"BlFTjlSXze9BIh1KOszcE3",sequenceNo:14}`.
         */
        public var blockAddress: aws.sdk.kotlin.services.qldb.model.ValueHolder? = null
        /**
         * The latest block location covered by the digest for which to request a proof. An address is an Amazon Ion structure that has two fields: `strandId` and `sequenceNo`.
         *
         * For example: `{strandId:"BlFTjlSXze9BIh1KOszcE3",sequenceNo:49}`.
         */
        public var digestTipAddress: aws.sdk.kotlin.services.qldb.model.ValueHolder? = null
        /**
         * The name of the ledger.
         */
        public var name: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.qldb.model.GetBlockRequest) : this() {
            this.blockAddress = x.blockAddress
            this.digestTipAddress = x.digestTipAddress
            this.name = x.name
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.qldb.model.GetBlockRequest = GetBlockRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.qldb.model.ValueHolder] inside the given [block]
         */
        public fun blockAddress(block: aws.sdk.kotlin.services.qldb.model.ValueHolder.Builder.() -> kotlin.Unit) {
            this.blockAddress = aws.sdk.kotlin.services.qldb.model.ValueHolder.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.qldb.model.ValueHolder] inside the given [block]
         */
        public fun digestTipAddress(block: aws.sdk.kotlin.services.qldb.model.ValueHolder.Builder.() -> kotlin.Unit) {
            this.digestTipAddress = aws.sdk.kotlin.services.qldb.model.ValueHolder.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
