// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.qldb.transform

import aws.sdk.kotlin.services.qldb.model.PermissionsMode
import aws.sdk.kotlin.services.qldb.model.QldbException
import aws.sdk.kotlin.services.qldb.model.UpdateLedgerPermissionsModeResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class UpdateLedgerPermissionsModeOperationDeserializer: HttpDeserialize<UpdateLedgerPermissionsModeResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): UpdateLedgerPermissionsModeResponse {
        if (!response.status.isSuccess()) {
            throwUpdateLedgerPermissionsModeError(context, response)
        }
        val builder = UpdateLedgerPermissionsModeResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeUpdateLedgerPermissionsModeOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwUpdateLedgerPermissionsModeError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw QldbException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidParameterException" -> InvalidParameterExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> QldbException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeUpdateLedgerPermissionsModeOperationBody(builder: UpdateLedgerPermissionsModeResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Arn"))
    val NAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("Name"))
    val PERMISSIONSMODE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("PermissionsMode"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ARN_DESCRIPTOR)
        field(NAME_DESCRIPTOR)
        field(PERMISSIONSMODE_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ARN_DESCRIPTOR.index -> builder.arn = deserializeString()
                NAME_DESCRIPTOR.index -> builder.name = deserializeString()
                PERMISSIONSMODE_DESCRIPTOR.index -> builder.permissionsMode = deserializeString().let { PermissionsMode.fromValue(it) }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
