// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.qldb.transform

import aws.sdk.kotlin.services.qldb.model.GetBlockResponse
import aws.sdk.kotlin.services.qldb.model.QldbException
import aws.sdk.kotlin.services.qldb.model.ValueHolder
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class GetBlockOperationDeserializer: HttpDeserialize<GetBlockResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): GetBlockResponse {
        if (!response.status.isSuccess()) {
            throwGetBlockError(context, response)
        }
        val builder = GetBlockResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeGetBlockOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwGetBlockError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw QldbException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidParameterException" -> InvalidParameterExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourcePreconditionNotMetException" -> ResourcePreconditionNotMetExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> QldbException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetBlockOperationBody(builder: GetBlockResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val BLOCK_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("Block"))
    val PROOF_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("Proof"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(BLOCK_DESCRIPTOR)
        field(PROOF_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                BLOCK_DESCRIPTOR.index -> builder.block = deserializeValueHolderDocument(deserializer)
                PROOF_DESCRIPTOR.index -> builder.proof = deserializeValueHolderDocument(deserializer)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
