// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.qldb.transform

import aws.sdk.kotlin.services.qldb.model.ExportJournalToS3Request
import aws.sdk.kotlin.services.qldb.model.OutputFormat
import aws.sdk.kotlin.services.qldb.model.S3ExportConfiguration
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.content.ByteArrayContent
import aws.smithy.kotlin.runtime.http.operation.HttpSerialize
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.http.util.encodeLabel
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat


internal class ExportJournalToS3OperationSerializer: HttpSerialize<ExportJournalToS3Request> {
    override suspend fun serialize(context: ExecutionContext, input: ExportJournalToS3Request): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            val pathSegments = listOf<String>(
                "ledgers",
                "${input.name}".encodeLabel(),
                "journal-s3-exports",
            )
            path = pathSegments.joinToString(separator = "/", prefix = "/")
        }

        val payload = serializeExportJournalToS3OperationBody(context, input)
        builder.body = ByteArrayContent(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeExportJournalToS3OperationBody(context: ExecutionContext, input: ExportJournalToS3Request): ByteArray {
    val serializer = JsonSerializer()
    val EXCLUSIVEENDTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("ExclusiveEndTime"))
    val INCLUSIVESTARTTIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("InclusiveStartTime"))
    val OUTPUTFORMAT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("OutputFormat"))
    val ROLEARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("RoleArn"))
    val S3EXPORTCONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("S3ExportConfiguration"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(EXCLUSIVEENDTIME_DESCRIPTOR)
        field(INCLUSIVESTARTTIME_DESCRIPTOR)
        field(OUTPUTFORMAT_DESCRIPTOR)
        field(ROLEARN_DESCRIPTOR)
        field(S3EXPORTCONFIGURATION_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.exclusiveEndTime?.let { field(EXCLUSIVEENDTIME_DESCRIPTOR, it, TimestampFormat.EPOCH_SECONDS) }
        input.inclusiveStartTime?.let { field(INCLUSIVESTARTTIME_DESCRIPTOR, it, TimestampFormat.EPOCH_SECONDS) }
        input.outputFormat?.let { field(OUTPUTFORMAT_DESCRIPTOR, it.value) }
        input.roleArn?.let { field(ROLEARN_DESCRIPTOR, it) }
        input.s3ExportConfiguration?.let { field(S3EXPORTCONFIGURATION_DESCRIPTOR, it, ::serializeS3ExportConfigurationDocument) }
    }
    return serializer.toByteArray()
}
