// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.qldb.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.qldb.model.JournalKinesisStreamDescription
import aws.sdk.kotlin.services.qldb.model.ListJournalKinesisStreamsForLedgerResponse
import aws.sdk.kotlin.services.qldb.model.QldbException
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class ListJournalKinesisStreamsForLedgerOperationDeserializer: HttpDeserialize<ListJournalKinesisStreamsForLedgerResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): ListJournalKinesisStreamsForLedgerResponse {
        if (!response.status.isSuccess()) {
            throwListJournalKinesisStreamsForLedgerError(context, response)
        }
        val builder = ListJournalKinesisStreamsForLedgerResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeListJournalKinesisStreamsForLedgerOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwListJournalKinesisStreamsForLedgerError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw QldbException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InvalidParameterException" -> InvalidParameterExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourcePreconditionNotMetException" -> ResourcePreconditionNotMetExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> QldbException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeListJournalKinesisStreamsForLedgerOperationBody(builder: ListJournalKinesisStreamsForLedgerResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val NEXTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("NextToken"))
    val STREAMS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Streams"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(NEXTTOKEN_DESCRIPTOR)
        field(STREAMS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                NEXTTOKEN_DESCRIPTOR.index -> builder.nextToken = deserializeString()
                STREAMS_DESCRIPTOR.index -> builder.streams =
                    deserializer.deserializeList(STREAMS_DESCRIPTOR) {
                        val col0 = mutableListOf<JournalKinesisStreamDescription>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeJournalKinesisStreamDescriptionDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
