// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.qldb.model



/**
 * The encryption settings that are used by a journal export job to write data in an Amazon Simple Storage Service (Amazon S3) bucket.
 */
public class S3EncryptionConfiguration private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of a symmetric key in Key Management Service (KMS). Amazon S3 does not support asymmetric KMS keys.
     *
     * You must provide a `KmsKeyArn` if you specify `SSE_KMS` as the `ObjectEncryptionType`.
     *
     * `KmsKeyArn` is not required if you specify `SSE_S3` as the `ObjectEncryptionType`.
     */
    public val kmsKeyArn: kotlin.String? = builder.kmsKeyArn
    /**
     * The Amazon S3 object encryption type.
     *
     * To learn more about server-side encryption options in Amazon S3, see [Protecting Data Using Server-Side Encryption](https://docs.aws.amazon.com/AmazonS3/latest/dev/serv-side-encryption.html) in the *Amazon S3 Developer Guide*.
     */
    public val objectEncryptionType: aws.sdk.kotlin.services.qldb.model.S3ObjectEncryptionType? = builder.objectEncryptionType

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.qldb.model.S3EncryptionConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("S3EncryptionConfiguration(")
        append("kmsKeyArn=$kmsKeyArn,")
        append("objectEncryptionType=$objectEncryptionType")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = kmsKeyArn?.hashCode() ?: 0
        result = 31 * result + (objectEncryptionType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as S3EncryptionConfiguration

        if (kmsKeyArn != other.kmsKeyArn) return false
        if (objectEncryptionType != other.objectEncryptionType) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.qldb.model.S3EncryptionConfiguration = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of a symmetric key in Key Management Service (KMS). Amazon S3 does not support asymmetric KMS keys.
         *
         * You must provide a `KmsKeyArn` if you specify `SSE_KMS` as the `ObjectEncryptionType`.
         *
         * `KmsKeyArn` is not required if you specify `SSE_S3` as the `ObjectEncryptionType`.
         */
        public var kmsKeyArn: kotlin.String? = null
        /**
         * The Amazon S3 object encryption type.
         *
         * To learn more about server-side encryption options in Amazon S3, see [Protecting Data Using Server-Side Encryption](https://docs.aws.amazon.com/AmazonS3/latest/dev/serv-side-encryption.html) in the *Amazon S3 Developer Guide*.
         */
        public var objectEncryptionType: aws.sdk.kotlin.services.qldb.model.S3ObjectEncryptionType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.qldb.model.S3EncryptionConfiguration) : this() {
            this.kmsKeyArn = x.kmsKeyArn
            this.objectEncryptionType = x.objectEncryptionType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.qldb.model.S3EncryptionConfiguration = S3EncryptionConfiguration(this)
    }
}
