// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.qldb

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.borrow
import aws.sdk.kotlin.runtime.config.retries.resolveRetryStrategy
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.qldb.endpoints.DefaultEndpointProvider
import aws.sdk.kotlin.services.qldb.endpoints.EndpointProvider
import aws.sdk.kotlin.services.qldb.model.*
import aws.sdk.kotlin.services.qldb.model.CancelJournalKinesisStreamRequest
import aws.sdk.kotlin.services.qldb.model.CancelJournalKinesisStreamResponse
import aws.sdk.kotlin.services.qldb.model.CreateLedgerRequest
import aws.sdk.kotlin.services.qldb.model.CreateLedgerResponse
import aws.sdk.kotlin.services.qldb.model.DeleteLedgerRequest
import aws.sdk.kotlin.services.qldb.model.DeleteLedgerResponse
import aws.sdk.kotlin.services.qldb.model.DescribeJournalKinesisStreamRequest
import aws.sdk.kotlin.services.qldb.model.DescribeJournalKinesisStreamResponse
import aws.sdk.kotlin.services.qldb.model.DescribeJournalS3ExportRequest
import aws.sdk.kotlin.services.qldb.model.DescribeJournalS3ExportResponse
import aws.sdk.kotlin.services.qldb.model.DescribeLedgerRequest
import aws.sdk.kotlin.services.qldb.model.DescribeLedgerResponse
import aws.sdk.kotlin.services.qldb.model.ExportJournalToS3Request
import aws.sdk.kotlin.services.qldb.model.ExportJournalToS3Response
import aws.sdk.kotlin.services.qldb.model.GetBlockRequest
import aws.sdk.kotlin.services.qldb.model.GetBlockResponse
import aws.sdk.kotlin.services.qldb.model.GetDigestRequest
import aws.sdk.kotlin.services.qldb.model.GetDigestResponse
import aws.sdk.kotlin.services.qldb.model.GetRevisionRequest
import aws.sdk.kotlin.services.qldb.model.GetRevisionResponse
import aws.sdk.kotlin.services.qldb.model.ListJournalKinesisStreamsForLedgerRequest
import aws.sdk.kotlin.services.qldb.model.ListJournalKinesisStreamsForLedgerResponse
import aws.sdk.kotlin.services.qldb.model.ListJournalS3ExportsForLedgerRequest
import aws.sdk.kotlin.services.qldb.model.ListJournalS3ExportsForLedgerResponse
import aws.sdk.kotlin.services.qldb.model.ListJournalS3ExportsRequest
import aws.sdk.kotlin.services.qldb.model.ListJournalS3ExportsResponse
import aws.sdk.kotlin.services.qldb.model.ListLedgersRequest
import aws.sdk.kotlin.services.qldb.model.ListLedgersResponse
import aws.sdk.kotlin.services.qldb.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.qldb.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.qldb.model.StreamJournalToKinesisRequest
import aws.sdk.kotlin.services.qldb.model.StreamJournalToKinesisResponse
import aws.sdk.kotlin.services.qldb.model.TagResourceRequest
import aws.sdk.kotlin.services.qldb.model.TagResourceResponse
import aws.sdk.kotlin.services.qldb.model.UntagResourceRequest
import aws.sdk.kotlin.services.qldb.model.UntagResourceResponse
import aws.sdk.kotlin.services.qldb.model.UpdateLedgerPermissionsModeRequest
import aws.sdk.kotlin.services.qldb.model.UpdateLedgerPermissionsModeResponse
import aws.sdk.kotlin.services.qldb.model.UpdateLedgerRequest
import aws.sdk.kotlin.services.qldb.model.UpdateLedgerResponse
import aws.smithy.kotlin.runtime.SdkClient
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigner
import aws.smithy.kotlin.runtime.auth.awssigning.DefaultAwsSigner
import aws.smithy.kotlin.runtime.client.SdkLogMode
import aws.smithy.kotlin.runtime.config.SdkClientConfig
import aws.smithy.kotlin.runtime.http.Url
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.StandardRetryStrategy
import aws.smithy.kotlin.runtime.tracing.DefaultTracer
import aws.smithy.kotlin.runtime.tracing.LoggingTraceProbe
import aws.smithy.kotlin.runtime.tracing.Tracer
import aws.smithy.kotlin.runtime.tracing.TracingClientConfig
import kotlin.collections.MutableList

/**
 * The control plane for Amazon QLDB
 */
public interface QldbClient : SdkClient {

    override val serviceName: String
        get() = "QLDB"
    /**
     * QldbClient's configuration
     */
    public val config: Config

    public companion object {
        public operator fun invoke(block: Config.Builder.() -> Unit): QldbClient {
            val config = Config.Builder().apply(block).build()
            return DefaultQldbClient(config)
        }

        public operator fun invoke(config: Config): QldbClient = DefaultQldbClient(config)

        /**
         * Construct a [QldbClient] by resolving the configuration from the current environment.
         */
        public suspend fun fromEnvironment(block: (Config.Builder.() -> Unit)? = null): QldbClient {
            val builder = Config.Builder()
            if (block != null) builder.apply(block)
            builder.region = builder.region ?: resolveRegion()
            builder.retryStrategy = builder.retryStrategy ?: resolveRetryStrategy()
            return DefaultQldbClient(builder.build())
        }
    }

    public class Config private constructor(builder: Builder): HttpClientConfig, SdkClientConfig, TracingClientConfig {
        override val httpClientEngine: HttpClientEngine? = builder.httpClientEngine
        public val region: String = requireNotNull(builder.region) { "region is a required configuration property" }
        public val credentialsProvider: CredentialsProvider = builder.credentialsProvider?.borrow() ?: DefaultChainCredentialsProvider(httpClientEngine = httpClientEngine, region = region)
        public val endpointProvider: EndpointProvider = builder.endpointProvider ?: DefaultEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        public val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        public val retryStrategy: RetryStrategy = builder.retryStrategy ?: StandardRetryStrategy()
        override val sdkLogMode: SdkLogMode = builder.sdkLogMode
        public val signer: AwsSigner = builder.signer ?: DefaultAwsSigner
        override val tracer: Tracer = builder.tracer ?: DefaultTracer(LoggingTraceProbe, "QLDB")
        public val useDualStack: Boolean = builder.useDualStack
        public val useFips: Boolean = builder.useFips
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public class Builder {
            /**
             * Override the default HTTP client engine used to make SDK requests (e.g. configure proxy behavior, timeouts, concurrency, etc).
             * NOTE: The caller is responsible for managing the lifetime of the engine when set. The SDK
             * client will not close it when the client is closed.
             */
            public var httpClientEngine: HttpClientEngine? = null

            /**
             * AWS region to make requests to
             */
            public var region: String? = null

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            public var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint provider used to determine where to make service requests.
             */
            public var endpointProvider: EndpointProvider? = null

            /**
             * A custom endpoint to use when making requests.
             */
            public var endpointUrl: Url? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            public var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * The [RetryStrategy] implementation to use for service calls. All API calls will be wrapped by the
             * strategy.
             */
            public var retryStrategy: RetryStrategy? = null

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            public var sdkLogMode: SdkLogMode = SdkLogMode.Default

            /**
             * The implementation of AWS signer to use for signing requests
             */
            public var signer: AwsSigner? = null

            /**
             * The tracer that is responsible for creating trace spans and wiring them up to a tracing backend (e.g.,
             * a trace probe). By default, this will create a standard tracer that uses the service name for the root
             * trace span and delegates to a logging trace probe (i.e.,
             * `DefaultTracer(LoggingTraceProbe, "<service-name>")`).
             */
            public var tracer: Tracer? = null

            /**
             * Flag to toggle whether to use dual-stack endpoints when making requests.
             */
            public var useDualStack: Boolean = false

            /**
             * Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             */
            public var useFips: Boolean = false

            @PublishedApi
            internal fun build(): Config = Config(this)
        }
    }

    /**
     * Ends a given Amazon QLDB journal stream. Before a stream can be canceled, its current status must be `ACTIVE`.
     *
     * You can't restart a stream after you cancel it. Canceled QLDB stream resources are subject to a 7-day retention period, so they are automatically deleted after this limit expires.
     */
    public suspend fun cancelJournalKinesisStream(input: CancelJournalKinesisStreamRequest): CancelJournalKinesisStreamResponse

    /**
     * Creates a new ledger in your Amazon Web Services account in the current Region.
     */
    public suspend fun createLedger(input: CreateLedgerRequest): CreateLedgerResponse

    /**
     * Deletes a ledger and all of its contents. This action is irreversible.
     *
     * If deletion protection is enabled, you must first disable it before you can delete the ledger. You can disable it by calling the `UpdateLedger` operation to set the flag to `false`.
     */
    public suspend fun deleteLedger(input: DeleteLedgerRequest): DeleteLedgerResponse

    /**
     * Returns detailed information about a given Amazon QLDB journal stream. The output includes the Amazon Resource Name (ARN), stream name, current status, creation time, and the parameters of the original stream creation request.
     *
     * This action does not return any expired journal streams. For more information, see [Expiration for terminal streams](https://docs.aws.amazon.com/qldb/latest/developerguide/streams.create.html#streams.create.states.expiration) in the *Amazon QLDB Developer Guide*.
     */
    public suspend fun describeJournalKinesisStream(input: DescribeJournalKinesisStreamRequest): DescribeJournalKinesisStreamResponse

    /**
     * Returns information about a journal export job, including the ledger name, export ID, creation time, current status, and the parameters of the original export creation request.
     *
     * This action does not return any expired export jobs. For more information, see [Export job expiration](https://docs.aws.amazon.com/qldb/latest/developerguide/export-journal.request.html#export-journal.request.expiration) in the *Amazon QLDB Developer Guide*.
     *
     * If the export job with the given `ExportId` doesn't exist, then throws `ResourceNotFoundException`.
     *
     * If the ledger with the given `Name` doesn't exist, then throws `ResourceNotFoundException`.
     */
    public suspend fun describeJournalS3Export(input: DescribeJournalS3ExportRequest): DescribeJournalS3ExportResponse

    /**
     * Returns information about a ledger, including its state, permissions mode, encryption at rest settings, and when it was created.
     */
    public suspend fun describeLedger(input: DescribeLedgerRequest): DescribeLedgerResponse

    /**
     * Exports journal contents within a date and time range from a ledger into a specified Amazon Simple Storage Service (Amazon S3) bucket. A journal export job can write the data objects in either the text or binary representation of Amazon Ion format, or in *JSON Lines* text format.
     *
     * In JSON Lines format, each journal block in the exported data object is a valid JSON object that is delimited by a newline. You can use this format to easily integrate JSON exports with analytics tools such as Glue and Amazon Athena because these services can parse newline-delimited JSON automatically. For more information about the format, see [JSON Lines](https://jsonlines.org/).
     *
     * If the ledger with the given `Name` doesn't exist, then throws `ResourceNotFoundException`.
     *
     * If the ledger with the given `Name` is in `CREATING` status, then throws `ResourcePreconditionNotMetException`.
     *
     * You can initiate up to two concurrent journal export requests for each ledger. Beyond this limit, journal export requests throw `LimitExceededException`.
     */
    public suspend fun exportJournalToS3(input: ExportJournalToS3Request): ExportJournalToS3Response

    /**
     * Returns a block object at a specified address in a journal. Also returns a proof of the specified block for verification if `DigestTipAddress` is provided.
     *
     * For information about the data contents in a block, see [Journal contents](https://docs.aws.amazon.com/qldb/latest/developerguide/journal-contents.html) in the *Amazon QLDB Developer Guide*.
     *
     * If the specified ledger doesn't exist or is in `DELETING` status, then throws `ResourceNotFoundException`.
     *
     * If the specified ledger is in `CREATING` status, then throws `ResourcePreconditionNotMetException`.
     *
     * If no block exists with the specified address, then throws `InvalidParameterException`.
     */
    public suspend fun getBlock(input: GetBlockRequest): GetBlockResponse

    /**
     * Returns the digest of a ledger at the latest committed block in the journal. The response includes a 256-bit hash value and a block address.
     */
    public suspend fun getDigest(input: GetDigestRequest): GetDigestResponse

    /**
     * Returns a revision data object for a specified document ID and block address. Also returns a proof of the specified revision for verification if `DigestTipAddress` is provided.
     */
    public suspend fun getRevision(input: GetRevisionRequest): GetRevisionResponse

    /**
     * Returns an array of all Amazon QLDB journal stream descriptors for a given ledger. The output of each stream descriptor includes the same details that are returned by `DescribeJournalKinesisStream`.
     *
     * This action does not return any expired journal streams. For more information, see [Expiration for terminal streams](https://docs.aws.amazon.com/qldb/latest/developerguide/streams.create.html#streams.create.states.expiration) in the *Amazon QLDB Developer Guide*.
     *
     * This action returns a maximum of `MaxResults` items. It is paginated so that you can retrieve all the items by calling `ListJournalKinesisStreamsForLedger` multiple times.
     */
    public suspend fun listJournalKinesisStreamsForLedger(input: ListJournalKinesisStreamsForLedgerRequest): ListJournalKinesisStreamsForLedgerResponse

    /**
     * Returns an array of journal export job descriptions for all ledgers that are associated with the current Amazon Web Services account and Region.
     *
     * This action returns a maximum of `MaxResults` items, and is paginated so that you can retrieve all the items by calling `ListJournalS3Exports` multiple times.
     *
     * This action does not return any expired export jobs. For more information, see [Export job expiration](https://docs.aws.amazon.com/qldb/latest/developerguide/export-journal.request.html#export-journal.request.expiration) in the *Amazon QLDB Developer Guide*.
     */
    public suspend fun listJournalS3Exports(input: ListJournalS3ExportsRequest = ListJournalS3ExportsRequest {}): ListJournalS3ExportsResponse

    /**
     * Returns an array of journal export job descriptions for a specified ledger.
     *
     * This action returns a maximum of `MaxResults` items, and is paginated so that you can retrieve all the items by calling `ListJournalS3ExportsForLedger` multiple times.
     *
     * This action does not return any expired export jobs. For more information, see [Export job expiration](https://docs.aws.amazon.com/qldb/latest/developerguide/export-journal.request.html#export-journal.request.expiration) in the *Amazon QLDB Developer Guide*.
     */
    public suspend fun listJournalS3ExportsForLedger(input: ListJournalS3ExportsForLedgerRequest): ListJournalS3ExportsForLedgerResponse

    /**
     * Returns an array of ledger summaries that are associated with the current Amazon Web Services account and Region.
     *
     * This action returns a maximum of 100 items and is paginated so that you can retrieve all the items by calling `ListLedgers` multiple times.
     */
    public suspend fun listLedgers(input: ListLedgersRequest = ListLedgersRequest {}): ListLedgersResponse

    /**
     * Returns all tags for a specified Amazon QLDB resource.
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Creates a journal stream for a given Amazon QLDB ledger. The stream captures every document revision that is committed to the ledger's journal and delivers the data to a specified Amazon Kinesis Data Streams resource.
     */
    public suspend fun streamJournalToKinesis(input: StreamJournalToKinesisRequest): StreamJournalToKinesisResponse

    /**
     * Adds one or more tags to a specified Amazon QLDB resource.
     *
     * A resource can have up to 50 tags. If you try to create more than 50 tags for a resource, your request fails and returns an error.
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Removes one or more tags from a specified Amazon QLDB resource. You can specify up to 50 tag keys to remove.
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Updates properties on a ledger.
     */
    public suspend fun updateLedger(input: UpdateLedgerRequest): UpdateLedgerResponse

    /**
     * Updates the permissions mode of a ledger.
     *
     * Before you switch to the `STANDARD` permissions mode, you must first create all required IAM policies and table tags to avoid disruption to your users. To learn more, see [Migrating to the standard permissions mode](https://docs.aws.amazon.com/qldb/latest/developerguide/ledger-management.basics.html#ledger-mgmt.basics.update-permissions.migrating) in the *Amazon QLDB Developer Guide*.
     */
    public suspend fun updateLedgerPermissionsMode(input: UpdateLedgerPermissionsModeRequest): UpdateLedgerPermissionsModeResponse
}

/**
 * Ends a given Amazon QLDB journal stream. Before a stream can be canceled, its current status must be `ACTIVE`.
 *
 * You can't restart a stream after you cancel it. Canceled QLDB stream resources are subject to a 7-day retention period, so they are automatically deleted after this limit expires.
 */
public suspend inline fun QldbClient.cancelJournalKinesisStream(crossinline block: CancelJournalKinesisStreamRequest.Builder.() -> Unit): CancelJournalKinesisStreamResponse = cancelJournalKinesisStream(CancelJournalKinesisStreamRequest.Builder().apply(block).build())

/**
 * Creates a new ledger in your Amazon Web Services account in the current Region.
 */
public suspend inline fun QldbClient.createLedger(crossinline block: CreateLedgerRequest.Builder.() -> Unit): CreateLedgerResponse = createLedger(CreateLedgerRequest.Builder().apply(block).build())

/**
 * Deletes a ledger and all of its contents. This action is irreversible.
 *
 * If deletion protection is enabled, you must first disable it before you can delete the ledger. You can disable it by calling the `UpdateLedger` operation to set the flag to `false`.
 */
public suspend inline fun QldbClient.deleteLedger(crossinline block: DeleteLedgerRequest.Builder.() -> Unit): DeleteLedgerResponse = deleteLedger(DeleteLedgerRequest.Builder().apply(block).build())

/**
 * Returns detailed information about a given Amazon QLDB journal stream. The output includes the Amazon Resource Name (ARN), stream name, current status, creation time, and the parameters of the original stream creation request.
 *
 * This action does not return any expired journal streams. For more information, see [Expiration for terminal streams](https://docs.aws.amazon.com/qldb/latest/developerguide/streams.create.html#streams.create.states.expiration) in the *Amazon QLDB Developer Guide*.
 */
public suspend inline fun QldbClient.describeJournalKinesisStream(crossinline block: DescribeJournalKinesisStreamRequest.Builder.() -> Unit): DescribeJournalKinesisStreamResponse = describeJournalKinesisStream(DescribeJournalKinesisStreamRequest.Builder().apply(block).build())

/**
 * Returns information about a journal export job, including the ledger name, export ID, creation time, current status, and the parameters of the original export creation request.
 *
 * This action does not return any expired export jobs. For more information, see [Export job expiration](https://docs.aws.amazon.com/qldb/latest/developerguide/export-journal.request.html#export-journal.request.expiration) in the *Amazon QLDB Developer Guide*.
 *
 * If the export job with the given `ExportId` doesn't exist, then throws `ResourceNotFoundException`.
 *
 * If the ledger with the given `Name` doesn't exist, then throws `ResourceNotFoundException`.
 */
public suspend inline fun QldbClient.describeJournalS3Export(crossinline block: DescribeJournalS3ExportRequest.Builder.() -> Unit): DescribeJournalS3ExportResponse = describeJournalS3Export(DescribeJournalS3ExportRequest.Builder().apply(block).build())

/**
 * Returns information about a ledger, including its state, permissions mode, encryption at rest settings, and when it was created.
 */
public suspend inline fun QldbClient.describeLedger(crossinline block: DescribeLedgerRequest.Builder.() -> Unit): DescribeLedgerResponse = describeLedger(DescribeLedgerRequest.Builder().apply(block).build())

/**
 * Exports journal contents within a date and time range from a ledger into a specified Amazon Simple Storage Service (Amazon S3) bucket. A journal export job can write the data objects in either the text or binary representation of Amazon Ion format, or in *JSON Lines* text format.
 *
 * In JSON Lines format, each journal block in the exported data object is a valid JSON object that is delimited by a newline. You can use this format to easily integrate JSON exports with analytics tools such as Glue and Amazon Athena because these services can parse newline-delimited JSON automatically. For more information about the format, see [JSON Lines](https://jsonlines.org/).
 *
 * If the ledger with the given `Name` doesn't exist, then throws `ResourceNotFoundException`.
 *
 * If the ledger with the given `Name` is in `CREATING` status, then throws `ResourcePreconditionNotMetException`.
 *
 * You can initiate up to two concurrent journal export requests for each ledger. Beyond this limit, journal export requests throw `LimitExceededException`.
 */
public suspend inline fun QldbClient.exportJournalToS3(crossinline block: ExportJournalToS3Request.Builder.() -> Unit): ExportJournalToS3Response = exportJournalToS3(ExportJournalToS3Request.Builder().apply(block).build())

/**
 * Returns a block object at a specified address in a journal. Also returns a proof of the specified block for verification if `DigestTipAddress` is provided.
 *
 * For information about the data contents in a block, see [Journal contents](https://docs.aws.amazon.com/qldb/latest/developerguide/journal-contents.html) in the *Amazon QLDB Developer Guide*.
 *
 * If the specified ledger doesn't exist or is in `DELETING` status, then throws `ResourceNotFoundException`.
 *
 * If the specified ledger is in `CREATING` status, then throws `ResourcePreconditionNotMetException`.
 *
 * If no block exists with the specified address, then throws `InvalidParameterException`.
 */
public suspend inline fun QldbClient.getBlock(crossinline block: GetBlockRequest.Builder.() -> Unit): GetBlockResponse = getBlock(GetBlockRequest.Builder().apply(block).build())

/**
 * Returns the digest of a ledger at the latest committed block in the journal. The response includes a 256-bit hash value and a block address.
 */
public suspend inline fun QldbClient.getDigest(crossinline block: GetDigestRequest.Builder.() -> Unit): GetDigestResponse = getDigest(GetDigestRequest.Builder().apply(block).build())

/**
 * Returns a revision data object for a specified document ID and block address. Also returns a proof of the specified revision for verification if `DigestTipAddress` is provided.
 */
public suspend inline fun QldbClient.getRevision(crossinline block: GetRevisionRequest.Builder.() -> Unit): GetRevisionResponse = getRevision(GetRevisionRequest.Builder().apply(block).build())

/**
 * Returns an array of all Amazon QLDB journal stream descriptors for a given ledger. The output of each stream descriptor includes the same details that are returned by `DescribeJournalKinesisStream`.
 *
 * This action does not return any expired journal streams. For more information, see [Expiration for terminal streams](https://docs.aws.amazon.com/qldb/latest/developerguide/streams.create.html#streams.create.states.expiration) in the *Amazon QLDB Developer Guide*.
 *
 * This action returns a maximum of `MaxResults` items. It is paginated so that you can retrieve all the items by calling `ListJournalKinesisStreamsForLedger` multiple times.
 */
public suspend inline fun QldbClient.listJournalKinesisStreamsForLedger(crossinline block: ListJournalKinesisStreamsForLedgerRequest.Builder.() -> Unit): ListJournalKinesisStreamsForLedgerResponse = listJournalKinesisStreamsForLedger(ListJournalKinesisStreamsForLedgerRequest.Builder().apply(block).build())

/**
 * Returns an array of journal export job descriptions for all ledgers that are associated with the current Amazon Web Services account and Region.
 *
 * This action returns a maximum of `MaxResults` items, and is paginated so that you can retrieve all the items by calling `ListJournalS3Exports` multiple times.
 *
 * This action does not return any expired export jobs. For more information, see [Export job expiration](https://docs.aws.amazon.com/qldb/latest/developerguide/export-journal.request.html#export-journal.request.expiration) in the *Amazon QLDB Developer Guide*.
 */
public suspend inline fun QldbClient.listJournalS3Exports(crossinline block: ListJournalS3ExportsRequest.Builder.() -> Unit): ListJournalS3ExportsResponse = listJournalS3Exports(ListJournalS3ExportsRequest.Builder().apply(block).build())

/**
 * Returns an array of journal export job descriptions for a specified ledger.
 *
 * This action returns a maximum of `MaxResults` items, and is paginated so that you can retrieve all the items by calling `ListJournalS3ExportsForLedger` multiple times.
 *
 * This action does not return any expired export jobs. For more information, see [Export job expiration](https://docs.aws.amazon.com/qldb/latest/developerguide/export-journal.request.html#export-journal.request.expiration) in the *Amazon QLDB Developer Guide*.
 */
public suspend inline fun QldbClient.listJournalS3ExportsForLedger(crossinline block: ListJournalS3ExportsForLedgerRequest.Builder.() -> Unit): ListJournalS3ExportsForLedgerResponse = listJournalS3ExportsForLedger(ListJournalS3ExportsForLedgerRequest.Builder().apply(block).build())

/**
 * Returns an array of ledger summaries that are associated with the current Amazon Web Services account and Region.
 *
 * This action returns a maximum of 100 items and is paginated so that you can retrieve all the items by calling `ListLedgers` multiple times.
 */
public suspend inline fun QldbClient.listLedgers(crossinline block: ListLedgersRequest.Builder.() -> Unit): ListLedgersResponse = listLedgers(ListLedgersRequest.Builder().apply(block).build())

/**
 * Returns all tags for a specified Amazon QLDB resource.
 */
public suspend inline fun QldbClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Creates a journal stream for a given Amazon QLDB ledger. The stream captures every document revision that is committed to the ledger's journal and delivers the data to a specified Amazon Kinesis Data Streams resource.
 */
public suspend inline fun QldbClient.streamJournalToKinesis(crossinline block: StreamJournalToKinesisRequest.Builder.() -> Unit): StreamJournalToKinesisResponse = streamJournalToKinesis(StreamJournalToKinesisRequest.Builder().apply(block).build())

/**
 * Adds one or more tags to a specified Amazon QLDB resource.
 *
 * A resource can have up to 50 tags. If you try to create more than 50 tags for a resource, your request fails and returns an error.
 */
public suspend inline fun QldbClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Removes one or more tags from a specified Amazon QLDB resource. You can specify up to 50 tag keys to remove.
 */
public suspend inline fun QldbClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * Updates properties on a ledger.
 */
public suspend inline fun QldbClient.updateLedger(crossinline block: UpdateLedgerRequest.Builder.() -> Unit): UpdateLedgerResponse = updateLedger(UpdateLedgerRequest.Builder().apply(block).build())

/**
 * Updates the permissions mode of a ledger.
 *
 * Before you switch to the `STANDARD` permissions mode, you must first create all required IAM policies and table tags to avoid disruption to your users. To learn more, see [Migrating to the standard permissions mode](https://docs.aws.amazon.com/qldb/latest/developerguide/ledger-management.basics.html#ledger-mgmt.basics.update-permissions.migrating) in the *Amazon QLDB Developer Guide*.
 */
public suspend inline fun QldbClient.updateLedgerPermissionsMode(crossinline block: UpdateLedgerPermissionsModeRequest.Builder.() -> Unit): UpdateLedgerPermissionsModeResponse = updateLedgerPermissionsMode(UpdateLedgerPermissionsModeRequest.Builder().apply(block).build())
