// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.qconnect.serde

import aws.sdk.kotlin.services.qconnect.model.AiAgentConfigurationData
import aws.sdk.kotlin.services.qconnect.model.AiAgentType
import aws.sdk.kotlin.services.qconnect.model.TagFilter
import aws.sdk.kotlin.services.qconnect.model.UpdateSessionRequest
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class UpdateSessionOperationSerializer: HttpSerializer.NonStreaming<UpdateSessionRequest> {
    override fun serialize(context: ExecutionContext, input: UpdateSessionRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            requireNotNull(input.assistantId) { "assistantId is bound to the URI and must not be null" }
            requireNotNull(input.sessionId) { "sessionId is bound to the URI and must not be null" }
            path.encodedSegments {
                add(PercentEncoding.Path.encode("assistants"))
                add(PercentEncoding.SmithyLabel.encode(input.assistantId))
                add(PercentEncoding.Path.encode("sessions"))
                add(PercentEncoding.SmithyLabel.encode(input.sessionId))
            }
        }

        val payload = serializeUpdateSessionOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeUpdateSessionOperationBody(context: ExecutionContext, input: UpdateSessionRequest): ByteArray {
    val serializer = JsonSerializer()
    val AIAGENTCONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("aiAgentConfiguration"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("description"))
    val TAGFILTER_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("tagFilter"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(AIAGENTCONFIGURATION_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(TAGFILTER_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        if (input.aiAgentConfiguration != null) {
            mapField(AIAGENTCONFIGURATION_DESCRIPTOR) {
                input.aiAgentConfiguration.forEach { (key, value) -> entry(key.value, asSdkSerializable(value, ::serializeAiAgentConfigurationDataDocument)) }
            }
        }
        input.description?.let { field(DESCRIPTION_DESCRIPTOR, it) }
        input.tagFilter?.let { field(TAGFILTER_DESCRIPTOR, it, ::serializeTagFilterDocument) }
    }
    return serializer.toByteArray()
}
