// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.qconnect.serde

import aws.sdk.kotlin.services.qconnect.model.QConnectException
import aws.sdk.kotlin.services.qconnect.model.RuntimeSessionData
import aws.sdk.kotlin.services.qconnect.model.SessionDataNamespace
import aws.sdk.kotlin.services.qconnect.model.UpdateSessionDataResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class UpdateSessionDataOperationDeserializer: HttpDeserializer.NonStreaming<UpdateSessionDataResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): UpdateSessionDataResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwUpdateSessionDataError(context, call, payload)
        }
        val builder = UpdateSessionDataResponse.Builder()

        if (payload != null) {
            deserializeUpdateSessionDataOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwUpdateSessionDataError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw QConnectException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "UnauthorizedException" -> UnauthorizedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> QConnectException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeUpdateSessionDataOperationBody(builder: UpdateSessionDataResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val DATA_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("data"))
    val NAMESPACE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("namespace"))
    val SESSIONARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("sessionArn"))
    val SESSIONID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("sessionId"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(DATA_DESCRIPTOR)
        field(NAMESPACE_DESCRIPTOR)
        field(SESSIONARN_DESCRIPTOR)
        field(SESSIONID_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                DATA_DESCRIPTOR.index -> builder.data =
                    deserializer.deserializeList(DATA_DESCRIPTOR) {
                        val col0 = mutableListOf<RuntimeSessionData>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeRuntimeSessionDataDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                NAMESPACE_DESCRIPTOR.index -> builder.namespace = deserializeString().let { SessionDataNamespace.fromValue(it) }
                SESSIONARN_DESCRIPTOR.index -> builder.sessionArn = deserializeString()
                SESSIONID_DESCRIPTOR.index -> builder.sessionId = deserializeString()
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
