// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.qconnect.serde

import aws.sdk.kotlin.services.qconnect.model.ExternalSourceConfiguration
import aws.sdk.kotlin.services.qconnect.model.ImportJobType
import aws.sdk.kotlin.services.qconnect.model.StartImportJobRequest
import aws.smithy.kotlin.runtime.client.idempotencyTokenProvider
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class StartImportJobOperationSerializer: HttpSerializer.NonStreaming<StartImportJobRequest> {
    override fun serialize(context: ExecutionContext, input: StartImportJobRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            requireNotNull(input.knowledgeBaseId) { "knowledgeBaseId is bound to the URI and must not be null" }
            path.encodedSegments {
                add(PercentEncoding.Path.encode("knowledgeBases"))
                add(PercentEncoding.SmithyLabel.encode(input.knowledgeBaseId))
                add(PercentEncoding.Path.encode("importJobs"))
            }
        }

        val payload = serializeStartImportJobOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeStartImportJobOperationBody(context: ExecutionContext, input: StartImportJobRequest): ByteArray {
    val serializer = JsonSerializer()
    val CLIENTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("clientToken"))
    val EXTERNALSOURCECONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("externalSourceConfiguration"))
    val IMPORTJOBTYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("importJobType"))
    val METADATA_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("metadata"))
    val UPLOADID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("uploadId"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CLIENTTOKEN_DESCRIPTOR)
        field(EXTERNALSOURCECONFIGURATION_DESCRIPTOR)
        field(IMPORTJOBTYPE_DESCRIPTOR)
        field(METADATA_DESCRIPTOR)
        field(UPLOADID_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.clientToken?.let { field(CLIENTTOKEN_DESCRIPTOR, it) } ?: field(CLIENTTOKEN_DESCRIPTOR, context.idempotencyTokenProvider.generateToken())
        input.externalSourceConfiguration?.let { field(EXTERNALSOURCECONFIGURATION_DESCRIPTOR, it, ::serializeExternalSourceConfigurationDocument) }
        input.importJobType?.let { field(IMPORTJOBTYPE_DESCRIPTOR, it.value) }
        if (input.metadata != null) {
            mapField(METADATA_DESCRIPTOR) {
                input.metadata.forEach { (key, value) ->
                    entry(key, value)
                }
            }
        }
        input.uploadId?.let { field(UPLOADID_DESCRIPTOR, it) }
    }
    return serializer.toByteArray()
}
