// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.qconnect.serde

import aws.sdk.kotlin.services.qconnect.model.ConversationContext
import aws.sdk.kotlin.services.qconnect.model.MessageConfiguration
import aws.sdk.kotlin.services.qconnect.model.MessageInput
import aws.sdk.kotlin.services.qconnect.model.MessageType
import aws.sdk.kotlin.services.qconnect.model.SendMessageRequest
import aws.smithy.kotlin.runtime.client.idempotencyTokenProvider
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class SendMessageOperationSerializer: HttpSerializer.NonStreaming<SendMessageRequest> {
    override fun serialize(context: ExecutionContext, input: SendMessageRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            requireNotNull(input.assistantId) { "assistantId is bound to the URI and must not be null" }
            requireNotNull(input.sessionId) { "sessionId is bound to the URI and must not be null" }
            path.encodedSegments {
                add(PercentEncoding.Path.encode("assistants"))
                add(PercentEncoding.SmithyLabel.encode(input.assistantId))
                add(PercentEncoding.Path.encode("sessions"))
                add(PercentEncoding.SmithyLabel.encode(input.sessionId))
                add(PercentEncoding.Path.encode("message"))
            }
        }

        val payload = serializeSendMessageOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeSendMessageOperationBody(context: ExecutionContext, input: SendMessageRequest): ByteArray {
    val serializer = JsonSerializer()
    val CLIENTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("clientToken"))
    val CONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("configuration"))
    val CONVERSATIONCONTEXT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("conversationContext"))
    val MESSAGE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("message"))
    val TYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("type"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CLIENTTOKEN_DESCRIPTOR)
        field(CONFIGURATION_DESCRIPTOR)
        field(CONVERSATIONCONTEXT_DESCRIPTOR)
        field(MESSAGE_DESCRIPTOR)
        field(TYPE_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.clientToken?.let { field(CLIENTTOKEN_DESCRIPTOR, it) } ?: field(CLIENTTOKEN_DESCRIPTOR, context.idempotencyTokenProvider.generateToken())
        input.configuration?.let { field(CONFIGURATION_DESCRIPTOR, it, ::serializeMessageConfigurationDocument) }
        input.conversationContext?.let { field(CONVERSATIONCONTEXT_DESCRIPTOR, it, ::serializeConversationContextDocument) }
        input.message?.let { field(MESSAGE_DESCRIPTOR, it, ::serializeMessageInputDocument) }
        input.type?.let { field(TYPE_DESCRIPTOR, it.value) }
    }
    return serializer.toByteArray()
}
