// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.qconnect.serde

import aws.sdk.kotlin.services.qconnect.model.SearchExpression
import aws.sdk.kotlin.services.qconnect.model.SearchSessionsRequest
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class SearchSessionsOperationSerializer: HttpSerializer.NonStreaming<SearchSessionsRequest> {
    override fun serialize(context: ExecutionContext, input: SearchSessionsRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            path.encodedSegments {
                add(PercentEncoding.Path.encode("assistants"))
                add(PercentEncoding.SmithyLabel.encode(input.assistantId))
                add(PercentEncoding.Path.encode("searchSessions"))
            }
            parameters.decodedParameters(PercentEncoding.SmithyLabel) {
                if (input.maxResults != null) add("maxResults", input.maxResults.toString())
                if (input.nextToken != null) add("nextToken", input.nextToken)
            }
        }

        val payload = serializeSearchSessionsOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeSearchSessionsOperationBody(context: ExecutionContext, input: SearchSessionsRequest): ByteArray {
    val serializer = JsonSerializer()
    val SEARCHEXPRESSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("searchExpression"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(SEARCHEXPRESSION_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.searchExpression?.let { field(SEARCHEXPRESSION_DESCRIPTOR, it, ::serializeSearchExpressionDocument) }
    }
    return serializer.toByteArray()
}
