// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.qconnect.serde

import aws.sdk.kotlin.services.qconnect.model.ContentFeedbackData
import aws.sdk.kotlin.services.qconnect.model.PutFeedbackResponse
import aws.sdk.kotlin.services.qconnect.model.QConnectException
import aws.sdk.kotlin.services.qconnect.model.TargetType
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class PutFeedbackOperationDeserializer: HttpDeserializer.NonStreaming<PutFeedbackResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): PutFeedbackResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwPutFeedbackError(context, call, payload)
        }
        val builder = PutFeedbackResponse.Builder()

        if (payload != null) {
            deserializePutFeedbackOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwPutFeedbackError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw QConnectException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> QConnectException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializePutFeedbackOperationBody(builder: PutFeedbackResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ASSISTANTARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("assistantArn"))
    val ASSISTANTID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("assistantId"))
    val CONTENTFEEDBACK_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("contentFeedback"))
    val TARGETID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("targetId"))
    val TARGETTYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("targetType"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ASSISTANTARN_DESCRIPTOR)
        field(ASSISTANTID_DESCRIPTOR)
        field(CONTENTFEEDBACK_DESCRIPTOR)
        field(TARGETID_DESCRIPTOR)
        field(TARGETTYPE_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ASSISTANTARN_DESCRIPTOR.index -> builder.assistantArn = deserializeString()
                ASSISTANTID_DESCRIPTOR.index -> builder.assistantId = deserializeString()
                CONTENTFEEDBACK_DESCRIPTOR.index -> builder.contentFeedback = deserializeContentFeedbackDataDocument(deserializer)
                TARGETID_DESCRIPTOR.index -> builder.targetId = deserializeString()
                TARGETTYPE_DESCRIPTOR.index -> builder.targetType = deserializeString().let { TargetType.fromValue(it) }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
