// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.qconnect.serde

import aws.sdk.kotlin.services.qconnect.model.ConversationState
import aws.sdk.kotlin.services.qconnect.model.GetNextMessageResponse
import aws.sdk.kotlin.services.qconnect.model.MessageOutput
import aws.sdk.kotlin.services.qconnect.model.MessageType
import aws.sdk.kotlin.services.qconnect.model.QConnectException
import aws.sdk.kotlin.services.qconnect.model.RuntimeSessionData
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class GetNextMessageOperationDeserializer: HttpDeserializer.NonStreaming<GetNextMessageResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): GetNextMessageResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwGetNextMessageError(context, call, payload)
        }
        val builder = GetNextMessageResponse.Builder()

        if (payload != null) {
            deserializeGetNextMessageOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwGetNextMessageError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw QConnectException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> QConnectException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeGetNextMessageOperationBody(builder: GetNextMessageResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val CONVERSATIONSESSIONDATA_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("conversationSessionData"))
    val CONVERSATIONSTATE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("conversationState"))
    val NEXTMESSAGETOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("nextMessageToken"))
    val REQUESTMESSAGEID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("requestMessageId"))
    val RESPONSE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("response"))
    val TYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("type"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CONVERSATIONSESSIONDATA_DESCRIPTOR)
        field(CONVERSATIONSTATE_DESCRIPTOR)
        field(NEXTMESSAGETOKEN_DESCRIPTOR)
        field(REQUESTMESSAGEID_DESCRIPTOR)
        field(RESPONSE_DESCRIPTOR)
        field(TYPE_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                CONVERSATIONSESSIONDATA_DESCRIPTOR.index -> builder.conversationSessionData =
                    deserializer.deserializeList(CONVERSATIONSESSIONDATA_DESCRIPTOR) {
                        val col0 = mutableListOf<RuntimeSessionData>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeRuntimeSessionDataDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                CONVERSATIONSTATE_DESCRIPTOR.index -> builder.conversationState = deserializeConversationStateDocument(deserializer)
                NEXTMESSAGETOKEN_DESCRIPTOR.index -> builder.nextMessageToken = deserializeString()
                REQUESTMESSAGEID_DESCRIPTOR.index -> builder.requestMessageId = deserializeString()
                RESPONSE_DESCRIPTOR.index -> builder.response = deserializeMessageOutputDocument(deserializer)
                TYPE_DESCRIPTOR.index -> builder.type = deserializeString().let { MessageType.fromValue(it) }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
