// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.qconnect.serde

import aws.sdk.kotlin.services.qconnect.model.CreateQuickResponseRequest
import aws.sdk.kotlin.services.qconnect.model.GroupingConfiguration
import aws.sdk.kotlin.services.qconnect.model.QuickResponseDataProvider
import aws.smithy.kotlin.runtime.client.idempotencyTokenProvider
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class CreateQuickResponseOperationSerializer: HttpSerializer.NonStreaming<CreateQuickResponseRequest> {
    override fun serialize(context: ExecutionContext, input: CreateQuickResponseRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            requireNotNull(input.knowledgeBaseId) { "knowledgeBaseId is bound to the URI and must not be null" }
            path.encodedSegments {
                add(PercentEncoding.Path.encode("knowledgeBases"))
                add(PercentEncoding.SmithyLabel.encode(input.knowledgeBaseId))
                add(PercentEncoding.Path.encode("quickResponses"))
            }
        }

        val payload = serializeCreateQuickResponseOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeCreateQuickResponseOperationBody(context: ExecutionContext, input: CreateQuickResponseRequest): ByteArray {
    val serializer = JsonSerializer()
    val CHANNELS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("channels"))
    val CLIENTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("clientToken"))
    val CONTENT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("content"))
    val CONTENTTYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("contentType"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("description"))
    val GROUPINGCONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("groupingConfiguration"))
    val ISACTIVE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Boolean, JsonSerialName("isActive"))
    val LANGUAGE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("language"))
    val NAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("name"))
    val SHORTCUTKEY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("shortcutKey"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("tags"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CHANNELS_DESCRIPTOR)
        field(CLIENTTOKEN_DESCRIPTOR)
        field(CONTENT_DESCRIPTOR)
        field(CONTENTTYPE_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(GROUPINGCONFIGURATION_DESCRIPTOR)
        field(ISACTIVE_DESCRIPTOR)
        field(LANGUAGE_DESCRIPTOR)
        field(NAME_DESCRIPTOR)
        field(SHORTCUTKEY_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        if (input.channels != null) {
            listField(CHANNELS_DESCRIPTOR) {
                for (el0 in input.channels) {
                    serializeString(el0)
                }
            }
        }
        input.clientToken?.let { field(CLIENTTOKEN_DESCRIPTOR, it) } ?: field(CLIENTTOKEN_DESCRIPTOR, context.idempotencyTokenProvider.generateToken())
        input.content?.let { field(CONTENT_DESCRIPTOR, it, ::serializeQuickResponseDataProviderDocument) }
        input.contentType?.let { field(CONTENTTYPE_DESCRIPTOR, it) }
        input.description?.let { field(DESCRIPTION_DESCRIPTOR, it) }
        input.groupingConfiguration?.let { field(GROUPINGCONFIGURATION_DESCRIPTOR, it, ::serializeGroupingConfigurationDocument) }
        input.isActive?.let { field(ISACTIVE_DESCRIPTOR, it) }
        input.language?.let { field(LANGUAGE_DESCRIPTOR, it) }
        input.name?.let { field(NAME_DESCRIPTOR, it) }
        input.shortcutKey?.let { field(SHORTCUTKEY_DESCRIPTOR, it) }
        if (input.tags != null) {
            mapField(TAGS_DESCRIPTOR) {
                input.tags.forEach { (key, value) ->
                    entry(key, value)
                }
            }
        }
    }
    return serializer.toByteArray()
}
