// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.qconnect.serde

import aws.sdk.kotlin.services.qconnect.model.ChannelSubtype
import aws.sdk.kotlin.services.qconnect.model.CreateMessageTemplateRequest
import aws.sdk.kotlin.services.qconnect.model.GroupingConfiguration
import aws.sdk.kotlin.services.qconnect.model.MessageTemplateAttributes
import aws.sdk.kotlin.services.qconnect.model.MessageTemplateContentProvider
import aws.smithy.kotlin.runtime.client.idempotencyTokenProvider
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.text.encoding.PercentEncoding


internal class CreateMessageTemplateOperationSerializer: HttpSerializer.NonStreaming<CreateMessageTemplateRequest> {
    override fun serialize(context: ExecutionContext, input: CreateMessageTemplateRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            requireNotNull(input.knowledgeBaseId) { "knowledgeBaseId is bound to the URI and must not be null" }
            path.encodedSegments {
                add(PercentEncoding.Path.encode("knowledgeBases"))
                add(PercentEncoding.SmithyLabel.encode(input.knowledgeBaseId))
                add(PercentEncoding.Path.encode("messageTemplates"))
            }
        }

        val payload = serializeCreateMessageTemplateOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeCreateMessageTemplateOperationBody(context: ExecutionContext, input: CreateMessageTemplateRequest): ByteArray {
    val serializer = JsonSerializer()
    val CHANNELSUBTYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("channelSubtype"))
    val CLIENTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("clientToken"))
    val CONTENT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("content"))
    val DEFAULTATTRIBUTES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("defaultAttributes"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("description"))
    val GROUPINGCONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("groupingConfiguration"))
    val LANGUAGE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("language"))
    val NAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("name"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("tags"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CHANNELSUBTYPE_DESCRIPTOR)
        field(CLIENTTOKEN_DESCRIPTOR)
        field(CONTENT_DESCRIPTOR)
        field(DEFAULTATTRIBUTES_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(GROUPINGCONFIGURATION_DESCRIPTOR)
        field(LANGUAGE_DESCRIPTOR)
        field(NAME_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.channelSubtype?.let { field(CHANNELSUBTYPE_DESCRIPTOR, it.value) }
        input.clientToken?.let { field(CLIENTTOKEN_DESCRIPTOR, it) } ?: field(CLIENTTOKEN_DESCRIPTOR, context.idempotencyTokenProvider.generateToken())
        input.content?.let { field(CONTENT_DESCRIPTOR, it, ::serializeMessageTemplateContentProviderDocument) }
        input.defaultAttributes?.let { field(DEFAULTATTRIBUTES_DESCRIPTOR, it, ::serializeMessageTemplateAttributesDocument) }
        input.description?.let { field(DESCRIPTION_DESCRIPTOR, it) }
        input.groupingConfiguration?.let { field(GROUPINGCONFIGURATION_DESCRIPTOR, it, ::serializeGroupingConfigurationDocument) }
        input.language?.let { field(LANGUAGE_DESCRIPTOR, it) }
        input.name?.let { field(NAME_DESCRIPTOR, it) }
        if (input.tags != null) {
            mapField(TAGS_DESCRIPTOR) {
                input.tags.forEach { (key, value) ->
                    entry(key, value)
                }
            }
        }
    }
    return serializer.toByteArray()
}
