// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.qconnect.serde

import aws.sdk.kotlin.services.qconnect.model.CreateKnowledgeBaseRequest
import aws.sdk.kotlin.services.qconnect.model.KnowledgeBaseType
import aws.sdk.kotlin.services.qconnect.model.RenderingConfiguration
import aws.sdk.kotlin.services.qconnect.model.ServerSideEncryptionConfiguration
import aws.sdk.kotlin.services.qconnect.model.SourceConfiguration
import aws.sdk.kotlin.services.qconnect.model.VectorIngestionConfiguration
import aws.smithy.kotlin.runtime.client.idempotencyTokenProvider
import aws.smithy.kotlin.runtime.http.HttpBody
import aws.smithy.kotlin.runtime.http.HttpMethod
import aws.smithy.kotlin.runtime.http.operation.HttpSerializer
import aws.smithy.kotlin.runtime.http.request.HttpRequestBuilder
import aws.smithy.kotlin.runtime.http.request.url
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.json.JsonSerializer
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class CreateKnowledgeBaseOperationSerializer: HttpSerializer.NonStreaming<CreateKnowledgeBaseRequest> {
    override fun serialize(context: ExecutionContext, input: CreateKnowledgeBaseRequest): HttpRequestBuilder {
        val builder = HttpRequestBuilder()
        builder.method = HttpMethod.POST

        builder.url {
            path.encoded = "/knowledgeBases"
        }

        val payload = serializeCreateKnowledgeBaseOperationBody(context, input)
        builder.body = HttpBody.fromBytes(payload)
        if (builder.body !is HttpBody.Empty) {
            builder.headers.setMissing("Content-Type", "application/json")
        }
        return builder
    }
}

private fun serializeCreateKnowledgeBaseOperationBody(context: ExecutionContext, input: CreateKnowledgeBaseRequest): ByteArray {
    val serializer = JsonSerializer()
    val CLIENTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("clientToken"))
    val DESCRIPTION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("description"))
    val KNOWLEDGEBASETYPE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("knowledgeBaseType"))
    val NAME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("name"))
    val RENDERINGCONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("renderingConfiguration"))
    val SERVERSIDEENCRYPTIONCONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("serverSideEncryptionConfiguration"))
    val SOURCECONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("sourceConfiguration"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("tags"))
    val VECTORINGESTIONCONFIGURATION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("vectorIngestionConfiguration"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(CLIENTTOKEN_DESCRIPTOR)
        field(DESCRIPTION_DESCRIPTOR)
        field(KNOWLEDGEBASETYPE_DESCRIPTOR)
        field(NAME_DESCRIPTOR)
        field(RENDERINGCONFIGURATION_DESCRIPTOR)
        field(SERVERSIDEENCRYPTIONCONFIGURATION_DESCRIPTOR)
        field(SOURCECONFIGURATION_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
        field(VECTORINGESTIONCONFIGURATION_DESCRIPTOR)
    }

    serializer.serializeStruct(OBJ_DESCRIPTOR) {
        input.clientToken?.let { field(CLIENTTOKEN_DESCRIPTOR, it) } ?: field(CLIENTTOKEN_DESCRIPTOR, context.idempotencyTokenProvider.generateToken())
        input.description?.let { field(DESCRIPTION_DESCRIPTOR, it) }
        field(KNOWLEDGEBASETYPE_DESCRIPTOR, input.knowledgeBaseType.value)
        field(NAME_DESCRIPTOR, input.name)
        input.renderingConfiguration?.let { field(RENDERINGCONFIGURATION_DESCRIPTOR, it, ::serializeRenderingConfigurationDocument) }
        input.serverSideEncryptionConfiguration?.let { field(SERVERSIDEENCRYPTIONCONFIGURATION_DESCRIPTOR, it, ::serializeServerSideEncryptionConfigurationDocument) }
        input.sourceConfiguration?.let { field(SOURCECONFIGURATION_DESCRIPTOR, it, ::serializeSourceConfigurationDocument) }
        if (input.tags != null) {
            mapField(TAGS_DESCRIPTOR) {
                input.tags.forEach { (key, value) ->
                    entry(key, value)
                }
            }
        }
        input.vectorIngestionConfiguration?.let { field(VECTORINGESTIONCONFIGURATION_DESCRIPTOR, it, ::serializeVectorIngestionConfigurationDocument) }
    }
    return serializer.toByteArray()
}
